#include "mbed.h"
#include "MicroBit.h"

#include "i2c_callbacks.h"

#ifndef BME680_H
#define BME680_H

#include "bme680_defs.h"

/*
the code has been taken from https://github.com/BoschSensortec/BME680_driver
and only been slightly adjusted for mbed MicroBit
*/

class Bme680 {
    public:
        /* function prototype declarations */
        /*!
         *  @brief This API is the entry point.
         *  It reads the chip-id and calibration data from the sensor.
         *
         *  @param[in,out] dev : Structure instance of bme680_dev
         *
         *  @return Result of API execution status
         *  @retval zero -> Success / +ve value -> Warning / -ve value -> Error
         */
         Bme680(I2cCallbacks *callbacks);
         int init();
         int measure(struct bme680_field_data* data, const int ambTemp, const uint16_t heatr_dur, const uint16_t heatr_temp);
         
    private:
        int get_calib_data();
        int set_gas_config();
        int get_gas_config();
        int16_t calc_temperature(uint32_t temp_adc);
        uint32_t calc_humidity(uint16_t hum_adc);
        uint32_t calc_pressure(uint32_t pres_adc);
        uint32_t calc_gas_resistance(uint16_t gas_res_adc, uint8_t gas_range);
        uint8_t calc_heater_res(uint16_t temp);
        uint8_t calc_heater_dur(uint16_t dur);
        
        
        int read_field_data(struct bme680_field_data *data);
        //int8_t set_mem_page(uint8_t reg_addr, struct bme680_dev *dev);
        //int8_t get_mem_page();
        int null_ptr_check();
        int boundary_check(uint8_t *value, uint8_t min, uint8_t max);
        
        int soft_reset();
        int set_regs(const uint8_t *reg_addr, const uint8_t *reg_data, uint8_t len);
        int get_regs(uint8_t reg_addr, uint8_t *reg_data, uint16_t len);
        int set_sensor_settings(uint16_t desired_settings);
        int set_sensor_mode();
        int get_sensor_settings(uint16_t desired_settings);
        int get_sensor_mode(struct bme680_dev *dev);
        void set_profile_dur(uint16_t duration);
        void get_profile_dur(uint16_t *duration);
        int get_sensor_data(struct bme680_field_data *data);
        
        int analyze_sensor_data(struct bme680_field_data *data);
        
        struct bme680_dev *_dev;
        I2cCallbacks* _i2cCallbacks;
};

#endif // BME680_H