#ifndef IaqNonVolatileStore_H
#define IaqNonVolatileStore_H

#include "mbed.h"
#include "MicroBit.h"

class MovingAverage;

class IaqNonVolatileStore {
    public:
        static const int AVERAGE_BUFFER_SIZE;
        
        IaqNonVolatileStore(MicroBit* uBit);
        ~IaqNonVolatileStore();
        
        void clear();
        void resetTmpHumCo2();
        
        void updateGas(uint32_t gas);
        uint32_t getGasMax();
        uint32_t getGasMin();
        
        void updateTemp(const int16_t temperature);
        int16_t getTempMax();
        int16_t getTempMin();
        
        void updatePress(const uint32_t pressure);
        uint32_t getPressMax();
        uint32_t getPressMin();
        
        void updateHumidity(const uint32_t humidity);
        uint32_t getHumMax();
        uint32_t getHumMin();
        
        void updateVoc(const uint32_t voc);
        uint32_t getVocMax();
 
        void updateCo(const uint32_t co);
        uint32_t getCoMax();
        void storeIAQBaseline(uint16_t eco2_base, uint16_t tvoc_base);
        bool getIAQBaseline(uint16_t *eco2_base, uint16_t *tvoc_base);
        void clearIQQBaseline();
        
        const uint32_t* debugInfo();
        bool strayData();
               
    private:
        MicroBit* _uBit;
        
        MovingAverage* _movingAverage;
        
        int16_t _tempMax, _tempMin;
        uint32_t _maxGas, _minGas,
            _pressMax, _pressMin,
            _humMax, _humMin,
            _vocMax,
            _coMax;
        
        uint32_t getStored(const char* key, const uint32_t defaultVal);
        int16_t getStored16(const char * key, const int16_t defaultVal);
        void update(const uint32_t value, uint32_t* maxVal, uint32_t* minVal, const char* maxKey, const char* minKey);
};

#endif // IaqNonVolatileStore_H