#include "mbed.h"
#include "main.h"
#include "WD_CONT.h"
#include "MCP23017.h"
#include "IO_CONT.h"
#include "nextion_lcd.h"
#include "APP.h"

//打点数カウント///
unsigned char WD1_CNT=0;
//極棒交換カウント///
unsigned long WD1H_CHG_CNT=0;

//打点数カウント///
unsigned char WD2_CNT=0;
//極棒交換カウント///
unsigned long WD2H_CHG_CNT=0;//右側平極棒

//極棒交換カウント///
unsigned long WD2R_CHG_CNT=0;//右側丸極棒 新規追加 2021/07/26

unsigned char PS1_POS_ST=0xFF;
unsigned char PS2_POS_ST=0xFF;

unsigned char RT1_ST=FET_OFF;//回転制御シリンダー電磁弁状態0=OFF 1=0N
unsigned char RT2_ST=FET_OFF;//回転制御シリンダー電磁弁状態0=OFF 1=0N
unsigned char VS_ST=3;//0=1系　1=2系

unsigned char WD_JUDG_1[8];//0=NG 1=OK
unsigned char WD_TCNT_1=0;//A+Cパーツの一括打点カウント(L平）
unsigned char WD_JUDG_2[8];//0=NG 1=OK
unsigned char WD_TCNT_2=0;//A+Cパーツの一括打点カウント(R丸）

unsigned char WD_JUDG_NG_F=0;//NG有無　1=NGあり


////////////溶接ヘッド回転制御/////////////////////
//ヘッド1回転リレー制御///
void WDRT1_CONT(unsigned char cont){
    if(cont==FETON){
        FET7_O=FETON;
        RT1_ST=1;//回転制御シリンダー電磁弁状態0=OFF 1=0N
     }else{
        FET7_O=FETOFF;
        RT1_ST=0;//回転制御シリンダー電磁弁状態0=OFF 1=0N
     }   
}

////2022/04/06 同時溶接お試し
void HEAD_RT(void){

    WDRT1_CONT(FETON); 
    WDRT2_CONT(FETON); 
    wait_ms(RT_ST_DEF); 
    WDRT1_CONT(FETOFF);
    WDRT2_CONT(FETOFF);
    wait_ms(RT_ST_DEF); 
}


//ヘッド1回転制御
void HEAD1_RT(void){

    WDRT1_CONT(FETON); 
    wait_ms(RT_ST_DEF); 
    WDRT1_CONT(FETOFF);
    wait_ms(RT_ST_DEF); 
 }


//ヘッド2回転リレー制御///
void WDRT2_CONT(unsigned char cont){
     
     if(cont==FETON){
        FET8_O=FETON;
         RT2_ST=1;//回転制御シリンダー電磁弁状態0=OFF 1=0N
     }else{
        FET8_O=FETOFF;
        RT2_ST=0;//回転制御シリンダー電磁弁状態0=OFF 1=0N
     }
     
}
//ヘッド2回転制御
void HEAD2_RT(void){
    WDRT2_CONT(FETON); 
    wait_ms(RT_ST_DEF); 
    WDRT2_CONT(FETOFF);
    wait_ms(RT_ST_DEF); 
}
////////////溶接ヘッド回転制御/////////////////////

/////////////溶接加圧軸1///////////////////////////

/////////////////////////////////////////////
 //加圧軸１　待機位置(後退)移動開始待ち
void PS1_PE0_SWAIT(unsigned long wait){ 
    unsigned long mv_timeout=0;;   
    ///移動開始待ち////
    while(IO_EX_BIT_READ(PS1_PE0_I) !=IOEX_OFF_I && mv_timeout<wait){
        wait_ms(1); 
        mv_timeout++;
    }
    if(mv_timeout>=MOVE_TIME_OUT){
        ALM_ST=ALM_PS1_ST;
        ALM_HOLD_SET();
    }
 
}
 //加圧軸１　待機位置(後退) 移動完了待
void PS1_PE0_EWAIT(unsigned long wait){ 
    unsigned long mv_timeout=0;;   
    while(IO_EX_BIT_READ(PS1_PE0_I) !=IOEX_ON_I && mv_timeout<wait){
        wait_ms(1); 
        mv_timeout++;
    }
    if(mv_timeout>=wait){  
        ALM_ST=ALM_PS1_ED;
        ALM_HOLD_SET();
    }
    IO_EX_BIT_WITE(PS1_ST0_O,IOEX_OFF_O);

}
 //加圧軸１　待機位置(後退) 
void PS1_PE0_WAIT(unsigned long wait){ 
    //移動開始待ち///
    PS1_PE0_SWAIT(wait);
     //移動完了待ち///
    PS1_PE0_EWAIT(wait);
}
/////////////////////////////////////////////

 //加圧軸１　回転位置移動開始待ち
void PS1_PE1_SWAIT(unsigned long wait){
    unsigned long mv_timeout=0;;
    
    ///移動開始待ち////
    while(IO_EX_BIT_READ(PS1_PE1_I) !=IOEX_OFF_I && mv_timeout<wait){
        wait_ms(1); 
        mv_timeout++;
    }
    if(mv_timeout>=MOVE_TIME_OUT){
        ALM_ST=ALM_PS1_ST;
        ALM_HOLD_SET();
    }
}

 //加圧軸１　回転位置移動完了待ち
void PS1_PE1_EWAIT(unsigned long wait){
    unsigned long mv_timeout=0;;
    while(IO_EX_BIT_READ(PS1_PE1_I) !=IOEX_ON_I && mv_timeout<wait){
        wait_ms(1); 
        mv_timeout++;
    }
    if(mv_timeout>=wait){
        ALM_ST=ALM_PS1_ED;
        ALM_HOLD_SET();
    }
    IO_EX_BIT_WITE(PS1_ST1_O,IOEX_OFF_O);
}
 //加圧軸１　回転位置移動開始完了待ち
void PS1_PE1_WAIT(unsigned long wait){
    //移動開始待ち//
    PS1_PE1_SWAIT(wait);
    ///移動完了待ち///
    PS1_PE1_EWAIT(wait);
}
/////////////////////////////////////////////
//加圧軸1 加圧位置　移動開始待ち
void PS1_PE2_SWAIT(unsigned long wait){
    unsigned long mv_timeout=0;    
    ///移動開始待ち////
    while(IO_EX_BIT_READ(PS1_PE2_I) !=IOEX_OFF_I && mv_timeout<wait){
        wait_ms(1); 
        mv_timeout++;
    }
    if(mv_timeout>=MOVE_TIME_OUT){
        ALM_ST=ALM_PS1_ST;
        ALM_HOLD_SET();
    }
}       
//加圧軸1　加圧位置　移動完了待ち
void PS1_PE2_EWAIT(unsigned long wait){
    unsigned long mv_timeout=0;    
    while(IO_EX_BIT_READ(PS1_PE2_I) !=IOEX_ON_I && mv_timeout<wait){
        wait_ms(1); 
        mv_timeout++;
    }
    if(mv_timeout>=wait){
        ALM_ST=ALM_PS1_ED;
        ALM_HOLD_SET();
    }
    IO_EX_BIT_WITE(PS1_ST2_O,IOEX_OFF_O);
}       
//加圧軸1　加圧位置　移動開始完了待ち
void PS1_PE2_WAIT(unsigned long wait){
    ///移動開始待ち////
    PS1_PE2_SWAIT(wait);
    ///移動完了待ち///
    PS1_PE2_EWAIT(wait);
}       
/////////////////////////////////////////////               
///加圧軸1 原点復帰///
void PS1_HOME(void){
    IO_EX_BIT_WITE(PS1_ST0_O,IOEX_OFF_O);
    IO_EX_BIT_WITE(PS1_ST1_O,IOEX_OFF_O);
    IO_EX_BIT_WITE(PS1_ST2_O,IOEX_OFF_O);
    if(IO_EX_BIT_READ(PS1_PE0_I) !=IOEX_ON_I){
        PS1_MOVE0(EWAIT_DIS);
        PS1_PE0_EWAIT(5000); //移動完了待ち
    }
    
}

 //加圧軸１　待機位置(後退)//ST0 ON
void PS1_MOVE0(unsigned char EWAIT_SEL){//EWAIT_SEL=1で終了待ち  

    if(PS1_POS_ST !=PS1_POS_WAIT){
        IO_EX_BIT_WITE(PS1_ST0_O,IOEX_ON_O);
        PS1_PE0_SWAIT(1000);
        if(EWAIT_SEL==EWAIT_ENB){
            PS1_PE0_EWAIT(1000);
        }
        PS1_POS_ST=PS1_POS_WAIT;
        
    }else{
        lcd_print("t0","現在位置です。");   
    }
}

//加圧軸1回転位置（中点） ST1 ON
void PS1_MOVE1(unsigned char EWAIT_SEL){//EWAIT_SEL=1で終了待ち  

    if(PS1_POS_ST !=PS1_POS_RT){
        IO_EX_BIT_WITE(PS1_ST1_O,IOEX_ON_O);
        PS1_PE1_SWAIT(1000);
        if(EWAIT_SEL==EWAIT_ENB){
            PS1_PE1_EWAIT(1000);
        }
        PS1_POS_ST=PS1_POS_RT;
    }else{
        lcd_print("t0","現在位置です。");   
    }
 
}

 //加圧軸１　加圧位置(前進)  ST2 ON
void PS1_MOVE2(unsigned char EWAIT_SEL){//EWAIT_SEL=1で終了待ち  
 
    if(PS1_POS_ST !=PS1_POS_PU){
        IO_EX_BIT_WITE(PS1_ST2_O,IOEX_ON_O);
        PS1_PE2_SWAIT(1000);
        if(EWAIT_SEL==EWAIT_ENB){
            PS1_PE2_EWAIT(1000);
        }
        PS1_POS_ST=PS1_POS_PU;
    }else{
        lcd_print("t0","現在位置です。");   
        
    }
}   

/////////////溶接加圧軸2///////////////////////////

/////////////////////////////////////////////
//加圧軸2　待機位置 移動開始待ち
void PS2_PE0_SWAIT(unsigned long wait){ 
    unsigned long mv_timeout=0;;
    
    ///移動開始待ち////
    while(IO_EX_BIT_READ(PS2_PE0_I) !=IOEX_OFF_I && mv_timeout<wait){
        wait_ms(1); 
        mv_timeout++;
    }
    if(mv_timeout>=wait){
        ALM_ST=ALM_PS2_ST;
        ALM_HOLD_SET();
    }
}
//加圧軸2　待機位置 移動完了待ち
void PS2_PE0_EWAIT(unsigned long wait){ //移動完了待ち
    unsigned long mv_timeout=0;;
    while(IO_EX_BIT_READ(PS2_PE0_I) !=IOEX_ON_I && mv_timeout<wait){
        wait_ms(1); 
        mv_timeout++;
    }
    if(mv_timeout>=wait){
        ALM_ST=ALM_PS2_ED;
        ALM_HOLD_SET();
    }
    IO_EX_BIT_WITE(PS2_ST0_O,IOEX_OFF_O);
}
 //加圧軸2　待機位置 移動開始完了待ち
void PS2_PE0_WAIT(unsigned long wait){ 
    ///移動開始待ち////
    PS2_PE0_SWAIT(wait);
    ///移動完了待ち///
    PS2_PE0_EWAIT(wait);
}
/////////////////////////////////////////////
//加圧軸2　回転位置 移動開始待ち
void PS2_PE1_SWAIT(unsigned long wait){
    unsigned long mv_timeout=0;;
    
    ///移動開始待ち////
    while(IO_EX_BIT_READ(PS2_PE1_I) !=IOEX_OFF_I && mv_timeout<wait){
        wait_ms(1); 
        mv_timeout++;
    }
    if(mv_timeout>=wait){
        ALM_ST=ALM_PS2_ST;
        ALM_HOLD_SET();
    }
}

 //加圧軸2　回転位置　移動完了待ち
void PS2_PE1_EWAIT(unsigned long wait){
    unsigned long mv_timeout=0;;
    while(IO_EX_BIT_READ(PS2_PE1_I) !=IOEX_ON_I && mv_timeout<wait){
        wait_ms(1); 
        mv_timeout++;
    }
    if(mv_timeout>=wait){
        ALM_ST=ALM_PS2_ED;
        ALM_HOLD_SET();
    }
    IO_EX_BIT_WITE(PS2_ST1_O,IOEX_OFF_O);
}
 //加圧軸2　　回転位置　移動開始完了待ち
void PS2_PE1_WAIT(unsigned long wait){   
    ///移動開始待ち////
    PS2_PE1_SWAIT(wait);
    ///移動完了待ち///
    PS2_PE1_EWAIT(wait);
}
/////////////////////////////////////////////
//加圧軸2　加圧位置　移動開始待ち
void PS2_PE2_SWAIT(unsigned long wait){
    unsigned long mv_timeout=0;
    ///移動開始待ち////
    while(IO_EX_BIT_READ(PS2_PE2_I) !=IOEX_OFF_I && mv_timeout<wait){
        wait_ms(1); 
        mv_timeout++;
    }
    if(mv_timeout>=wait){
        ALM_ST=ALM_PS2_ST;
        ALM_HOLD_SET();
    }
}       
//加圧軸2　加圧位置　移動完了待ち
void PS2_PE2_EWAIT(unsigned long wait){
    unsigned long mv_timeout=0;
    while(IO_EX_BIT_READ(PS2_PE2_I) !=IOEX_ON_I && mv_timeout<wait){
        wait_ms(1); 
        mv_timeout++;
    }
    if(mv_timeout>=wait){
        ALM_ST=ALM_PS2_ED;
        ALM_HOLD_SET();
    }
    IO_EX_BIT_WITE(PS2_ST2_O,IOEX_OFF_O);
}       
//加圧軸2　加圧位置　移動開始完了待ち
void PS2_PE2_WAIT(unsigned long wait){
    ///移動開始待ち////
    PS2_PE2_SWAIT(wait);
    ///移動完了待ち///
    PS2_PE2_EWAIT(wait);
}       
/////////////////////////////////////////////                
///加圧軸2 原点復帰///
void PS2_HOME(void){
    IO_EX_BIT_WITE(PS2_ST0_O,IOEX_OFF_O);
    IO_EX_BIT_WITE(PS2_ST1_O,IOEX_OFF_O);
    IO_EX_BIT_WITE(PS2_ST2_O,IOEX_OFF_O);
    
    if(IO_EX_BIT_READ(PS2_PE0_I) !=IOEX_ON_I){
        PS2_MOVE0(EWAIT_DIS);
        PS2_PE0_EWAIT(5000); //移動完了待ち
    }
}
 //加圧軸2　待機位置(後退) ST0
void PS2_MOVE0(unsigned char EWAIT_SEL){//EWAIT_SEL=1で終了待ち  
    if(PS2_POS_ST !=PS2_POS_WAIT){
        IO_EX_BIT_WITE(PS2_ST0_O,IOEX_ON_O);
        PS2_PE0_SWAIT(1000);
        if(EWAIT_SEL==EWAIT_ENB){
            PS2_PE0_EWAIT(1000);
        }
        PS2_POS_ST=PS2_POS_WAIT;
    }else{
        lcd_print("t0","現在位置です。");  
 
    }
}

//加圧軸2回転位置（中点） ST1 ON
void PS2_MOVE1(unsigned char EWAIT_SEL){//EWAIT_SEL=1で終了待ち  
    if(PS2_POS_ST !=PS2_POS_RT){
        IO_EX_BIT_WITE(PS2_ST1_O,IOEX_ON_O);
        PS2_PE1_SWAIT(1000);
        if(EWAIT_SEL==EWAIT_ENB){
            PS2_PE1_EWAIT(1000);
        }
        PS2_POS_ST=PS2_POS_RT;
    }else{
        lcd_print("t0","現在位置です。");   
    }
 
}

 //加圧軸2　加圧位置(前進)  ST2 ON
void PS2_MOVE2(unsigned char EWAIT_SEL){//EWAIT_SEL=1で終了待ち  

    if(PS2_POS_ST !=PS2_POS_PU){
        IO_EX_BIT_WITE(PS2_ST2_O,IOEX_ON_O);
        PS2_PE2_SWAIT(1000); 
        if(EWAIT_SEL==EWAIT_ENB){
             PS2_PE2_EWAIT(1000);
        }
        PS2_POS_ST=PS2_POS_PU;
    }else{

        lcd_print("t0","現在位置です。");   
        
    }
} 

////////*****************溶接機****************************//////////////
///溶接機 OK BIT4 BIT0を確認///
char WD_OK_CHECK(void){
    unsigned char on_cnt=0;
    unsigned long time_out_cnt=0;
    unsigned char OK_DATA=IOEX_A0_BYR();
    unsigned char WD1_OK_GET=0;
    unsigned char WD2_OK_GET=0;
    OK_DATA |=0xEE; //溶接2台ともOKならEE　そうでないならFF,EF,FEの3パターン
    //800ms以内にokがくることを確認している。
    while((WD1_OK_GET==0 || WD2_OK_GET==0) && time_out_cnt<80){//1ms x800=800ms(800msでタイムアウト)
        OK_DATA=IOEX_A0_BYR();
        OK_DATA |=0xEE;
        ////同時にOKのタイミングが取れない場合を考慮し個別にフラグで検出する///
        ///溶接機1が先にOK///
        if(OK_DATA ==0xFE){
            WD1_OK_GET=1;
        }
        ///溶接機2が先にOK///
        if(OK_DATA ==0xEF){
            WD2_OK_GET=1;
        }     
        ///同時にOK///
        if(OK_DATA ==0xEE){
            WD1_OK_GET=1;
            WD2_OK_GET=1;
        }  
        wait_ms(10);
        time_out_cnt++;
    }
    if(time_out_cnt<80){//パルスが短いので表示を省略    
           return 0;//いままでと逆にした(2022/04/09)  
    }else{
        if(WD1_OK_GET ==0 && WD2_OK_GET==1){
           return 1;//溶接機1NG
        }
        if(WD1_OK_GET ==1 && WD2_OK_GET==0){
           return 2;//溶接機2NG 
        }
        if(WD1_OK_GET==0 && WD2_OK_GET==0){
           return 3;//溶接機1,2NG 
        }
    }
    return 0;//いままでと逆にした(2022/04/09)  
}
///溶接機 ENDを確認///
char WD_END_CHECK(void){
    unsigned char on_cnt=0;
    unsigned long time_out_cnt=0;
    unsigned char END_DATA=IOEX_A0_BYR();
    unsigned char WD1_END_GET=0;
    unsigned char WD2_END_GET=0;
    
    END_DATA |=0xBB; //溶接2台ともENDありならBB　そうでないならFF　BF,FBの3パターン
    while((WD1_END_GET==0 || WD2_END_GET==0) && time_out_cnt<80){//ONになるまで100ms待つ
        END_DATA=IOEX_A0_BYR();
        END_DATA |=0xBB;
        ////同時にENDのタイミングが取れない場合を考慮し個別にフラグで検出する///
        ///溶接機1が先にEND///
        if(END_DATA ==0xFB){
            WD1_END_GET=1;
        }
        ///溶接機2が先にEND///
        if(END_DATA ==0xBF){
            WD2_END_GET=1;
        }     
        ///同時にEND///
        if(END_DATA ==0xBB){
            WD1_END_GET=1;
            WD2_END_GET=1;
        }  
        wait_ms(10);
        time_out_cnt++;
    }

    if(time_out_cnt<80){//パルスが短いので表示を省略    
        return 0;//いままでと逆にした(2022/04/09)  
    }else{
        if(WD1_END_GET ==0 && WD2_END_GET==1){
           return 1;//溶接機1NG
        }
        if(WD1_END_GET ==1 && WD2_END_GET==0){
           return 2;//溶接機2NG 
        }
        if(WD1_END_GET==0 && WD2_END_GET==0){
           return 3;//溶接機1,2NG 
        }
    }
    return 0;
} 
////2022/06/28 溶接機２台対応////////
char WD1_END_CHECK(void){
    unsigned char on_cnt=0;
    unsigned long time_out_cnt=0;
   
    while(IO_EX_BIT_READ(WD1_END_I)==IOEX_OFF_I && time_out_cnt<80){//ONになるまで100ms待つ

    wait_ms(10);
    time_out_cnt++;
    }

    if(time_out_cnt<80){//パルスが短いので表示を省略    
        return 0;///2022/06/28 いままでと逆にした    
    }else{
        return 1;
    }

} 
////2022/06/28 溶接機２台対応////////
char WD2_END_CHECK(void){
    unsigned char on_cnt=0;
    unsigned long time_out_cnt=0;
   
    while(IO_EX_BIT_READ(WD2_END_I)==IOEX_OFF_I && time_out_cnt<80){//ONになるまで100ms待つ

    wait_ms(10);
    time_out_cnt++;
    }

    if(time_out_cnt<80){//パルスが短いので表示を省略    
        return 0;///2022/06/28 いままでと逆にした    
    }else{
        return 1;
    }

}
////2022/06/28 溶接機２台対応////////
char WD1_OK_CHECK(void){
    unsigned char on_cnt=0;
    unsigned long time_out_cnt=0;
    //20ms以内にokがくることを確認している。
    while(IO_EX_BIT_READ(WD1_OK_I)==IOEX_OFF_I && time_out_cnt<80){//1ms x100=100ms連続検出を確認(100msでタイムアウト) *8000Bは、ENDから35mS程度あとからokがくる模様（
      wait_ms(10);
      time_out_cnt++;
    }
    if(time_out_cnt<80){
        return 0;///2022/06/28 いままでと逆にした  
    }else{
        return 1;
    }
}
////2022/06/28 溶接機２台対応////////
char WD2_OK_CHECK(void){
    unsigned char on_cnt=0;
    unsigned long time_out_cnt=0;
    //20ms以内にokがくることを確認している。
    while(IO_EX_BIT_READ(WD2_OK_I)==IOEX_OFF_I && time_out_cnt<80){//1ms x100=100ms連続検出を確認(100msでタイムアウト) *8000Bは、ENDから35mS程度あとからokがくる模様（
      wait_ms(10);
      time_out_cnt++;
    }
    if(time_out_cnt<80){
        return 0; ///2022/06/28 いままでと逆にした   
    }else{
        return 1;
    }
}

//2022/04/06　同時に変更お試し
void WD_START_TEST(){

    //加圧位置へ移動
    PS1_MOVE2(EWAIT_DIS);
    PS2_MOVE2(EWAIT_DIS);
    //加圧位置移動完了待ち
    PS1_PE1_EWAIT(1000);
    PS2_PE1_EWAIT(1000);
    wait_ms(100);//end待ちの変わり
    
    WD_JUDG_1[WD_TCNT_1]=WD_JUGE_OK;
    WD_JUDG_2[WD_TCNT_2]=WD_JUGE_OK;
    WD_TCNT_1++;
    WD_TCNT_2++;

    
    ////回転位置へ移動////
    PS1_MOVE1(EWAIT_DIS);
    PS2_MOVE1(EWAIT_DIS);
    ///回転位置移動完了待ち///
    PS1_PE2_EWAIT(1000);
    PS2_PE2_EWAIT(1000);

    
     //ヘッド1回転制御 
    HEAD_RT();  
    //加圧軸後退      
    PS1_MOVE0(EWAIT_DIS);
    PS2_MOVE0(EWAIT_DIS);
    //加圧軸後退完了待ち 
    PS1_PE0_EWAIT(1000);
    PS2_PE0_EWAIT(1000);
    WD1_CNT++;
    WD1H_CHG_CNT++;
    WD2_CNT++;
    WD2H_CHG_CNT++;//右側平
    WD2R_CHG_CNT++;//右側丸 2021/07/26  
    WD_CNT_DISP();
          
}
/////2022/04/09 全面変更　溶接機2台同時使用////////////////////////////
void WD_START_NR(){
   unsigned char END_CHK=0xFF;
   unsigned char OK_CHK=0xFF;
   //加圧位置へ移動
    PS1_MOVE2(EWAIT_DIS);
    PS2_MOVE2(EWAIT_DIS);
    //加圧位置移動完了待ち
    PS1_PE1_EWAIT(1000);
    PS2_PE1_EWAIT(1000);
    END_CHK=WD_END_CHECK();
    if(END_CHK==0){//エンド信号ありなら(溶接機両方OK)
        OK_CHK=WD_OK_CHECK();
        ///溶接機1,2OK
        if(OK_CHK==0){
            WD_JUDG_1[WD_TCNT_1]=WD_JUGE_OK;
            WD_JUDG_2[WD_TCNT_2]=WD_JUGE_OK;
            //結果格納用バッファインクリ
            WD_TCNT_1++;
            WD_TCNT_2++;  
        }
        ///溶接機1NG
        if(OK_CHK==1){
            ERR_ST=ERR_WDNG_1;
            WD_JUDG_NG_F=1;
            WD_JUDG_1[WD_TCNT_1]=WD_JUGE_NG;
            WD_JUDG_2[WD_TCNT_2]=WD_JUGE_OK;
            //結果格納用バッファインクリ
            WD_TCNT_1++;
            WD_TCNT_2++;  
        }   
        ///溶接機2NG
        if(OK_CHK==2){
            ERR_ST=ERR_WDNG_2;
            WD_JUDG_NG_F=1;
            WD_JUDG_1[WD_TCNT_1]=WD_JUGE_OK;
            WD_JUDG_2[WD_TCNT_2]=WD_JUGE_NG;
            //結果格納用バッファインクリ
            WD_TCNT_1++;
            WD_TCNT_2++;  
        }     
        ///溶接機1,2NG
        if(OK_CHK==3){
            ERR_ST=ERR_WDNG_12;
            WD_JUDG_NG_F=1;
            WD_JUDG_1[WD_TCNT_1]=WD_JUGE_NG;
            WD_JUDG_2[WD_TCNT_2]=WD_JUGE_NG;
            //結果格納用バッファインクリ
            WD_TCNT_1++;
            WD_TCNT_2++;  
        }    
    }else{
        if(END_CHK==1){
            ALM_ST=ALM_WDENG_1;
            ALM_HOLD_SET();  
        }
        if(END_CHK==2){
            ALM_ST=ALM_WDENG_2;
            ALM_HOLD_SET();  
        }  
        if(END_CHK==3){
            ALM_ST=ALM_WDENG_12;
            ALM_HOLD_SET();  
        }
    }
   ////回転位置へ移動////
    PS1_MOVE1(EWAIT_DIS);
    PS2_MOVE1(EWAIT_DIS);
    ///回転位置移動完了待ち///
    PS1_PE2_EWAIT(1000);
    PS2_PE2_EWAIT(1000);
    //ヘッド回転制御 
    HEAD_RT();     
    //加圧軸後退      
    PS1_MOVE0(EWAIT_DIS);
    PS2_MOVE0(EWAIT_DIS);
    //加圧軸後退完了待ち 
    PS1_PE0_EWAIT(1000);
    PS2_PE0_EWAIT(1000);    
    WD1_CNT++;
    WD1H_CHG_CNT++;             
    WD2_CNT++;
    WD2H_CHG_CNT++;//右側平
    WD2R_CHG_CNT++;//右側丸 2021/07/26  
    WD_CNT_DISP();
}

void WD_START(){

    if(TEST_MODE_EN==0){
        WD_START_NR();
    }else{
        WD_START_TEST();
    }
}
 

void WD_HEAD1_START_NR(unsigned char ch,unsigned char esc_dis){

       PS1_MOVE2(EWAIT_ENB);//加圧位置へ移動
       if(WD1_END_CHECK()==0){//エンド信号ありなら//2022/06/28いままで0でNGだったが逆にした
            PS1_MOVE1(EWAIT_ENB);//回転位置（中点)
            HEAD1_RT(); //ヘッド1回転制御
            if(esc_dis==HEAD_ESC_EN){
                PS1_MOVE0(EWAIT_ENB);//待機位置(後退)  
            }  
       }else{
            ALM_ST=ALM_WDENG_1;
            ALM_HOLD_SET();
      }    
        WD1_CNT++;
        WD1H_CHG_CNT++;
        if(page==P_MAIN){
            sprintf(lcd_print_buf,"%04d",WD1H_CHG_CNT);//左4mm 2021/07/26変更 カウントのみ
            lcd_print("t10",lcd_print_buf);
        }
}


void WD_HEAD2_START_NR(unsigned char ch,unsigned char esc_dis){
       PS2_MOVE2(EWAIT_ENB);//加圧位置へ移動
       if(WD2_END_CHECK()==0){//エンド信号ありなら
            PS2_MOVE1(EWAIT_ENB);//回転位置（中点)
            HEAD2_RT(); //ヘッド1回転制御
            if(esc_dis==HEAD_ESC_EN){
                PS2_MOVE0(EWAIT_ENB);//待機位置(後退)  
            }
       }else{
            ALM_ST=ALM_WDENG_2;
            ALM_HOLD_SET();
      } 
        WD2_CNT++;
        WD2H_CHG_CNT++;//右側平
        WD2R_CHG_CNT++;//右側丸 2021/07/26   
        if(page==P_MAIN){
            sprintf(lcd_print_buf,"%04d/%04d",WD2H_CHG_CNT,WD2H_CHG_SET_DAT);//2021/07/26
            lcd_print("t6",lcd_print_buf);
            sprintf(lcd_print_buf,"%04d/%04d",WD2R_CHG_CNT,WD2R_CHG_SET_DAT);//2021/07/26
            lcd_print("t7",lcd_print_buf);
        }
}
void WD_HEAD1_START_TEST(unsigned char ch,unsigned char esc_dis){
        PS1_MOVE2(EWAIT_ENB);//加圧位置へ移動
        wait_ms(50);  
        PS1_MOVE1(EWAIT_ENB);//回転位置（中点)
        HEAD1_RT(); //ヘッド1回転制御
        if(esc_dis==HEAD_ESC_EN){
            PS1_MOVE0(EWAIT_ENB);//待機位置(後退)
        }    
        WD1_CNT++;
        WD1H_CHG_CNT++;
        if(page==P_MAIN){//2021/07/26削除
        sprintf(lcd_print_buf,"%04d",WD1H_CHG_CNT);//左4mm 2021/07/26変更 カウントのみ
        lcd_print("t10",lcd_print_buf);
        }
}

void WD_HEAD2_START_TEST(unsigned char ch,unsigned char esc_dis){
        PS2_MOVE2(EWAIT_ENB);//加圧位置へ移動
        wait_ms(50);
        
        PS2_MOVE1(EWAIT_ENB);//回転位置（中点)
        HEAD2_RT(); //ヘッド1回転制御
        if(esc_dis==HEAD_ESC_EN){
            PS2_MOVE0(EWAIT_ENB);//待機位置(後退)  
        }
        WD2_CNT++;
        WD2H_CHG_CNT++;//右側平
        WD2R_CHG_CNT++;//右側丸　2021/07/26追加     
        if(page==P_MAIN){
            sprintf(lcd_print_buf,"%04d/%04d",WD2H_CHG_CNT,WD2H_CHG_SET_DAT);//2021/07/26
            lcd_print("t6",lcd_print_buf);
            sprintf(lcd_print_buf,"%04d/%04d",WD2R_CHG_CNT,WD2R_CHG_SET_DAT);//2021/07/26
            lcd_print("t7",lcd_print_buf);
        }
}
void WD_HEAD1_START(unsigned char ch,unsigned char esc_dis){
    if(TEST_MODE_EN==0){
        WD_HEAD1_START_NR(ch,esc_dis);
    }else{
        WD_HEAD1_START_TEST(ch,esc_dis);
    }
    
}
void WD_HEAD2_START(unsigned char ch,unsigned char esc_dis){
    if(TEST_MODE_EN==0){
        WD_HEAD2_START_NR(ch,esc_dis);
    }else{
        WD_HEAD2_START_TEST(ch,esc_dis);
    }
}

//判定結果保持配列のクリア///
void WD_JUDG_CLR(){
    //NGデータで埋める//
    for(unsigned char clr=0; clr<8; clr++){
        WD_JUDG_1[clr]=WD_JUGE_NG;
        WD_JUDG_2[clr]=WD_JUGE_NG;
    }
      WD_TCNT_1=0;//A+Cパーツの一括打点カウント(L平）
      WD_TCNT_2=0;//A+Cパーツの一括打点カウント(L平） 
      WD_JUDG_NG_F=0;//2021/05/25
}
