#include "mbed.h"
#include "main.h"
#include "CUT_CONT.h"
#include "APP.h"
#include "SAVE_CONT.h"

DigitalOut C1_MOT_CW_O(PB_8);
DigitalOut C2_MOT_CW_O(PB_9);///PB_9   PC_9=試験用ダミー


Ticker C1_MOT_STEP_P;
Ticker C2_MOT_STEP_P;

unsigned long C1_MOT_STEP_S;
unsigned long C1_MOT_IRQ_CNT=0;
unsigned char C1_MOT_IRQEND_F=1;


unsigned long C2_MOT_STEP_S;
unsigned long C2_MOT_IRQ_CNT=0;
unsigned char C2_MOT_IRQEND_F=1;
/*
duaro ACC
初動 10000us
加速 5000us
通常 3750us
減速 10000us
*/
unsigned int C1_MOT_SPEED_STA=10000;
unsigned int C1_MOT_SPEED_ACC=5000;
unsigned int C1_MOT_SPEED_RUN=3750;
unsigned int C1_MOT_SPEED_DEC=10000;

unsigned int C2_MOT_SPEED_STA=10000;
unsigned int C2_MOT_SPEED_ACC=5000;
unsigned int C2_MOT_SPEED_RUN=3750;
unsigned int C2_MOT_SPEED_DEC=10000;

void C1_MOT_STEP_IRQ(void){ 
   if(C1_MOT_IRQEND_F==0 && C1_MOT_CW_O ==0){
        C1_MOT_CW_O = 1;
    }else if(C1_MOT_IRQEND_F==0 && C1_MOT_CW_O ==1){
        C1_MOT_CW_O = 0;
        C1_MOT_IRQ_CNT++;
    }
    //初動 10%
    if(C1_MOT_IRQ_CNT<(C1_MOT_STEP_S*10)/100){
        C1_MOT_STEP_P.attach_us(&C1_MOT_STEP_IRQ,C1_MOT_SPEED_STA);
    }
    //移動量の10%を超えて最終25%までの間は加速
    if(C1_MOT_IRQ_CNT>=(C1_MOT_STEP_S*10)/100&& C1_MOT_IRQ_CNT<(C1_MOT_STEP_S*25/100)){
        C1_MOT_STEP_P.attach_us(&C1_MOT_STEP_IRQ,C1_MOT_SPEED_ACC);
    }
    //移動量の25%を超えて最終5%までの間は通常速度
    if(C1_MOT_IRQ_CNT>=(C1_MOT_STEP_S*25)/100&& C1_MOT_IRQ_CNT<(C1_MOT_STEP_S*95/100)){
        C1_MOT_STEP_P.attach_us(&C1_MOT_STEP_IRQ,C1_MOT_SPEED_RUN);
    }
    //最後の5%で減速
    if(C1_MOT_IRQ_CNT>=(C1_MOT_STEP_S*95/100)){
        C1_MOT_STEP_P.attach_us(&C1_MOT_STEP_IRQ,C1_MOT_SPEED_DEC);
    }
    if(C1_MOT_IRQ_CNT==C1_MOT_STEP_S){
       C1_MOT_IRQEND_F=1; //移動完了フラグ
       C1_MOT_STEP_P.detach();
    }
}
void C1_MOT_STEP_IRQ_WAIT(){
    unsigned long timeout=0;
    while(C1_MOT_IRQEND_F==0 && timeout<1000){
        thread_sleep_for(10);
        timeout++;
    } 
    if(timeout<1000){
        //printf("MOT IRQ END=%d\r\n",C1_MOT_IRQ_CNT);
    }else{
        printf("MOT IRQ END TIMEOUT!!=%d\r\n",C1_MOT_IRQ_CNT);   
    }
}

void C1_MOT_STEP_IRQSET(unsigned long STEP){
    if(STEP !=0){
        C1_MOT_STEP_IRQ_WAIT(); //終了していない場合はwait
        C1_MOT_STEP_S=STEP;//割り込み内で使用      
        C1_MOT_IRQEND_F=0;//割り込み内で使用
        C1_MOT_IRQ_CNT=0;
        C1_MOT_STEP_P.attach_us(&C1_MOT_STEP_IRQ,C1_MOT_SPEED_STA);
    }

}
void C1_MOT_MOVE_MM(double mm,char wait_en){

    unsigned long SET_STEP=0;
    //送りロールの円周(mm)//
    double l=ROLL_DIAM*PI;
    //1回転分のステップ数//
    double R1_STEP=360/M_STEP;
    //double R1_STEP=360/(M_STEP/2);
    //1stepあたりの送り量(mm)//
    double STEP_MM=l/R1_STEP;
    double SET=mm/STEP_MM;
    SET_STEP=mm/STEP_MM;
   // printf("SET_STEP=%d\r\n",SET_STEP);
    //sprintf(lcd_print_buf,"MM=%f  R1_STEP=%f  STEP_MM=%f  SET_STEP=%d",mm,R1_STEP,STEP_MM,SET_STEP);
    //lcd_print("t0",lcd_print_buf);
    C1_MOT_STEP_IRQSET(SET_STEP);
    if(wait_en==1){
        C1_MOT_STEP_IRQ_WAIT();
    }

}
void C1_MOT_MOVE_THE(double the,char wait_en){
    

    unsigned long SET_STEP=0;
    //1回転分のステップ数//
    double R1_STEP=360/M_STEP;
   // double R1_STEP=360/(M_STEP/2);
    
    SET_STEP=R1_STEP*the/360;
    
    C1_MOT_STEP_IRQSET(SET_STEP);
    if(wait_en==1){
        C1_MOT_STEP_IRQ_WAIT();
    }


}

/////////////////////ニッケル切断機2//////////////////
void C2_MOT_STEP_IRQ(void){ 
   if(C2_MOT_IRQEND_F==0 && C2_MOT_CW_O ==0){
        C2_MOT_CW_O = 1;
    }else if(C2_MOT_IRQEND_F==0 && C2_MOT_CW_O ==1){
        C2_MOT_CW_O = 0;
        C2_MOT_IRQ_CNT++;
    }

    //初動 10%
    if(C2_MOT_IRQ_CNT<(C2_MOT_STEP_S*10)/100){
        C2_MOT_STEP_P.attach_us(&C2_MOT_STEP_IRQ,C2_MOT_SPEED_STA);
    }
    //移動量の10%を超えて最終25%までの間は加速
    if(C2_MOT_IRQ_CNT>=(C2_MOT_STEP_S*10)/100&& C2_MOT_IRQ_CNT<(C2_MOT_STEP_S*25/100)){
        C2_MOT_STEP_P.attach_us(&C2_MOT_STEP_IRQ,C2_MOT_SPEED_ACC);
    }
    //移動量の25%を超えて最終5%までの間は通常速度
    if(C2_MOT_IRQ_CNT>=(C2_MOT_STEP_S*25)/100&& C2_MOT_IRQ_CNT<(C2_MOT_STEP_S*95/100)){
        C2_MOT_STEP_P.attach_us(&C2_MOT_STEP_IRQ,C2_MOT_SPEED_RUN);
    }
    //最後の5%で減速
    if(C2_MOT_IRQ_CNT>=(C2_MOT_STEP_S*95/100)){
        C2_MOT_STEP_P.attach_us(&C2_MOT_STEP_IRQ,C2_MOT_SPEED_DEC);
    }
    if(C2_MOT_IRQ_CNT==C2_MOT_STEP_S){
       C2_MOT_IRQEND_F=1; //移動完了フラグ
       C2_MOT_STEP_P.detach();
    }
}
void C2_MOT_STEP_IRQ_WAIT(){
    unsigned long timeout=0;
    while(C2_MOT_IRQEND_F==0 && timeout<1000){
        thread_sleep_for(10);
        timeout++;
    } 
    if(timeout<1000){
        //printf("MOT IRQ END=%d\r\n",C2_MOT_IRQ_CNT);
    }else{
        printf("MOT IRQ END TIMEOUT!!=%d\r\n",C2_MOT_IRQ_CNT);   
    }
}

void C2_MOT_STEP_IRQSET(unsigned long STEP){
    if(STEP !=0){
        C2_MOT_STEP_IRQ_WAIT(); //終了していない場合はwait
        C2_MOT_STEP_S=STEP;//割り込み内で使用      
        C2_MOT_IRQEND_F=0;//割り込み内で使用
        C2_MOT_IRQ_CNT=0;
        C2_MOT_STEP_P.attach_us(&C2_MOT_STEP_IRQ,C2_MOT_SPEED_STA);
    }

}
void C2_MOT_MOVE_MM(double mm,char wait_en){

    unsigned long SET_STEP=0;
    //送りロールの円周(mm)//
    double l=ROLL_DIAM*PI;
    //1回転分のステップ数//
    double R1_STEP=360/M_STEP;
    //double R1_STEP=360/(M_STEP/2);
    //1stepあたりの送り量(mm)//
    double STEP_MM=l/R1_STEP;
    double SET=mm/STEP_MM;
    SET_STEP=mm/STEP_MM;
   // printf("SET_STEP=%d\r\n",SET_STEP);
    //sprintf(lcd_print_buf,"MM=%f  R1_STEP=%f  STEP_MM=%f  SET_STEP=%d",mm,R1_STEP,STEP_MM,SET_STEP);
    //lcd_print("t0",lcd_print_buf);
    C2_MOT_STEP_IRQSET(SET_STEP);
    if(wait_en==1){
        C2_MOT_STEP_IRQ_WAIT();
    }

}
void C2_MOT_MOVE_THE(double the,char wait_en){
    unsigned long SET_STEP=0;
    //1回転分のステップ数//
    double R1_STEP=360/M_STEP;
   // double R1_STEP=360/(M_STEP/2);
    
    SET_STEP=R1_STEP*the/360;
    
    C2_MOT_STEP_IRQSET(SET_STEP);
    if(wait_en==1){
        C2_MOT_STEP_IRQ_WAIT();
    }

}

void C1A2_MOT_STEP_IRQ_WAIT(){
    C1_MOT_STEP_IRQ_WAIT();
    C2_MOT_STEP_IRQ_WAIT();
}

void C1A2_MOT_MOVE_MM(double C1_MM,double C2_MM,char WAIT_EN){
    C1_MOT_MOVE_MM(C1_MM,WAIT_EN);
    C2_MOT_MOVE_MM(C2_MM,WAIT_EN);
}

