#include "mbed.h"
#include "main.h"
#include "nextion_lcd.h"
#include "APP.h"
#include "WORK_START.h"
///////////////////////
#include "ROBO1_CONT.h"
#include "ROBO2_CONT.h"
#include "ROBO_TWIN_CONT.h"
#include "SAVE_CONT.h"
///////////////////////
#include "PS3_BT_CTL.h"
/////////////////////////

/////////////////////////////////page 5 一時停止画面の操作//////////////////////////////////////
void PAUSE_PAGE(void)
{
    if(touch_id!=0) {
        tp_mask=1;//1=タッチパネルマスク
    }

    switch (touch_id) {
        ////caseはnextion lcdのSWに割り当てられたidを記載する///
        case BT2_RESTART :
                            lcd_page_set(P_MAIN,50);
                            //作業中であれば再開//////
                            if( WORK_STEP !=0) {
                                MAIN_PAGE_DISP();
                                lcd_print("t0","作業再開します");
                                lcd_audio_play(AU_RESTART,0,80);
                                wait_ms(2000);
                               // duAro_re_start();
                                touch_id=BT1_START;
                                tp_mask=0;//1=タッチパネルマスク
                            } else {
                                touch_id=0;
                            }
                            PAUSE_F=0;//一時停止フラグクリア

                            ALM_ST=ALM_NONE;
                            lcd_bc_color_chg("b10",63504,50);
                            MAIN_PAGE_DISP();
                            break;

        case BT2_END:
                            lcd_page_set(P_MAIN,50);
                            lcd_audio_play(AU_WEND,0,80);
                            wait_ms(2000);
                            lcd_page=0;//一時停止画面遷移チェックをクリア
                            WORK_STEP=0;
                            HOME_STATE=0; //原点復帰実行監視（1=原点復帰済み 0=未実施)
                            PAUSE_F=0;//一時停止フラグクリア
 
                            ALM_ST=ALM_NONE;
                            lcd_bc_color_chg("b10",63504,50);
                            MAIN_PAGE_DISP();
                            touch_id=0;
                            break;

    }

    if(touch_id==0 && tp_mask==1) { //タッチパネルに割りつけた作業がおわったらセンサ開始再開
        tp_mask=0;//1=タッチパネルマスク
    }
}
