#include "mbed.h"
#include "main.h"
#include "nextion_lcd.h"
#include "APP.h"
#include "WORK_START.h"
///////////////////////
#include "ROBO1_CONT.h"
#include "ROBO2_CONT.h"
#include "ROBO_TWIN_CONT.h"
#include "SAVE_CONT.h"
#include "WD_CONT.h"
#include "CUT_CONT.h"
#include "DiNi_supplyr.h"
#include "IO_CONT.h"
#include "PS3_BT_CTL.h"
DigitalOut led(LED1);
Thread ROBO_T_THREAD;


double time_chk_buf[64];

void ALL_HOME(){
    lcd_print("t0","原点復帰中・・・・");
    lcd_audio_play(AU_HOME,0,80);
    wait_ms(3000);

    ////ロボット初期位置////
     RB1A2_HOME_MOVE();
    //端子供給ハンド、押し当て軸///
    C1_HAND_FET_CONT(FET_OFF);//ハンド開
    C1_WD_FET_CONT(FET_OFF);//溶接押し当て退避
    C2_HAND_FET_CONT(FET_OFF);//ハンド開
    C2_WD_FET_CONT(FET_OFF);//溶接押し当て退避
    wait_ms(100);
    ///端子供給軸原点復帰///
    //C1_HOME();
    //C2_HOME();
    ///ダイオード搬送軸原点復帰///
    WT_HOME();
    ///ロボットをワークピックアップ待機位置へ///
    //RB1A2_SEL_MOVE(RP_EJECT,10,10);        
    //RB1A2_MOVE_EWAIT(20000);//sでタイムアウトを指定  
    ///溶接加圧軸//
    //PS1_HOME();
    //PS2_HOME();
    ////////////////
    ////ロボット速度設定///
    RB1_SPEED_SET(RB_HIGH);//ロボット１単体動作時
    RB2_SPEED_SET(RB_HIGH);//ロボット２単体動作時
    RB1A2_SPEED_SET(RB_HIGH);//ロボット１、２同時動作時
    
    /////ダイオード搬送軸　待機位置（ダイオード投入）へ/////
    WT_MOVE(POS_WT_WAIT);
    WT_MOVE_EWAIT();
    
    lcd_print("t0","準備完了しました");
    lcd_audio_play(AU_STBOK,0,80);
    HOME_STATE=1; //原点復帰実行監視（1=原点復帰済み 0=未実施)
    WORK_STEP=0;
    CUT1_STBY_CHK=0;
    CUT2_STBY_CHK=0;
}

void ALL_HOME_OLG(){
    lcd_print("t0","原点復帰中・・・・");
    lcd_audio_play(AU_HOME,0,80);
    wait_ms(3000);
    /////////////////
    RB1_SEND_CMD("EnableRobot()");
    RB1_CMD_WAIT(RB_SWAIT);
    
    RB2_SEND_CMD("EnableRobot()");
    RB2_CMD_WAIT(RB_SWAIT);
    
    RB1_SEND_CMD("ClearError()");    
    RB1_CMD_WAIT(RB_SWAIT);
    
    RB2_SEND_CMD("ClearError()");    
    RB2_CMD_WAIT(RB_SWAIT);
    
    ////ロボット原点復帰速度////
    RB1_SPEED_SET(RB_LOW);
    RB2_SPEED_SET(RB_LOW);
    RB1A2_SPEED_SET(RB_LOW);
    ////ロボット初期位置////
    RB1_HOME_MOVE();
    RB2_HOME_MOVE();
    

    //端子供給ハンド、押し当て軸///
    C1_HAND_FET_CONT(FET_OFF);//ハンド開
    C1_WD_FET_CONT(FET_OFF);//溶接押し当て退避
    C2_HAND_FET_CONT(FET_OFF);//ハンド開
    C2_WD_FET_CONT(FET_OFF);//溶接押し当て退避
    wait_ms(100);
    ///端子供給軸原点復帰///
    C1_HOME();
    C2_HOME();
    ///ダイオード搬送軸原点復帰///
    WT_HOME();
    ///溶接加圧軸//
    PS1_HOME();
    PS2_HOME();
    
    ////ロボット運転速度////
    RB1_SPEED_SET(RB_HIGH);
    RB2_SPEED_SET(RB_HIGH);
    RB1A2_SPEED_SET(RB_HIGH);
    ////////////////
    lcd_print("t0","準備完了しました");
    lcd_audio_play(AU_STBOK,0,80);
    HOME_STATE=1; //原点復帰実行監視（1=原点復帰済み 0=未実施)
    WORK_STEP=0;
    CUT1_STBY_CHK=0;//初回ニッケルカット確認（バックラッシュ対策)
    CUT2_STBY_CHK=0;//初回ニッケルカット確認（バックラッシュ対策)
    FIRST_WORK_F=0;//最初のワークを生産済みかのフラグ(32mm事前準備しているか確認用）
}



void MAIN_PAGE(void)
{
    PS3_MAIN_CONT();
    if(touch_id!=0 &&touch_id!=BT1_START ) { //作業中は、一時停止受付るため、マスクしない
        tp_mask=1;//1=タッチパネルマスク
    }
        ///作業中にSTARTまたは、PAUSE以外のタッチIDを検出したら強制クリアして無視する。///
    if(WORK_STEP !=0 && touch_id!=0 && touch_id!=BT1_START && touch_id !=BT1_PAUSE && touch_id!=BT1_STEP_MODE) {
        lcd_print("t0","作業中に無効な操作を検出しました。(作業開始で再開）");
        touch_id=0;
        tp_mask=0;
    }
      switch (touch_id) {
        ////caseはnextion lcdのSWに割り当てられたidを記載する///

        case BT1_START:   
                            ////原点復帰完了確認/////
                            if(HOME_STATE==0) { //原点復帰実行監視（1=原点復帰済み 0=未実施)
                                lcd_print("t0","原点復帰してください");
                                lcd_audio_play(AU_HOME_ERR,0,80);
                                wait_ms(2000);
                                LOOP_MODE_F=0;
                                touch_id=0;
                                break;
                             }
                       
                            /*
                            ////端子供給（左）準備完了（初回端子カット済み）チェック///////2021/06/22　新規追加
                            if(CUT1_STBY_CHK!=1){//1で準備完了（初回端子カット済み）
                                lcd_print("t0","端子供給（左）初回端子カット未実施");
                                lcd_audio_play(AU_TANSI_STB,0,80);
                                wait_ms(2000);//端子供給装置側のACK_O信号の論理が1000msで復帰なのでそれ以上のwaitを入れておく
                                LOOP_MODE_F=0;
                                touch_id=0;  
                                break;    
                            }
                                                        ////端子供給（右）準備完了（初回端子カット済み）チェック///////2021/06/22　新規追加
                            if(CUT2_STBY_CHK!=1){//1で準備完了（初回端子カット済み）
                                lcd_print("t0","端子供給（右） 初回端子カット未実施");
                                lcd_audio_play(AU_TANSI_STB,0,80);
                                wait_ms(2000);//端子供給装置側のACK_O信号の論理が1000msで復帰なのでそれ以上のwaitを入れておく
                                LOOP_MODE_F=0;
                                touch_id=0;  
                                break; 
                               
                            }
                            */
                            /*
                            ///ワークのセット状態を確認////
                            if(WORK_STEP==0 && TEST_MODE_EN==0 &&IO_EX_BIT_READ(WORK_SENS_I)==IOEX_OFF_I){
                                lcd_print("t0","ワークセット異常です。");
                                lcd_audio_play(AU_WORK_NG,0,80);
                                wait_ms(2000);
                                LOOP_MODE_F=0;
                                touch_id=0;  
                                break;
                            } 
                            */
                                                        ///作業開始時の処理////////
                            if(WORK_STEP==0) {
                                if(LOOP_MODE_F==0){//1でループモードON 
                                    lcd_print("t0","作業中");
                                }else{
                                    lcd_print("t0","連続作業中");
                                }
                                if(LOOP_MODE_F==0){
                                    lcd_audio_play(AU_WORK_START,0,80);
                                }
                                //打点カウントクリア
                                WD1_CNT=0;
                                WD2_CNT=0;
                                //判定結果保持配列のクリア///
                                WD_JUDG_CLR();
                                t_tact.reset();//タイマー起動(タクト測定)
                                t_tact.start();
                                
                                //t_test.reset();//タイマー起動(タクト測定)
                                //t_test.start();
         
                            }
                            //sprintf(lcd_print_buf,"WORK_STEP=%02d",WORK_STEP);
                            //lcd_print("t0",lcd_print_buf);
                            ///////////作業開始(作業完了繰り返し実行）////////////////////////////
                            WORK_START();
                            //t_test.stop();
                            //time_chk_buf[WORK_STEP]=t_test.read();         
                            //t_test.reset();//タイマー起動(タクト測定)
                            //t_test.start();
                            
                            
                            
                            ///////////作業終了処理/////////////////////////
                            if(W_STEP_END==1) { //最終ステップ終了フラグ
                                W_STEP_END=0;
                                WORK_STEP=0;  
                                t_tact.stop();
                                tact_chk=t_tact.read();
                                printf("The time taken was %2.4f s\r\n",tact_chk);
                                sprintf(lcd_print_buf,"作業完了(%2.4f s)",tact_chk);
                                lcd_print("t0",lcd_print_buf);
                                sprintf(lcd_print_buf,"%2.4f s",tact_chk);
                                lcd_print("t22",lcd_print_buf);
                                ///////////////////////////////
                               /* for(unsigned char tcnt=0; tcnt<24; tcnt++){
                                    printf("TIME[%02d] = %2.4f\r\n",tcnt,  time_chk_buf[tcnt]);
                                    
                                }
                                */
                                
                                //wait_ms(2000);
                                //極棒交換回数の確認//
                                BAR_CHG_CHK();
                                //溶接結果確認画面表示判定//
                                if(WD_JUDG_NG_F==1){
                                    WD_JUDG_DISP_F=1;//1で溶接結果確認画面表示
                                } 
                                ////溶接NGまたは極棒交換がなければ通常の作業終了メッセージ鳴動
                                if(WD_JUDG_DISP_F==0 && BAR_CHG_DISP_F==0 && LOOP_MODE_F==0){
                                 lcd_audio_play(AU_WEND,0,80);
                                }
                                if(LOOP_MODE_F==0){//1でループモードON ループモード時は、touch_idをくりあしないで継続
                                    touch_id=0;
                                }
                            }
                          
                            if(STEP_MODE_F==1){//1でステップモードON
                                sprintf(lcd_print_buf,"STEP :%02d 完了", WORK_STEP-1);
                                lcd_print("t0",lcd_print_buf);
                                //DFP_PALY_NO(0x01,AU_ROBO_HSTB);//ピンポン音
                                touch_id=0;
                            }      
                            break;  
        case BT1_RE_START:  //連続運転///
        
        
                            LOOP_MODE_F=1;//1でループモードON 
                            lcd_audio_play(AU_WORK_START,0,80);
                            touch_id=BT1_START;
                            tp_mask=0;//1=タッチパネルマスク
                            break;
        case BT1_PAUSE :
                            touch_id=0;
                            break;

        case BT1_HOME:                              
                            ALL_HOME();
                            touch_id=0; 
                            break;
        case BT1_PDA_3_P:   
                            if(PD_CNT_A_3<=9){
                                PD_CNT_A_3++;
                            }
                            if(PD_CNT_A_3==10){
                                PD_CNT_A_3=0;
                            }
                            sprintf(lcd_print_buf,"%d",PD_CNT_A_3);
                            lcd_print("t12",lcd_print_buf); 
                            PD_CNT_A=PD_CNT_A_3*100+PD_CNT_A_2*10+PD_CNT_A_1;
                            wait_ms(60);
                            touch_id=0;
                            break;
        case BT1_PDA_3_M:   
                            if(PD_CNT_A_3==0){
                                PD_CNT_A_3=9;
                            }else if(PD_CNT_A_3>=1){
                                PD_CNT_A_3--;
                            }
       
                            sprintf(lcd_print_buf,"%d",PD_CNT_A_3);
                            lcd_print("t12",lcd_print_buf); 
                            PD_CNT_A=PD_CNT_A_3*100+PD_CNT_A_2*10+PD_CNT_A_1;
                            wait_ms(60);
                            touch_id=0;
                            break;
        case BT1_PDA_2_P:   
                            if(PD_CNT_A_2<=9){
                                PD_CNT_A_2++;
                            }
                            if(PD_CNT_A_2==10){
                                PD_CNT_A_2=0;
                            }
                            sprintf(lcd_print_buf,"%d",PD_CNT_A_2);
                            lcd_print("t13",lcd_print_buf); 
                            PD_CNT_A=PD_CNT_A_3*100+PD_CNT_A_2*10+PD_CNT_A_1;
                            wait_ms(60);
                            touch_id=0;
                            break;
        case BT1_PDA_2_M:   
                            if(PD_CNT_A_2==0){
                                PD_CNT_A_2=9;
                            }else if(PD_CNT_A_2>=1){
                                PD_CNT_A_2--;
                            }
                            sprintf(lcd_print_buf,"%d",PD_CNT_A_2);
                            lcd_print("t13",lcd_print_buf); 
                            PD_CNT_A=PD_CNT_A_3*100+PD_CNT_A_2*10+PD_CNT_A_1;
                            wait_ms(60);
                            touch_id=0;
                            break;
        case BT1_PDA_1_P:   
                            if(PD_CNT_A_1<=9){
                                PD_CNT_A_1++;
                            }
                            if(PD_CNT_A_1==10){
                                PD_CNT_A_1=0;
                            }
                            sprintf(lcd_print_buf,"%d",PD_CNT_A_1);
                            lcd_print("t14",lcd_print_buf); 
                            PD_CNT_A=PD_CNT_A_3*100+PD_CNT_A_2*10+PD_CNT_A_1;
                            wait_ms(60);
                            touch_id=0;
                            break;
        case BT1_PDA_1_M:   
                            if(PD_CNT_A_1==0){
                                PD_CNT_A_1=9;
                            }else if(PD_CNT_A_1>=1){
                                PD_CNT_A_1--;
                            }
                            sprintf(lcd_print_buf,"%d",PD_CNT_A_1);
                            lcd_print("t14",lcd_print_buf); 
                            PD_CNT_A=PD_CNT_A_3*100+PD_CNT_A_2*10+PD_CNT_A_1;
                            wait_ms(60);
                            touch_id=0;
                            break;
        case BT1_PDA_CL:   
                            PD_CNT_A=0;
                            PD_CNT_A_DISP();
                            wait_ms(60);
                            touch_id=0;
                            break;   
                            
        case BT1_NI1_OUT:   
                            lcd_print("t0","端子供給１側　テスト出力"); 
                            C1_MOT_MOVE_MM(C1_SET_50MM,MOT_WAIT_EN);
                            CUT1_STBY_CHK=2;
                            lcd_audio_play(AU_PINCON ,0,80);
                            lcd_print("t0","端子供給１側　テスト出力完了"); 
                            touch_id=0;
                            break;
        case BT1_NI1_CUT:   
                            lcd_print("t0","端子供給１側　端子カット"); 
                            C1_CUT_FET_CONT(FET_ON);
                            wait_ms(100);
                            C1_CUT_FET_CONT(FET_OFF);
                            wait_ms(100);
                            if(CUT1_STBY_CHK==2){
                                CUT1_STBY_CHK=1;   
                            }
                            lcd_print("t0","端子供給１側　端子カット完了"); 
                            touch_id=0;
                            break;
        case BT1_RB1ADJ:   
                            ////原点復帰完了確認/////
                            if(HOME_STATE==0) { //原点復帰実行監視（1=原点復帰済み 0=未実施)
                                lcd_print("t0","原点復帰してください");
                            lcd_audio_play(AU_HOME_ERR,0,80);
                            wait_ms(2000);
                            LOOP_MODE_F=0;
                            touch_id=0;
                            break;
                            }
                            lcd_page_set(P_ROBO1_ADJ,100);
                            ROBO1_ADJ_DISP();
                            touch_id=0;
                            break;                            
                                                                            
        case BT1_PDC_3_P:   
                            if(PD_CNT_C_3<=9){
                                PD_CNT_C_3++;
                            }
                            if(PD_CNT_C_3==10){
                                PD_CNT_C_3=0;
                            }
                            sprintf(lcd_print_buf,"%01d",PD_CNT_C_3);
                            lcd_print("t15",lcd_print_buf); 
                            PD_CNT_C=PD_CNT_C_3*100+PD_CNT_C_2*10+PD_CNT_C_1;
                            wait_ms(60);
                            touch_id=0;
                            break;
        case BT1_PDC_3_M:   
                            if(PD_CNT_C_3==0){
                                PD_CNT_C_3=9;
                            }else if(PD_CNT_C_3>=1){
                                PD_CNT_C_3--;
                            }
                            sprintf(lcd_print_buf,"%01d",PD_CNT_C_3);
                            lcd_print("t15",lcd_print_buf); 
                            PD_CNT_C=PD_CNT_C_3*100+PD_CNT_C_2*10+PD_CNT_C_1;
                            wait_ms(60);
                            touch_id=0;
                            break;
        case BT1_PDC_2_P: 
                            if(PD_CNT_C_2<=9){
                                PD_CNT_C_2++;
                            }
                            if(PD_CNT_C_2==10){
                                PD_CNT_C_2=0;
                            }
                            sprintf(lcd_print_buf,"%01d",PD_CNT_C_2);
                            lcd_print("t16",lcd_print_buf); 
                            PD_CNT_C=PD_CNT_C_3*100+PD_CNT_C_2*10+PD_CNT_C_1;
                            wait_ms(60);
                            touch_id=0;  
                            break;
        case BT1_PDC_2_M:   
                            if(PD_CNT_C_2==0){
                                PD_CNT_C_2=9;
                            }else if(PD_CNT_C_2>=1){
                                PD_CNT_C_2--;
                            }
                            sprintf(lcd_print_buf,"%01d",PD_CNT_C_2);
                            lcd_print("t16",lcd_print_buf); 
                            PD_CNT_C=PD_CNT_A_3*100+PD_CNT_C_2*10+PD_CNT_C_1;
                            wait_ms(60);
                            touch_id=0;
                            break;
        case BT1_PDC_1_P:   
                            if(PD_CNT_C_1<=9){
                                PD_CNT_C_1++;
                            }
                            if(PD_CNT_C_1==10){
                                PD_CNT_C_1=0;
                            }
                            sprintf(lcd_print_buf,"%01d",PD_CNT_C_1);
                            lcd_print("t17",lcd_print_buf); 
                            PD_CNT_C=PD_CNT_C_3*100+PD_CNT_C_2*10+PD_CNT_C_1;
                            wait_ms(60);
                            touch_id=0;
                            break;
        case BT1_PDC_1_M:   
                            if(PD_CNT_C_1==0){
                                PD_CNT_C_1=9;
                            }else if(PD_CNT_C_1>=1){
                                PD_CNT_C_1--;
                            }
                            sprintf(lcd_print_buf,"%01d",PD_CNT_C_1);
                            lcd_print("t17",lcd_print_buf); 
                            PD_CNT_C=PD_CNT_C_3*100+PD_CNT_C_2*10+PD_CNT_C_1;
                            wait_ms(60);
                            touch_id=0;
                            break;
        case BT1_PDC_CL:  
                            PD_CNT_C=0;
                            PD_CNT_C_DISP();
                            wait_ms(60);
                            touch_id=0; 
                            break;                             
        case BT1_NI2_OUT:   //右ニッケル端子テスト出力///
                            lcd_print("t0","端子供給２側　テスト出力"); 
                            C2_MOT_MOVE_MM(C2_SET_50MM,MOT_WAIT_EN);
                            lcd_audio_play(AU_PINCON ,0,80);
                            CUT2_STBY_CHK=2;
                            lcd_print("t0","端子供給２側　テスト出力完了"); 
                            touch_id=0;
                            break;
        case BT1_NI2_CUT:   //右ニッケル端子カット///
                            lcd_print("t0","端子供給２側　端子カット"); 
                            C2_CUT_FET_CONT(FET_ON);
                            wait_ms(100);
                            C2_CUT_FET_CONT(FET_OFF);
                            wait_ms(100);
                            if(CUT2_STBY_CHK==2){
                                 CUT2_STBY_CHK=1;   
                            }
                            lcd_print("t0","端子供給２側 子カット完了"); 
                            touch_id=0;
                            break;
        case BT1_RB2ADJ:   
                            ////原点復帰完了確認/////
                            if(HOME_STATE==0) { //原点復帰実行監視（1=原点復帰済み 0=未実施)
                                lcd_print("t0","原点復帰してください");
                                lcd_audio_play(AU_HOME_ERR,0,80);
                                wait_ms(2000);
                                LOOP_MODE_F=0;
                                touch_id=0;
                                break;
                            }
                            lcd_page_set(P_ROBO2_ADJ,100);
                            ROBO2_ADJ_DISP();
                            touch_id=0;
                            break;      
        case BT1_WCHG1_CLR:   
                            WD1H_CHG_CNT=0;//極棒1 
                            sprintf(lcd_print_buf,"%04d/%04d",WD1H_CHG_CNT,WD1H_CHG_SET_DAT);
                            lcd_print("t19",lcd_print_buf);
                            wait_ms(60);
                            touch_id=0;//毎回停止
                            break; 
        case BT1_WCHG2H_CLR:   
                            WD2H_CHG_CNT=0;//極棒1 
                            sprintf(lcd_print_buf,"%04d/%04d",WD2H_CHG_CNT,WD2H_CHG_SET_DAT);
                            lcd_print("t7",lcd_print_buf);
                            wait_ms(60);
                            touch_id=0;//毎回停止
                            break; 
        case BT1_WCHG2R_CLR:   
                            WD2R_CHG_CNT=0;//極棒1 
                            sprintf(lcd_print_buf,"%04d/%04d",WD2R_CHG_CNT,WD2R_CHG_SET_DAT);
                            lcd_print("t8",lcd_print_buf);
                            wait_ms(60);
                            touch_id=0;//毎回停止
                            break; 
        case BT1_CHG_SET:   
                            lcd_page_set(P_CHGSET,50);
                            BC_SET_DISP();
                            touch_id=0;
                            break; 
        case BT1_BAR_CHG:   
                            lcd_page_set(P_BARCHG,50);
                            touch_id=0;
                            break; 
        case BT1_PULL_TST:   
                            ////原点復帰完了確認/////
                            if(HOME_STATE==0) { //原点復帰実行監視（1=原点復帰済み 0=未実施)
                                lcd_print("t0","原点復帰してください");
                                lcd_audio_play(AU_HOME_ERR,0,80);
                                wait_ms(2000);
                                touch_id=0;
                                break;
                            } 
                            lcd_page_set(P_PULLTEST,50);
                            touch_id=0;
                            break; 
        case BT1_JUG_DISP:   
                            lcd_page_set(P_WD_JUDGE,50);
                            WD_JUDG_DISP();
                            touch_id=0;
                            break; 
        case BT1_TEST_MODE: 
                            /*  
                            if(TEST_MODE_EN==0) { //1=テストモード
                                TEST_MODE_EN=1;
                                lcd_print("t0","テストモードに切り替えました");
                                lcd_bc_color_chg("b11",LCD_RED,50);
                            } else {
                                TEST_MODE_EN=0;
                                lcd_print("t0","テストモードを解除しました");
                                lcd_bc_color_chg("b11",2032,50);
                            }*/
                            lcd_page_set(P_JIKUTEST,50);//暫定（あとでボタンを作る）
                            touch_id=0;
                            break; 
        case BT1_STEP_MODE:   
                            if(STEP_MODE_F==0){//1でステップモードON 
                                lcd_bc_color_chg("b27",LCD_RED,50);
                                STEP_MODE_F=1;//1でステップモードON
                                lcd_print("t0","ステップ実行モードに切り替えました");
                            }else{
                                lcd_bc_color_chg("b27",2032,50);
                                STEP_MODE_F=0;//1でステップモードON 
                                lcd_print("t0","ステップ実行モードを解除しました");
                            }
                            touch_id=0;
                            break;    
        case BT1_NI_ADJ:   
                            lcd_page_set(P_TANSI_MNT,50);
                            TANSHI_L_DISP();
                            touch_id=0;
                            break;   
        case BT1_MUTE:
                            if(MUTE_ST==0){
                                 lcd_audio_vol(0,100);//val=0から100
                                 MUTE_ST=1;
                                 lcd_bc_color_chg("b39",LCD_GRAY,50);
                            }else{
                                lcd_audio_vol(80,100);//val=0から100
                                 MUTE_ST=0;
                                 lcd_bc_color_chg("b39",2032,50);     
                                
                            }
                            touch_id=0;
                            break;  
        case BT1_RB_SPEED:
                            if(RB_SPEED_ST==RB_HIGH){
                                lcd_print("t0","ロボット速度が低速モードになりました。"); 
                                RB_SPEED_ST=RB_LOW;
                                RB1_SPEED_SET(RB_LOW);
                                RB2_SPEED_SET(RB_LOW);
                                RB1A2_SPEED_SET(RB_LOW);
                                lcd_bc_color_chg("b40",LCD_RED,50);
                                 
                            }else{
                                lcd_print("t0","ロボット速度が通常（高速）モードになりました。"); 
                                RB_SPEED_ST=RB_HIGH;
                                RB1_SPEED_SET(RB_HIGH);
                                RB2_SPEED_SET(RB_HIGH);
                                RB1A2_SPEED_SET(RB_HIGH);
                                lcd_bc_color_chg("b40",34815,50); 
                            }
                            touch_id=0;
                            break;                      
        case BT1_TIME:          //時計合わせ
                            ////作業途中では、受け付けない///////
                            if(WORK_STEP!=0){
                                lcd_print("t0","作業途中では、操作できません。");
                                lcd_audio_play(AU_ERR,0,50);
                                wait_ms(2000);
                                touch_id=0;
                                break;
                            }
                            
                            lcd_page_set(P_TIME ,100);
                            touch_id=0;
                            break;                           
                                           
    }
    if(touch_id==0 && tp_mask==1) {
        tp_mask=0;//1=タッチパネルマスク
    }
    //AREA_SENS_CHEK();

    PAUSE_CHK();
}