#define ALM_HOLD 1
#define RB_SWAIT 2000   //msで指定 移動開始待ち
#define RB_EWAIT 5000   //msで指定 移動完了待ち

#define RB_HIGH 0
#define RB_LOW  1

#define RB_SPEED_HIGH 100
#define RB_SPEED_LOW  20

#define RB_ACC_HIGH   80
#define RB_ACC_LOW    50

/////////ALM状態//////
#define ALM_NONE        0       //ALM無し（正常）
#define ALM_PS1_HM      1       //加圧軸1原点復帰
#define ALM_PS1_ST      2       //加圧軸1移動開始
#define ALM_PS1_ED      3       //加圧軸1移動完了


#define ALM_PS2_HM      4       //加圧軸2原点復帰
#define ALM_PS2_ST      5       //加圧軸2移動開始
#define ALM_PS2_ED      6       //加圧軸2移動完了

#define ALM_NISP1_HM    7       //ニッケル搬送軸1原点復帰
#define ALM_NISP1_ST    8       //ニッケル搬送軸1移動開始
#define ALM_NISP1_ED    9       //ニッケル搬送軸1移動終了

#define ALM_NISP2_HM    10       //ニッケル搬送軸2原点復帰
#define ALM_NISP2_ST    11       //ニッケル搬送軸2移動開始
#define ALM_NISP2_ED    12       //ニッケル搬送軸2移動完了

#define ALM_DISP_HM     13       //ダイオード搬送軸原点復帰   
#define ALM_DISP_ST     14       //ダイオード搬送軸移動開始   
#define ALM_DISP_ED     15       //ダイオード搬送軸移動完了

#define ALM_DOBOT1      16       //DOBOT1異常   
#define ALM_DOBOT1_ST   17       //DOBOT1移動開始
#define ALM_DOBOT1_ED   18       //DOBOT1移動完了
#define ALM_DOBOT1_CM   19       //DOBOT1コマンド送信失敗

#define ALM_DOBOT2      20       //DOBOT2異常   
#define ALM_DOBOT2_ST   21       //DOBOT2移動開始
#define ALM_DOBOT2_ED   22       //DOBOT2移動完了
#define ALM_DOBOT2_CM   23       //DOBOT2コマンド送信失敗

#define ALM_DOBOT12     24       //DOBOT1,2コマンド応答異常
#define ALM_DOBOT12_ST  25       //DOBOT1,2移動開始  
#define ALM_DOBOT12_ED  26       //DOBOT1,2移動完了

#define ALM_WDENG_1     27       //溶接エンド信号受信NG 左（平）
#define ALM_WDENG_2     28       //溶接エンド信号受信NG 右（丸）
#define ALM_WDENG_12    29      //溶接エンド信号受信NG 両方
#define ALM_SD          30      //ＳＤカードアクセス異常

/////////ERR状態//////
#define ERR_NONE        0       //ERRなし
#define ERR_WORK        1       //端子供給機0系異常(端子切れ）
#define ERR_CUT1        2       //端子供給機0系異常(端子切れ）
#define ERR_CUT2        3       //端子供給機1系異常(端子切れ）
#define ERR_AREA        4       //エリアセンサ検出
#define ERR_WDNG_1      5       //溶接コンパレート外れ左（平）
#define ERR_WDNG_2      6       //溶接コンパレート外れ右（丸）
#define ERR_WDNG_12     7       //溶接コンパレート外れ両方



extern unsigned char MUTE_ST;//1で消音状態
extern unsigned char RB_SPEED_ST;//1で低速
extern unsigned char RB1_POSE_DISP_EN;//1:JOG動作中の位置表示リアルタイム更新有効
extern unsigned char RB2_POSE_DISP_EN;//1:JOG動作中の位置表示リアルタイム更新有効
extern unsigned char RB1_PSEL;//ロボットポジションセレクト
extern unsigned char RB2_PSEL;//ロボットポジションセレクト
extern unsigned char RB1_PSEL_BAK;
extern unsigned char RB2_PSEL_BAK;


extern unsigned char MOVE_MODE_ST;//0=通常　1=JOG
extern unsigned char WD_JUDG_DISP_F;//1で溶接結果確認画面表示
extern unsigned char BAR_CHG_DISP_F;//1で極棒交換画面表示


extern unsigned int  rtc_year;    //年
extern unsigned char rtc_month;      //月
extern unsigned char rtc_date;      //日
extern unsigned char rtc_hour;      //時
extern unsigned char rtc_min;    //分
extern unsigned char rtc_sec;       //秒

extern unsigned char tp_mask;//1=タッチパネルマスク
extern unsigned char EDIT_SEL;
extern double EDIT_DATA;

extern unsigned char RB1_POSE_DISP_EN;//1:JOG動作中の位置表示リアルタイム更新有効
extern unsigned char RB2_POSE_DISP_EN;//1:JOG動作中の位置表示リアルタイム更新有効

extern unsigned char ROBO_SPEED_DEF;

extern Timer t_tact;//タクト確確認用
extern Timer t_test;//試験用タイマー
extern float time_chk;



////////////////DUAROより移植///////////////
extern Timer t_tact;//タクト確確認用
extern float time_chk;
extern float tact_chk;//タクト確認用

extern unsigned char LOOP_MODE_F;//1でループモードON 
extern unsigned char STEP_MODE_F;//1でステップモードON 

extern unsigned char WORK_STEP;  //ワークステップ（一連動作の進捗）
extern unsigned char WORK_STATE; //作業中フラグ(1=作業中 0=待機中)
extern unsigned char HOME_STATE; //原点復帰実行監視（1=原点復帰済み 0=未実施)

extern unsigned char W_STEP_END;//ワークステップの最後の処理が終了時に1

extern unsigned char STEP_STBY_F;//ステップ実行準備完了フラグ 1で準備完了
extern unsigned char CUT1_STBY_CHK;//1で準備完了（初回端子カット済み）
extern unsigned char CUT2_STBY_CHK;//1で準備完了（初回端子カット済み）


extern unsigned char HAND1_ESC_F;//1でハンド退避済み（左側極棒交換用）
extern unsigned char HAND2_ESC_F;//1でハンド退避済み（右側極棒交換用）

///極棒交換回数設定用

extern unsigned long WD1H_CHG_SET_DAT;//極棒交換回数

extern unsigned char WD1H_CHGDAT_4;
extern unsigned char WD1H_CHGDAT_3;
extern unsigned char WD1H_CHGDAT_2;
extern unsigned char WD1H_CHGDAT_1;

extern unsigned long WD2H_CHG_SET_DAT;//極棒交換回数

extern unsigned char WD2H_CHGDAT_4;
extern unsigned char WD2H_CHGDAT_3;
extern unsigned char WD2H_CHGDAT_2;
extern unsigned char WD2H_CHGDAT_1;

extern unsigned long WD2R_CHG_SET_DAT;//極棒交換回数

extern unsigned char WD2R_CHGDAT_4;
extern unsigned char WD2R_CHGDAT_3;
extern unsigned char WD2R_CHGDAT_2;
extern unsigned char WD2R_CHGDAT_1;

extern unsigned char BAR_CHG_MODE;//0=交換なし  1=極棒1のみ　2=極棒2のみ 3=極棒1,2両方
extern unsigned char PSTB_LOK_F;//1=引っ張り試験準備ok左側
extern unsigned char PSTB_ROK_F;//1=引っ張り試験準備ok左側
extern unsigned char WORK_STEP;
extern unsigned long PD_CNT_A;
extern unsigned long PD_CNT_C;
extern unsigned char TEST_MODE_EN; //1=テストモード

extern unsigned char PD_CNT_A_3;
extern unsigned char PD_CNT_A_2;
extern unsigned char PD_CNT_A_1;

extern unsigned char PD_CNT_C_3;
extern unsigned char PD_CNT_C_2;
extern unsigned char PD_CNT_C_1;

extern unsigned char ERR_ST;//ERR状態
extern unsigned char ALM_ST;//ALM状態


/////端子切断機用///////////////////
extern unsigned char ADJ_DAT_3;
extern unsigned char ADJ_DAT_2;
extern unsigned char ADJ_DAT_1;
extern unsigned char ADJ_MODE;//0=50 1=32 2=23
/////////ALM状態//////
#define ALM_NONE        0       //ALM無し（正常）
#define ALM_MAIN        1       //MAIN制御部異常 （加圧軸等）  
#define ALM_DUARO       2       //duAro異常   
#define ALM_CUT0        3       //端子供給機0系異常(端子切れ）
#define ALM_CUT1        4       //端子供給機1系異常(端子切れ）
#define ALM_AREA        5       //エリアセンサ検出
#define ALM_WDNG_L      6       //溶接コンパレート外れ左（平）
#define ALM_WDNG_R      7       //溶接コンパレート外れ右（丸）
#define ALM_WDNG_LR     8       //溶接コンパレート外れ両方

////////////////DUAROより移植///////////////


void BAR_CHG_CHK();
void BC_SET_DISP();
void WD_JUDG_DISP();
void MAIN_PAGE_DISP();
void TANSHI_L_DISP();
void ADJ_DISP();
void PD_CNT_A_DISP();
void PD_CNT_C_DISP();
void ROBO1_ADJ_DISP();
void ROBO2_ADJ_DISP();



void MG400_AP(void);
void ALM_HOLD_SET();
void RTC_GET(void);
void RB1_POSE_DISP();
void RB2_POSE_DISP();
void POUSE_PAGE_DISP(); //一時停止表示
void PAUSE_CHK();
void AREA_SENS_CHEK(void);


void MAIN_PAGE(void);//01
void PAUSE_PAGE(void);//02
void BARCHG_PAGE(void);//03
void CHGSET_PAGE(void);//04
void PULLTEST_PAGE(void);//05
void WD_JUDGE_PAGE(void);//06
void TANSI_MNT_PAGE(void);//07
void NI_ADJ_PAGE(void);//08
void ROBO1_ADJ_PAGE(void);//09
void ROBO2_ADJ_PAGE(void);//10
void ROBO1_KEY_PAGE(void);//11
void ROBO2_KEY_PAGE(void);//12
void ROBO_ALM_PAGE(void);//13
void JIKUTEST_PAGE(void);//17 
void WD_CNT_DISP();






