
#include "mbed.h"
#include "main.h"
#include "nextion_lcd.h"
#include "APP.h"
#include "main.h"
static UnbufferedSerial *nx_lcd;

char lcd_print_buf[64];
Ticker LCD_RX_TIME_OUT;
unsigned char page=0;//lcd画面ページ
unsigned char page_bak=0;//lcd画面ページ(一個前のページ）
unsigned char PAUSE_F=0;//一時停止;
unsigned char lcd_rx_buf_cnt=0;
char lcd_rx_buf[64];
int nx_lineIndex;
char lot_edit_set[32];
unsigned char LOT_EDIT_F=0;


extern char lcd_print_buf[64];
extern unsigned char a_read_ng;//audio file read ng

extern unsigned char tp_mask;//1=タッチパネルマスク

void nx_lcd_rx ();
void nx_sw_chk(void);
unsigned char touch_id=0;
unsigned char  vc_ds_sw=0;//DUAL STATE SWの論理確認用
unsigned char val_get=0;//ボリューム取得完了フラグ(1で完了)
unsigned char val_st=0;//ボリューム状態
unsigned char page_get=0;//ページ取得済み1
unsigned char page_st=0xFF;//ページNo

unsigned char touch_p=0xFF;//ボタンタッチ時のページ識別ID
unsigned char touch_t=0xFF;//ボタンのトグル状態　1=on 0=off(タッチパネル設定でボタンを離した時にもデータ送信設定した場合の識別）

unsigned char lcd_page=0;//lcdからページを取得した場合、ページNoが入る


char temdat[3];
char dcdat[3];
///ロット編集結果の取り込み//(SD保存する場合は、config.cppのLOT_DAT_WR()を実行
void lot_edit_chk(void){
  for(unsigned char cp=0; cp<lcd_rx_buf_cnt ; cp++){         
        lot_edit_set[cp]=lcd_rx_buf[cp];
    }
    lot_edit_set[lcd_rx_buf_cnt-1]=NULL;//で終端
    buf_clr();
    LOT_EDIT_F=1;//1=ロット編集あり

}
void nx_printf(char *txt){
    char tx_buf[64];
    unsigned char len = strlen(txt);//文字列の長さを確認
    nx_lcd->write(txt,len);  
}

///受信タイムアウト処理/////
void LCD_RX_TIMEOUT_IRQ(void){
      LCD_RX_TIME_OUT.detach();//シリアル受信タイムアウトカウンタ停止
      buf_clr();
}
void buf_clr(void){
   char rxdat[8];
  //読み捨て処理
   while(nx_lcd->readable()==1){
       nx_lcd->read(rxdat,1);
   }
    
    for(unsigned char clrcnt=0; clrcnt<sizeof(lcd_rx_buf); clrcnt++){
        lcd_rx_buf[clrcnt]=0x00;
       
    }
    lcd_rx_buf_cnt=0;
    nx_lineIndex=0; 

}

unsigned char nx_val_get(char *obj){
    char buf[64];
    unsigned char time_out=0;
    unsigned char tp_mask_bak=tp_mask;
    if(tp_mask_bak==1){
        tp_mask=0;//1=タッチパネルマスク解除
    }
    val_get=0;
    val_st=0xFF;
    sprintf(buf,"get %s.val",obj);
    nx_printf(buf);
    nx_lcd->write(temdat,3);
    fflush(stdout);
    while(val_get==0 && time_out<200){//受信割り込みタイムアウトを100msにしているのでそれ以上は待つこと
     time_out++;
     wait_ms(10);   
    }
    if(tp_mask_bak==1){
        tp_mask=1;//1=タッチパネルマスク
    }
    if(time_out>=200){
        tp_mask=1;//1=タッチパネルマスク
    return 0xFF;   
    }else{
        tp_mask=1;//1=タッチパネルマスク
    return  val_st;
    }
}

void nx_val_set(char *obj,char cont){
    char buf[64];
    unsigned char time_out=0;
    val_get=0;
    sprintf(buf,"%s.val=%d",obj,cont);
    nx_printf(buf);
    nx_lcd->write(temdat,3);
    fflush(stdout);
}

unsigned char nx_val_get_cbox(char no){
    char buf[64];
    unsigned long time_out=0;
    unsigned char tp_mask_bak=tp_mask;
    if(tp_mask_bak==1){
        tp_mask=0;//1=タッチパネルマスク解除
    }
    val_get=0;
    sprintf(buf,"get c%d.val",no);
    nx_printf(buf);
    nx_lcd->write(temdat,3);
    fflush(stdout);
    while(val_get==0 && time_out<200){//受信割り込みタイムアウトを100msにしているのでそれ以上は待つこと
     time_out++;
     wait_ms(10);   
    }
    if(tp_mask_bak==1){
        tp_mask=1;//1=タッチパネルマスク
    }
    if(time_out>=200){
        return 0xFF;   
    }else{
        return  val_st;
    }
}
unsigned char nx_get(char *obj){
    char buf[64];
    
    unsigned char time_out=0;
    unsigned char tp_mask_bak=tp_mask;
    if(tp_mask_bak==1){
        tp_mask=0;//1=タッチパネルマスク解除
    }
    val_get=0;
    val_st=0xFF;
    buf_clr();
    sprintf(buf,"get %s",obj);
    nx_printf(buf);
    nx_lcd->write(temdat,3);
    fflush(stdout);
    while(val_get==0 && time_out<200){//受信割り込みタイムアウトを100msにしているのでそれ以上は待つこと
     time_out++;
     wait_ms(1);   
    }
    if(tp_mask_bak==1){
        tp_mask=1;//1=タッチパネルマスク
    }
    if(time_out>=200){
     sprintf(lcd_print_buf,"RTC受信不良 cnt=%d",lcd_rx_buf_cnt);
     lcd_print("t0",lcd_print_buf);
         for(;;);
         return 0;   
    }else{
     return  val_st;
    }
}
unsigned char nx_page_get(){
    char buf[64];
    unsigned char time_out=0;
    unsigned char tp_mask_bak=tp_mask;
    if(tp_mask_bak==1){
        tp_mask=0;//1=タッチパネルマスク解除
    }
    page_get=0;
    page_st=0xFF;
    buf_clr();
    nx_printf("sendme");
    nx_lcd->write(temdat,3);
    fflush(stdout);
    
    while(page_get==0 && time_out<200){//受信割り込みタイムアウトを100msにしているのでそれ以上は待つこと
     time_out++;
     wait_ms(10);   
    }
    if(tp_mask_bak==1){
        tp_mask=1;//1=タッチパネルマスク解除
    }
    if(time_out>=200){
     printf("page get ng\r\n");
     fflush(stdout);
     return 0xFF;   
    }else{
     //printf("page=%d\r\n",page_st);
     fflush(stdout);
     return  page_st;
    }
}

//LCD I/Fデータ受信割り込み//////
void nx_lcd_rx () {
   unsigned char rxsize=nx_lcd->size();
   char rxdat[8];
   nx_lcd->read(rxdat,1);
   lcd_rx_buf[lcd_rx_buf_cnt]=rxdat[0];//マスク中は読み捨て
   // sprintf(lcd_print_buf,"rxsize=%d\r\n",rxsize);
    //pc_printf(lcd_print_buf);
    if(tp_mask==0){//1=タッチパネルマスク
        lcd_rx_buf_cnt++;
                ///タイムアウトセット最初のデータ受信から一定時間終端コードがこない場合は、タイムアウト処理する
                //下記を記載するとos err
        if(lcd_rx_buf_cnt==1){//1バイト目を受信したらタイムアウトカウンタを起動する。
            LCD_RX_TIME_OUT.attach(&LCD_RX_TIMEOUT_IRQ,0.2); ////0.1
        }
        //バッファオーバーフロー処理////
        if(lcd_rx_buf_cnt>sizeof(lcd_rx_buf)){
            buf_clr();
        }
                ////終端コード受信時の処理///
        if(lcd_rx_buf[lcd_rx_buf_cnt-3]==0xFF && lcd_rx_buf[lcd_rx_buf_cnt-2]==0xFF && lcd_rx_buf[lcd_rx_buf_cnt-1]==0xFF){
                switch (lcd_rx_buf[0]) {
                ////caseはnextion lcdのSWに割り当てられたidを記載する///
                case 0x65    :      ///通常のボタン押下//
                                    touch_p=lcd_rx_buf[1];  //ボタンタッチ時のページ識別ID
                                    touch_id=lcd_rx_buf[2];  //タッチボタンのIDを取得
                                    touch_t=lcd_rx_buf[3];  //タッチ時か、リリース時かを識別
                                   // printf("touch_id=%x\r\n",touch_id);
                                    if(page==P_MAIN && touch_id==BT1_PAUSE){//一時停止がおされた場合
                                        PAUSE_F=1;//一時停止
                                    }
                                    if(touch_p !=page){
                                        printf("TOUCH PAGE NG!!\r\n");
                                        lcd_print("t0","タッチパネル通信異常が発生しました。");
                                        ALM_HOLD_SET();   
                                    }
                                    break;
                case 0x66    :      //page取得///
                                    page_get=1;
                                    page_st=lcd_rx_buf[1];
                                    break;                
                case 0x71    :      //val取得////
                                    val_st=lcd_rx_buf[1];
                                    val_get=1;
                                    break;    
                
                                                  
                }
                buf_clr();
        }
        if(lcd_rx_buf[lcd_rx_buf_cnt-1]==0x21 &&lcd_rx_buf[lcd_rx_buf_cnt-2]==0x21 && lcd_rx_buf_cnt>=1){
            lot_edit_chk();
        }
    }
}


void nextion_lcd_ini(void){
    temdat[0]=0xFF;
    temdat[1]=0xFF;
    temdat[2]=0xFF;
    
    dcdat[0]=0x22;
    
    nx_lcd= new UnbufferedSerial(PA_9,PA_10,115200);//J4
    //nx_lcd= new UnbufferedSerial(USBTX, USBRX,9600);
    wait_ms(100);
    nx_printf("rest"); 
    fflush(stdout);  
    nx_lcd->write(temdat,3);
    fflush(stdout);
    //wait_ms(1000);
    //os5では、バッファにデータが残っているとattach時にハング(受信割り込みで復帰）するのでクリア時に読み捨てをいれて対処
    buf_clr();
     //シリアル通信の割り込み処理
    nx_lcd->attach(nx_lcd_rx, SerialBase::RxIrq);

    

}
void lcd_text_color_chg(char *obj,unsigned long color,char wait_set){//(例:lcd_text_color_chg("b0",63488,50);ボタン0のテキストが赤に変わる(緑は2016)
    char buf[32];
    sprintf(buf,"%s.pco=%d",obj,color);
    nx_printf(buf);
    nx_lcd->write(temdat,3);
    fflush(stdout);
    wait_ms(wait_set);
    
}   
void lcd_bc_color_chg(char *obj,unsigned long color,char wait_set){//(例:lcd_bc_color_chg("b0",63488,50);ボタン0の背景色が赤に変わる(緑は2016)
    char buf[32];
    sprintf(buf,"%s.bco=%d",obj,color);
    nx_printf(buf);
    nx_lcd->write(temdat,3);
    fflush(stdout);
    wait_ms(wait_set);

}

void lcd_print(char *obj,char *txt){
    float wait_set=0;///2021/05/18 お試し 旧 unsigned char
    char temdat2[1];   
    temdat2[0]=0x22;
    char buf[32];
    unsigned char len = strlen(txt);//文字列の長さを確認
    //wait_set=len*2;//9600bpsの場合1文字送信時間は1ms程度なので、マージンを取って2倍する。]
     wait_set=(len*2)/10;/////2021/05/18 お試し  旧 wait_set=len
    
    sprintf(buf,"%s.txt=",obj);
    nx_printf(buf);
    nx_lcd->write(dcdat,1);
    nx_printf(txt);
    nx_lcd->write(dcdat,1);
    nx_lcd->write(temdat,3);
    fflush(stdout);
    wait_ms(wait_set);
    //printf("len=%d wait=%d\r\n",len,wait_set);
}
void lcd_print_cb(char *obj,char *txt){
    float wait_set=0;///2021/05/18 お試し 旧 unsigned char
    char temdat2[1];   
    temdat2[0]=0x22;
    char buf[256];
    unsigned char len = strlen(txt);//文字列の長さを確認
    //wait_set=len*2;//9600bpsの場合1文字送信時間は1ms程度なので、マージンを取って2倍する。]
     wait_set=(len*2)/10;/////2021/05/18 お試し  旧 wait_set=len
    
    sprintf(buf,"%s.path+=",obj);
    nx_printf(buf);
    nx_lcd->write(dcdat,1);
    nx_printf(txt);
    nx_lcd->write(dcdat,1);
    nx_lcd->write(temdat,3);
    fflush(stdout);
    wait_ms(wait_set);
    //printf("len=%d wait=%d\r\n",len,wait_set);
}
void lcd_page_set_olg(unsigned char  page_set,unsigned char wait_set){//(例:lcd_page_set(1,50);//ページ1に切り替わる wait 50ms

    char buf[32];   
    sprintf(buf,"page %d",page_set);
    nx_printf(buf);
    nx_lcd->write(temdat,3);
    fflush(stdout);
    wait_ms(wait_set);

}

void lcd_page_set(unsigned char  page_set,unsigned char wait_set){//(例:lcd_page_set(1,50);//ページ1に切り替わる wait 50ms
    unsigned char page_set_rt=0;
    tp_mask=0;//1=タッチパネルマスク page変更時は、強制解除
    buf_clr();
    while(page_set_rt<2){
        lcd_page_set_olg(page_set,wait_set);
        buf_clr();
        if(nx_page_get()==page_set){
            page=page_set;
            break;
        }
        page_set_rt++;
    } 
    if(page_set_rt>=2){
        printf("PAGE SET NG\r\n");   
        fflush(stdout);
        lcd_print("t0","タッチパネル通信異常が発生しました。");
        ALM_HOLD_SET(); 
    }else{
        //printf("PAGE SET OK\r\n");   
        fflush(stdout);
    }

}
void lcd_progressbar(char *obj,unsigned char val,unsigned char wait_set){//(例:lcd_progressbar("j0",50,50);//プログレスバー表示が50になる wait 50ms
    char buf[32];
    sprintf(buf,"%s.val=%d",obj,val);
    nx_printf(buf);
    nx_lcd->write(temdat,3);
    wait_ms(wait_set);
}

void lcd_pic_chg(char *obj,unsigned char val,unsigned char wait_set){//(例:lcd_pic_chg("p0",3,50);//p0の画像指定が3に代わる（画像切り替えができる）wait 50ms
    char buf[64];
    sprintf(buf,"%s.pic=%d",obj,val);
    nx_printf(buf);
    nx_lcd->write(temdat,3);
    fflush(stdout);
    wait_ms(wait_set);
}
void nx_dsbt_st_set(char *obj,unsigned char val,unsigned char wait_set){//例:nx_dsbt_st_set("bt0",0,50);dualステートボタンを強制OFF(50ms　wait)
    char buf[64];
    sprintf(buf,"%s.val=%d",obj,val);
    nx_printf(buf);
    nx_lcd->write(temdat,3);
    fflush(stdout);
    wait_ms(wait_set);
}
void lcd_page_chk(){//(例:lcd_page_chk(); lcdのページ番号を要求
    unsigned char timeout=0;
    lcd_page=0;//lcdからページを取得した場合、ページNoが入る
    
    nx_printf("sendme");
    nx_lcd->write(temdat,3);
    fflush(stdout);
    //////lcd_pageに値が受信割り込みで入るまでwait////
    while(lcd_page==0 && timeout<30){
        timeout++;
        wait_ms(10);   
    }
}
void lcd_bt_en(char *obj,unsigned char val,unsigned char wait_set){//(例:lcd_bten(b0,0,50); b0が無効  lcd_bt_en(b0,1,50); b0がゆうこう有効
    char buf[64];
    sprintf(buf,"tsw %s,%d",obj,val);
    nx_printf(buf);
    nx_lcd->write(temdat,3);
    fflush(stdout);
    wait_ms(wait_set);
}
void lcd_audio_play(unsigned char id,unsigned char loop,unsigned char wait_set){//(例:lcd_audio_play(0,0,50);//0番のaudioをループ無し再生、コマンドwait 50ms
    char buf[64];
    sprintf(buf,"play 0,%d,%d",id,loop);//ch,id,loop
    nx_printf(buf);
    nx_lcd->write(temdat,3);
    fflush(stdout);
    wait_ms(wait_set);
}

void lcd_audio_cont(unsigned char val,unsigned char wait_set){//val=0 再生停止 1 resume 2 puse
    char buf[64];
    sprintf(buf,"audio0=%d",val);
    nx_printf(buf);
    nx_lcd->write(temdat,3);
    fflush(stdout);
    wait_ms(wait_set);
}
void lcd_audio_vol(unsigned char val,unsigned char wait_set){//val=0から100
    char buf[64];
    sprintf(buf,"volume=%d",val);
    nx_printf(buf);
    nx_lcd->write(temdat,3);
    fflush(stdout); 
    wait_ms(wait_set);
}

void lcd_backlight(unsigned char val){//例 lcd_backlight(50); //明るさがセンターになる。
    char buf[32];
    sprintf(buf,"dim=%d",val);
    nx_printf(buf);
    nx_lcd->write(temdat,3);
    fflush(stdout);
    
}
