#include "mbed.h"
#include "nextion_lcd.h"
#include "APP.h"

#include "FATFileSystem.h"
// Block devices
#include "SDBlockDevice.h"
#include "SAVE_CONT.h"
#include "PS3_BT_CTL.h"
#include "ROBO1_CONT.h"
#include "ROBO2_CONT.h"
#include "IO_CONT.h"
#include "CUT_CONT.h"
#include "ROBO_TWIN_CONT.h"
#include "DiNi_supplyr.h"

DigitalIn SD_CD_I(PC_4);
// File system declaration
FATFileSystem   fileSystem("fs");

// Physical block device, can be any device that supports the BlockDevice API
SDBlockDevice   blockDevice(PC_3,PC_2,PB_10,PB_12);  // mosi, miso, sck, cs
static UnbufferedSerial *pc;

char pc_print_buf[64];


void time_set(){
    RTC_GET();
    // setup time structure for Wed, 28 Oct 2009 11:35:37
    struct tm t;
    t.tm_sec = rtc_sec;    // 0-59
    t.tm_min = rtc_min;    // 0-59
    t.tm_hour =rtc_hour;   // 0-23
    t.tm_mday = rtc_date;   // 1-31
    t.tm_mon = rtc_month-1;     // 0-11
    t.tm_year = rtc_year-1900;  // year since 1900
 
    // convert to timestamp and set (1256729737)
    time_t seconds = mktime(&t);
    set_time(seconds);   
}
void time_disp(){
   //time_t seconds = time(NULL) + (60 * 60 * 9); // JST
    time_t seconds = time(NULL);
    struct tm *t = localtime(&seconds);
 
    printf("%04d/%02d/%02d %02d:%02d:%02d",
      t->tm_year + 1900, t->tm_mon + 1, t->tm_mday, t->tm_hour, t->tm_min, t->tm_sec);
    
}
void pc_printf(char *txt){
    unsigned char len = strlen(txt);//文字列の長さを確認
    pc->write(txt,len);  
}
////ms単位でのwait指定////
void wait_ms(double wcnt){
  wait_us(wcnt*1000);   
    
}
void wait(double wcnt){
  wait_us(wcnt*1000000000);   
    
}

void SD_CARD_INI(){
   SD_CD_I.mode(PullUp);
    if(SD_CD_I.read()==1){
        lcd_print("t0","SDカード未挿入の為、起動できません。");
        ALM_ST= ALM_SD;
        ALM_HOLD_SET();
    }else{
        lcd_print("t0","SDカード挿入確認OK");
    } 
    //lcdのRTCから時刻を取得してマイコンのRTCにセット(ファイルの保存時刻用）
    //time_set();
   // time_disp();
        // Try to mount the filesystem
    printf("Mounting the filesystem... ");
    fflush(stdout);

    int err = fileSystem.mount(&blockDevice);
    printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        // Reformat if we can't mount the filesystem
        // this should only happen on the first boot
        printf("No filesystem found, formatting... ");
        fflush(stdout);
        ALM_ST= ALM_SD;
        lcd_print("t0","SDカード異常の為、起動できません。");
        ALM_HOLD_SET(); 
         
    }   
     
}

int main() {
    wait_ms(500);
    nextion_lcd_ini();  //LCD初期化
    lcd_backlight(50);
    //Set serial port baudrate speed: 115200
    pc= new UnbufferedSerial(USBTX, USBRX,115200);

     
    //RB1_CONNECT();
   // RB2_CONNECT();
    HOME_STATE=1;//TEST

　  IO_INI();//IO初期化 I2C絶縁IO
    EA_IO_INI();


    PS3_CTL_INI();
    /////SDカード初期処理///
    SD_CARD_INI();
    wait_ms(100);

    ////ポジションデータ読み込み///
    RB1_LIST_READ();   
    RB2_LIST_READ();
    sprintf(lcd_print_buf,"ポイントデータ読み込み件数 :RB1 : %02d R2 : %02d",RB1_POINT_NO_CNT-1,RB1_POINT_NO_CNT-1);
    lcd_print("t0",lcd_print_buf);
    ///極棒交換回数,ニッケル端子設定値の読み出し//
   // SET_UP_SAVE();
    SETUP_DATA_RD();//設定値の読み出し(リセット時にSDエラーになるのでデバック中は、コメントアウト）

    //lcdのRTCから時刻を取得してマイコンのRTCにセット(ファイルの保存時刻用）
    time_set();
    time_disp();

    wait_ms(1500);
 //   printf("Start\r\n");
    
    ///作業画面へ移行////
    lcd_page_set(P_MAIN,100);
    wait_ms(200);


    lcd_print("t0","ダイレクト溶接DOBOT板 V0.17(2022/10/13)");
    printf("dobot direct prgoram start\r\n");
    MAIN_PAGE_DISP();
    lcd_audio_vol(0,100);//val=0から100 def80
    lcd_audio_play(AU_BOOT,0,80);
    //lcdのRTCから時刻を取得してマイコンのRTCにセット(ファイルの保存時刻用）
    time_set();
    time_disp();
    wait_ms(1000);
    
   /* while(1){
        if(IO_EX_BIT_READ(WTRP_HEND_I)==IOEX_OFF_I){
            printf("HEND OFF\r\n");
        lcd_print("t0","HEND OFF");
        }else{
            printf("HEND ON\r\n");
        lcd_print("t0","HEND ON");
        }
    wait_ms(1000);
    }
*/
    while(1){
     MG400_AP();
    }
}
