#include "mbed.h"
#include "main.h"
#include "nextion_lcd.h"
#include "APP.h"
#include "WORK_START.h"
///////////////////////
#include "ROBO1_CONT.h"
#include "ROBO2_CONT.h"
#include "ROBO_TWIN_CONT.h"
#include "SAVE_CONT.h"
///////////////////////
#include "PS3_BT_CTL.h"
/////////////////////////
#include "WD_CONT.h"
#include "CUT_CONT.h"
#include "DiNi_supplyr.h"
#include "IO_CONT.h"
#define NI_MASK 1


unsigned char FIRST_WORK_F=0;//1で最初のワーク生産終了



void WORK_START_TST(){

    W_STEP_END=1;  
}
///ニッケル搬送//////////////
void NI_CUT_MOVE(){
    C1A2_HAND_FET_CONT(FET_ON);//ハンド閉
    wait_ms(100);
    /////////カット動作////////
    C1A2_CUT_FET_CONT(FET_ON);
    wait_ms(100);
    C1A2_CUT_FET_CONT(FET_OFF);
    wait_ms(100);
    /////搬送/////////////////
   // C1A2_MOVE(POS_WD_1,POS_WD_1);  
    //C1A2_MOVE_EWAIT();

    //////極棒押し当て//////
    C1A2_WD_FET_CONT(FET_ON);
    //wait_ms(100);//ロボット動作の間に動作完了するとみこしてコメントアウト
    
}



void WD_DUMMY(){
    
    lcd_audio_play(AU_PINCON ,0,80);
    wait_ms(2000-80);  
    WD1H_CHG_CNT++;
    WD2H_CHG_CNT++;
    WD2R_CHG_CNT++;
    WD_CNT_DISP();     
}
///ロボット連続移動のwaitをまとめてみるversion
void WORK_START(){///30.2477,29.9306,

       switch (WORK_STEP) {
                case 0   : 
                            WT_MOVE(POS_WT_START);
                            ////端子供給1 32-1mm  端子供給2 32mm//
                            if(FIRST_WORK_F==0){//1で最初のワーク生産終了
                                WT_MOVE_EWAIT();//初回は開始位置移動をまってからとする
                               // lcd_print("t0","32mm,32mm");
                                ////ニッケル端子割り込み出力開始////
                                C1A2_MOT_MOVE_MM(C1_SET_32MM,C2_SET_32MM,MOT_WAIT_DIS);    
                                C1A2_HAND_FET_CONT(FET_OFF);//ハンド開
                                C1A2_WD_FET_CONT(FET_OFF);//溶接押し当て退避
                                wait_ms(100);
                                        
                                ///搬送軸戻す///
                                //C1A2_MOVE(POS_WAIT_13MM,POS_WAIT_3MM);//待機
                                ///32mm 32mm 出力待ち///
                                C1A2_MOT_STEP_IRQ_WAIT();
                                C1A2_MOVE_EWAIT();
                            }
                            WORK_STEP++;
                            break;
                case 1   :
                            //ロボット　PIICK 上//
                             ///排出位置=ピックアップ位置なので原点位置等別の場所にいる場合は、排出位置に移動、
                            if(RP_SEL_SET !=RP_EJECT){
                                RB1A2_SEL_MOVE(RP_EJECT,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);        
                                RB1A2_MOVE_EWAIT(RB_EWAIT);//sでタイムアウトを指定  
                            }
                            WT_MOVE_EWAIT();//初回以外はここで待つ
                            WORK_STEP++;
                            break;
                case 2   :
                            //ロボット　PIICK 下//
                            RB1A2_SEL_MOVE(RP_WORK_DW,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);
                            RB1A2_MOVE_EWAIT(RB_EWAIT);//sでタイムアウトを指定  
                            WORK_STEP++; 
                            break;
                case 3   :
                            //ロボット　把持///////////////////
                            RB1A2_HAND_CONT(R12_HAND_CLOSE);
                            WORK_STEP++;
                            break;
                case 4   :
                             ////ロボット　ワークを上げる////// 
                            RB1A2_SEL_MOVE(RP_WORK_UP,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);    
                            RB1A2_MOVE_EWAIT(RB_EWAIT);//sでタイムアウトを指定 
                            WORK_STEP++;     
                            break;
                case 5   :
                            RB1A2_SEL_MOVE(RP_ESC_CHG1,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);        
                            ////ロボット 溶接ヘッドの上へ移動////// 
                            RB1A2_SEL_MOVE(RP_H1WD_UP,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);
                            RB1A2_MOVE_SWAIT(RB_EWAIT);//msでタイムアウトを指定          
                            ////ニッケル搬送//// ロボット移動と重ねる為このタイミング
                            NI_CUT_MOVE();
                    
                            ///次の端子の事前準備 50mm/2 50mm/2///
                           // lcd_print("t0","50mm_1,50mm_1");
                            C1A2_MOT_MOVE_MM(C1_SET_50MM/2,C2_SET_50MM/2,MOT_WAIT_DIS);
                               
                            ////ロボット移動完了待ち/////
                            RB1A2_MOVE_EWAIT(RB_EWAIT);//sでタイムアウトを指定
                            ///////ワーク搬送軸を戻す/////////
                            WT_MOVE(POS_WT_WAIT);
                            WORK_STEP++;
                            break;
 
                            
                case 6   :  ///ロボット移動溶接Aパーツ1点目 Cパーツ1点目//           
                            RB1A2_SEL_MOVE(RP_WDP_1,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);      
                            RB1A2_MOVE_EWAIT(RB_EWAIT);//sでタイムアウトを指定                       
                            WORK_STEP++; 
                            break;
                            
                case 7  :   ///溶接Aパーツ1点目 Cパーツ1点目// 
                            // WD_START();
                            WD_DUMMY();//溶接ダミー 
                            
                            //ニッケルハンド開
                            C1A2_HAND_FET_CONT(FET_OFF);
                            //wait_ms(100);溶接ヘッドの動きのほうが遅いのでコメント不要とする。 
                            WORK_STEP++; 
                            break;
            
                case 8   :  ///ロボット 2打点目移動////
                            RB1A2_SEL_MOVE(RP_WDP_2,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);      
                            //2打点目用位置へニッケル搬送軸を移動///
                            C2_MOVE(POS_WD_2);
                            //C2_MOVE_WAIT();
                            RB1A2_MOVE_EWAIT(RB_EWAIT);//sでタイムアウトを指定      
                            WORK_STEP++; 
                            break;
                            
                case 9   :  ///溶接Aパーツ2点目 Cパーツ2点目//  
                            C1A2_HAND_FET_CONT(FET_ON);//ハンド閉
                            wait_ms(100);                                   
                            //WD_START();
                            WD_DUMMY();//溶接ダミー
                            C1A2_HAND_FET_CONT(FET_OFF);//ハンド開
                            //wait_ms(100);溶接ヘッドの動きのほうが遅いのでコメント不要とする。 
                            WORK_STEP++; 
                            break;
                                         
                            
                case 10   :  //溶接押し当て退避
                            C1A2_WD_FET_CONT(FET_OFF);
                             ///ロボット 退避///
                            RB1A2_SEL_MOVE(RP_H1WD_UP,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);      
                            RB1A2_MOVE_EWAIT(RB_EWAIT);//sでタイムアウトを指定
                            WORK_STEP++;
                            break;
                    
                case 11 :     ////端子供給1 50mm  端子供給2 50mm//
                            /////ニッケル搬送軸を戻す//////////
                            //C1A2_MOVE(POS_WAIT_3MM,POS_WAIT_4R5MM);//4R5はガイド用,別途31mm位置でつかみなおす               
                            //C1A2_MOVE_EWAIT();
                            ////事前準備の50mm/2出力待ち
                            C1A2_MOT_STEP_IRQ_WAIT();
                            
                            ////残りの50mmを出す///// 
                            //lcd_print("t0","50mm_2,50mm_2");
                            C1A2_MOT_MOVE_MM(C1_SET_50MM/2,C2_SET_50MM/2,MOT_WAIT_DIS);
                            //把持位置変更
                            C2_MOVE(POS_WAIT_31MM);
                            //C2_MOVE_WAIT();
                            /////////////////////////////////////////
                            
                            WORK_STEP++;        
                            break;  
                            
                case 12 :    ///dobot パーツ180度回転///
                            RB1A2_SEL_MOVE(RP_ESC1_RT,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);      
                            ///残りの50mm送出待ち
                            C1A2_MOT_STEP_IRQ_WAIT();
                            ///50mm端子搬送//
                            NI_CUT_MOVE();
                            
                            //端子供給32mm,23mm 準備
                           // lcd_print("t0","32mm,23mm");
                            C1A2_MOT_MOVE_MM(C1_SET_32MM,C2_SET_23MM,MOT_WAIT_DIS); 
                            RB1A2_MOVE_EWAIT(RB_EWAIT);//sでタイムアウトを指定
                            
                            ///DOBOT 50mm一点目移動///                
                            RB1A2_SEL_MOVE(RP_WDP_3,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);      
                            RB1A2_MOVE_EWAIT(RB_EWAIT);//sでタイムアウトを指定  
                            WORK_STEP++;      
                            break;
                            
                case 13 :    ///溶接Aパーツ3点目 Cパーツ3点目//       
                            // WD_START();
                            WD_DUMMY();//溶接ダミー 
                            //ニッケルハンド開
                            C1A2_HAND_FET_CONT(FET_OFF);
                            //wait_ms(100);溶接ヘッドの動きのほうが遅いのでコメント不要とする。 
                            WORK_STEP++;     
                            break; 
 
                case 14 :  //2点目へ移動 ニッケル側　ニッケル把持ハンド移動
                           ///dobot 50mm２打点目////
                            RB1A2_SEL_MOVE(RP_WDP_4,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);      
                            C2_MOVE(POS_WD_2);
                           // C2_MOVE_WAIT(); 
                            RB1A2_MOVE_EWAIT(RB_EWAIT);//sでタイムアウトを指定   
                            WORK_STEP++; 
                            break;  

                case 15:    ///溶接Aパーツ4点目 Cパーツ4点目//  
                            C1A2_HAND_FET_CONT(FET_ON);//ハンド閉
                            wait_ms(100);                                   
                            //WD_START();
                            WD_DUMMY();//溶接ダミー
                            C1A2_HAND_FET_CONT(FET_OFF);//ハンド開
                            //wait_ms(100);溶接ヘッドの動きのほうが遅いのでコメント不要とする。 
                            WORK_STEP++;
                            break;
                
                case 16 :   
                            ///ロボットヘッド入れ替え動作暫定（もっと退避を考える必要あるかも）////// 
                            RB1A2_SEL_MOVE(RP_ESC_CHG1,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);       
                            RB1A2_SEL_MOVE(RP_ESC_CHG2,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);        
                            RB1A2_MOVE_WAIT(RB_EWAIT);//msでタイムアウトを指定     
                            WORK_STEP++;  
                            break;         
                            
                 case 17 :  
                            //ヘッド上移動////
                            RB1A2_SEL_MOVE(RP_H2WD_UP,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);        
                            ////ロボット溶接点移動////
                            RB1A2_SEL_MOVE(RP_WDP_5,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);      
                            RB1A2_MOVE_WAIT(RB_EWAIT);//sでタイムアウトを指定                       
                            WORK_STEP++;  
                            break; 
                                       
                case 18 :    ///溶接Aパーツ5点目 Cパーツ5点目//  
                            C1A2_HAND_FET_CONT(FET_ON);//ハンド閉
                            wait_ms(100);                                   
                            //WD_START();
                            WD_DUMMY();//溶接ダミー
                            C1A2_HAND_FET_CONT(FET_OFF);//ハンド開
                            //wait_ms(100);溶接ヘッドの動きのほうが遅いのでコメント不要とする。 
                            WORK_STEP++;  
                            break;
                            
                case 19 :    
                            //2点目移動/////
                            RB1A2_SEL_MOVE(RP_WDP_6,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);      
                            //2点目へ移動 ニッケル側　ニッケル把持ハンド移動
                            C2_MOVE(POS_WD_2);
                            //C2_MOVE_WAIT();  
                            RB1A2_MOVE_EWAIT(RB_EWAIT);//sでタイムアウトを指定                    
                            WORK_STEP++;    
                            break;             
                                                               
                case 20 :  ///溶接Aパーツ6点目 Cパーツ6点目//  
                            C1A2_HAND_FET_CONT(FET_ON);//ハンド閉
                            wait_ms(100);                                   
                            //WD_START();
                            WD_DUMMY();//溶接ダミー
                            C1A2_HAND_FET_CONT(FET_OFF);//ハンド開
                            //wait_ms(100);溶接ヘッドの動きのほうが遅いのでコメント不要とする。 
                            WORK_STEP++;
                            break;       
         
                case 21:    
                            C1A2_WD_FET_CONT(FET_OFF);//溶接押し当て退避
                            //ロボット退避/////
                            RB1A2_SEL_MOVE(RP_H2WD_UP,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);      
                            RB1A2_MOVE_EWAIT(RB_EWAIT);//sでタイムアウトを指定  
                            WORK_STEP++;        
                            break;
                            
                case 22:    ////端子供給1 32-2mm  端子供給2 23mm//
                            //ニッケル搬送軸を戻す////
                             /////ニッケル搬送軸を戻す//////////
                            //C1A2_MOVE(POS_WAIT_3MM,POS_WAIT_4R5MM);   
                            //C1A2_MOVE_EWAIT();
                                                 
                            ////事前準備の32mm,23mmが出し終わっているか確認
                            C1A2_MOT_STEP_IRQ_WAIT();                          
                            ///32mm 23mm搬送////
                            NI_CUT_MOVE();
                            //次のサイクルの最初の32mmを出す(DUAROはやってない）////////
                            //lcd_print("t0","次サイクル 32mm,32mm");
                            C1A2_MOT_MOVE_MM(C1_SET_32MM,C2_SET_23MM,MOT_WAIT_DIS);
                            FIRST_WORK_F=1;
                            //////////////////////////////////////////////////                            
              
                            WORK_STEP++; 
                            break; 
                case 23 :  //180度回転/////
                            RB1A2_SEL_MOVE(RP_ESC2_RT,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);      
                            //DOBOT 23mm 32mm 一点目移動/// 
                            RB1A2_SEL_MOVE(RP_WDP_7,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);      
                            RB1A2_MOVE_WAIT(RB_EWAIT);//sでタイムアウトを指定        
                            WORK_STEP++;        
                            break;       
                                               
                case 24 :    ///溶接Aパーツ7点目 Cパーツ7点目//  
                            // WD_START();
                            WD_DUMMY();//溶接ダミー 
                            //ニッケルハンド開
                            C1A2_HAND_FET_CONT(FET_OFF);
                            //wait_ms(100);溶接ヘッドの動きのほうが遅いのでコメント不要とする。 
                            WORK_STEP++;  
                            break;      
                
                case 25 :   ///ロボット　32mm 23mm２打点目////
                            RB1A2_SEL_MOVE(RP_WDP_8,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);      
                            //2点目へ移動 ニッケル側　ニッケル把持ハンド移動    
                            
                            C2_MOVE(POS_WD_2);
                            //C2_MOVE_WAIT();                           
                            RB1A2_MOVE_EWAIT(RB_EWAIT);//sでタイムアウトを指定    
                            WT_MOVE_EWAIT();//ワーク搬送軸が戻っているか確認
                            WT_MOVE(POS_WT_EJECT);
                            WORK_STEP++; 
                            break;

                case 26:   ///溶接Aパーツ8点目 Cパーツ8点目//          
                            C1A2_HAND_FET_CONT(FET_ON);//ハンド閉
                            wait_ms(100);                                   
                            //WD_START();
                            WD_DUMMY();//溶接ダミー
                            C1A2_HAND_FET_CONT(FET_OFF);//ハンド開
                            //wait_ms(100);溶接ヘッドの動きのほうが遅いのでコメント不要とする。 
                            WORK_STEP++;
                            break;  
                       
                case 27:  
                            ///////////ロボット排出動作//////////
                        
                            //退避///
                            RB1A2_SEL_MOVE(RP_H2WD_UP,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);        
                            RB1A2_MOVE_EWAIT(RB_EWAIT);//sでタイムアウトを指定 
                            
                            ///ニッケルハンドを最初の待機位置へ移動(DUAROはやってない）///
                            //C1A2_MOVE(POS_WAIT_13MM,POS_WAIT_3MM);    
                       
                            
                            //排出位置移動////
                            RB1A2_SEL_MOVE(RP_EJECT,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);        
                            RB1A2_MOVE_EWAIT(RB_EWAIT);//sでタイムアウトを指定   
                            //C1A2_MOVE_EWAIT();
                           
                            WT_MOVE_EWAIT();///ワーク搬送軸が排出位置に移動完了しているか？
                            ///ロボットハンドを離す////
                            RB1A2_HAND_CONT(R12_HAND_OPEN);
                            WORK_STEP++;        
                            break;
                   
                case 28:  //作業終了//////
                            ////////////////////////////////////////
                            PD_CNT_A++;
                            PD_CNT_A_DISP();
                            PD_CNT_C++;
                            PD_CNT_C_DISP(); 
                            //WD_CNT_DISP();
                            ///次のサイクルの32mmの準備完を待つ//
                            C1A2_MOT_STEP_IRQ_WAIT();
                            ///ニッケル搬送軸の戻り待ち///
                            C1A2_MOVE_EWAIT();
                            WORK_STEP++; 
                            W_STEP_END=1;  
                            break;                 
                                                                                       
                }
}
    
 
