#include "mbed.h"
#include "main.h"
#include "nextion_lcd.h"
#include "APP.h"
#include "main.h"
#include "PS3_BT_CTL.h"
///////////////////////
#include "ROBO1_CONT.h"
#include "ROBO2_CONT.h"
#include "SAVE_CONT.h"
///////////////////////
extern unsigned char tp_mask;//1=タッチパネルマスク

static UnbufferedSerial *PS3_CTL;
Ticker PS3_RX_TIME_OUT;

char PS3_RX_BUF[8];
unsigned char PS3_RX_BUF_CNT=0;

unsigned char CTL_ST=0x00;
unsigned char CTL_ST_BAK=0x00;
        

void PS3_RX_TIMEOUT_IRQ(){
    PS3_RX_TIME_OUT.detach();//シリアル受信タイムアウトカウンタ停止
    buf_clr();
    CTL_ST=CTL_END;
}

void ps_buf_clr(){
    for(unsigned char clr=0; clr<sizeof(PS3_RX_BUF); clr++){
           PS3_RX_BUF[clr]=0;
    }
   PS3_RX_BUF_CNT=0;     
}

//メイン作業画面でのコントローラ操作///
void PS3_MAIN_CONT(){
      if(CTL_ST !=CTL_ST_BAK){
          PS3_RX_TIME_OUT.detach();//シリアル受信タイムアウトカウンタ停止
       switch (CTL_ST) {
        case CTL_END     : 

                            break;
        case CTL_START     :///単品動作/// 
                            if(touch_id!=BT1_START){
                                touch_id=BT1_START;
                            }
                            break;
        case CTL_CI         ://連続運転///
                            touch_id=BT1_RE_START;
                            break;
        case CTL_SELECT    : 
                            touch_id=BT1_HOME;
                            break;
        case CTL_L1        :
                            touch_id=BT1_NI1_OUT;
                            break;
        case CTL_L3       :
                            touch_id=BT1_NI1_CUT;
                            break;
        case CTL_R1        :
                            touch_id=BT1_NI2_OUT;
                            break;
        case CTL_R3       :
                            touch_id=BT1_NI2_CUT;
                            break;
                                   
        }
        
        
    CTL_ST_BAK=CTL_ST;

    }  
    
}
void PS3_ROBO1_CONT(){
      if(CTL_ST !=CTL_ST_BAK){
          PS3_RX_TIME_OUT.detach();//シリアル受信タイムアウトカウンタ停止
       switch (CTL_ST) {
        case CTL_END     : 
                            RB1_SEND_CMD("MoveJog()");
                            RB1_CMD_WAIT(RB_SWAIT);
                            RB1_POSE_DISP_EN=0; 
                            RB1_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）
                            break;
        case CTL_START     : 
                            lcd_print("t0","初期位置移動"); 
                            RB1_SEND_CMD("EnableRobot()");
                            RB1_CMD_WAIT(RB_SWAIT);
                            RB1_POSE_DISP_EN=0;
                            RB1_HOME_MOVE();
                            RB1_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）
                            break;
        case CTL_SELECT    : 
                            lcd_print("t0","位置保存");
                            RB1_PSEL=nx_val_get("cb0");
                            ///ダイレクトティーチング用に位置を取り込んでから保存////
                            RB1_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している） 
                            RB1_SEND_CMD("EnableRobot()");//ダイレクトティーチの場合一度イネーブルをなげないとmovコマンドが使えない
                            RB1_CMD_WAIT(RB_SWAIT); 
                            RB1_PSEL_BAK=0xFF;
                            ////////////////////////////////////////////////
                            RB1_POINT_RD[RB1_PSEL][PX]=RB1_X_GET;
                            RB1_POINT_RD[RB1_PSEL][PY]=RB1_Y_GET;
                            RB1_POINT_RD[RB1_PSEL][PZ]=RB1_Z_GET;
                            RB1_POINT_RD[RB1_PSEL][PR]=RB1_R_GET;                            
                            RB1_LIST_WRITE();//保存
                            lcd_print("t0","位置保存完了");
                            break;


        case CTL_UP    : 
                            lcd_print("t0","JOG Y-");
                            RB1_SEND_CMD("MoveJog(y-)");
                            RB1_POSE_DISP_EN=1;//位置表示自動更新ON      
                            break;
        case CTL_DW    : 
                            lcd_print("t0","JOG Y+");
                            RB1_SEND_CMD("MoveJog(y+)");
                            RB1_POSE_DISP_EN=1;//位置表示自動更新ON      
                            break;
        case CTL_RI    : 
                            lcd_print("t0","JOG X-");
                            RB1_SEND_CMD("MoveJog(x-)");
                            RB1_POSE_DISP_EN=1;//位置表示自動更新ON      
                            break;
        case CTL_LE    : 
                            lcd_print("t0","JOG X+");
                            RB1_SEND_CMD("MoveJog(x+)");
                            RB1_POSE_DISP_EN=1;//位置表示自動更新ON      
                            break;


        case CTL_CR    : 
                            lcd_print("t0","JOG Z-");
                            RB1_SEND_CMD("MoveJog(z-)");
                            RB1_POSE_DISP_EN=1;//位置表示自動更新ON      
                            break;            
      
        case CTL_TR    : 
                            lcd_print("t0","JOG Z+");
                            RB1_SEND_CMD("MoveJog(z+)");
                            RB1_POSE_DISP_EN=1;//位置表示自動更新ON      
                            break;
        case CTL_CI    : 
                            lcd_print("t0","JOG R+");
                            RB1_SEND_CMD("MoveJog(j4+)");
                            RB1_POSE_DISP_EN=1;//位置表示自動更新ON      
                            break;  
        case CTL_SQ    : 
                            lcd_print("t0","JOG R-");
                            RB1_SEND_CMD("MoveJog(j4-)");
                            RB1_POSE_DISP_EN=1;//位置表示自動更新ON      
                            break;
                            
        case CTL_L1    :
                            touch_id=BT9_R_HAND;
                            break;
                                   
        }
        
        
    CTL_ST_BAK=CTL_ST;

    }  
    
}
void PS3_ROBO2_CONT(){
      if(CTL_ST !=CTL_ST_BAK){
       PS3_RX_TIME_OUT.detach();//シリアル受信タイムアウトカウンタ停止
       RB2_SEND_CMD("MoveJog()");
       RB2_CMD_WAIT(RB_SWAIT);
       RB2_POSE_DISP_EN=0; 
       RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）
       
       switch (CTL_ST) {
        case CTL_END     : 
                            RB2_SEND_CMD("MoveJog()");
                            RB2_CMD_WAIT(RB_SWAIT);
                            RB2_POSE_DISP_EN=0; 
                            RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）
                            break;
        case CTL_START     : 
                            lcd_print("t0","初期位置移動"); 
                            RB2_SEND_CMD("EnableRobot()");
                            RB2_CMD_WAIT(RB_SWAIT);
                            RB2_HOME_MOVE();
                            RB2_POSE_DISP_EN=0;
                            RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）
                            break;
        case CTL_SELECT    : 
                            lcd_print("t0","位置保存");
                            RB2_PSEL=nx_val_get("cb0");
                            ///ダイレクトティーチング用に位置を取り込んでから保存////
                            RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している） 
                            RB2_SEND_CMD("EnableRobot()");//ダイレクトティーチの場合一度イネーブルをなげないとmovコマンドが使えない
                            RB2_CMD_WAIT(RB_SWAIT); 
                            RB2_PSEL_BAK=0xFF;
                            ////////////////////////////////////////////////
                            RB2_POINT_RD[RB1_PSEL][PX]=RB2_X_GET;
                            RB2_POINT_RD[RB1_PSEL][PY]=RB2_Y_GET;
                            RB2_POINT_RD[RB1_PSEL][PZ]=RB2_Z_GET;
                            RB2_POINT_RD[RB1_PSEL][PR]=RB2_R_GET;                            
                            RB2_LIST_WRITE();//保存
                            lcd_print("t0","位置保存完了");
                            break;


        case CTL_UP    : 
                            lcd_print("t0","JOG Y+");
                            RB2_SEND_CMD("MoveJog(y+)");
                            RB2_POSE_DISP_EN=1;//位置表示自動更新ON      
                            break;
        case CTL_DW    : 
                            lcd_print("t0","JOG Y-");
                            RB2_SEND_CMD("MoveJog(y-)");
                            RB2_POSE_DISP_EN=1;//位置表示自動更新ON      
                            break;
        case CTL_RI    : 
                            lcd_print("t0","JOG X+");
                            RB2_SEND_CMD("MoveJog(x+)");
                            RB2_POSE_DISP_EN=1;//位置表示自動更新ON      
                            break;
        case CTL_LE    : 
                            lcd_print("t0","JOG X-");
                            RB2_SEND_CMD("MoveJog(x-)");
                            RB2_POSE_DISP_EN=1;//位置表示自動更新ON      
                            break;


        case CTL_CR    : 
                            lcd_print("t0","JOG Z-");
                            RB2_SEND_CMD("MoveJog(z-)");
                            RB2_POSE_DISP_EN=1;//位置表示自動更新ON      
                            break;            
      
        case CTL_TR    : 
                            lcd_print("t0","JOG Z+");
                            RB2_SEND_CMD("MoveJog(z+)");
                            RB2_POSE_DISP_EN=1;//位置表示自動更新ON      
                            break;
        case CTL_CI    : 
                            lcd_print("t0","JOG R-");
                            RB2_SEND_CMD("MoveJog(j4-)");
                            RB2_POSE_DISP_EN=1;//位置表示自動更新ON      
                            break;  
        case CTL_SQ    : 
                            lcd_print("t0","JOG R+");
                            RB2_SEND_CMD("MoveJog(j4+)");
                            RB2_POSE_DISP_EN=1;//位置表示自動更新ON      
                            break;
        case CTL_L1    :
                            touch_id=BT10_R_HAND;
                            break;
                                   
        }
        
        
    CTL_ST_BAK=CTL_ST;

    }  
    
}

////試験用シリアル表示///
void PS3_RX_DISP(){
    
    if(CTL_ST !=CTL_ST_BAK){
       switch (CTL_ST) {
        case CTL_END     : 
                            printf("PS3_CTL_END\r\n");
                            break;
        case CTL_START     : 
                            printf("PS3_START\r\n");
       
                            break;
        case CTL_SELECT    : 
                            printf("PS3_SELECT\r\n");
                            break;
        case CTL_L1    : 
                            printf("PS3_L1\r\n");
                            break;
        case CTL_L2    : 
                            printf("PS3_L2\r\n");
                            break;
        case CTL_L3    : 
                            printf("PS3_L3\r\n");
                            break;
        case CTL_R1    : 
                            printf("PS3_R1\r\n");
                            break;
        case CTL_R2    : 
                            printf("PS3_R2\r\n");
                            break;
        case CTL_R3    : 
                            printf("PS3_R3\r\n");
                            break;
        case CTL_UP    : 
                            printf("PS3_UP\r\n");
                            break;
        case CTL_RI    : 
                            printf("PS3_RIGHT\r\n");
                            break;
        case CTL_DW    : 
                            printf("PS3_DOWN\r\n");
                            break;
        case CTL_LE    : 
                            printf("PS3_LEFT\r\n");
                            break;
        case CTL_CR    : 
                            printf("PS3_CROSS\r\n");
                            break;            
        case CTL_SQ    : 
                            printf("PS3_SQUARE\r\n");
                            break;
        case CTL_TR    : 
                            printf("PS3_TRIANGLE\r\n");
                            break;
        case CTL_CI    : 
                            printf("PS3_CIRCLE\r\n");
                            break;                                     
        }
        
        
     CTL_ST_BAK=CTL_ST;
    }  
}
void PS3_RX_CHK(){
    CTL_ST=0xFF;
    if(strstr(PS3_RX_BUF,"ED") !=NULL){   
        CTL_ST=CTL_END;   
    } 
    if(strstr(PS3_RX_BUF,"ST") !=NULL){// start
        CTL_ST=CTL_START;  
        if(page==P_MAIN && touch_id==BT1_START){
            touch_id=0;
            PAUSE_F=1;
        }
         if(page==P_PAUSE){
            touch_id=BT2_RESTART;
        }
    }
    if(strstr(PS3_RX_BUF,"SE") !=NULL){// select
        CTL_ST=CTL_SELECT;  
    } 

    if(strstr(PS3_RX_BUF,"L1") !=NULL){// button L1
        CTL_ST=CTL_L1;  
    }
    if(strstr(PS3_RX_BUF,"L2") !=NULL){// button L2
        CTL_ST=CTL_L2;  
    } 
    if(strstr(PS3_RX_BUF,"L3") !=NULL){// analog L3   
        CTL_ST=CTL_L3;   
    } 
    if(strstr(PS3_RX_BUF,"R1") !=NULL){// button R1
        CTL_ST=CTL_R1;  
    }
    if(strstr(PS3_RX_BUF,"R2") !=NULL){// button R2
        CTL_ST=CTL_R2;  
    } 
    if(strstr(PS3_RX_BUF,"R3") !=NULL){// analog R3   
        CTL_ST=CTL_R3;   
    } 
    
    if(strstr(PS3_RX_BUF,"UP") !=NULL){// ↑   
        CTL_ST=CTL_UP;   
    } 
    if(strstr(PS3_RX_BUF,"RI") !=NULL){// →
        CTL_ST=CTL_RI;  
    }
    if(strstr(PS3_RX_BUF,"DW") !=NULL){// ↓
        CTL_ST=CTL_DW;  
    } 
    if(strstr(PS3_RX_BUF,"LE") !=NULL){// ←    
        CTL_ST=CTL_LE;   
    }  
    if(strstr(PS3_RX_BUF,"CR") !=NULL){// Ｘ  
        CTL_ST=CTL_CR;   
    } 
    if(strstr(PS3_RX_BUF,"SQ") !=NULL){// □ 
        CTL_ST=CTL_SQ;  
    }
    if(strstr(PS3_RX_BUF,"TR") !=NULL){// △
        CTL_ST=CTL_TR;  
    } 
    if(strstr(PS3_RX_BUF,"CI") !=NULL){// 〇   
        CTL_ST=CTL_CI;   
    }
    if(CTL_ST !=0xFF){
     PS3_RX_TIME_OUT.detach();//シリアル受信タイムアウトカウンタ停止   
    }   
    ps_buf_clr();   
}
void PS3_CTL_RX(){
    unsigned char rxsize=PS3_CTL->size();
   char rxdat[8];
   PS3_CTL->read(rxdat,1);
   PS3_RX_BUF[PS3_RX_BUF_CNT]=rxdat[0];//マスク中は読み捨て
   if(tp_mask==0){//1=タッチパネルマスク         
        PS3_RX_BUF_CNT++;
        //バッファオーバーフロー処理////
        if(PS3_RX_BUF_CNT>sizeof(PS3_RX_BUF)){
            ps_buf_clr();
        }
                ////終端コード受信時の処理///
        if(PS3_RX_BUF[PS3_RX_BUF_CNT-1]==0x0a){//lf終端検出 
                ///タイムアウトセット操作検出から一定時間で自動クリアする
                PS3_RX_TIME_OUT.attach(&PS3_RX_TIMEOUT_IRQ,0.2); ////0.1
                PS3_RX_CHK();
        }
    }
    
}
void PS3_CTL_INI(void){
    
    PS3_CTL= new UnbufferedSerial(PC_10,PC_11,115200);//J4
     //シリアル通信の割り込み処理
    PS3_CTL->attach(PS3_CTL_RX, SerialBase::RxIrq);

    

}