#include "mbed.h"
#include "main.h"
#include "IO_CONT.h"
#include "MCP23017.h"

/////////////IOエクスパンダー///////////////////////////
I2C i2c(PB_4, PA_8);
MCP23017 IOEX = MCP23017(i2c,IOEX_ADD_0);///A2,A1,A0=0,0,0

extern char lcd_print_buf[64];
extern unsigned char page;//lcd画面ページ
extern unsigned char HAND_WORK_OK;//1=ワーク把持成功
/////////////IOエクスパンダー　出力ポート///////////////////////////
//溶接1加圧//
unsigned int PS1_ST0_O      = IOEX_B0_write_bit0;
unsigned int PS1_ST1_O      = IOEX_B0_write_bit1;
unsigned int PS1_ST2_O      = IOEX_B0_write_bit2;

//溶接2加圧//
unsigned int PS2_ST0_O      = IOEX_B0_write_bit3;
unsigned int PS2_ST1_O      = IOEX_B0_write_bit4;
unsigned int PS2_ST2_O      = IOEX_B0_write_bit5;

//ワーク搬送軸//
unsigned int WTRP_PC1_O     = IOEX_A0_write_bit0;
unsigned int WTRP_PC2_O     = IOEX_A0_write_bit1;
unsigned int WTRP_PC4_O     = IOEX_A0_write_bit2;
unsigned int WTRP_PC8_O     = IOEX_A0_write_bit3;
unsigned int WTRP_HOME_O    = IOEX_A0_write_bit4;
unsigned int WTRP_STP_O     = IOEX_A0_write_bit5;
unsigned int WTRP_CSTR_O    = IOEX_A0_write_bit6;

//ニッケル搬送軸1//
unsigned int NTRP1_PC1_O    = IOEX_B1_write_bit0;
unsigned int NTRP1_PC2_O    = IOEX_B1_write_bit1;
unsigned int NTRP1_PC4_O    = IOEX_B1_write_bit2;
unsigned int NTRP1_PC8_O    = IOEX_B1_write_bit3;
unsigned int NTRP1_HOME_O   = IOEX_B1_write_bit4;
unsigned int NTRP1_STP_O    = IOEX_B1_write_bit5;
unsigned int NTRP1_CSTR_O   = IOEX_B1_write_bit6;
unsigned int WD1_ERR_RST_O  = IOEX_A1_write_bit7;

//ニッケル搬送軸2//
unsigned int NTRP2_PC1_O    = IOEX_A1_write_bit0;
unsigned int NTRP2_PC2_O    = IOEX_A1_write_bit1;
unsigned int NTRP2_PC4_O    = IOEX_A1_write_bit2;
unsigned int NTRP2_PC8_O    = IOEX_A1_write_bit3;
unsigned int NTRP2_HOME_O   = IOEX_A1_write_bit4;
unsigned int NTRP2_STP_O    = IOEX_A1_write_bit5;
unsigned int NTRP2_CSTR_O   = IOEX_A1_write_bit6;
unsigned int WD2_ERR_RST_O  = IOEX_A1_write_bit7;

/////////////IOエクスパンダー　入力ポート/////////////////////////
//溶接1加圧//
unsigned int PS1_PE0_I      = IOEX_B0_read_bit0;
unsigned int PS1_PE1_I      = IOEX_B0_read_bit1;
unsigned int PS1_PE2_I      = IOEX_B0_read_bit2;
unsigned int PS1_PE3_I      = IOEX_B0_read_bit3;//未使用
//溶接2加圧//
unsigned int PS2_PE0_I      = IOEX_B0_read_bit4;
unsigned int PS2_PE1_I      = IOEX_B0_read_bit5;
unsigned int PS2_PE2_I      = IOEX_B0_read_bit6;
unsigned int PS2_PE3_I      = IOEX_B0_read_bit7;//未使用


///センサ他//
unsigned int START_SW_I     = IOEX_A0_read_bit0;
unsigned int AREA_SENS_I    = IOEX_A0_read_bit1;

//予備入力//
unsigned int SENS_RSV1_I    = IOEX_A0_read_bit4;
unsigned int SENS_RSV2_I    = IOEX_A0_read_bit5;
unsigned int SENS_RSV3_I    = IOEX_A0_read_bit6;
unsigned int SENS_RSV4_I    = IOEX_A0_read_bit7;
//ワーク搬送軸//
unsigned int WTRP_HEND_I    = IOEX_B1_read_bit0;
unsigned int WTRP_PEND_I    = IOEX_B1_read_bit1;
//ニッケル搬送軸1//
unsigned int NTRP1_HEND_I   = IOEX_B1_read_bit2;
unsigned int NTRP1_PEND_I   = IOEX_B1_read_bit3;
//ニッケル搬送軸2//
unsigned int NTRP2_HEND_I   = IOEX_B1_read_bit4;
unsigned int NTRP2_PEND_I   = IOEX_B1_read_bit5;
//溶接機1//
unsigned int WD1_OK_I       = IOEX_A1_read_bit0;
unsigned int WD1_NG_I       = IOEX_A1_read_bit1;
unsigned int WD1_END_I      = IOEX_A1_read_bit2;
//溶接機2//
unsigned int WD2_OK_I       = IOEX_A1_read_bit3;
unsigned int WD2_NG_I       = IOEX_A1_read_bit4;
unsigned int WD2_END_I      = IOEX_A1_read_bit5;

//IO初期化時のPORT状態(IOEX)/////
unsigned char IOEX_A0_data=0x00;
unsigned char IOEX_B0_data=0x00;
unsigned char IOEX_A1_data=0x00;
unsigned char IOEX_B1_data=0x00;
 //////////////DIPSW////////////////////////////
/* FETに割り当ての為使用不能
DigitalIn DIPSW_1(PA_4);
DigitalIn DIPSW_2(PB_0);
DigitalIn DIPSW_4(PC_1);
DigitalIn DIPSW_8(PC_0);
*/
DigitalOut IOEX_RST_O(PC_8);

DigitalOut FET1_O(PA_0);//ニッケルカット1 CN8
DigitalOut FET2_O(PA_1);//ニッケル把持1 CN8
DigitalOut FET3_O(PA_4);//ニッケル押し当て1 CN8
DigitalOut FET4_O(PB_0);//ニッケルカット2 CN8

DigitalOut FET5_O(PC_1);//ニッケル把持2 CN8
DigitalOut FET6_O(PC_0);//ニッケル押し当て2 CN8
DigitalOut FET7_O(PD_2);//極棒回転1
DigitalOut FET8_O(PC_12);//極棒回転2

////////////////////////////////////////
void IOEX_A0_BYW(unsigned char data){
    IOEX_A0_data=data;
    IOEX.add_set(IOEX_ADD_0);
    IOEX.write(PORT_A,IOEX_A0_data);
}
void IOEX_B0_BYW(unsigned char data){
    IOEX_B0_data=data;
    IOEX.add_set(IOEX_ADD_0);
    IOEX.write(PORT_B,IOEX_B0_data);
}
void IOEX_A1_BYW(unsigned char data){
    IOEX_A1_data=data;
    IOEX.add_set(IOEX_ADD_1);
    IOEX.write(PORT_A,IOEX_A1_data);
}
void IOEX_B1_BYW(unsigned char data){
    IOEX_B1_data=data;
    IOEX.add_set(IOEX_ADD_1);
    IOEX.write(PORT_B,IOEX_B1_data);
}


void IOEX_A0_bW(unsigned int bit,unsigned char cont){//P0RTA bit書き込み    PORTA BIT0をHi 例:IOEX_0A_bW(IOEX_read_bit0,IOEX_on)
    if(cont==1){
        IOEX_A0_data |=bit;
    }else{
         IOEX_A0_data &= ~bit;
    }
    IOEX.add_set(IOEX_ADD_0);
    IOEX.write(PORT_A,IOEX_A0_data);
}
void IOEX_B0_bW(unsigned int bit,unsigned char cont){
    if(cont==1){
        IOEX_B0_data |=bit;
    }else{
         IOEX_B0_data &= ~bit;
    }
    IOEX.add_set(IOEX_ADD_0);
    IOEX.write(PORT_B,IOEX_B0_data);
}

void IOEX_A1_bW(unsigned int bit,unsigned char cont){//P0RTA bit書き込み    PORTA BIT0をHi 例:IOEX_0A_bW(IOEX_read_bit0,IOEX_on)
    if(cont==1){
        IOEX_A1_data |=bit;
    }else{
         IOEX_A1_data &= ~bit;
    }
    IOEX.add_set(IOEX_ADD_1);
    IOEX.write(PORT_A,IOEX_A1_data);
}
void IOEX_B1_bW(unsigned int bit,unsigned char cont){
    if(cont==1){
        IOEX_B1_data |=bit;
    }else{
         IOEX_B1_data &= ~bit;
    }
    IOEX.add_set(IOEX_ADD_1);
    IOEX.write(PORT_B,IOEX_B1_data);
}





void IO_EX_BIT_WITE(unsigned int bit,unsigned char cont){
    
    
    if(bit<=0x080){
        IOEX_A0_bW(bit,cont);
    }
    
    if(bit>0x080 &&bit<=0x180){
        bit =(bit & 0xFF);
        IOEX_B0_bW(bit,cont);
    }
    if(bit>0x180 &&bit<=0x280){
        bit =(bit & 0xFF);
        IOEX_A1_bW(bit,cont);
        
    }
    if(bit>0x280 &&bit<=0x380){
        bit =(bit & 0xFF);
        IOEX_B1_bW(bit,cont);
        
    }
}



unsigned char IOEX_A0_bR(unsigned int bit){//P0RTA bit読み込み 
    unsigned char data=0;
    IOEX.add_set(IOEX_ADD_2);
    data=IOEX.read(PORT_A)>>bit;
    data &=0x01;
     
    return data;
}
unsigned char IOEX_A0_BYR(){//P0RTA BYTE読み込み 2022/04/09
    unsigned char data=0;
    IOEX.add_set(IOEX_ADD_2);
    data=IOEX.read(PORT_A);     
    return data;
}
unsigned char IOEX_B0_bR(unsigned int bit){//P0RTb bit読み込み 
    unsigned char data=0;  
    IOEX.add_set(IOEX_ADD_2);
    data=IOEX.read(PORT_B)>>(bit-10);
    data &=0x01;
    return data;
}

unsigned char IOEX_B0_BYR(){//P0RTB BYTE読み込み 2022/04/09
    unsigned char data=0;
    IOEX.add_set(IOEX_ADD_2);
    data=IOEX.read(PORT_B);     
    return data;
}
unsigned char IOEX_A1_bR(unsigned int bit){//P0RTA bit読み込み 
    unsigned char data=0;
    IOEX.add_set(IOEX_ADD_3);
    data=IOEX.read(PORT_A)>>(bit-20);
    data &=0x01;
     
    return data;
}
unsigned char IOEX_A1_BYR(){//P0RTA BYTE読み込み 2022/04/09
    unsigned char data=0;
    IOEX.add_set(IOEX_ADD_3);
    data=IOEX.read(PORT_A);     
    return data;
}
unsigned char IOEX_B1_bR(unsigned int bit){//P0RTb bit読み込み 
    unsigned char data=0;
    IOEX.add_set(IOEX_ADD_3);  
    data=IOEX.read(PORT_B)>>(bit-30);
    data &=0x01;
    return data;
}
unsigned char IOEX_B1_BYR(){//P0RTB BYTE読み込み 2022/04/09
    unsigned char data=0;
    IOEX.add_set(IOEX_ADD_3);
    data=IOEX.read(PORT_B);     
    return data;
}


unsigned char IO_EX_BIT_READ(unsigned int vol){
    unsigned char data=0;
    
    if(vol<=7){
        data=IOEX_A0_bR(vol);
    }
    if(vol>7 && vol<=17){
        data=IOEX_B0_bR(vol);   
    }
    
    if(vol>17 && vol<=27){
        data=IOEX_A1_bR(vol);
        
    }
    if(vol>27 && vol<=37){
        data=IOEX_B1_bR(vol);
        
    }
    return data;            
}   
///IOの初期論理を設定///
void IO_INI(void){
     /////////IOEX////////////
    ///リセット///
     IOEX_RST_O=0;
     wait_ms(100);
     IOEX_RST_O=1;
     wait_ms(100);
    // I2C init (IOEX用)
    i2c.frequency(400000);
    
    //ポートディレクション設定///
    //IOEX0//
    IOEX.add_set(IOEX_ADD_0); 
    IOEX.direction(PORT_A, PORT_DIR_OUT);//PORTAを全ピン出力に設定  
    IOEX.direction(PORT_B, PORT_DIR_OUT);//PORTBを全ピン出力に設定
    IOEX.write(PORT_A,IOEX_A0_data);//PORTA出力初期値設定 
    IOEX.write(PORT_B,IOEX_B0_data);//PORTB出力初期値設定   
    //IOEX1//
    IOEX.add_set(IOEX_ADD_1); 
    IOEX.direction(PORT_A, PORT_DIR_OUT);//PORTAを全ピン出力に設定  
    IOEX.direction(PORT_B, PORT_DIR_OUT);//PORTBを全ピン出力に設定
    IOEX.write(PORT_A,IOEX_A1_data);//PORTA出力初期値設定 
    IOEX.write(PORT_B,IOEX_B1_data);//PORTB出力初期値設定    
    
    //IOEX2//
    IOEX.add_set(IOEX_ADD_2); 
    IOEX.direction(PORT_A, PORT_DIR_IN);//PORTAを全ピン入力に設定
    IOEX.direction(PORT_B, PORT_DIR_IN);//PORTBを全ピン入力に設定
    IOEX.configurePullUps(PORT_A,0xFF);//PORTA全品PULL UP ON   
    IOEX.configurePullUps(PORT_B,0xFF);//PORTB全品PULL UP ON     
    //IOEX3//
    IOEX.add_set(IOEX_ADD_3); 
    IOEX.direction(PORT_A, PORT_DIR_IN);//PORTAを全ピン入力に設定
    IOEX.direction(PORT_B, PORT_DIR_IN);//PORTBを全ピン入力に設定
    IOEX.configurePullUps(PORT_A,0xFF);//PORTA全品PULL UP ON   
    IOEX.configurePullUps(PORT_B,0xFF);//PORTB全品PULL UP ON     
   /* FETに割り当ての為使用不可
    DIPSW_1.mode(PullUp);
    DIPSW_2.mode(PullUp);
    DIPSW_4.mode(PullUp);
    DIPSW_8.mode(PullUp);
    */
    
    wait_ms(2000);

    
    
            
}

