#include "mbed.h"
#include "main.h"
#include "nextion_lcd.h"
#include "APP.h"
#include "WORK_START.h"
///////////////////////
#include "ROBO1_CONT.h"
#include "ROBO2_CONT.h"
#include "ROBO_TWIN_CONT.h"
#include "SAVE_CONT.h"
///////////////////////
#include "PS3_BT_CTL.h"
/////////////////////////
#include "WD_CONT.h"
#include "DiNi_supplyr.h"
#include "CUT_CONT.h"
#include "IO_CONT.h"
/////////////////////////////////page6 端子供給装置モーション画面の操作//////////////////////////////////////
void TANSI_MNT_PAGE(void) ///page 7 一時停止
{
    if(touch_id!=0) {
        tp_mask=1;//1=タッチパネルマスク
    }
    switch (touch_id) {
        ////caseはnextion lcdのSWに割り当てられたidを記載する///
        case BT7_CT1_HAND:
                                if(C1_HAND_FET_ST==FET_OFF){
                                    C1_HAND_FET_CONT(FET_ON);//ハンド閉
                                    lcd_bc_color_chg("b15",LCD_RED,50);
                                }else{
                                    C1_HAND_FET_CONT(FET_OFF);//ハンド開    
                                    lcd_bc_color_chg("b15",64520,50);
                                }
                                touch_id=0;
                                break;
        case BT7_CT1_WDPOS:
                                if(C1_WD_FET_ST==FET_OFF){
                                    C1_WD_FET_CONT(FET_ON);//極棒押し当て
                                    lcd_bc_color_chg("b16",LCD_RED,50);
                                }else{
                                    C1_WD_FET_CONT(FET_OFF);//極棒押し当て解除
                                    lcd_bc_color_chg("b16",64520,50);
                                }
                                touch_id=0;
                                break;
        case BT7_CT1_CUT:
                                if(C1_CUT_FET_ST==FET_OFF){
                                    C1_CUT_FET_CONT(FET_ON);//カットON
                                    lcd_bc_color_chg("b17",LCD_RED,50);
                                }else{
                                    C1_CUT_FET_CONT(FET_OFF);//カットOFF  
                                    lcd_bc_color_chg("b17",64520,50);
                                }
                                touch_id=0;
                                break;
        case BT7_CT1_50STB  :    
                                C1_HAND_FET_CONT(FET_OFF);//ハンド開
                                C1_WD_FET_CONT(FET_OFF);//溶接押し当て退避
                                wait_ms(100);
                                C1_MOVE(POS_WAIT_3MM);
                                C1_MOVE_WAIT();
                                C1_MOT_MOVE_MM(C1_SET_50MM,MOT_WAIT_EN);
                                touch_id=0;
                                break;
        case BT7_CT1_32_1STB:
                                C1_HAND_FET_CONT(FET_OFF);//ハンド開
                                C1_WD_FET_CONT(FET_OFF);//溶接押し当て退避
                                wait_ms(100);
                                C1_MOVE(POS_WAIT_13MM);
                                C1_MOVE_WAIT();
                                C1_MOT_MOVE_MM(C1_SET_32MM,MOT_WAIT_EN);
                                touch_id=0;
                                break;
        case BT7_CT1_32_2STB:
                                C1_HAND_FET_CONT(FET_OFF);//ハンド開
                                C1_WD_FET_CONT(FET_OFF);//溶接押し当て退避
                                C1_MOVE(POS_WAIT_3MM);
                                C1_MOVE_WAIT();
                                C1_MOT_MOVE_MM(C1_SET_23MM,MOT_WAIT_EN);
                                touch_id=0;
                                break;
        case BT7_CT1_50_ADJ:
                                lcd_page_set(P_NI_ADJ,50);
                                ADJ_MODE=0;//左<0=50 1=32 2=23> 右<4=50 5=32 6=23>
                                ADJ_DISP();
                                touch_id=0;
                                break;
        case BT7_CT1_32_ADJ:
                                lcd_page_set(P_NI_ADJ,50);
                                ADJ_MODE=1;//左<0=50 1=32 2=23> 右<4=50 5=32 6=23>
                                ADJ_DISP();
                                touch_id=0;
                                break;
        case BT7_CT1_23_ADJ:
                                lcd_page_set(P_NI_ADJ,50);
                                ADJ_MODE=2;//左<0=50 1=32 2=23> 右<4=50 5=32 6=23>
                                ADJ_DISP();
                                touch_id=0;
                                break;
        case BT7_CT1_MOV  :
                                C1_HAND_FET_CONT(FET_ON);//ハンド閉
                                wait_ms(100);
                                C1_CUT_FET_CONT(FET_ON);
                                wait_ms(100);
                                C1_CUT_FET_CONT(FET_OFF);
                                wait_ms(100);
                                C1_MOVE(POS_WD_1);
                                C1_MOVE_WAIT();
                                touch_id=0;
                                break;



        case BT7_CT1_TEST:
                                C1_MOT_MOVE_MM(C1_SET_50MM,MOT_WAIT_EN);
                                touch_id=0;
                                break;


        case BT7_CT1_TCUT:      //端子切断のみ動作///
                                C1_CUT_FET_CONT(FET_ON);
                                wait_ms(100);
                                C1_CUT_FET_CONT(FET_OFF);
                                wait_ms(100);
                                touch_id=0;
                                break;
        case BT7_CT1_WDP1:      //搬送軸溶接ポイント1///
                                C1_MOVE(POS_WD_1);
                                C1_MOVE_WAIT();
                                touch_id=0;
                                break;
        case BT7_CT1_WDP2:      //搬送軸溶接ポイント2///
                                C1_MOVE(POS_WD_2);
                                C1_MOVE_WAIT();
                                touch_id=0;
                                break;
        case BT7_CT2_HAND:
                                if(C2_HAND_FET_ST==FET_OFF){
                                    C2_HAND_FET_CONT(FET_ON);//ハンド閉
                                    lcd_bc_color_chg("b18",LCD_RED,50);
                                }else{
                                    C2_HAND_FET_CONT(FET_OFF);//ハンド開    
                                    lcd_bc_color_chg("b18",64520,50);
                                }
                                touch_id=0;
                                break;
        case BT7_CT2_WDPOS:
                                if(C2_WD_FET_ST==FET_OFF){
                                    C2_WD_FET_CONT(FET_ON);//極棒押し当て
                                    lcd_bc_color_chg("b19",LCD_RED,50);
                                }else{
                                    C2_WD_FET_CONT(FET_OFF);//極棒押し当て解除
                                    lcd_bc_color_chg("b19",64520,50);
                                }
                                touch_id=0;
                                break;
        case BT7_CT2_CUT:
                                if(C2_CUT_FET_ST==FET_OFF){
                                    C2_CUT_FET_CONT(FET_ON);//カットON
                                    lcd_bc_color_chg("b20",LCD_RED,50);
                                }else{
                                    C2_CUT_FET_CONT(FET_OFF);//カットOFF  
                                    lcd_bc_color_chg("b20",64520,50);
                                }
                                touch_id=0;
                                break;
        case BT7_CT2_50STB  :   ///この50mmは２分割でだす///
                                C2_HAND_FET_CONT(FET_OFF);//ハンド開
                                C2_WD_FET_CONT(FET_OFF);//溶接押し当て退避
                                wait_ms(100);
                                C2_MOVE(POS_WAIT_4R5MM);
                                C2_MOVE_WAIT();
                                C2_MOT_MOVE_MM(C2_SET_50MM/2,MOT_WAIT_EN);
                                C2_MOVE(POS_WAIT_31MM);
                                C2_MOVE_WAIT();  
                                C2_MOT_MOVE_MM(C2_SET_50MM/2,MOT_WAIT_EN);
                                touch_id=0;
                                break;
        case BT7_CT2_32STB:
                                C2_HAND_FET_CONT(FET_OFF);//ハンド開
                                C2_WD_FET_CONT(FET_OFF);//溶接押し当て退避
                                wait_ms(100);
                                C2_MOVE(POS_WAIT_3MM);
                                C2_MOVE_WAIT();
                                C2_MOT_MOVE_MM(C2_SET_32MM,MOT_WAIT_EN);
                                touch_id=0;
                                break;
        case BT7_CT2_23STB:
                                C2_HAND_FET_CONT(FET_OFF);//ハンド開
                                C2_WD_FET_CONT(FET_OFF);//溶接押し当て退避
                                wait_ms(100);
                                C2_MOVE(POS_WAIT_4R5MM);
                                C2_MOVE_WAIT();
                                C2_MOT_MOVE_MM(C2_SET_23MM,MOT_WAIT_EN);
                                touch_id=0;
                                break;
        case BT7_CT2_50_ADJ:
                                lcd_page_set(P_NI_ADJ,50);
                                ADJ_MODE=3;//左<0=50 1=32 2=23> 右<4=50 5=32 6=23>
                                ADJ_DISP();
                                touch_id=0;
                                break;
        case BT7_CT2_32_ADJ:
                                lcd_page_set(P_NI_ADJ,50);
                                ADJ_MODE=4;//左<0=50 1=32 2=23> 右<4=50 5=32 6=23>
                                ADJ_DISP();
                                touch_id=0;
                                break;
        case BT7_CT2_23_ADJ:
                                lcd_page_set(P_NI_ADJ,50);
                                ADJ_MODE=5;//左<0=50 1=32 2=23> 右<4=50 5=32 6=23>
                                ADJ_DISP();
                                touch_id=0;
                                break;
        case BT7_CT2_MOV  :
                                C2_HAND_FET_CONT(FET_ON);//ハンド閉
                                wait_ms(100);
                                C2_CUT_FET_CONT(FET_ON);
                                wait_ms(100);
                                C2_CUT_FET_CONT(FET_OFF);
                                wait_ms(100);
                                C2_MOVE(POS_WD_1);
                                C2_MOVE_WAIT();
                                touch_id=0;
                                touch_id=0;
                                break;


        case BT7_CT2_TEST:
                                C2_MOT_MOVE_MM(C2_SET_50MM,MOT_WAIT_EN);
                                touch_id=0;
                                break;

        case BT7_CT2_TCUT:      //端子切断のみ動作///
                                C2_CUT_FET_CONT(FET_ON);
                                wait_ms(100);
                                C2_CUT_FET_CONT(FET_OFF);
                                wait_ms(100);
                                touch_id=0;
                                break;
        case BT7_CT2_WDP1:      //搬送軸溶接ポイント1///
                                C2_MOVE(POS_WD_1);
                                C2_MOVE_WAIT();
                                touch_id=0;
                                break;
        case BT7_CT2_WDP2:      //搬送軸溶接ポイント2///
                                C2_MOVE(POS_WD_2);
                                C2_MOVE_WAIT();
                                touch_id=0;
                                break;
        case BT7_BACK    :
                                lcd_page_set(P_MAIN,50);
                                MAIN_PAGE_DISP();
                                ALM_ST=ALM_NONE;
                                touch_id=0;
                                break;


    }
    if(touch_id==0 && tp_mask==1) { //タッチパネルに割りつけた作業がおわったらセンサ開始再開
        tp_mask=0;//1=タッチパネルマスク
    }
}