#include "mbed.h"
#include "main.h"
#include "nextion_lcd.h"
#include "APP.h"
#include "ROBO1_CONT.h"
#include "ROBO2_CONT.h"
#include "SAVE_CONT.h"
#include "ROBO_TWIN_CONT.h"

Ticker RB1A2_RX_TIME_OUT;
unsigned char RB1A2_RX_TIME_OUT_F=0;

unsigned char RB1A2_SPEED_ADJ=100;
unsigned char RB1A2_ACC_ADJ=80;


unsigned char RP_SEL_SET=0;

void  RB1A2_RX_TIME_OUT_IRQ(){
    RB1A2_RX_TIME_OUT_F=1;
    RB1A2_RX_TIME_OUT.detach();//シリアル受信タイムアウトカウンタ停止
    RB1_eth_buf_clr();
    RB2_eth_buf_clr();

}
/*
ロボットのタイムアウト検出は割り込みを使用して行う。
通常のwaitをカウントする方法では、時間が大きくずれる為
＊Etherの受信処理にもタイムアウト設定がある為
WIZnet_Socket.hの以下の設定　下記だと一度ETHER受信しタイムアウトまで300msかかる
set_blocking(bool blocking, unsigned int timeout=300);//1500

*/
void RB1A2_MOVE_SWAIT(unsigned long tout_ms){
    char *cmp1_txt="0,{7},RobotMode()";
    char *cmp2_txt="0,{5},RobotMode()";
    char *cmp3_txt="0,{9},RobotMode()";
    unsigned char RB1_START_F=0;
    unsigned char RB1_ERR_F=0;
    unsigned char RB2_START_F=0;
    unsigned char RB2_ERR_F=0;
    
    RB1_SEND_CMD("RobotMode()");
    RB2_SEND_CMD("RobotMode()");
    RB1A2_RX_TIME_OUT_F=0;
    RB1A2_RX_TIME_OUT.attach_us(&RB1A2_RX_TIME_OUT_IRQ,tout_ms*1000); 

    while(RB1A2_RX_TIME_OUT_F==0 && (RB1_START_F==0 || RB2_START_F==0)  && (RB1_ERR_F==0 || RB2_ERR_F==0)){
        if(RB1_RX_DATA()>0){
            if(strstr(RB1_rob_rx_buffer,cmp3_txt) ==NULL){//err状態でないことを確認
                //移動開始確認///
                if(strstr(RB1_rob_rx_buffer,cmp1_txt) !=NULL){
                    RB1_START_F=1;
                }else{
                    RB1_SEND_CMD("RobotMode()");   
                }
            }else{
                RB1_ERR_F=1;
                ALM_ST=ALM_DOBOT1_ST;
                ALM_HOLD_SET();
            }
        }
   
        if(RB2_RX_DATA()>0 && RB2_ERR_F==0){
            if(strstr(RB2_rob_rx_buffer,cmp3_txt) ==NULL){//err状態でないことを確認
                //移動開始確認///
                if(strstr(RB2_rob_rx_buffer,cmp1_txt) !=NULL){
                    RB2_START_F=1;
                }else{
                    RB2_SEND_CMD("RobotMode()");   
                }
            }else{
                RB2_ERR_F=1;
                ALM_ST=ALM_DOBOT2_ST;
                ALM_HOLD_SET();
            }
        }

        wait_us(10*1000); 
    }
    if(RB1A2_RX_TIME_OUT_F==1){
        if(RB1_START_F==0 && RB2_START_F==1){
            ALM_ST=ALM_DOBOT1_ST;
            
        }
        if(RB1_START_F==1 && RB2_START_F==0){
            ALM_ST=ALM_DOBOT2_ST;
        }   
        if(RB1_START_F==0 && RB2_START_F==0){
            ALM_ST=ALM_DOBOT12_ST;
        }  
        ALM_HOLD_SET();
    }else{
        RB1A2_RX_TIME_OUT.detach();//タイムアウトカウンタ停止
        RB1_eth_buf_clr();
        RB2_eth_buf_clr();
    }
}
void RB1A2_MOVE_EWAIT(unsigned long tout_ms){

    char *cmp1_txt="0,{7},RobotMode()";
    char *cmp2_txt="0,{5},RobotMode()";
    char *cmp3_txt="0,{9},RobotMode()";
    unsigned char RB1_END_F=0;
    unsigned char RB1_ERR_F=0;
    unsigned char RB2_END_F=0;
    unsigned char RB2_ERR_F=0;

    RB1_SEND_CMD("RobotMode()");
    RB2_SEND_CMD("RobotMode()");
    RB1A2_RX_TIME_OUT_F=0;
    RB1A2_RX_TIME_OUT.attach_us(&RB1A2_RX_TIME_OUT_IRQ,tout_ms*1000); 
    while(RB1A2_RX_TIME_OUT_F==0 && (RB1_END_F==0 || RB2_END_F==0)  && (RB1_ERR_F==0 || RB2_ERR_F==0)){
        if(RB1_RX_DATA()>0 && RB1_ERR_F==0){
            if(strstr(RB1_rob_rx_buffer,cmp3_txt) ==NULL){//err状態でないことを確認
                //移動開始確認///
                if(strstr(RB1_rob_rx_buffer,cmp2_txt) !=NULL){
                    RB1_END_F=1;
                }else{
                    RB1_SEND_CMD("RobotMode()");   
                }
            }else{
                RB1_ERR_F=1;
                ALM_ST=ALM_DOBOT1_ED;
                ALM_HOLD_SET();
            }
        }
        if(RB2_RX_DATA()>0 && RB2_ERR_F==0){
            if(strstr(RB2_rob_rx_buffer,cmp3_txt) ==NULL){//err状態でないことを確認
                //移動開始確認///
                if(strstr(RB2_rob_rx_buffer,cmp2_txt) !=NULL){
                    RB2_END_F=1;
                }else{
                    RB2_SEND_CMD("RobotMode()");   
                }
            }else{
                RB2_ERR_F=1;
                ALM_ST=ALM_DOBOT2_ED;
                ALM_HOLD_SET();
            }
        }
        wait_us(10*1000);   
    }
    if(RB1A2_RX_TIME_OUT_F==1){
        if(RB1_END_F==0 && RB2_END_F==1){
            ALM_ST=ALM_DOBOT1_ED;
        }
        if(RB1_END_F==1 && RB2_END_F==0){
            ALM_ST=ALM_DOBOT2_ED;
        }   
        if(RB1_END_F==0 && RB2_END_F==0){
            ALM_ST=ALM_DOBOT12_ED;
        }  
         ALM_HOLD_SET();

    }else{
        RB1A2_RX_TIME_OUT.detach();//タイムアウトカウンタ停止
        RB1_eth_buf_clr();
        RB2_eth_buf_clr();
    }
    
    
}
void RB1A2_MOVE_WAIT(unsigned long tout_ms){
    RB1A2_MOVE_SWAIT(tout_ms);
    RB1A2_MOVE_EWAIT(tout_ms);
    
} 
void RB1A2_SEL_MOVE(unsigned char RP_SEL,unsigned int SPEED,unsigned int ACC){
    RB1_SEL_MOVE(RP_SEL,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);      
    RB2_SEL_MOVE(RP_SEL,RB1A2_SPEED_ADJ,RB1A2_ACC_ADJ);   
    RB1A2_MOVE_SWAIT(RB_SWAIT);
    RP_SEL_SET=RP_SEL;
}


void RB1A2_CMD_WAIT(unsigned long tout_ms){
    unsigned char RB1_END_F=0;
    unsigned char RB2_END_F=0;

    RB1A2_RX_TIME_OUT_F=0;
    RB1A2_RX_TIME_OUT.attach_us(&RB1A2_RX_TIME_OUT_IRQ,tout_ms*1000); 
    
    while(RB1A2_RX_TIME_OUT_F==0 && (RB1_END_F==0 || RB2_END_F==0)){
        if(RB1_RX_DATA()>0){
            if(strstr(RB1_rob_rx_buffer, RB1_rob_tx_buffer) !=NULL){
                RB1_END_F=1;
            }
        }
        if(RB2_RX_DATA()>0){
            if(strstr(RB2_rob_rx_buffer, RB2_rob_tx_buffer) !=NULL){
                RB2_END_F=1;
            }
        }  
        wait_us(10*1000);  
    
    }
    if(RB1A2_RX_TIME_OUT_F==1){
        if(RB1_END_F==0 && RB2_END_F==1){
            ALM_ST=ALM_DOBOT1;
        }
        if(RB1_END_F==1 && RB2_END_F==0){
            ALM_ST=ALM_DOBOT2;
        }   
        if(RB1_END_F==0 && RB2_END_F==0){
            ALM_ST=ALM_DOBOT12;
        }  
         ALM_HOLD_SET();

    }else{
        RB1A2_RX_TIME_OUT.detach();//タイムアウトカウンタ停止
        RB1_eth_buf_clr();
        RB2_eth_buf_clr();
    }
}
/////////////ハンド同時制御/////////////////////
void RB1A2_HAND_CONT(unsigned char cont){
    char RB1_BUF[64];
    char RB2_BUF[64];
    //RB1_SEND_CMD("EnableRobot()");//だんまり防止テスト（治具干渉するとだんまりになる？？）
    //RB1_CMD_WAIT(RB_SWAIT);
    //RB2_SEND_CMD("EnableRobot()");//だんまり防止テスト（治具干渉するとだんまりになる？？）
    //RB2_CMD_WAIT(RB_SWAIT);
    if(cont !=  RB1_HAND_ST){
        if(cont==RB1_HAND_CLOSE){
            sprintf(RB1_BUF,"DO(%d,%d)",1, 1);       
            RB1_SEND_CMD(RB1_BUF);  
        }else{
            sprintf(RB1_BUF,"DO(%d,%d)",1, 0);       
            RB1_SEND_CMD(RB1_BUF);  
        }
        RB1_HAND_ST=cont;
    }    
    if(cont !=  RB2_HAND_ST){
        if(cont==RB2_HAND_CLOSE){
            sprintf(RB2_BUF,"DO(%d,%d)",1, 1);       
            RB2_SEND_CMD(RB2_BUF);  
        }else{
            sprintf(RB2_BUF,"DO(%d,%d)",1, 0);       
            RB2_SEND_CMD(RB2_BUF);  
        }
        RB2_HAND_ST=cont;
    }      
    RB1A2_CMD_WAIT(RB_SWAIT);
}

void RB1A2_SPEED_SET(unsigned char SET){
    if(SET==RB_HIGH){
        RB1A2_SPEED_ADJ = RB_SPEED_HIGH;
        RB1A2_ACC_ADJ = RB_ACC_HIGH; 
    }else{
        RB1A2_SPEED_ADJ = RB_SPEED_LOW;
        RB1A2_ACC_ADJ = RB_ACC_LOW;     
    }   
}
void RB1A2_HOME_MOVE(){
   ///移動命令内でチェックしているポジション情報クリア//
    RB1_POS_CLR();
    RB2_POS_CLR();
    /////////////////
    RB1_SEND_CMD("ClearError()");    
    RB1_CMD_WAIT(RB_SWAIT);
    
    RB2_SEND_CMD("ClearError()");    
    RB2_CMD_WAIT(RB_SWAIT);
    RB1_SEND_CMD("EnableRobot()");
    RB1_CMD_WAIT(RB_SWAIT);
    
    RB2_SEND_CMD("EnableRobot()");
    RB2_CMD_WAIT(RB_SWAIT);
    
    
    ///ハンドの制御ポートを開側にする///  
    RB1_DO_CONT(1,0);
    RB2_DO_CONT(1,0);
    RB1_HAND_ST=RB1_HAND_OPEN;
    RB2_HAND_ST=RB2_HAND_OPEN;
    wait_ms(50);
    ///現在位置を確認し上昇///
    RB1_GETPOS(RB_EWAIT); 
    ///Zが-40以下の場合は、Zを上げてから原点復帰///
   if(RB1_Z_GET<100){
        RB1_MovJ(RB1_X_GET,RB1_Y_GET,100.0,RB1_R_GET,0,0,RB1_SPEED_ADJ,RB1_ACC_ADJ);
        RB1_MOVE_WAIT(2000);
    }
  
    ///現在位置を確認し上昇///
    RB2_GETPOS(RB_EWAIT); 
    ///Zが-40以下の場合は、Zを上げてから原点復帰///
    
    if(RB2_Z_GET<100){
        RB2_MovJ(RB2_X_GET,RB2_Y_GET,100.0,RB2_R_GET,0,0,RB2_SPEED_ADJ,RB2_ACC_ADJ);
        RB2_MOVE_WAIT(2000);
    }
    //角度指定で退避角度に移動///
    RB1_GETANG(RB_EWAIT); 

    if(RB1_J2_GET > -11.0 || RB1_J2_GET<-12.0 || RB1_J3_GET>-13.5 || RB1_J3_GET<-14.5){ 
        RB1_JointMovJ(RB1_J1_GET,-11.5,-14.0,0,0,0,10,10);
        RB1_MOVE_WAIT(20000);
    }
    RB2_GETANG(RB_EWAIT); 
   if(RB2_J2_GET > -11.0 || RB2_J2_GET<-12.0 || RB2_J3_GET>-13.5 || RB2_J3_GET<-14.5){ 
        RB2_JointMovJ(RB2_J1_GET,-11.5,-14.0,0,0,0,10,10);
        RB2_MOVE_WAIT(20000);  
    }
    //角度指定で正面0度に移動///
    if(RB1_J1_GET <0.5 || RB1_J1_GET >0.5){
        RB1_JointMovJ(0.0,-11.5,-14.0,0,0,0,10,10);
        RB1_MOVE_WAIT(40000);
    }
    if(RB2_J1_GET <0.5 || RB2_J1_GET >0.5){
        RB2_JointMovJ(0.0,-11.5,-14.0,0,0,0,10,10);
        RB2_MOVE_WAIT(40000);  
    }
    RB1_PSEL_BAK=RP_HOME;
    RB2_PSEL_BAK=RP_HOME;
    RP_SEL_SET=RP_HOME;

    
    ////初期座標に移動////
    RB1_SEL_MOVE(RP_EJECT,10,10);
    RB1_MOVE_WAIT(40000);//移動開始終了待ち
    RB2_SEL_MOVE(RP_EJECT,10,10);
    RB2_MOVE_WAIT(40000);//移動開始終了待ち
    RP_SEL_SET=RP_EJECT;



     
}
void RB1A2_HOME_MOVE2(){
    /////////////////
    RB1_SEND_CMD("ClearError()");    
    RB1_CMD_WAIT(RB_SWAIT);
    
    RB2_SEND_CMD("ClearError()");    
    RB2_CMD_WAIT(RB_SWAIT);
    RB1_SEND_CMD("EnableRobot()");
    RB1_CMD_WAIT(RB_SWAIT);
    
    RB2_SEND_CMD("EnableRobot()");
    RB2_CMD_WAIT(RB_SWAIT);
    
    
    ///ハンドの制御ポートを開側にする///  
    RB1_DO_CONT(1,0);
    RB2_DO_CONT(1,0);
    RB1_HAND_ST=RB1_HAND_OPEN;
    RB2_HAND_ST=RB2_HAND_OPEN;
    wait_ms(50);
    ///現在位置を確認し上昇///
    RB1_GETPOS(RB_EWAIT); 
    ///Zが-40以下の場合は、Zを上げてから原点復帰///
   if(RB1_Z_GET<100){
        RB1_MovJ(RB1_X_GET,RB1_Y_GET,100.0,RB1_R_GET,0,0,RB1_SPEED_ADJ,RB1_ACC_ADJ);
        RB1_MOVE_WAIT(2000);
    }
  
    ///現在位置を確認し上昇///
    RB2_GETPOS(RB_EWAIT); 
    ///Zが-40以下の場合は、Zを上げてから原点復帰///
    
    if(RB2_Z_GET<100){
        RB2_MovJ(RB2_X_GET,RB2_Y_GET,100.0,RB2_R_GET,0,0,RB2_SPEED_ADJ,RB2_ACC_ADJ);
        RB2_MOVE_WAIT(2000);
    }
    //角度指定で退避角度に移動///
    RB1_GETANG(RB_EWAIT); 

    if(RB1_J2_GET > -24.5 || RB1_J2_GET<-23.5 || RB1_J3_GET<2.5 || RB1_J3_GET>3.5){ 
        RB1_JointMovJ(RB1_J1_GET,-24.0,3.0,0,0,0,10,10);
        RB1_MOVE_WAIT(20000);
    }
    RB2_GETANG(RB_EWAIT); 
    if(RB2_J2_GET<-24.5 || RB2_J2_GET<-23.5 || RB2_J3_GET<2.5 || RB2_J3_GET>3.5){ 
        RB2_JointMovJ(RB2_J1_GET,-24.0,3.0,0,0,0,10,10);
        RB2_MOVE_WAIT(20000);  
    }
    //角度指定で正面0度に移動///
    if(RB1_J1_GET <0.5 || RB1_J1_GET >0.5){
        RB1_JointMovJ(0.0,-24.0,3.0,0,0,0,10,10);
        RB1_MOVE_WAIT(40000);
    }
    if(RB2_J1_GET <0.5 || RB2_J1_GET >0.5){
        RB2_JointMovJ(0.0,-24.0,3.0,0,0,0,10,10);
        RB2_MOVE_WAIT(40000);  
    }
    RB1_PSEL_BAK=RP_HOME;
    RB2_PSEL_BAK=RP_HOME;
    RP_SEL_SET=RP_HOME;
    ////初期座標に移動////
    RB1_SEL_MOVE(RP_EJECT,10,10);
    RB1_MOVE_WAIT(40000);//移動開始終了待ち
    RB2_SEL_MOVE(RP_EJECT,10,10);
    RB2_MOVE_WAIT(40000);//移動開始終了待ち
    RP_SEL_SET=RP_EJECT;
    
   /* RB1_MovJ(220.0,0.0,80.0,0,0,0,RB1_SPEED_ADJ,RB1_ACC_ADJ);  
    RB1_MOVE_WAIT(10000);
    
    RB1_MovJ(230.0,0.0,80.0,0,0,0,RB1_SPEED_ADJ,RB1_ACC_ADJ);  
    RB1_MOVE_WAIT(10000);
    
    
    RB2_MovJ(220.0,0.0,80.0,0,0,0,RB2_SPEED_ADJ,RB2_ACC_ADJ);
    RB2_MOVE_WAIT(10000);   
    
    RB2_MovJ(230.0,0.0,80.0,0,0,0,RB2_SPEED_ADJ,RB2_ACC_ADJ);
    RB2_MOVE_WAIT(10000);
    
    RP_SEL_SET=RP_HOME;
    */
    

     
}