#include "mbed.h"
#include "main.h"
#include "nextion_lcd.h"
#include "APP.h"
#include "ROBO1_CONT.h"
#include "SAVE_CONT.h"
///////////////////////
#include "WIZnetInterface.h"
#define USE_DHCP    0
#define LOOPBACKPORT    7
Ticker RB1_RX_TIME_OUT;

const char * IP_Addr    = "192.168.2.10";
const char * IP_Subnet  = "255.255.255.0";
const char * IP_Gateway = "192.168.2.1";
unsigned char MAC_Addr[6] = {0x00,0x08,0xDC,0x12,0x34,0x56};

const char *RB1_SV_Addr     = "192.168.2.7";
const int   RB1_SV_port     =30003;
//const int   SV_port     =30005;
SPI spi(PA_7, PA_6, PA_5);
WIZnetInterface RB1_ethernet(&spi,PB_1, PB_2);//CONT BOARD MINIは、PA_15,PB_2
TCPSocketConnection RB1_server;

///////////////////////
char RB1_rob_tx_buffer[128];
char RB1_rob_rx_buffer[128];


double RB1_Q1SET=0.0;
double RB1_Q2SET=0.0;
double RB1_Q3SET=0.0;
double RB1_Q4SET=0.0;
double RB1_Q5SET=0.0;
double RB1_Q6SET=0.0;


double RB1_X_SET=0.0;
double RB1_Y_SET=0.0;
double RB1_Z_SET=0.0;
double RB1_A_SET=0.0;
double RB1_B_SET=0.0;
double RB1_C_SET=0.0;

extern double RB1_POINT_RD[32][4];


unsigned char RB1_SPEED_ADJ=100;
unsigned char RB1_ACC_ADJ=80;

unsigned char RB1_PSEL_BAK=0xFF;


unsigned char RB1_RX_TIME_OUT_F=0;

unsigned char RB1_HAND_ST=RB1_HAND_OPEN;
char RB1_J1_DAT[32];
char RB1_J2_DAT[32];
char RB1_J3_DAT[32];
char RB1_J4_DAT[32];
char RB1_XDAT[32];
char RB1_YDAT[32];
char RB1_ZDAT[32];
char RB1_RDAT[32];

double RB1_J1_GET=0.0;
double RB1_J2_GET=0.0;
double RB1_J3_GET=0.0;
double RB1_J4_GET=0.0;

double RB1_X_GET=0.0;
double RB1_Y_GET=0.0;
double RB1_Z_GET=0.0;
double RB1_R_GET=0.0;

unsigned char R1_WAIT_MASK=0;//1でマスク　現在位置への移動指定時WAITをマスクする


void  RB1_RX_TIME_OUT_IRQ(){
    RB1_RX_TIME_OUT_F=1;
    RB1_RX_TIME_OUT.detach();//シリアル受信タイムアウトカウンタ停止
    RB1_eth_buf_clr();

}


void RB1_eth_buf_clr(){
    
    for(unsigned long clcnt=0; clcnt<sizeof(RB1_rob_tx_buffer); clcnt++){  
        RB1_rob_tx_buffer[clcnt]=0;
    }
    for(unsigned long clcnt=0; clcnt<sizeof(RB1_rob_rx_buffer); clcnt++){  
        RB1_rob_rx_buffer[clcnt]=0;
    }
}

void RB1_POS_CLR(){
    RB1_Q1SET=0.0;
    RB1_Q2SET=0.0;
    RB1_Q3SET=0.0;
    RB1_Q4SET=0.0;
    RB1_Q5SET=0.0;
    RB1_Q6SET=0.0;
    
    
    RB1_X_SET=0.0;
    RB1_Y_SET=0.0;
    RB1_Z_SET=0.0;
    RB1_A_SET=0.0;
    RB1_B_SET=0.0;
    RB1_C_SET=0.0;  
}
/////////////////////////////////page 1 作業画面の操作/////////////////////////////////////
char RB1_ETH_CONECT_CHK(){
    
    if(RB1_server.is_connected()==true){
        return 0;   
    }else{
        lcd_print("t0","LAN切断中です。再接続してください。"); 
        return -1; 
    }   
    
}

char RB1_CONNECT(){
    unsigned long timeout=0;
    sprintf(lcd_print_buf,"ロボット1(%s) 接続開始...",RB1_SV_Addr);
    lcd_print("t2",lcd_print_buf); 
    RB1_ethernet.disconnect();
    int ret = RB1_ethernet.init(MAC_Addr,IP_Addr,IP_Subnet,IP_Gateway);
    if (!ret) {
            printf("Initialized, MAC: %s\r\n", RB1_ethernet.getMACAddress());
            sprintf(lcd_print_buf,"Initialized, MAC: %s\r\n", RB1_ethernet.getMACAddress());
            //lcd_print("t0",lcd_print_buf);
            ret = RB1_ethernet.connect();
            if (!ret) {
                printf("IP: %s, MASK: %s, GW: %s\r\n",  
                RB1_ethernet.getIPAddress(), RB1_ethernet.getNetworkMask(), RB1_ethernet.getGateway());
                sprintf(lcd_print_buf,"IP: %s, MASK: %s, GW: %s\r\n",
                RB1_ethernet.getIPAddress(), RB1_ethernet.getNetworkMask(), RB1_ethernet.getGateway());
                //lcd_print("t0",lcd_print_buf);
                ret =RB1_server.connect(RB1_SV_Addr,RB1_SV_port);  
                if(ret !=0){
                    sprintf(lcd_print_buf,"ロボット1(%s) 接続待機中...",RB1_SV_Addr);
                    lcd_print("t2",lcd_print_buf); 
                      }
                while(ret !=0 && timeout<100){
                     ret =RB1_server.connect(RB1_SV_Addr,RB1_SV_port); 
                    wait_ms(100); 
                }
                printf("connect end\r\n");
                sprintf(lcd_print_buf,"ロボット1(%s) 接続完了",RB1_SV_Addr);
                lcd_print("t2",lcd_print_buf); 
                return 0;
            } else {
                printf("Error ethernet.connect() - ret = %d\r\n", ret);
                sprintf(lcd_print_buf,"ロボット1(%s) 接続異常",RB1_SV_Addr);
                lcd_print("t2",lcd_print_buf); 
                 return -1;
            }
    } else {
        printf("Error ethernet.init() - ret = %d\r\n", ret);
        lcd_print("t2","ETHER I/F  初期化異常"); 
        return -1;
    }
    
}

char RB1_DISCONNECT(){
    lcd_print("t0","RB1 Disconnect"); 
    int ret =RB1_ethernet.disconnect();
    wait_ms(2000);
    if(ret==0){
        lcd_print("t0","RB1 Disconnect End"); 
        return 0;
    }else{
        lcd_print("t0","RB1 Disconnect ERR"); 
        return -1;
    }
 
     
}

/*
ロボットのタイムアウト検出は割り込みを使用して行う。
通常のwaitをカウントする方法では、時間が大きくずれる為
＊Etherの受信処理にもタイムアウト設定がある為
WIZnet_Socket.hの以下の設定　下記だと一度ETHER受信しタイムアウトまで300msかかる
set_blocking(bool blocking, unsigned int timeout=300);//1500

*/


void RB1_GETANG(unsigned long tout_ms){
    char *cmp1_txt="GetAngle();";
    unsigned char DAT_GET_F=0;
    
    RB1_SEND_CMD("GetAngle()");
    RB1_RX_TIME_OUT_F=0;
    RB1_RX_TIME_OUT.attach_us(&RB1_RX_TIME_OUT_IRQ,tout_ms*1000); 
    while(RB1_RX_TIME_OUT_F==0 && DAT_GET_F==0){
        if(RB1_RX_DATA()>0){
            //移動開始確認///
            if(strstr(RB1_rob_rx_buffer,cmp1_txt) !=NULL){
                DAT_GET_F=1;
            }else{
                RB1_SEND_CMD("GetAngle()");
            }
        }
    wait_us(10*1000); 
    }
    unsigned char DAT_CNT=0;
    unsigned char DAT_CNT_T=3;
    if(RB1_RX_TIME_OUT_F==1){
        lcd_print("t0","RB1 GetAngle TIMEOUT");
        
    }else{
        RB1_RX_TIME_OUT.detach();//タイムアウトカウンタ停止
        while(RB1_rob_rx_buffer[DAT_CNT_T] !=0x2c && DAT_CNT<sizeof(RB1_J1_DAT)){
               RB1_J1_DAT[DAT_CNT++]=RB1_rob_rx_buffer[DAT_CNT_T++];
        }
        DAT_CNT_T++;//カンマを飛ばす
        DAT_CNT=0;
        while(RB1_rob_rx_buffer[DAT_CNT_T] !=0x2c && DAT_CNT<sizeof(RB1_J2_DAT)){
               RB1_J2_DAT[DAT_CNT++]=RB1_rob_rx_buffer[DAT_CNT_T++];
        }   
        DAT_CNT_T++;//カンマを飛ばす
        DAT_CNT=0;
        while(RB1_rob_rx_buffer[DAT_CNT_T] !=0x2c && DAT_CNT<sizeof(RB1_J3_DAT)){
               RB1_J3_DAT[DAT_CNT++]=RB1_rob_rx_buffer[DAT_CNT_T++];
        }   
        DAT_CNT_T++;//カンマを飛ばす
        DAT_CNT=0;
        while(RB1_rob_rx_buffer[DAT_CNT_T] !=0x2c && DAT_CNT<sizeof(RB1_J4_DAT)){
               RB1_J4_DAT[DAT_CNT++]=RB1_rob_rx_buffer[DAT_CNT_T++];
        }  
        RB1_J1_GET=atof(RB1_J1_DAT);
        RB1_J2_GET=atof(RB1_J2_DAT);
        RB1_J3_GET=atof(RB1_J3_DAT);
        RB1_J4_GET=atof(RB1_J4_DAT);
        
    }

    printf("J1=%f J2=%f J3=%f J4=%f\r\n",RB1_J1_GET,RB1_J2_GET,RB1_J3_GET,RB1_J4_GET);
    RB1_eth_buf_clr();
}  
void RB1_GETPOS(unsigned long tout_ms){
    char *cmp1_txt="GetPose();";
    unsigned char DAT_GET_F=0;
    RB1_SEND_CMD("GetPose()");
    RB1_RX_TIME_OUT_F=0;
    RB1_RX_TIME_OUT.attach_us(&RB1_RX_TIME_OUT_IRQ,tout_ms*1000); 
    while(RB1_RX_TIME_OUT_F==0 && DAT_GET_F==0){
        if(RB1_RX_DATA()>0){
            //移動開始確認///
            if(strstr(RB1_rob_rx_buffer,cmp1_txt) !=NULL){
                DAT_GET_F=1;
            }else{
               RB1_SEND_CMD("GetPose()");
            }
        } 
        wait_us(10*1000); 
    }
    unsigned char DAT_CNT=0;
    unsigned char DAT_CNT_T=3;
    if(RB1_RX_TIME_OUT_F==1){
        lcd_print("t0","RB1 GetPose TIMEOUT");
    }else{
        RB1_RX_TIME_OUT.detach();//タイムアウトカウンタ停止
        while(RB1_rob_rx_buffer[DAT_CNT_T] !=0x2c && DAT_CNT<sizeof(RB1_XDAT)){
               RB1_XDAT[DAT_CNT++]=RB1_rob_rx_buffer[DAT_CNT_T++];
        }
        DAT_CNT_T++;//カンマを飛ばす
        DAT_CNT=0;
        while(RB1_rob_rx_buffer[DAT_CNT_T] !=0x2c && DAT_CNT<sizeof(RB1_YDAT)){
               RB1_YDAT[DAT_CNT++]=RB1_rob_rx_buffer[DAT_CNT_T++];
        }   
        DAT_CNT_T++;//カンマを飛ばす
        DAT_CNT=0;
        while(RB1_rob_rx_buffer[DAT_CNT_T] !=0x2c && DAT_CNT<sizeof(RB1_ZDAT)){
               RB1_ZDAT[DAT_CNT++]=RB1_rob_rx_buffer[DAT_CNT_T++];
        }   
        DAT_CNT_T++;//カンマを飛ばす
        DAT_CNT=0;
        while(RB1_rob_rx_buffer[DAT_CNT_T] !=0x2c && DAT_CNT<sizeof(RB1_RDAT)){
               RB1_RDAT[DAT_CNT++]=RB1_rob_rx_buffer[DAT_CNT_T++];
        }  
        RB1_X_GET=atof(RB1_XDAT);
        RB1_Y_GET=atof(RB1_YDAT);
        RB1_Z_GET=atof(RB1_ZDAT);
        RB1_R_GET=atof(RB1_RDAT);
        
    }


    RB1_eth_buf_clr();
}  


/*
RobotMode()コマンドを使用してロボットの移動完了(Mode 5 idle)を確認する
 Mode | Description           | NOTE                             |
| ---- | --------------------- | -------------------------------- |
| 1    | ROBOT_MODE_INIT       | initialization                   |
| 2    | ROBOT_MODE_BRAKE_OPEN | The brake release                |
| 3    |                       | Reserved                         |
| 4    | ROBOT_MODE_DISABLED   | Disabled (brake is not released) |
| 5    | ROBOT_MODE_ENABLE     | Enable (idle)                    |
| 6    | ROBOT_MODE_BACKDRIVE  | Dragging state                   |
| 7    | ROBOT_MODE_RUNNING    | Running state                    |
| 8    | ROBOT_MODE_RECORDING  | Dragging recording               |
| 9    | ROBOT_MODE_ERROR      | Alarm state                      |
| 10   | ROBOT_MODE_PAUSE      | pause state                      |
| 11   | ROBOT_MODE_JOG        | jogging state                    |


*/

void RB1_MOVE_WAIT(unsigned long tout_ms){//移動開始待ち
    char *cmp1_txt="0,{7},RobotMode()";
    char *cmp2_txt="0,{5},RobotMode()";
    char *cmp3_txt="0,{9},RobotMode()";
    
    unsigned char MOVE_START_F=0;
    unsigned char MOVE_END_F=0;
    unsigned char MOVE_ERR_F=0;
    if(R1_WAIT_MASK==0){//1でマスク　現在位置への移動指定時WAITをマスクする
        RB1_SEND_CMD("RobotMode()");
        RB1_RX_TIME_OUT_F=0;
        RB1_RX_TIME_OUT.attach_us(&RB1_RX_TIME_OUT_IRQ,tout_ms*1000);
        while(RB1_RX_TIME_OUT_F==0 && MOVE_START_F==0  && MOVE_ERR_F==0){
            if(RB1_RX_DATA()>0){
                if(strstr(RB1_rob_rx_buffer,cmp3_txt) ==NULL){//err状態でないことを確認
                    //移動開始確認///
                    if(strstr(RB1_rob_rx_buffer,cmp1_txt) !=NULL){
                        MOVE_START_F=1;
                    }else{
                        RB1_SEND_CMD("RobotMode()");   
                    }
                }else{
                    MOVE_ERR_F=1;
                    ALM_ST=ALM_DOBOT1;
                    ALM_HOLD_SET();
                }
            }
            wait_us(10*1000); 
        }
         if(RB1_RX_TIME_OUT_F==1){
            //printf("MOVE START TIMEOUT!! TX=%s  Rx=%s\r\n",RB1_rob_tx_buffer,RB1_rob_rx_buffer);
            ALM_ST=ALM_DOBOT1_ST;
            ALM_HOLD_SET();
        }else{
            RB1_RX_TIME_OUT.detach();//タイムアウトカウンタ停止
        }
        if(ALM_ST==ALM_NONE){
             ///移動完了チェック///
            RB1_RX_TIME_OUT_F=0;
            RB1_RX_TIME_OUT.attach_us(&RB1_RX_TIME_OUT_IRQ,tout_ms*1000); 
            RB1_SEND_CMD("RobotMode()");        
            while(RB1_RX_TIME_OUT_F==0 && MOVE_END_F==0  && MOVE_ERR_F==0){
                if(RB1_RX_DATA()>0){
                    if(strstr(RB1_rob_rx_buffer,cmp3_txt) ==NULL){//err状態でないことを確認
                        //移動完了確認///
                        if(strstr(RB1_rob_rx_buffer,cmp2_txt) !=NULL){
                            MOVE_END_F=1;
                        }else{
                             RB1_SEND_CMD("RobotMode()");   
                        }
                    }else{
                        MOVE_ERR_F=1;
                        ALM_ST=ALM_DOBOT1;
                        ALM_HOLD_SET();
                    }
                }
                wait_us(10*1000); //10ms
            }
             if(RB1_RX_TIME_OUT_F==1){
                ALM_ST=ALM_DOBOT1_ED;
                ALM_HOLD_SET();
            }else{
                RB1_RX_TIME_OUT.detach();//タイムアウトカウンタ停止
            }
        }
    
        RB1_eth_buf_clr();  
    }
    
    
}
void RB1_MOVE_SWAIT(unsigned long tout_ms){//移動開始待ち
    char *cmp1_txt="0,{7},RobotMode()";
    char *cmp2_txt="0,{5},RobotMode()";
    char *cmp3_txt="0,{9},RobotMode()";
    unsigned char MOVE_START_F=0;
    unsigned char MOVE_ERR_F=0;
    if(R1_WAIT_MASK==0){//1でマスク　現在位置への移動指定時WAITをマスクする
        RB1_SEND_CMD("RobotMode()");
        RB1_RX_TIME_OUT_F=0;
        RB1_RX_TIME_OUT.attach_us(&RB1_RX_TIME_OUT_IRQ,tout_ms*1000);
        while(RB1_RX_TIME_OUT_F==0 && MOVE_START_F==0  && MOVE_ERR_F==0){
            if(RB1_RX_DATA()>0){
                if(strstr(RB1_rob_rx_buffer,cmp3_txt) ==NULL){//err状態でないことを確認
                    //移動開始確認///
                    if(strstr(RB1_rob_rx_buffer,cmp1_txt) !=NULL){
                        MOVE_START_F=1;
                    }else{
                        RB1_SEND_CMD("RobotMode()");   
                    }
                }else{
                    MOVE_ERR_F=1;
                    ALM_ST=ALM_DOBOT1;
                    ALM_HOLD_SET();
                }
            }
            wait_us(10*1000); //10ms
        }
        if(RB1_RX_TIME_OUT_F==1){
            //printf("MOVE START TIMEOUT!! TX=%s  Rx=%s\r\n",RB1_rob_tx_buffer,RB1_rob_rx_buffer);
            ALM_ST=ALM_DOBOT1_ST;
            ALM_HOLD_SET();
    
        }else{
            RB1_RX_TIME_OUT.detach();//タイムアウトカウンタ停止
        }
    }
}
void RB1_MOVE_EWAIT(unsigned long tout_ms){

    char *cmp1_txt="0,{7},RobotMode()";
    char *cmp2_txt="0,{5},RobotMode()";
    char *cmp3_txt="0,{9},RobotMode()";
    unsigned char MOVE_END_F=0;
    unsigned char MOVE_ERR_F=0;
    if(R1_WAIT_MASK==0){//1でマスク　現在位置への移動指定時WAITをマスクする
    ///移動完了チェック///
        RB1_SEND_CMD("RobotMode()");     
        RB1_RX_TIME_OUT_F=0;
        RB1_RX_TIME_OUT.attach_us(&RB1_RX_TIME_OUT_IRQ,tout_ms*1000);
        while(RB1_RX_TIME_OUT_F==0 && MOVE_END_F==0  && MOVE_ERR_F==0){
            if(RB1_RX_DATA()>0){
                if(strstr(RB1_rob_rx_buffer,cmp3_txt) ==NULL){//err状態でないことを確認
                    //移動完了確認///
                    if(strstr(RB1_rob_rx_buffer,cmp2_txt) !=NULL){
                        MOVE_END_F=1;
                    }else{
                         RB1_SEND_CMD("RobotMode()");   
                    }
                }else{
                    MOVE_ERR_F=1;
                    ALM_ST=ALM_DOBOT1;
                    ALM_HOLD_SET();
                }
            }
            wait_us(10*1000); //10ms

        }
        if(RB1_RX_TIME_OUT_F==1){
           // printf("MOVE END TIMEOUT!! TX=%s  Rx=%s\r\n",RB1_rob_tx_buffer,RB1_rob_rx_buffer);
            ALM_ST=ALM_DOBOT1_ED;
            ALM_HOLD_SET();
        }else{
            RB1_RX_TIME_OUT.detach();//タイムアウトカウンタ停止
        }
    RB1_eth_buf_clr(); 
    } 
}
void RB1_JOG_WAIT(unsigned long tout_ms){
    char *cmp1_txt="0,{7},RobotMode()";
    char *cmp2_txt="0,{5},RobotMode()";
    char *cmp3_txt="0,{9},RobotMode()";
    unsigned char MOVE_END_F=0;
    unsigned char MOVE_ERR_F=0;
    ///移動完了チェック///
    RB1_SEND_CMD("RobotMode()");    
    RB1_RX_TIME_OUT_F=0;
    RB1_RX_TIME_OUT.attach_us(&RB1_RX_TIME_OUT_IRQ,tout_ms*1000);
    while(RB1_RX_TIME_OUT_F==0 && MOVE_END_F==0 && MOVE_ERR_F==0){
        if(RB1_RX_DATA()>0){
            if(strstr(RB1_rob_rx_buffer,cmp3_txt) ==NULL){//err状態でないことを確認
                //移動完了確認///
                if(strstr(RB1_rob_rx_buffer,cmp2_txt) !=NULL){
                    MOVE_END_F=1;
                }else{
                     RB1_SEND_CMD("RobotMode()");   
                }
            }else{
                MOVE_ERR_F=1;
                ALM_ST=ALM_DOBOT1;
                ALM_HOLD_SET();
            }
        }
        wait_us(10*1000); //10ms
    }
    if(RB1_RX_TIME_OUT_F==1){
        //printf("JOG MOVE END TIMEOUT!! TX=%s  Rx=%s\r\n",RB1_rob_tx_buffer,RB1_rob_rx_buffer);
        ALM_ST=ALM_DOBOT1_ED;
        ALM_HOLD_SET();
    }else{
        RB1_RX_TIME_OUT.detach();//タイムアウトカウンタ停止
    }
    RB1_eth_buf_clr();  
}


void RB1_STATUS_READ(unsigned long tout_ms){
    RB1_SEND_CMD("RobotMode()");
    RB1_RX_TIME_OUT_F=0;       
    RB1_RX_DATA();
    RB1_RX_TIME_OUT_F=0;
    RB1_RX_TIME_OUT.attach_us(&RB1_RX_TIME_OUT_IRQ,tout_ms*1000);

    while(RB1_RX_TIME_OUT_F==0 && strstr(RB1_rob_rx_buffer,RB1_rob_tx_buffer) ==NULL){
        RB1_RX_DATA();
        wait_us(10*1000); //10ms
    }

    if(RB1_RX_TIME_OUT_F==1){
        //printf("CMD ACK TIMEOUT!!\r\n");
        ALM_ST=ALM_DOBOT1;
        ALM_HOLD_SET();
    }else{
        RB1_RX_TIME_OUT.detach();//タイムアウトカウンタ停止
    }

    sprintf(lcd_print_buf,"STATUS=%s",RB1_rob_rx_buffer);
    lcd_print("t0",lcd_print_buf);
    RB1_eth_buf_clr();  
}
////データ受信処理/////////
unsigned long RB1_RX_DATA(){//WIZnet_Socket.hのset_blocking(bool blocking, unsigned int timeout=1500);の設定で空読みしたときのタイムアウト時間がかわる
    int n= RB1_server.receive(RB1_rob_rx_buffer, sizeof(RB1_rob_rx_buffer));
    if(n > 0){//def 0
        //printf("ROBO1_DATA=%s\r\n",RB1_rob_rx_buffer);
        //sprintf(lcd_print_buf,"ROBO1_DATA=%s\r\n",RB1_rob_rx_buffer);
        //lcd_print("t0",lcd_print_buf);
        return n; 
    }else{
        return 0;
    }
}
////データ受信処理テスト/////////
unsigned long RB1_RX_DATA_TEST(){
    int n= RB1_server.receive(RB1_rob_rx_buffer, sizeof(RB1_rob_rx_buffer));
    if(n > 0){//def 0
        //printf("ROBO1_DATA=%s\r\n",RB1_rob_rx_buffer);
        RB1_eth_buf_clr();  
        return n; 
    }else{
        return 0;
    }
}
void RB1_CMD_WAIT(unsigned long tout_ms){

    RB1_RX_DATA();
    RB1_RX_TIME_OUT_F=0;
    RB1_RX_TIME_OUT.attach_us(&RB1_RX_TIME_OUT_IRQ,tout_ms*1000);

    while(RB1_RX_TIME_OUT_F==0 && strstr(RB1_rob_rx_buffer,RB1_rob_tx_buffer) ==NULL){
        RB1_RX_DATA();
        wait_us(10*1000); //10ms
    }

    if(RB1_RX_TIME_OUT_F==1){
        //printf("CMD ACK TIMEOUT!!\r\n");
        ALM_ST=ALM_DOBOT1;
        ALM_HOLD_SET();
    }else{
        RB1_RX_TIME_OUT.detach();//タイムアウトカウンタ停止
    }
    RB1_eth_buf_clr();  
}

char RB1_SEND_CMD(char *txt){
    unsigned char len = strlen(txt);//文字列の長さを確認
    unsigned char SEND_RET=0;
    sprintf(RB1_rob_tx_buffer,"%s\0",txt);
    SEND_RET=RB1_server.send_all(RB1_rob_tx_buffer,len+1);
    if(SEND_RET !=len+1){
        sprintf(lcd_print_buf,"コマンド送信失敗!! 送信指定数 : %02d  送信完了数 : %02d",len+1,SEND_RET);
        lcd_print("t0",RB1_rob_tx_buffer);   
        return -1;
    }else{
        
        return 0;
    }
    
}




void RB1_MovJ(double x,double y,double z,double a,double b,double c,unsigned int speed,unsigned int acc){
   char RB1_BUF[128];
   // printf("MovJ(%f,%f,%f,%f,%f,%f,SpeedJ=%d)",x,y,z,a,b,c,speed);
    if(x==RB1_X_SET && y==RB1_Y_SET && z==RB1_Z_SET && a==RB1_A_SET && b==RB1_B_SET && c==RB1_C_SET){
        lcd_print("t0","現在位置です");
        R1_WAIT_MASK=1;//1でマスク　現在位置への移動指定時WAITをマスクする
    }else{
        sprintf(RB1_BUF,"MovJ(%f,%f,%f,%f,%f,%f,SpeedJ=%d,AccJ=%d)",x,y,z,a,b,c,speed,acc);
        R1_WAIT_MASK=0;//1でマスク　現在位置への移動指定時WAITをマスクする
        if(RB1_SEND_CMD(RB1_BUF)==0){
            RB1_X_SET=x;
            RB1_Y_SET=y;
            RB1_Z_SET=z;
            RB1_A_SET=a;
            RB1_B_SET=b;
            RB1_C_SET=c;
        }else{//コマンド送信失敗
            ALM_ST=ALM_DOBOT1_CM;
            ALM_HOLD_SET();
        }
    }
    
}

void RB1_JointMovJ(double Q1,double Q2,double Q3,double Q4,double Q5,double Q6,unsigned int speed,unsigned int acc){
    char RB1_BUF[128];
    if(Q1==RB1_Q1SET && Q2==RB1_Q2SET && Q3==RB1_Q3SET && Q4==RB1_Q4SET &&Q5==RB1_Q5SET && Q6==RB1_Q6SET){
         lcd_print("t0","現在位置です");
         R1_WAIT_MASK=1;//1でマスク　現在位置への移動指定時WAITをマスクする
    }else{
        sprintf(RB1_rob_tx_buffer,"JointMovJ(%f,%f,%f,%f,%f,%f,SpeedJ=%d,AccJ=%d)",Q1,Q2,Q3,Q4,Q5,Q6,speed,acc);
        R1_WAIT_MASK=0;//1でマスク　現在位置への移動指定時WAITをマスクする
        if(RB1_SEND_CMD(RB1_rob_tx_buffer)==0){
            RB1_Q1SET=Q1;
            RB1_Q2SET=Q2;
            RB1_Q3SET=Q3;
            RB1_Q4SET=Q4;
            RB1_Q5SET=Q5;
            RB1_Q6SET=Q6;
        }else{//コマンド送信失敗
            ALM_ST=ALM_DOBOT1_CM;
            ALM_HOLD_SET();
        }
    }
    
}

void RB1_MovL(double x,double y,double z,double a,double b,double c,unsigned int speed,unsigned int acc){
    char RB1_BUF[128];
    if(x==RB1_X_SET && y==RB1_Y_SET && z==RB1_Z_SET && a==RB1_A_SET && b==RB1_B_SET && c==RB1_C_SET){
        lcd_print("t0","現在位置です");
        R1_WAIT_MASK=1;//1でマスク　現在位置への移動指定時WAITをマスクする
    }else{
        sprintf(RB1_BUF,"MovL(%f,%f,%f,%f,%f,%f,SpeedL=%d,AccL=%d)",x,y,z,a,b,c,speed,acc);
        R1_WAIT_MASK=0;//1でマスク　現在位置への移動指定時WAITをマスクする
        if(RB1_SEND_CMD(RB1_BUF)==0){
            RB1_X_SET=x;
            RB1_Y_SET=y;
            RB1_Z_SET=z;
            RB1_A_SET=a;
            RB1_B_SET=b;
            RB1_C_SET=c;
        }else{//コマンド送信失敗
            ALM_ST=ALM_DOBOT1_CM ;
            ALM_HOLD_SET();
        }
    }
}



void RB1_HOME_MOVE(){
    ///現在位置を確認///
    RB1_GETPOS(RB_EWAIT); 
    ///Zが-40以下の場合は、Zを上げてから原点復帰///
    if(RB1_Z_GET<100){
        RB1_MovJ(RB1_X_GET,RB1_Y_GET,100.0,RB1_R_GET,0,0,RB1_SPEED_ADJ,RB1_ACC_ADJ);
        RB1_MOVE_WAIT(5000);
    }
    
    //RB1_MovJ(230.0,0.0,80.0,0,0,0,RB1_SPEED_ADJ,RB1_ACC_ADJ);
    RB1_MovJ(178.0,124.0,100.0,0,0,0,RB1_SPEED_ADJ,RB1_ACC_ADJ);
    RB1_MOVE_WAIT(10000);
    RB1_MovJ(220.0,0.0,80.0,0,0,0,RB1_SPEED_ADJ,RB1_ACC_ADJ);  
    RB1_MOVE_WAIT(10000);
    
    RB1_PSEL_BAK=0xFE;

    ///ハンドの制御ポートを開側にする///  
    RB1_DO_CONT(1,0);
    RB1_HAND_ST=RB1_HAND_OPEN;
    
}

void RB1_SEL_MOVE(unsigned char SEL,unsigned int speed,unsigned int acc){
    RB1_MovJ(RB1_POINT_RD[SEL][PX],RB1_POINT_RD[SEL][PY],RB1_POINT_RD[SEL][PZ],RB1_POINT_RD[SEL][PR],0,0,speed,acc);
}




void RB1_SEL_MOVE_OLG(unsigned char SEL,unsigned int speed,unsigned int acc){//現在値と差分があるときだけ移動
    unsigned char POS_CHK_F=0;
    
    RB1_GETPOS(RB_EWAIT);
    ////現在位置と指定座標に差分があるか確認///
   if(RB1_X_GET > RB1_POINT_RD[SEL][PX]+0.1 || RB1_X_GET < RB1_POINT_RD[SEL][PX]-0.1){
        POS_CHK_F=1;
    }
    if(RB1_Y_GET > RB1_POINT_RD[SEL][PY]+0.1 || RB1_Y_GET < RB1_POINT_RD[SEL][PY]-0.1){
        POS_CHK_F=1;
    }
    if(RB1_Z_GET > RB1_POINT_RD[SEL][PZ]+0.1 || RB1_Z_GET < RB1_POINT_RD[SEL][PZ]-0.1){
        POS_CHK_F=1;
    }
    if(RB1_R_GET > RB1_POINT_RD[SEL][PR]+0.1 || RB1_R_GET < RB1_POINT_RD[SEL][PR]-0.1){
        POS_CHK_F=1;
    }
    
    if(POS_CHK_F==1){
        RB1_MovJ(RB1_POINT_RD[SEL][PX],RB1_POINT_RD[SEL][PY],RB1_POINT_RD[SEL][PZ],RB1_POINT_RD[SEL][PR],0,0,speed,acc);
    }else{
        lcd_print("t0","現在位置です。");
    }
    
    
}
void RB1_SEL_MOVE_SQ(unsigned char SEL,unsigned char MOV_MOD,unsigned int speed,unsigned int acc){

    if(SEL !=RB1_PSEL_BAK){
        RB1_PSEL_BAK=SEL;
        if(MOV_MOD==0){
            RB1_MovL(RB1_POINT_RD[SEL][PX],RB1_POINT_RD[SEL][PY],RB1_POINT_RD[SEL][PZ],RB1_POINT_RD[SEL][PR],0,0,speed,acc);
        }else{
            RB1_MovJ(RB1_POINT_RD[SEL][PX],RB1_POINT_RD[SEL][PY],RB1_POINT_RD[SEL][PZ],RB1_POINT_RD[SEL][PR],0,0,speed,acc);
        }
        R1_WAIT_MASK=0;//1でマスク　現在位置への移動指定時WAITをマスクする
       
    }else{
        lcd_print("t0","現在位置です。");
        R1_WAIT_MASK=1;//1でマスク　現在位置への移動指定時WAITをマスクする
    }
    
    
}
void RB1_DO_CONT(unsigned char INDEX,unsigned char STATUS){//例:DO(11,1) でDO11がON DO(11,0) でDO11がOFF
        char RB1_BUF[64];
        sprintf(RB1_BUF,"DO(%d,%d)",INDEX, STATUS);       
        RB1_SEND_CMD(RB1_BUF);    
        RB1_CMD_WAIT(RB_SWAIT);
 }
 

void RB1_HAND_CONT(unsigned char cont){
    if(cont !=  RB1_HAND_ST){
        if(cont==RB1_HAND_CLOSE){
            RB1_DO_CONT(1,1);
        }else{
            RB1_DO_CONT(1,0);
        }
     RB1_HAND_ST=cont;
    }        
}

////現在位置からx1,y1,z1を経由してx2,y2,z2まで移動（円運動）////
void RB1_ARC(double x1,double y1,double z1,double x2,double y2,double z2,unsigned int speed,unsigned int acc){
    char RB1_BUF[128];

        sprintf(RB1_BUF,"Arc(%f,%f,%f,%f,%f,%f,SpeedL=%d,AccL=%d)",x1,y1,z1,x2,y2,z2,speed,acc);
        if(RB1_SEND_CMD(RB1_BUF)==0){
            RB1_X_SET=x2;
            RB1_Y_SET=y2;
            RB1_Z_SET=z2; 
        }else{//コマンド送信失敗
            ALM_ST=ALM_DOBOT1_CM;
            ALM_HOLD_SET();
        }

}
void RB1_EMG_STOP(){ 
        RB1_SEND_CMD("EmergencyStop()");    
 }
 
void RB1_SPEED_SET(unsigned char SET){
    if(SET==RB_HIGH){
        RB1_SPEED_ADJ = RB_SPEED_HIGH;
        RB1_ACC_ADJ = RB_ACC_HIGH; 
    }else{
        RB1_SPEED_ADJ = RB_SPEED_LOW;
        RB1_ACC_ADJ = RB_ACC_LOW;     
    }   
}
