#include "mbed.h"
#include "main.h"
#include "nextion_lcd.h"
#include "APP.h"
#include "WORK_START.h"
///////////////////////
#include "ROBO1_CONT.h"
#include "ROBO2_CONT.h"
#include "ROBO_TWIN_CONT.h"
#include "SAVE_CONT.h"
///////////////////////
#include "PS3_BT_CTL.h"

void ROBO2_KEY_PAGE(void){
    if(touch_id!=0) { //作業中は、一時停止受付るため、マスクしない
        tp_mask=1;//1=タッチパネルマスク
    }
    switch (touch_id) {
        ////caseはnextion lcdのSWに割り当てられたidを記載する///
        case BT12_BACK     : 
                            
                            lcd_page_set(P_ROBO2_ADJ,100);
                            ROBO2_ADJ_DISP();
                            RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）
                            
                            sprintf(lcd_print_buf,"%03d",RB2_SPEED_ADJ);
                            lcd_print("t9",lcd_print_buf);
                            lcd_progressbar("j0",RB2_SPEED_ADJ,50);//プログレスバー表示が50になる wait 50ms     
                            nx_val_set("cb0",RB2_PSEL);//選択表示
                            touch_id=0;
                            break;
    }
    if(LOT_EDIT_F==1){
        LOT_EDIT_F=0;
        EDIT_DATA=atof(lot_edit_set);
        RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）  
        RB2_SEND_CMD("EnableRobot()");
        RB2_CMD_WAIT(RB_SWAIT);
        if(EDIT_SEL==PX){
            sprintf(lcd_print_buf,"X:%f",EDIT_DATA);
            lcd_print("t0",lcd_print_buf);    
            RB2_MovJ(EDIT_DATA,RB2_Y_GET,RB2_Z_GET,RB2_R_GET,0,0,RB2_SPEED_ADJ,RB2_ACC_ADJ);
            RB2_MOVE_WAIT(RB_EWAIT);
        }
        if(EDIT_SEL==PY){
            sprintf(lcd_print_buf,"Y:%f",EDIT_DATA);
            lcd_print("t0",lcd_print_buf);    
            RB2_MovJ(RB2_X_GET,EDIT_DATA,RB2_Z_GET,RB2_R_GET,0,0,RB2_SPEED_ADJ,RB2_ACC_ADJ);
            RB2_MOVE_WAIT(RB_EWAIT);
        }
        if(EDIT_SEL==PZ){
            sprintf(lcd_print_buf,"Z:%f",EDIT_DATA);
            lcd_print("t0",lcd_print_buf);    
            RB2_MovJ(RB2_X_GET,RB2_Y_GET,EDIT_DATA,RB2_R_GET,0,0,RB2_SPEED_ADJ,RB2_ACC_ADJ);
            RB2_MOVE_WAIT(RB_EWAIT);
        }
        if(EDIT_SEL==PR){
            sprintf(lcd_print_buf,"R:%f",EDIT_DATA);
            lcd_print("t0",lcd_print_buf);  
            RB2_MovJ(RB2_X_GET,RB2_Y_GET,RB2_Z_GET,EDIT_DATA,0,0,RB2_SPEED_ADJ,RB2_ACC_ADJ);
            RB2_MOVE_WAIT(RB_EWAIT);
        }            
        
    }
    if(touch_id==0 && tp_mask==1) {
        tp_mask=0;//1=タッチパネルマスク
    }
     //RB2_RX_DATA();
}