
extern unsigned char page;//lcd画面ページ
extern unsigned char page_bak;//lcd画面ページ(一個前のページ）
extern char lcd_print_buf[64];
extern unsigned char touch_id;
extern unsigned char touch_t;//ボタンのトグル状態　1=on 0=off(タッチパネル設定でボタンを離した時にもデータ送信設定した場合の識別）
extern unsigned char lcd_page;
extern unsigned char PAUSE_F;//一時停止;
extern char lot_edit_set[32];
extern unsigned char LOT_EDIT_F;//1=ロット編集あり

void buf_clr(void);
void nextion_lcd_ini(void);
void lcd_sw_get(void);
void home_sw_clr(void);
void start_sw_clr(void);
void lcd_print(char *obj,char *txt);//（例：lcd_print("t0","test");//objname t0にtestと表示される
void lcd_print_cb(char *obj,char *txt);//コムボックス表示用 \r\nで終端すると次のボックスに書き込める
void lcd_progressbar(char *obj,unsigned char val,unsigned char wait_set);//(例:lcd_progressbar("j0",50,50);//プログレスバー表示が50になる wait 50ms
void lcd_page_set(unsigned char  page_set,unsigned char wait_set);//(例:lcd_page_set(1,50);//ページ1に切り替わる wait 50ms
void lcd_pic_chg(char *obj,unsigned char val,unsigned char wait_set);//(例:lcd_pic_chg("p0",3,50);//p0の画像指定が3に代わる（画像切り替えができる）wait 50ms


unsigned char nx_val_get_cbox(char no);//チェックボックスの状態を取得
unsigned char nx_val_get(char *obj);
unsigned char nx_get(char *obj);
void nx_val_set(char *obj,char cont);//ボンタン等の状態をセットする。
void lot_edit_chk(void);
void lcd_text_color_chg(char *obj,unsigned long color,char wait_set);//(例:lcd_text_color_chg("b0",63488,50);ボタン0のテキストが赤に変わる(緑は2016)
void lcd_bc_color_chg(char *obj,unsigned long color,char wait_set);//(例:lcd_bc_color_chg("b0",63488,50);ボタン0の背景色が赤に変わる(緑は2016)
void lcd_page_chk();//(例:lcd_page_chk(); lcdのページ番号を要求
void lcd_bt_en(char *obj,unsigned char val,unsigned char w_ait_set);
void lcd_audio_play(unsigned char id,unsigned char loop,unsigned char wait_set);//(例:lcd_audio_play(0,0,50);//0番のaudioをループ無し再生、コマンドwait 50ms
void lcd_audio_cont(unsigned char val,unsigned char wait_set);//val=0 再生停止 1 resume 2 puse
void lcd_audio_vol(unsigned char val,unsigned char wait_set);//val=0から100
unsigned char nx_page_get();//現在の画面ページNoを取得
void nx_dsbt_st_set(char *obj,unsigned char val,unsigned char wait_set);//例:nx_dsbt_st_set("bt0",0,50);dualステートボタンを強制OFF(50ms　wait)
void lcd_backlight(unsigned char val);//例 lcd_backlight(50); //明るさがセンターになる。

///LCD AUDIO////
//#define AU_TANSI_STB    7


///////////////////////////
#define AU_BOOT         0//起動完了しました。    
#define AU_HOME         1//原点に戻ります。
#define AU_STBOK        2//準備が完了しました。
#define AU_ALM　　      3//異常が発生しました。
#define AU_PINCON       4//ピンコン
#define AU_HOME_ERR     5//原点復帰してください。
#define AU_PAUSE        6//一時停止しました。
#define AU_WORK_START   7//自動運転を開始します。
#define AU_RESTART      8//自動運転が再開します。
#define AU_ERR          9//ピピピ
#define AU_WORK_NG      10//ワークが異常です。
#define AU_WDBAR_CHG    11//溶接棒を交換してください。
#define AU_EMG_STP      12//非常停止しました。
#define AU_WORKPOS_NG   13//ワーク位置が異常です。
#define AU_WEND         14//作業が終了しました。
#define AU_ROBO_ALM     15//ロボットトラブル発生
#define AU_AREA_ALM     16//危険です、安全な場所に離れてください
///タッチボタンID/////
/*LCDの開発ツールNEXTION EDITORにて割り当てられたボタンのID番号を紐づける*/

#define LCD_RED 63488
#define LCD_GREEN 2016
#define LCD_BRACK 0
#define LCD_WHITE 65535
#define LCD_GRAY 50712
#define LCD_YELLOW 65504


//////////////LCDページ指定/////////////////////////////
#define P_MAIN       1
#define P_PAUSE      2
#define P_BARCHG     3
#define P_CHGSET     4
#define P_PULLTEST   5
#define P_WD_JUDGE   6
#define P_TANSI_MNT  7
#define P_NI_ADJ     8


#define P_ROBO1_ADJ  9
#define P_ROBO2_ADJ  10
#define P_ROBO1_KEY  11
#define P_ROBO2_KEY  12
#define P_ROBO_ALM   13
#define P_EMG_STOP   14
#define P_AREA_ALM   15
#define P_TIME       16
#define P_JIKUTEST   17
//////////////////////PAGE1////////////////////////////
#define BT1_START       85
#define BT1_RE_START    69
#define BT1_PAUSE       48
#define BT1_HOME        46
////////生産数Aパーツカウント/////
#define BT1_PDA_3_P     38
#define BT1_PDA_3_M     39
#define BT1_PDA_2_P     66
#define BT1_PDA_2_M     40
#define BT1_PDA_1_P     41
#define BT1_PDA_1_M     67
#define BT1_PDA_CL      58

#define BT1_NI1_OUT     79
#define BT1_NI1_CUT     80
#define BT1_RB1ADJ      35
////////生産数Cパーツカウント/////
#define BT1_PDC_3_P     60
#define BT1_PDC_3_M     51
#define BT1_PDC_2_P     52
#define BT1_PDC_2_M     53
#define BT1_PDC_1_P     65
#define BT1_PDC_1_M     56
#define BT1_PDC_CL      57

#define BT1_NI2_OUT     36
#define BT1_NI2_CUT     37
#define BT1_RB2ADJ      78

#define BT1_WCHG1_CLR   76 //曲棒交換回数クリア4Φ
#define BT1_WCHG2H_CLR  61//曲棒交換回数クリア3Φ平
#define BT1_WCHG2R_CLR  68//曲棒交換回数クリア3Φ丸

#define BT1_CHG_SET    47
#define BT1_BAR_CHG    59//曲棒交換画面
#define BT1_PULL_TST   62//引っ張り試験
#define BT1_JUG_DISP   63//溶接結果表示

#define BT1_TEST_MODE  64   //テストモード
#define BT1_STEP_MODE  77   //ステップ動作ON/OFF//
#define BT1_NI_ADJ     84
#define BT1_MUTE       89   //消音
#define BT1_RB_SPEED   90   //ロボット速度
#define BT1_TIME       34//時計合わせ

//////////////page 2（一時停止)//////////////////////////////
#define BT2_RESTART    3     //作業再開
#define BT2_END        4     //中断
//////////////page 3（極棒交換)//////////////////////////////
#define BT3_PU1_WAIT   4    //加圧1軸待機位置
#define BT3_PU1_RT     5    //加圧軸1回転位置
#define BT3_PU1_PU     6   //加圧軸1加圧位置

#define BT3_WD1_ST     7   //ヘッド1溶接開始
#define BT3_WD1_RT     19  //ヘッド1極棒回転
#define BT3_CT1_HESC   12 //端子供給機0ハンド退避

#define BT3_PU2_WAIT   9   //加圧2軸待機位置
#define BT3_PU2_RT     1    //加圧軸2回転位置
#define BT3_PU2_PU     10    //加圧軸2加圧位置

#define BT3_WD2_ST     11    //ヘッド2溶接開始
#define BT3_WD2_RT     2    //ヘッド2極棒回転
#define BT3_CT2_HESC   13//端子供給機1ハンド退避


#define BT3_SET        15   //交換完了

//////////////page 4（極棒交換回数設定)//////////////////////////////
#define BT4_WD2H_K4_P    3     //4桁目プラス
#define BT4_WD2H_K4_M    7     //4桁目マイナス
#define BT4_WD2H_K3_P    8     //3桁目プラス
#define BT4_WD2H_K3_M    9     //3桁目マイナス
#define BT4_WD2H_K2_P   10     //2桁目プラス
#define BT4_WD2H_K2_M   11     //2桁目マイナス
#define BT4_WD2H_K1_P   12     //1桁目プラス
#define BT4_WD2H_K1_M   13     //1桁目マイナス
#define BT4_SET_SAVE    14     //設定保存

#define BT4_WD2R_K4_P   16      //4桁目プラス
#define BT4_WD2R_K4_M   20     //4桁目マイナス
#define BT4_WD2R_K3_P   21     //3桁目プラス
#define BT4_WD2R_K3_M   22     //3桁目マイナス
#define BT4_WD2R_K2_P   23     //2桁目プラス
#define BT4_WD2R_K2_M   24     //2桁目マイナス
#define BT4_WD2R_K1_P   25     //1桁目プラス
#define BT4_WD2R_K1_M   26     //1桁目マイナス


#define BT4_WD1H_K4_P   30    //4桁目プラス
#define BT4_WD1H_K4_M   34     //4桁目マイナス
#define BT4_WD1H_K3_P   35     //3桁目プラス
#define BT4_WD1H_K3_M   36     //3桁目マイナス
#define BT4_WD1H_K2_P   37     //2桁目プラス
#define BT4_WD1H_K2_M   38     //2桁目マイナス
#define BT4_WD1H_K1_P   39     //1桁目プラス
#define BT4_WD1H_K1_M   40     //1桁目マイナス

///////////////page5 引っ張り試験////////////
#define BT5_L_STB        1//右側準備
#define BT5_L_WD         2//右側溶接
#define BT5_R_STB        3//左側準備
#define BT5_R_WD         4//左側溶接
#define BT5_BACK         12 //戻る
///////////////page10 溶接NG箇所確認////////////
#define BT6_CHK_OK       26//溶接NG箇所確認

//////////////page 7（端子供給機設定)//////////////////////////////
#define BT7_CT1_HAND        17
#define BT7_CT1_WDPOS       18
#define BT7_CT1_CUT         19

#define BT7_CT1_50STB       6
#define BT7_CT1_32_1STB     7
#define BT7_CT1_32_2STB     1

#define BT7_CT1_MOV         8
#define BT7_CT1_WDP1        9
#define BT7_CT1_WDP2        2

#define BT7_CT1_TEST        23 
#define BT7_CT1_TCUT        25

#define BT7_CT1_50_ADJ      29
#define BT7_CT1_32_ADJ      30
#define BT7_CT1_23_ADJ      31

#define BT7_CT2_HAND        20
#define BT7_CT2_WDPOS       21
#define BT7_CT2_CUT         22

#define BT7_CT2_50STB       11
#define BT7_CT2_32STB       12
#define BT7_CT2_23STB       3

#define BT7_CT2_MOV         13
#define BT7_CT2_WDP1        14
#define BT7_CT2_WDP2        4

#define BT7_CT2_TEST        24 
#define BT7_CT2_TCUT        26

#define BT7_CT2_50_ADJ      32
#define BT7_CT2_32_ADJ      33
#define BT7_CT2_23_ADJ      34

#define BT7_BACK            16  //戻る

//////////////page 8（ニッケル端子調整）//////////////////////////////
#define BT8_K3_P    2     //3桁目プラス
#define BT8_K3_M    5     //3桁目マイナス
#define BT8_K2_P    6     //2桁目プラス
#define BT8_K2_M    7     //2桁目マイナス
#define BT8_K1_P    8     //1桁目プラス
#define BT8_K1_M    9     //1桁目マイナス

#define BT8_SET    13     //設定（保存して戻る）

////////////////////PAGE9 ROBO1 ADJ////////////////////////////
#define BT9_PSEL        4
#define BT9_X_M         5
#define BT9_X_P         6
#define BT9_Y_M         7
#define BT9_Y_P         8
#define BT9_Z_M         9
#define BT9_Z_P         10
#define BT9_R_M         1
#define BT9_R_P         11
#define BT9_SPD_M       19
#define BT9_SPD_P       20

#define BT9_PSAVE       22
#define BT9_MOVE        23

#define BT9_LWD_PU      26
#define BT9_LWD_WT      27

#define BT9_RWD_PU      2
#define BT9_RWD_WT      28

#define BT9_R_HAND      29//ロボットハンド制御
#define BT9_WORK_WT     30//ワークトランスポート
#define BT9_WORK_EJ     39//ワーク排出位置
#define BT9_WORK_ST     40//ワーク作業開始位置（ピックアップ位置）

#define BT9_R0          32
#define BT9_RM90        36
#define BT9_RP90        37
#define BT9_RM180       33
#define BT9_RP180       34


#define BT9_ROSGET      35


#define BT9_X_KEY       12
#define BT9_Y_KEY       13
#define BT9_Z_KEY       14
#define BT9_R_KEY       15

#define BT9_BACK        21

//////////////////////PAGE4 ROBO2 ADJ////////////////////////////
#define BT10_PSEL        4
#define BT10_X_M         5
#define BT10_X_P         6
#define BT10_Y_M         7
#define BT10_Y_P         8
#define BT10_Z_M         9
#define BT10_Z_P         10
#define BT10_R_M         1
#define BT10_R_P         11
#define BT10_SPD_M       19
#define BT10_SPD_P       20

#define BT10_PSAVE       22
#define BT10_MOVE        23

#define BT10_LWD_PU      26
#define BT10_LWD_WT      27

#define BT10_RWD_PU      2
#define BT10_RWD_WT      28

#define BT10_R_HAND      29//ロボットハンド制御
#define BT10_WORK_WT     30//ワークトランスポート
#define BT10_WORK_EJ     39//ワーク排出位置
#define BT10_WORK_ST     40//ワーク作業開始位置（ピックアップ位置）

#define BT10_R0          32
#define BT10_RM90        36
#define BT10_RP90        37
#define BT10_RM180       33
#define BT10_RP180       34

#define BT10_ROSGET      35

#define BT10_X_KEY       12
#define BT10_Y_KEY       13
#define BT10_Z_KEY       14
#define BT10_R_KEY       15

#define BT10_BACK        21
/////////////////////PAGE11 ROBO1 KEYBOARD/////////////////
#define BT11_BACK        22        
/////////////////////PAGE12 ROBO2 KEYBOARD/////////////////
#define BT12_BACK        22        

//////////////////////PAGE13 ROBO ALM////////////////////////////
#define BT13_BACK        2

///////////////page14 エリアセンサ異常////////////

#define BT14_RESTART    1

/////////////page 15 時計/////////////////
#define BT15_SET         19//戻る

/////////////page 17各軸テスト/////////////////
#define BT17_PU1_HOME   2
#define BT17_PU1_WAIT   3
#define BT17_PU1_PU     4
#define BT17_PU1_RT     5

#define BT17_PU2_HOME   8
#define BT17_PU2_WAIT   9
#define BT17_PU2_PU     10
#define BT17_PU2_RT     11

#define BT17_NI1_HOME   13
#define BT17_NI1_POS0   14
#define BT17_NI1_POS1   15
#define BT17_NI1_POS2   16
#define BT17_NI1_POS3   17
#define BT17_NI1_POS4   18

#define BT17_NI2_HOME   20
#define BT17_NI2_POS0   21
#define BT17_NI2_POS1   22
#define BT17_NI2_POS2   23
#define BT17_NI2_POS3   24
#define BT17_NI2_POS4   25


#define BT17_DI_HOME    27
#define BT17_DI_HP      28
#define BT17_DI_WAIT    29
#define BT17_DI_EJECT   30
#define BT17_DI_START   31

#define BT17_BACK       32

