#include "mbed.h"
#include "main.h"
#include "nextion_lcd.h"
#include "APP.h"
#include "FATFileSystem.h"
#include "SAVE_CONT.h"
#include "WD_CONT.h"
// File system declaration
extern FATFileSystem   fileSystem;

FILE* fd;
double RB1_POINT_RD[32][4];
char RB1_point_wr_data[256];
char RB1_point_rd_data[4096];
char RB1_point_txt[32][64];
unsigned char RB1_POINT_NO_CNT=0;

double RB2_POINT_RD[32][4];
char RB2_point_wr_data[256];
char RB2_point_rd_data[4096];
char RB2_point_txt[32][64];
unsigned char RB2_POINT_NO_CNT=0;

unsigned long wr_size=0;
unsigned long rd_size=0;

//////
char config_dat[64];
char config_save_dat[64];

///ニッケル端子///
unsigned long C1_RD_50MM =0;
unsigned long C1_RD_32MM =0;
unsigned long C1_RD_23MM =0;

unsigned long  C1_WR_50MM =0;
unsigned long  C1_WR_32MM =0;
unsigned long  C1_WR_23MM =0;

double  C1_SET_50MM =0;
double  C1_SET_32MM =0;
double  C1_SET_23MM =0;

unsigned long C2_RD_50MM =0;
unsigned long C2_RD_32MM =0;
unsigned long C2_RD_23MM =0;

unsigned long  C2_WR_50MM =0;
unsigned long  C2_WR_32MM =0;
unsigned long  C2_WR_23MM =0;

double  C2_SET_50MM =0;
double  C2_SET_32MM =0;
double  C2_SET_23MM =0;

unsigned long RB1_p_cnt=0;
unsigned long RB2_p_cnt=0;

char file_name[32];
unsigned char date_chk=0;    
//ファイルサイズを取得////
long GetFileSize(const char *file)
{
   long size=0;
    FILE*   f = fopen(file, "r+");
    if(!f){
        printf("seize get ng\r\n");
        return -1L;
    }else{
        fseek(f, 0, SEEK_END); // seek to end of file
        size = ftell(f);       // get current file pointer
        fseek(f, 0, SEEK_SET); // seek back to beginning of file  
        fclose(f);
        //sprintf(pc_print_buf,"size=%d\r\n",size);
        //pc_printf(pc_print_buf);
        return  size;
    }
}

uint32_t utf_sjis_cnv(uint32_t utf_code){
    unsigned long sjis_add=0;
    unsigned short  sjis_code=0;
    unsigned char rdat[2];
    fd = fopen("/fs/system/utf_sjis.bin", "r");//r:読み込みようとしてファイルを開きます
    if (fd) {
        if(utf_code>=0 && utf_code<=0xF19F){
            sjis_add=utf_code*2;        
            fseek(fd, sjis_add, SEEK_SET);
            fread(rdat, 1,2,fd);
            sjis_code=rdat[0]<<8;
            sjis_code|=rdat[1];
        }else{
            sjis_add=(utf_code-0xE28000)*2+0x20000;     
            fseek(fd, sjis_add, SEEK_SET);
            fread(rdat, 1,2,fd);
            sjis_code=rdat[0]<<8;
            sjis_code|=rdat[1];         
        }
        fclose(fd); 
    }
    //pc.printf("sjis code:%x\r\n",sjis_code);
    return sjis_code;
}


//utfコードに対するsjisコードを返す(文章）
void  utf_to_sjis(char *utf_str ,char *sjis_str){
 
  const char* p = utf_str;
  uint8_t ch0,ch1,ch2;
  uint16_t draw_cnt=0;
  uint16_t draw_cnt_max=strlen(utf_str);
  char sjis_buf[3];
  uint32_t utf_code=0;
  uint16_t buf_cnt=0;
  sjis_buf[0]=0;
  sjis_buf[1]=0;
  sjis_buf[2]=0;
 // pc_printf(utf_str);
 // pc_printf("draw_cnt_max=%d\r\n",draw_cnt_max);
    while(draw_cnt<draw_cnt_max){
        utf_code=0;
        sjis_buf[0]=sjis_buf[1]=sjis_buf[2]=0;
        ch0 = (uint8_t)*p++;
        if(ch0 != 0){ 
            if(ch0 <=0x7E ){
                sjis_str[buf_cnt++]=ch0;
            }else{
                ch1 = (uint8_t)*p++;
                ch2 = (uint8_t)*p++;
                if(ch2>0x7F && ch2 < 0xE2){
                    utf_code = ch0<<16;
                    utf_code |= ch1<<8;
                    utf_code |= ch2;
                    sjis_str[buf_cnt++]=utf_sjis_cnv(utf_code)>>8;
                    sjis_str[buf_cnt++]=utf_sjis_cnv(utf_code);
                }else{
                    (uint8_t)*p--;
                    utf_code = ch0<<8;
                    utf_code |= ch1;
                    sjis_str[buf_cnt++]=utf_sjis_cnv(utf_code)>>8;
                    sjis_str[buf_cnt++]=utf_sjis_cnv(utf_code);
                }
            }
        }else{
          break;
        }
    }
     sjis_str[buf_cnt]=NULL;//null終端
    /*for(unsigned char chk=0 ; chk<buf_cnt ; chk++){
        pc_printf("sjis[%d]=%x\r\n",chk,sjis_str[chk]);   
    }*/
    sjis_str[buf_cnt]=NULL;

}

///ログ記録用csvファイルの先頭に見出しを付ける
void ALM_SAVE_HEAD(void){

    char head_data[256];
    char *Text_Out = "年,月,日,時間,分,秒,ALM要因";
    char head_size=0;
    utf_to_sjis(Text_Out ,head_data);
    head_size=strlen(head_data);//s-jis文字列の長さを調べる
    head_data[head_size]=0x0d;//CR
    head_data[head_size+1]=0x0a;//LF

   ///単セル:日毎のファイル///
    fd = fopen(file_name, "a+");//a+:読み込み/書き込みモードの両方のモードで開きます(ファイルが存在する場合は追加、ない場合は作成します)
    if(!fd){
        printf("savefile open ng!!\r\n");
        ALM_ST= ALM_SD;
        ALM_HOLD_SET();
   }else{
        fwrite(&head_data, 1, head_size+2, fd);
        fclose(fd);
    }
    
}
void ALM_INFO_SAVE(){
    char ALM_INFO_DATA[256];
    char save_data[256];
    char *Text_Out = "";
    unsigned char len=0;//文字の長さを格納
    RTC_GET();
    if(date_chk !=rtc_date){//日付が変わったか確認する。
        date_chk =rtc_date;
        sprintf(file_name,"/fs/ALM_LOG/%04d%02d.csv",rtc_year,rtc_month);
        fd = fopen(file_name, "r");//r:読み込みようとしてファイルを開きます
        if(!fd){//ファイルが開けない場合は新規にヘッダをつけてファイル生成        
            ALM_SAVE_HEAD();
        } 
    }
   
    switch (ALM_ST) {
    
    case ALM_PS1_HM :
                        Text_Out="加圧軸１_原点復帰タイムアウト";　
                        break; 
    case ALM_PS1_ST :
                        Text_Out="加圧軸１_移動開始タイムアウト";　
                        break;
    case ALM_PS1_ED :
                        Text_Out="加圧軸１_移動完了タイムアウト";
                        break; 
    case ALM_PS2_HM :
                        Text_Out="加圧軸２_原点復帰タイムアウト";　
                        break;
    case ALM_PS2_ST :
                        Text_Out="加圧軸２_移動開始タイムアウト";　
                        break; 
    case ALM_PS2_ED  :
                        Text_Out="加圧軸２_移動完了タイムアウト";
                        break;
    case ALM_NISP1_HM:
                        Text_Out="ニッケル搬送軸１_原点復帰タイムアウト";　
                        break; 
    case ALM_NISP1_ST:
                        Text_Out="ニッケル搬送軸１_移動開始タイムアウト";　
                        break;   
    case ALM_NISP1_ED:
                        Text_Out="ニッケル搬送軸１_移動完了タイムアウト";
                        break; 
    case ALM_NISP2_HM:
                        Text_Out="ニッケル搬送軸２_原点復帰タイムアウト";　
                        break;
    case ALM_NISP2_ST:
                        Text_Out="ニッケル搬送軸２_移動開始タイムアウト";　
                        break; 
    case ALM_NISP2_ED:
                        Text_Out="ニッケル搬送軸２_移動完了タイムアウト";
                        break;
    case ALM_DISP_HM :
                        Text_Out="ダイオード搬送軸_原点復帰タイムアウト";　
                        break; 
    case ALM_DISP_ST :
                        Text_Out="ダイオード搬送軸_移動開始タイムアウト";　
                        break;
    case ALM_DISP_ED :
                        Text_Out="ダイオード搬送軸_移動完了タイムアウト";
                        break; 
    case ALM_DOBOT1 :
                        Text_Out="ロボット１_ステータス異常検出";　
                        break; 
    case ALM_DOBOT1_ST:
                        Text_Out="ロボット１_移動開始タイムアウト";　
                        break;
    case ALM_DOBOT1_ED:
                        Text_Out="ロボット１_移動完了タイムアウト";
                        break; 
    case ALM_DOBOT1_CM:
                        Text_Out="ロボット１_コマンド送信失敗";
                        break;
    case ALM_DOBOT2 :
                        Text_Out="ロボット２_ステータス異常検出";　
                        break; 
    case ALM_DOBOT2_ST:
                        Text_Out="ロボット２_移動開始タイムアウト";　
                        break;
    case ALM_DOBOT2_ED:
                        Text_Out="ロボット２_移動完了タイムアウト";
                        break; 
    case ALM_DOBOT2_CM:
                        Text_Out="ロボット２_コマンド送信失敗";
                        break;
    case ALM_DOBOT12:
                        Text_Out="ロボット１、２_ステータス異常検出";//同時検出の場合
                        break;   
    case ALM_DOBOT12_ST:
                        Text_Out="ロボット１、２_移動開始タイムアウト";//同時検出の場合
                        break; 
    case ALM_DOBOT12_ED:
                        Text_Out="ロボット１、２_移動完了タイムアウト";//同時検出の場合
                        break;
    case ALM_WDENG_1:
                        Text_Out="溶接機１エンド信号受信タイムアウト";　
                        break; 
    case ALM_WDENG_2 :
                        Text_Out="溶接機２エンド信号受信タイムアウト";　
                        break;
    case ALM_WDENG_12  :
                        Text_Out="溶接機１、２エンド信号受信タイムアウト";//同時検出の場合　
                        break; 
    case ALM_SD :
                        Text_Out="ＳＤカードアクセス異常";///保存できないと思うが．．　
                        break;


    }
  ///UTF8の日本語をS-JISに変換する/////
    utf_to_sjis(Text_Out ,ALM_INFO_DATA);
    sprintf(save_data,"%04d,%02d,%02d,%02d,%02d,%02d,%s\r\n",rtc_year,rtc_month,rtc_date,rtc_hour,rtc_min,rtc_sec,ALM_INFO_DATA);
    len=strlen(save_data);//文字列の長さを確認  

    
   fd = fopen(file_name, "r+");//r+:既存ファイルを対象に、読み込み/書き込みの両方のモードで開きます
   if(!fd){
        printf("savefile open ng!!\r\n");
        ALM_ST= ALM_SD;
        ALM_HOLD_SET();
   }else{
        fseek(fd, 0, SEEK_END);
        fwrite(&save_data, 1, len, fd);   
        fclose(fd);
        
    }       
  
    /////画面表示///////////////////
    lcd_print("t0",Text_Out);
      /////生産数表示////////////////////
    sprintf(lcd_print_buf,"%03d",PD_CNT_A);
    lcd_print("t2",lcd_print_buf);
    sprintf(lcd_print_buf,"%03d",PD_CNT_C);
    lcd_print("t3",lcd_print_buf);
    
     /////////////極棒交換打点数表示///////////
    sprintf(lcd_print_buf,"%04d",WD1H_CHG_CNT);//左4mm
    lcd_print("t4",lcd_print_buf);
    sprintf(lcd_print_buf,"%04d",WD2H_CHG_CNT);
    lcd_print("t5",lcd_print_buf);
    sprintf(lcd_print_buf,"%04d",WD2R_CHG_CNT);
    lcd_print("t6",lcd_print_buf);
    
    ////////音声鳴動///
    if(ALM_ST>=ALM_DOBOT1 && ALM_ST<=ALM_DOBOT12_ED){
         //ロボットトラブル発生音声
        lcd_audio_play(AU_ROBO_ALM,0,80);     
    }else{
        ///その他 異常が発生しました音声///
        lcd_audio_play(AU_ALM,0,80); 
        ///ロボット異常以外で停止の場合、ロボット強制停止///
       // RB1_EMG_STOP();
       // RB2_EMG_STOP();
    }
              
        
}

void RB1_LIST_READ(){
    char r_buf[128];
    unsigned long dat_cnt=0;
    unsigned long cb_txt_cnt=0;
    unsigned char cp_cnt=0;
    unsigned char HEAD_SKIP=1;
    unsigned long OPEN_SIZE=GetFileSize("/fs/system/RB1_PLIST.csv");
    RB1_POINT_NO_CNT=0;
    
    //printf("open size=%d\r\n",OPEN_SIZE);
    fd = fopen("/fs/system/RB1_PLIST.csv","r");//r:既存ファイルを対象に、読み込みモードで開きます
    if(!fd){
        ALM_ST= ALM_SD;
        ALM_HOLD_SET();
    }else{ 
        fread(RB1_point_rd_data, 1,OPEN_SIZE,fd);  
        dat_cnt++; 
        ////最初のポイントNo部を飛ばす/////
        while(dat_cnt<OPEN_SIZE){//
            while(dat_cnt<OPEN_SIZE && RB1_point_rd_data[dat_cnt]!=0x2c){
                  dat_cnt++;
            }
            dat_cnt++;//カンマを飛ばす
            ////////////////////X DATA////////////////////
            cp_cnt=0;
            while(dat_cnt<OPEN_SIZE && RB1_point_rd_data[dat_cnt]!=0x2c){
                r_buf[cp_cnt]=RB1_point_rd_data[dat_cnt];
                dat_cnt++;
                cp_cnt++;
            }
            r_buf[cp_cnt]=NULL;
            dat_cnt++;//カンマを飛ばす
            if(dat_cnt<OPEN_SIZE && HEAD_SKIP==0){
                RB1_POINT_RD[RB1_POINT_NO_CNT][PX] =atof(r_buf);
            } 
            //////////////////Y DATA///////////////////   
            cp_cnt=0;
            while(dat_cnt<OPEN_SIZE && RB1_point_rd_data[dat_cnt]!=0x2c){
                r_buf[cp_cnt]=RB1_point_rd_data[dat_cnt];
                dat_cnt++;
                cp_cnt++;
            }
            r_buf[cp_cnt]=NULL;
            dat_cnt++;//カンマを飛ばす
            if(dat_cnt<OPEN_SIZE && HEAD_SKIP==0){
                RB1_POINT_RD[RB1_POINT_NO_CNT][PY] =atof(r_buf);   
            }
            //printf("PY =%f\r\n",RB1_POINT_RD[RB1_POINT_NO_CNT][PY]);
            //////////////////Z DATA///////////////////   
            cp_cnt=0;
            while(dat_cnt<OPEN_SIZE && RB1_point_rd_data[dat_cnt]!=0x2c){
                r_buf[cp_cnt]=RB1_point_rd_data[dat_cnt];
                dat_cnt++;
                cp_cnt++;
            }
            r_buf[cp_cnt]=NULL;
            dat_cnt++;//カンマを飛ばす
            if(dat_cnt<OPEN_SIZE && HEAD_SKIP==0){
                RB1_POINT_RD[RB1_POINT_NO_CNT][PZ] =atof(r_buf);   
            }
            
            
             //////////////////R DATA///////////////////   
            cp_cnt=0;
            while(dat_cnt<OPEN_SIZE && RB1_point_rd_data[dat_cnt]!=0x2c){
                r_buf[cp_cnt]=RB1_point_rd_data[dat_cnt];
                dat_cnt++;
                cp_cnt++;
            }
            r_buf[cp_cnt]=NULL;
            dat_cnt++;//カンマを飛ばす
            if(dat_cnt<OPEN_SIZE && HEAD_SKIP==0){
                RB1_POINT_RD[RB1_POINT_NO_CNT][PR] =atof(r_buf);   
     
            }
            
           // printf("PZ =%f\r\n",RB1_POINT_RD[RB1_POINT_NO_CNT][PZ]);
             //////////////////txt DATA ////   
            cp_cnt=0;
            while(dat_cnt<OPEN_SIZE && RB1_point_rd_data[dat_cnt]!=0x0a){
                if(HEAD_SKIP==0){
                    RB1_point_txt[RB1_POINT_NO_CNT][cp_cnt]=RB1_point_rd_data[dat_cnt];
                    cp_cnt++;
                }
                dat_cnt++;    
            }

           
            if(dat_cnt<OPEN_SIZE && HEAD_SKIP==0){
                RB1_point_txt[RB1_POINT_NO_CNT][cp_cnt-1]=NULL;
                RB1_point_txt[RB1_POINT_NO_CNT][cp_cnt]=NULL;
                //printf("RB1_POINT[%02d] : X:%f Y:%f Z:%f R:%f :%s\r\n",RB1_POINT_NO_CNT,RB1_POINT_RD[RB1_POINT_NO_CNT][PX],RB1_POINT_RD[RB1_POINT_NO_CNT][PY],RB1_POINT_RD[RB1_POINT_NO_CNT][PZ],RB1_POINT_RD[RB1_POINT_NO_CNT][PR],RB1_point_txt[RB1_POINT_NO_CNT]);  
                RB1_POINT_NO_CNT++;
            }
            HEAD_SKIP=0;            
         
        }
        fclose(fd);
    }  
    //printf("dat_cnt=%d OPEN_SIZE=%d\r\n",dat_cnt,OPEN_SIZE);


}

void RB1_LIST_WRITE(){
    fd = fopen("/fs/system/RB1_PLIST.csv", "w+");//w+:上書きモードでファイルを書き込み（存在しない場合は、ファイル作成）
     if(!fd){
        ALM_ST= ALM_SD;
        ALM_HOLD_SET();
   }else{ 
        ////ヘッダ部保存////
        sprintf(RB1_point_wr_data,"No,X,Y,Z,R,Location Name\r\n");
        wr_size=strlen(RB1_point_wr_data);//文字列の長さを調べる   
        fwrite(&RB1_point_wr_data, 1, wr_size, fd);  
        ///ポイントデータ保存////  
        unsigned char wcnt=0;
        for(wcnt=0; wcnt<RB1_POINT_NO_CNT; wcnt++){ 
            sprintf(RB1_point_wr_data,"%02d,%lf,%lf,%lf,%lf,%s\r\n",wcnt,RB1_POINT_RD[wcnt][PX],RB1_POINT_RD[wcnt][PY],RB1_POINT_RD[wcnt][PZ],RB1_POINT_RD[wcnt][PR],RB1_point_txt[wcnt]);
            wr_size=strlen(RB1_point_wr_data);//文字列の長さを調べる
            //fseek(fd, 0, SEEK_END);
            fwrite(&RB1_point_wr_data, 1, wr_size, fd);
        }
        //printf("WRITE CNT=%d\r\n",wcnt);
        fclose(fd);
   }
}


///////////////////ROBO2////////////////////////////////////

void RB2_LIST_READ(){
    char r_buf[128];
    unsigned long dat_cnt=0;
    unsigned long cb_txt_cnt=0;
    unsigned char cp_cnt=0;
    unsigned char HEAD_SKIP=1;
    unsigned long OPEN_SIZE=GetFileSize("/fs/system/RB2_PLIST.csv");
    RB2_POINT_NO_CNT=0;
    
    //printf("open size=%d\r\n",OPEN_SIZE);
    fd = fopen("/fs/system/RB2_PLIST.csv","r");//r:既存ファイルを対象に、読み込みモードで開きます
    if(!fd){
        ALM_ST= ALM_SD;
        ALM_HOLD_SET();
    }else{ 
        fread(RB2_point_rd_data, 1,OPEN_SIZE,fd);  
        dat_cnt++; 
        ////最初のポイントNo部を飛ばす/////
        while(dat_cnt<OPEN_SIZE){//
            while(dat_cnt<OPEN_SIZE && RB2_point_rd_data[dat_cnt]!=0x2c){
                  dat_cnt++;
            }
            dat_cnt++;//カンマを飛ばす
            ////////////////////X DATA////////////////////
            cp_cnt=0;
            while(dat_cnt<OPEN_SIZE && RB2_point_rd_data[dat_cnt]!=0x2c){
                r_buf[cp_cnt]=RB2_point_rd_data[dat_cnt];
                dat_cnt++;
                cp_cnt++;
            }
            r_buf[cp_cnt]=NULL;
            dat_cnt++;//カンマを飛ばす
            if(dat_cnt<OPEN_SIZE && HEAD_SKIP==0){
                RB2_POINT_RD[RB2_POINT_NO_CNT][PX] =atof(r_buf);
            } 
            //////////////////Y DATA///////////////////   
            cp_cnt=0;
            while(dat_cnt<OPEN_SIZE && RB2_point_rd_data[dat_cnt]!=0x2c){
                r_buf[cp_cnt]=RB2_point_rd_data[dat_cnt];
                dat_cnt++;
                cp_cnt++;
            }
            r_buf[cp_cnt]=NULL;
            dat_cnt++;//カンマを飛ばす
            if(dat_cnt<OPEN_SIZE && HEAD_SKIP==0){
                RB2_POINT_RD[RB2_POINT_NO_CNT][PY] =atof(r_buf);   
            }
            //printf("PY =%f\r\n",RB2_POINT_RD[RB2_POINT_NO_CNT][PY]);
            //////////////////Z DATA///////////////////   
            cp_cnt=0;
            while(dat_cnt<OPEN_SIZE && RB2_point_rd_data[dat_cnt]!=0x2c){
                r_buf[cp_cnt]=RB2_point_rd_data[dat_cnt];
                dat_cnt++;
                cp_cnt++;
            }
            r_buf[cp_cnt]=NULL;
            dat_cnt++;//カンマを飛ばす
            if(dat_cnt<OPEN_SIZE && HEAD_SKIP==0){
                RB2_POINT_RD[RB2_POINT_NO_CNT][PZ] =atof(r_buf);   
            }
            
            
             //////////////////R DATA///////////////////   
            cp_cnt=0;
            while(dat_cnt<OPEN_SIZE && RB2_point_rd_data[dat_cnt]!=0x2c){
                r_buf[cp_cnt]=RB2_point_rd_data[dat_cnt];
                dat_cnt++;
                cp_cnt++;
            }
            r_buf[cp_cnt]=NULL;
            dat_cnt++;//カンマを飛ばす
            if(dat_cnt<OPEN_SIZE && HEAD_SKIP==0){
                RB2_POINT_RD[RB2_POINT_NO_CNT][PR] =atof(r_buf);   
     
            }
            
           // printf("PZ =%f\r\n",RB2_POINT_RD[RB2_POINT_NO_CNT][PZ]);
             //////////////////txt DATA ////   
            cp_cnt=0;
            while(dat_cnt<OPEN_SIZE && RB2_point_rd_data[dat_cnt]!=0x0a){
                if(HEAD_SKIP==0){
                    RB2_point_txt[RB2_POINT_NO_CNT][cp_cnt]=RB2_point_rd_data[dat_cnt];
                    cp_cnt++;
                }
                dat_cnt++;    
            }

           
            if(dat_cnt<OPEN_SIZE && HEAD_SKIP==0){
                RB2_point_txt[RB2_POINT_NO_CNT][cp_cnt-1]=NULL;
                RB2_point_txt[RB2_POINT_NO_CNT][cp_cnt]=NULL;
                //printf("RB2_POINT[%02d] : X:%f Y:%f Z:%f R:%f :%s\r\n",RB2_POINT_NO_CNT,RB2_POINT_RD[RB2_POINT_NO_CNT][PX],RB2_POINT_RD[RB2_POINT_NO_CNT][PY],RB2_POINT_RD[RB2_POINT_NO_CNT][PZ],RB2_POINT_RD[RB2_POINT_NO_CNT][PR],RB2_point_txt[RB2_POINT_NO_CNT]);  
                RB2_POINT_NO_CNT++;
            }
            HEAD_SKIP=0;            
         
        }
        fclose(fd);
    }  
    //printf("dat_cnt=%d OPEN_SIZE=%d\r\n",dat_cnt,OPEN_SIZE);

}


void RB2_LIST_WRITE(){
    fd = fopen("/fs/system/RB2_PLIST.csv", "w+");//w+:上書きモードでファイルを書き込み（存在しない場合は、ファイル作成）
     if(!fd){
        ALM_ST= ALM_SD;
        ALM_HOLD_SET();
   }else{ 
        ////ヘッダ部保存////
        sprintf(RB2_point_wr_data,"No,X,Y,Z,R,Location Name\r\n");
        wr_size=strlen(RB2_point_wr_data);//文字列の長さを調べる   
        fwrite(&RB2_point_wr_data, 1, wr_size, fd);  
        ///ポイントデータ保存////  
        unsigned char wcnt=0;
        for(wcnt=0; wcnt<RB2_POINT_NO_CNT; wcnt++){ 
            sprintf(RB2_point_wr_data,"%02d,%lf,%lf,%lf,%lf,%s\r\n",wcnt,RB2_POINT_RD[wcnt][PX],RB2_POINT_RD[wcnt][PY],RB2_POINT_RD[wcnt][PZ],RB2_POINT_RD[wcnt][PR],RB2_point_txt[wcnt]);
            wr_size=strlen(RB2_point_wr_data);//文字列の長さを調べる
            //fseek(fd, 0, SEEK_END);
            fwrite(&RB2_point_wr_data, 1, wr_size, fd);
        }
        //printf("WRITE CNT=%d\r\n",wcnt);
        fclose(fd);
   }
}

/////////////////////////極棒交換////////////////////////////
//設定の読み込み
void SETUP_DATA_RD()
{
    fd = fopen("/fs/system/config.bin","r");//r:既存ファイルを対象に、読み込みモードで開きます
    rd_size=GetFileSize("/fs/system/config.bin");
    if(!fd){
        lcd_print("t0","SDカード異常の為、起動できません。");
        ALM_HOLD_SET();
   }else{   
        fread(&config_dat,1,rd_size,fd);
        fclose(fd);
        /////////Φ４平/////////
        WD1H_CHG_SET_DAT=config_dat[0]<<8;//上位バイト
        WD1H_CHG_SET_DAT &=0xFF00;
        WD1H_CHG_SET_DAT |=config_dat[1];//下位バイト

        WD1H_CHGDAT_4=WD1H_CHG_SET_DAT/1000;
        WD1H_CHGDAT_3=(WD1H_CHG_SET_DAT-(WD1H_CHGDAT_4*1000))/100;
        WD1H_CHGDAT_2=(WD1H_CHG_SET_DAT-(WD1H_CHGDAT_4*1000+WD1H_CHGDAT_3*100))/10;
        WD1H_CHGDAT_1=(WD1H_CHG_SET_DAT-(WD1H_CHGDAT_4*1000+WD1H_CHGDAT_3*100+WD1H_CHGDAT_2*10));
        
        
       /////////Φ３側平/////////
        WD2H_CHG_SET_DAT=config_dat[2]<<8;//上位バイト
        WD2H_CHG_SET_DAT &=0xFF00;
        WD2H_CHG_SET_DAT |=config_dat[3];//下位バイト

        WD2H_CHGDAT_4=WD2H_CHG_SET_DAT/1000;
        WD2H_CHGDAT_3=(WD2H_CHG_SET_DAT-(WD2H_CHGDAT_4*1000))/100;
        WD2H_CHGDAT_2=(WD2H_CHG_SET_DAT-(WD2H_CHGDAT_4*1000+WD2H_CHGDAT_3*100))/10;
        WD2H_CHGDAT_1=(WD2H_CHG_SET_DAT-(WD2H_CHGDAT_4*1000+WD2H_CHGDAT_3*100+WD2H_CHGDAT_2*10));
        ////Φ３丸//////////////
        WD2R_CHG_SET_DAT=config_dat[4]<<8;//上位バイト
        WD2R_CHG_SET_DAT &=0xFF00;
        WD2R_CHG_SET_DAT |=config_dat[5];//下位バイト

        WD2R_CHGDAT_4=WD2R_CHG_SET_DAT/1000;
        WD2R_CHGDAT_3=(WD2R_CHG_SET_DAT-(WD2R_CHGDAT_4*1000))/100;
        WD2R_CHGDAT_2=(WD2R_CHG_SET_DAT-(WD2R_CHGDAT_4*1000+WD2R_CHGDAT_3*100))/10;
        WD2R_CHGDAT_1=(WD2R_CHG_SET_DAT-(WD2R_CHGDAT_4*1000+WD2R_CHGDAT_3*100+WD2R_CHGDAT_2*10));
        //////////端子供給1側///////////////////
        C1_RD_50MM=config_dat[6]<<24;
        C1_RD_50MM &=0xFF000000;
        C1_RD_50MM |=config_dat[7]<<16;
        C1_RD_50MM &=0xFFFF0000;
        C1_RD_50MM |=config_dat[8]<<8;
        C1_RD_50MM &=0xFFFFFF00;
        C1_RD_50MM |=config_dat[9];
  
        C1_RD_32MM=config_dat[10]<<24;
        C1_RD_32MM &=0xFF000000;
        C1_RD_32MM |=config_dat[11]<<16;
        C1_RD_32MM &=0xFFFF0000;
        C1_RD_32MM |=config_dat[12]<<8;
        C1_RD_32MM &=0xFFFFFF00;
        C1_RD_32MM |=config_dat[13];

        C1_RD_23MM=config_dat[14]<<24;
        C1_RD_23MM &=0xFF000000;
        C1_RD_23MM |=config_dat[15]<<16;
        C1_RD_23MM &=0xFFFF0000;
        C1_RD_23MM |=config_dat[16]<<8;
        C1_RD_23MM &=0xFFFFFF00;
        C1_RD_23MM |=config_dat[17];
        ////////////////////////////////////
        //////////端子供給2側///////////////////
        C2_RD_50MM=config_dat[18]<<24;
        C2_RD_50MM &=0xFF000000;
        C2_RD_50MM |=config_dat[19]<<16;
        C2_RD_50MM &=0xFFFF0000;
        C2_RD_50MM |=config_dat[20]<<8;
        C2_RD_50MM &=0xFFFFFF00;
        C2_RD_50MM |=config_dat[21];
  
        C2_RD_32MM=config_dat[22]<<24;
        C2_RD_32MM &=0xFF000000;
        C2_RD_32MM |=config_dat[23]<<16;
        C2_RD_32MM &=0xFFFF0000;
        C2_RD_32MM |=config_dat[24]<<8;
        C2_RD_32MM &=0xFFFFFF00;
        C2_RD_32MM |=config_dat[25];

        C2_RD_23MM=config_dat[26]<<24;
        C2_RD_23MM &=0xFF000000;
        C2_RD_23MM |=config_dat[27]<<16;
        C2_RD_23MM &=0xFFFF0000;
        C2_RD_23MM |=config_dat[28]<<8;
        C2_RD_23MM &=0xFFFFFF00;
        C2_RD_23MM |=config_dat[29];
        
            ////書き込みデータの初期値を読み込みデータに設定///
            
        wait_us(100);
        C1_WR_50MM = C1_RD_50MM;
        C1_WR_32MM = C1_RD_32MM;
        C1_WR_23MM = C1_RD_23MM;
        
        C2_WR_50MM = C2_RD_50MM;
        C2_WR_32MM = C2_RD_32MM;
        C2_WR_23MM = C2_RD_23MM;
        
        /*
        printf("C1_RD_50MM=%d C1_RD_32MM=%d C1_RD_23MM=%d\r\n",C1_RD_50MM,C1_RD_32MM,C1_RD_23MM);
        printf("C2_RD_50MM=%d C2_RD_32MM=%d C2_RD_23MM=%d\r\n",C2_RD_50MM,C2_RD_32MM,C2_RD_23MM);
        
        printf("C1_WR_50MM=%d C1_WR_32MM=%d C1_WR_23MM=%d\r\n",C1_WR_50MM,C1_WR_32MM,C1_WR_23MM);
        printf("C2_WR_50MM=%d C2_WR_32MM=%d C2_WR_23MM=%d\r\n",C2_WR_50MM,C2_WR_32MM,C2_WR_23MM);
        */
        //////////端子供給１//////////////////////////
        C1_SET_50MM=C1_RD_50MM;
        C1_SET_32MM=C1_RD_32MM;
        C1_SET_23MM=C1_RD_23MM;

        C1_SET_50MM=C1_SET_50MM/10;
        C1_SET_32MM=C1_SET_32MM/10;
        C1_SET_23MM=C1_SET_23MM/10;

        
        //////////端子供給２//////////////////////////
        C2_SET_50MM=C2_RD_50MM;
        C2_SET_32MM=C2_RD_32MM;
        C2_SET_23MM=C2_RD_23MM;
        
        C2_SET_50MM=C2_SET_50MM/10;
        C2_SET_32MM=C2_SET_32MM/10;
        C2_SET_23MM=C2_SET_23MM/10;

   }    
}


////設定の保存//
void SET_UP_SAVE()
{

   fd = fopen("/fs/system/config.bin","w+");//w+:上書きモードでファイルを書き込み（存在しない場合は、ファイル作成）
   if(!fd){
        ALM_ST= ALM_SD;
        ALM_HOLD_SET();
   }else{ 
        /////////極棒交換//////////////////      
        ///Φ４平///
        config_save_dat[0]=WD1H_CHG_SET_DAT>>8;//上位バイト
        config_save_dat[1]=WD1H_CHG_SET_DAT;//下位バイト
        //Φ３平//
        config_save_dat[2]=WD2H_CHG_SET_DAT>>8;//上位バイト
        config_save_dat[3]=WD2H_CHG_SET_DAT;//下位バイト
        //Φ３//
        config_save_dat[4]=WD2R_CHG_SET_DAT>>8;//上位バイト
        config_save_dat[5]=WD2R_CHG_SET_DAT;//下位バイト
        /////////端子供給1////////////////
        config_save_dat[6]=C1_WR_50MM>>24;
        config_save_dat[7]=C1_WR_50MM>>16;
        config_save_dat[8]=C1_WR_50MM>>8;
        config_save_dat[9]=C1_WR_50MM;
        
        config_save_dat[10]=C1_WR_32MM>>24;
        config_save_dat[11]=C1_WR_32MM>>16;
        config_save_dat[12]=C1_WR_32MM>>8;
        config_save_dat[13]=C1_WR_32MM;
        
        config_save_dat[14]=C1_WR_23MM>>24;
        config_save_dat[15]=C1_WR_23MM>>16;
        config_save_dat[16]=C1_WR_23MM>>8;
        config_save_dat[17]=C1_WR_23MM;
        /////////端子供給2////////////////
        config_save_dat[18]=C2_WR_50MM>>24;
        config_save_dat[19]=C2_WR_50MM>>16;
        config_save_dat[20]=C2_WR_50MM>>8;
        config_save_dat[21]=C2_WR_50MM;
        
        config_save_dat[22]=C2_WR_32MM>>24;
        config_save_dat[23]=C2_WR_32MM>>16;
        config_save_dat[24]=C2_WR_32MM>>8;
        config_save_dat[25]=C2_WR_32MM;
        
        config_save_dat[26]=C2_WR_23MM>>24;
        config_save_dat[27]=C2_WR_23MM>>16;
        config_save_dat[28]=C2_WR_23MM>>8;
        config_save_dat[29]=C2_WR_23MM;
        fwrite(&config_save_dat, 1, 30, fd);
        fclose(fd);
        
        C1_SET_50MM=C1_WR_50MM/10;
        C1_SET_32MM=C1_WR_32MM/10;
        C1_SET_23MM=C1_WR_23MM/10;
        
        C2_SET_50MM=C2_WR_50MM/10;
        C2_SET_32MM=C2_WR_32MM/10;
        C2_SET_23MM=C2_WR_23MM/10;
        

        ///保存後の再読み込み///
        SETUP_DATA_RD();        
    }
}
