#include "mbed.h"
#include "main.h"
#include "DiNi_supplyr.h"
#include "MCP23017.h"
#include "IO_CONT.h"
#include "nextion_lcd.h"
#include "APP.h"
#include "SAVE_CONT.h"
#include "CUT_CONT.h"


unsigned long timeout=0;
unsigned char C1_POS_ST=0;
unsigned char C2_POS_ST=0;
unsigned char WT_POS_ST=0;

unsigned char C1_CUT_FET_ST=FET_OFF;
unsigned char C1_HAND_FET_ST=FET_OFF;
unsigned char C1_WD_FET_ST=FET_OFF;

unsigned char C2_CUT_FET_ST=FET_OFF;
unsigned char C2_HAND_FET_ST=FET_OFF;
unsigned char C2_WD_FET_ST=FET_OFF;

//直行軸のWAIT有効 1で有効 *重複呼び出し時にWAITをキャンセルする為のフラグ
unsigned char C1_MOV_WAIT_EN=0;
unsigned char C2_MOV_WAIT_EN=0;
unsigned char WT_MOV_WAIT_EN=0;

void C1_HAND_FET_CONT(unsigned char cont){
    if(cont !=C1_HAND_FET_ST){
        if(cont==FET_ON){
            FET1_O=1;
        }else{
            FET1_O=0;
        } 
        C1_HAND_FET_ST=cont;
    }
}

void C1_WD_FET_CONT(unsigned char cont){
    if(cont !=C1_WD_FET_ST){
        if(cont==FET_ON){
            FET2_O=1;
        }else{
            FET2_O=0;
        }
         C1_WD_FET_ST=cont;
    }
}


void C1_CUT_FET_CONT(unsigned char cont){
    if(cont !=C1_CUT_FET_ST){
        if(cont==FET_ON){
            FET3_O=1;
        }else{
            FET3_O=0;
        }
        C1_CUT_FET_ST=cont;
    }
}


void C2_HAND_FET_CONT(unsigned char cont){
    if(cont !=C2_HAND_FET_ST){
        if(cont==FET_ON){
            FET4_O=1;
        }else{
            FET4_O=0;
        } 
        C2_HAND_FET_ST=cont;
    }
}

void C2_WD_FET_CONT(unsigned char cont){
    if(cont !=C2_WD_FET_ST){
        if(cont==FET_ON){
            FET5_O=1;
        }else{
            FET5_O=0;
        }
         C2_WD_FET_ST=cont;
    }
}

void C2_CUT_FET_CONT(unsigned char cont){
    if(cont !=C2_CUT_FET_ST){
        if(cont==FET_ON){
            FET6_O=1;
        }else{
            FET6_O=0;
        }
        C2_CUT_FET_ST=cont;
    }
}


/////////////////端子供給1////////////////////////////////
//軸 原点復帰待ち//(MOVE_TIME_OUTの設定は、El_actuator.hを参照)
void C1_HOME_WAIT(void){
      
    ////HENDがOFFになるまで（移動開始まで）待つ///
    timeout=0;  
    while(IO_EX_BIT_READ(NTRP1_HEND_I) !=IOEX_OFF_I && timeout<MOVE_TIME_OUT){
        wait_ms(10); 
        timeout++;
    }
    if(timeout>=MOVE_TIME_OUT){
        ALM_ST= ALM_NISP1_HM;
        ALM_HOLD_SET();
    }
    ////HENDがONになるまで（移動終了まで）待つ///
    timeout=0;
    while(IO_EX_BIT_READ(NTRP1_HEND_I) !=IOEX_ON_I && timeout<MOVE_TIME_OUT){//10ms x500=5s
        wait_ms(10); 
        timeout++;
    }
    if(timeout>=MOVE_TIME_OUT){
        ALM_ST= ALM_NISP1_HM;
        ALM_HOLD_SET();
    }
}
///軸移動開始待ち//
void C1_MOVE_SWAIT(void){
        ////PENDがOFFになるまで（移動開始まで）待つ///
        if(C1_MOV_WAIT_EN==1){//直行軸のWAIT有効 1で有効
            timeout=0;
            while(IO_EX_BIT_READ(NTRP1_PEND_I) !=IOEX_OFF_I && timeout<MOVE_TIME_OUT){ //10ms x500=5s
                wait_ms(10); 
                timeout++;
            }
            if(timeout>=MOVE_TIME_OUT){
                ALM_ST= ALM_NISP1_ST;
                ALM_HOLD_SET();
            }
            IO_EX_BIT_WITE(NTRP1_CSTR_O,IOEX_OFF_O);//2021/03/18 CSTRは、PEND OFFでOFF
        }
  
}
///軸移動完了待ち//
void C1_MOVE_EWAIT(void){
     ////PENDがONになるまで（移動終了まで）待つ///
    if(C1_MOV_WAIT_EN==1){//直行軸のWAIT有効 1で有効
        timeout=0;
        while(IO_EX_BIT_READ(NTRP1_PEND_I) !=IOEX_ON_I && timeout<MOVE_TIME_OUT){ //10ms x500=5s
            wait_ms(10); 
            timeout++;
        }
        if(timeout>=MOVE_TIME_OUT){
            ALM_ST= ALM_NISP1_ED;
            ALM_HOLD_SET();
        }
    }
}
///軸移動待ち//(MOVE_TIME_OUTの設定は、El_actuator.hを参照)
void C1_MOVE_WAIT(void){
    if(C1_MOV_WAIT_EN==1){//直行軸のWAIT有効 1で有効
        ////PENDがOFFになるまで（移動開始まで）待つ///
        timeout=0;
        while(IO_EX_BIT_READ(NTRP1_PEND_I) !=IOEX_OFF_I && timeout<MOVE_TIME_OUT){ //10ms x500=5s
            wait_ms(10); 
            timeout++;
        }
        if(timeout>=MOVE_TIME_OUT){
            ALM_ST= ALM_NISP1_ST;
            ALM_HOLD_SET();
        }
        IO_EX_BIT_WITE(NTRP1_CSTR_O,IOEX_OFF_O);//2021/03/18 CSTRは、PEND OFFでOFF
        ////PENDがONになるまで（移動終了まで）待つ///
        timeout=0;
        while(IO_EX_BIT_READ(NTRP1_PEND_I) !=IOEX_ON_I && timeout<MOVE_TIME_OUT){ //10ms x500=5s
            wait_ms(10); 
            timeout++;
        }
        if(timeout>=MOVE_TIME_OUT){
            ALM_ST= ALM_NISP1_ED;
            ALM_HOLD_SET();
        }
    }
}


///加圧軸原点復帰///
void C1_HOME(void){   
  IO_EX_BIT_WITE(NTRP1_HOME_O,IOEX_ON_O);//加圧軸 HOME ON
  C1_HOME_WAIT();
  IO_EX_BIT_WITE(NTRP1_HOME_O,IOEX_OFF_O);//加圧軸 HOME OFF
  C1_POS_ST=POS_HOME; //2021/03/09追加
}

void C1_MOVE(unsigned char SEL){
    unsigned char BIT1=0;
    unsigned char BIT2=0;
    unsigned char BIT4=0;
    unsigned char BIT8=0;
     
    unsigned char SELECT=SEL;
    SELECT &=0x0F;
    
    BIT1 = SELECT;
    BIT1 &= 0x01;
    
    BIT2 = SELECT>>1;
    BIT2 &= 0x01;
    
    BIT4 = SELECT>>2;
    BIT4 &=0x01;  
    
    BIT8 = SELECT>>3;
    BIT8 &=0x01;  
    /////////ポジション指定//////////////
    if(BIT1==1){
        IO_EX_BIT_WITE(NTRP1_PC1_O,IOEX_ON_O);
    }else{
        IO_EX_BIT_WITE(NTRP1_PC1_O,IOEX_OFF_O);
    }
    
    if(BIT2==1){
        IO_EX_BIT_WITE(NTRP1_PC2_O,IOEX_ON_O);
    }else{
        IO_EX_BIT_WITE(NTRP1_PC2_O,IOEX_OFF_O);
    }       
    if(BIT4==1){
        IO_EX_BIT_WITE(NTRP1_PC4_O,IOEX_ON_O);
    }else{
        IO_EX_BIT_WITE(NTRP1_PC4_O,IOEX_OFF_O);
    }
    
    if(BIT8==1){
        IO_EX_BIT_WITE(NTRP1_PC8_O,IOEX_ON_O);
    }else{
        IO_EX_BIT_WITE(NTRP1_PC8_O,IOEX_OFF_O);
    }
    
    ///現在位置以外であれば移動開始////
    if(SELECT !=C1_POS_ST){
        wait_ms(30);
        IO_EX_BIT_WITE(NTRP1_CSTR_O,IOEX_ON_O);
        wait_ms(10);//min 6ms
        C1_MOVE_SWAIT();//2022/09/28 開始待ちは必ずいれることに変更
        C1_POS_ST=SELECT;
        
        C1_MOV_WAIT_EN=1;//直行軸のWAIT有効 1で有効
    }else{
        C1_MOV_WAIT_EN=0;//直行軸のWAIT有効 1で有効
    }
    
}

/////////////////端子供給2////////////////////////////////
//軸 原点復帰待ち//(MOVE_TIME_OUTの設定は、Ni_supplyr.hを参照)
void C2_HOME_WAIT(void){
      
    ////HENDがOFFになるまで（移動開始まで）待つ///
    timeout=0;  
    while(IO_EX_BIT_READ(NTRP2_HEND_I) !=IOEX_OFF_I && timeout<MOVE_TIME_OUT){
        wait_ms(10); 
        timeout++;
    }
    if(timeout>=MOVE_TIME_OUT){
        ALM_ST= ALM_NISP2_HM;
        ALM_HOLD_SET();
    }
    ////HENDがONになるまで（移動終了まで）待つ///
    timeout=0;
    while(IO_EX_BIT_READ(NTRP2_HEND_I) !=IOEX_ON_I && timeout<MOVE_TIME_OUT){//10ms x500=5s
        wait_ms(10); 
        timeout++;
    }
    if(timeout>=MOVE_TIME_OUT){
        ALM_ST= ALM_NISP2_HM;
        ALM_HOLD_SET();
    }
}
///軸移動開始待ち//
void C2_MOVE_SWAIT(void){
    ////PENDがOFFになるまで（移動開始まで）待つ///
    if(C2_MOV_WAIT_EN==1){//直行軸のWAIT有効 1で有効
        timeout=0;
        while(IO_EX_BIT_READ(NTRP2_PEND_I) !=IOEX_OFF_I && timeout<MOVE_TIME_OUT){ //10ms x500=5s
            wait_ms(10); 
            timeout++;
        }
        if(timeout>=MOVE_TIME_OUT){
            ALM_ST= ALM_NISP2_ST;
            ALM_HOLD_SET();
        }
        IO_EX_BIT_WITE(NTRP2_CSTR_O,IOEX_OFF_O);//2021/03/18 CSTRは、PEND OFFでOFF
    }
  
}
///軸移動完了待ち//
void C2_MOVE_EWAIT(void){
     ////PENDがONになるまで（移動終了まで）待つ///
    if(C2_MOV_WAIT_EN==1){//直行軸のWAIT有効 1で有効
        timeout=0;
        while(IO_EX_BIT_READ(NTRP2_PEND_I) !=IOEX_ON_I && timeout<MOVE_TIME_OUT){ //10ms x500=5s
            wait_ms(10); 
            timeout++;
        }
        if(timeout>=MOVE_TIME_OUT){
            ALM_ST= ALM_NISP2_ED;
            ALM_HOLD_SET();
        }
    }
}
///軸移動待ち//(MOVE_TIME_OUTの設定は、El_actuator.hを参照)
void C2_MOVE_WAIT(void){
    if(C2_MOV_WAIT_EN==1){//直行軸のWAIT有効 1で有効
        ////PENDがOFFになるまで（移動開始まで）待つ///
        timeout=0;
        while(IO_EX_BIT_READ(NTRP2_PEND_I) !=IOEX_OFF_I && timeout<MOVE_TIME_OUT){ //10ms x500=5s
            wait_ms(10); 
            timeout++;
        }
        if(timeout>=MOVE_TIME_OUT){
            ALM_ST= ALM_NISP2_ST;
            ALM_HOLD_SET();
        }
        IO_EX_BIT_WITE(NTRP2_CSTR_O,IOEX_OFF_O);//2021/03/18 CSTRは、PEND OFFでOFF
        ////PENDがONになるまで（移動終了まで）待つ///
        timeout=0;
        while(IO_EX_BIT_READ(NTRP2_PEND_I) !=IOEX_ON_I && timeout<MOVE_TIME_OUT){ //10ms x500=5s
            wait_ms(10); 
            timeout++;
        }
        if(timeout>=MOVE_TIME_OUT){
            ALM_ST= ALM_NISP2_ED;
            ALM_HOLD_SET();
        }
    }
}


///加圧軸原点復帰///
void C2_HOME(void){   
  IO_EX_BIT_WITE(NTRP2_HOME_O,IOEX_ON_O);//加圧軸 HOME ON
  C2_HOME_WAIT();
  IO_EX_BIT_WITE(NTRP2_HOME_O,IOEX_OFF_O);//加圧軸 HOME OFF
  C2_POS_ST=POS_HOME; //2021/03/09追加
}

void C2_MOVE(unsigned char SEL){
    unsigned char BIT1=0;
    unsigned char BIT2=0;
    unsigned char BIT4=0;
    unsigned char BIT8=0;
     
    unsigned char SELECT=SEL;
    SELECT &=0x0F;
    
    BIT1 = SELECT;
    BIT1 &= 0x01;
    
    BIT2 = SELECT>>1;
    BIT2 &= 0x01;
    
    BIT4 = SELECT>>2;
    BIT4 &=0x01;  
    
    BIT8 = SELECT>>3;
    BIT8 &=0x01;  
    /////////ポジション指定//////////////
    if(BIT1==1){
        IO_EX_BIT_WITE(NTRP2_PC1_O,IOEX_ON_O);
    }else{
        IO_EX_BIT_WITE(NTRP2_PC1_O,IOEX_OFF_O);
    }
    
    if(BIT2==1){
        IO_EX_BIT_WITE(NTRP2_PC2_O,IOEX_ON_O);
    }else{
        IO_EX_BIT_WITE(NTRP2_PC2_O,IOEX_OFF_O);
    }       
    if(BIT4==1){
        IO_EX_BIT_WITE(NTRP2_PC4_O,IOEX_ON_O);
    }else{
        IO_EX_BIT_WITE(NTRP2_PC4_O,IOEX_OFF_O);
    }
    
    if(BIT8==1){
        IO_EX_BIT_WITE(NTRP2_PC8_O,IOEX_ON_O);
    }else{
        IO_EX_BIT_WITE(NTRP2_PC8_O,IOEX_OFF_O);
    }
    
    ///現在位置以外であれば移動開始////
    if(SELECT !=C2_POS_ST){
        wait_ms(30);
        IO_EX_BIT_WITE(NTRP2_CSTR_O,IOEX_ON_O);
        wait_ms(10);//min 6ms
        C2_MOVE_SWAIT();//2022/09/28 開始待ちは必ずいれることに変更
        C2_POS_ST=SELECT;
        C2_MOV_WAIT_EN=1;//直行軸のWAIT有効 1で有効
    }else{
        C2_MOV_WAIT_EN=0;//直行軸のWAIT有効 1で有効
    }
    
}
/////////////////1,2同時////////////////////
////ニッケル把持ハンド////
void C1A2_HAND_FET_CONT(unsigned char cont){
    
    C1_HAND_FET_CONT(cont);
    C2_HAND_FET_CONT(cont);

}

///溶接棒押し当て///////
void C1A2_WD_FET_CONT(unsigned char cont){
    
    C1_WD_FET_CONT(cont);
    C2_WD_FET_CONT(cont);

}

////ニッケル端子切断////
void C1A2_CUT_FET_CONT(unsigned char cont){

    C1_CUT_FET_CONT(cont);
    C2_CUT_FET_CONT(cont);

}
///ニッケル搬送軸移動//////////
void C1A2_MOVE_EWAIT(void){//移動完了待ち
    
    C1_MOVE_EWAIT();
    C2_MOVE_EWAIT();
    
}

void C1A2_MOVE(unsigned char C1_SEL,unsigned char C2_SEL){
    C1_MOVE(C1_SEL);
    C2_MOVE(C2_SEL);
}
////////////////////////////////////////
/////////////////ダイオード（ワーク）搬送////////////////////////////////
//軸 原点復帰待ち//(MOVE_TIME_OUTの設定は、Ni_supplyr.hを参照)
void WT_HOME_WAIT(void){
      
    ////HENDがOFFになるまで（移動開始まで）待つ///
    timeout=0;  
    while(IO_EX_BIT_READ(WTRP_HEND_I) !=IOEX_OFF_I && timeout<100){
        wait_ms(10); 
        timeout++;
    }
    if(timeout>=MOVE_TIME_OUT){

        ALM_ST= ALM_DISP_HM;
        ALM_HOLD_SET();
    }
    ////HENDがONになるまで（移動終了まで）待つ///
    timeout=0;
    while(IO_EX_BIT_READ(WTRP_HEND_I) !=IOEX_ON_I && timeout<3000){//10ms x500=5s
        wait_ms(10); 
        timeout++;
    }
    if(timeout>=MOVE_TIME_OUT){
        ALM_ST= ALM_DISP_HM;
        ALM_HOLD_SET();
    }
}
///軸移動開始待ち//
void WT_MOVE_SWAIT(void){
    ////PENDがOFFになるまで（移動開始まで）待つ///
    if(WT_MOV_WAIT_EN==1){//直行軸のWAIT有効 1で有効 *重複呼び出し時にWAITをキャンセルする為のフラグ
        timeout=0;
        while(IO_EX_BIT_READ(WTRP_PEND_I) !=IOEX_OFF_I && timeout<MOVE_TIME_OUT){ //10ms x500=5s
            wait_ms(10); 
            timeout++;
        }
        if(timeout>=MOVE_TIME_OUT){
            ALM_ST= ALM_DISP_ST;
            ALM_HOLD_SET();
        }
        IO_EX_BIT_WITE(WTRP_CSTR_O,IOEX_OFF_O);//2021/03/18 CSTRは、PEND OFFでOFF
    }
  
}
///軸移動完了待ち//
void WT_MOVE_EWAIT(void){
     ////PENDがONになるまで（移動終了まで）待つ///
    if(WT_MOV_WAIT_EN==1){//直行軸のWAIT有効 1で有効 *重複呼び出し時にWAITをキャンセルする為のフラグ
        timeout=0;
        while(IO_EX_BIT_READ(WTRP_PEND_I) !=IOEX_ON_I && timeout<MOVE_TIME_OUT){ //10ms x500=5s
            wait_ms(10); 
            timeout++;
        }
        if(timeout>=MOVE_TIME_OUT){
            ALM_ST= ALM_DISP_ED;
            ALM_HOLD_SET();
        }
    }
}
///軸移動待ち//(MOVE_TIME_OUTの設定は、El_actuator.hを参照)
void WT_MOVE_WAIT(void){
    if(WT_MOV_WAIT_EN==1){//直行軸のWAIT有効 1で有効
        ////PENDがOFFになるまで（移動開始まで）待つ///
        timeout=0;
        while(IO_EX_BIT_READ(WTRP_PEND_I) !=IOEX_OFF_I && timeout<MOVE_TIME_OUT){ //10ms x500=5s
            wait_ms(10); 
            timeout++;
        }
        if(timeout>=MOVE_TIME_OUT){
            ALM_ST= ALM_DISP_ST;
            ALM_HOLD_SET();
        }
        IO_EX_BIT_WITE(WTRP_CSTR_O,IOEX_OFF_O);//2021/03/18 CSTRは、PEND OFFでOFF
        ////PENDがONになるまで（移動終了まで）待つ///
        timeout=0;
        while(IO_EX_BIT_READ(WTRP_PEND_I) !=IOEX_ON_I && timeout<MOVE_TIME_OUT){ //10ms x500=5s
            wait_ms(10); 
            timeout++;
        }
        if(timeout>=MOVE_TIME_OUT){
            ALM_ST= ALM_DISP_ED;
            ALM_HOLD_SET();
        }
    }
}


///原点復帰///
void WT_HOME(void){  
    if(IO_EX_BIT_READ(WTRP_HEND_I) ==IOEX_OFF_I){
        IO_EX_BIT_WITE(WTRP_HOME_O,IOEX_ON_O);//加圧軸 HOME ON
        WT_HOME_WAIT();
        IO_EX_BIT_WITE(WTRP_HOME_O,IOEX_OFF_O);//加圧軸 HOME OFF
        WT_POS_ST=POS_HOME; //2021/03/09追加
    }else{
        WT_MOVE(POS_WT_HOME);
        WT_MOVE_EWAIT();
        WT_POS_ST=POS_HOME; //2021/03/09追加
    }
    
}

void WT_MOVE(unsigned char SEL){
    unsigned char BIT1=0;
    unsigned char BIT2=0;
    unsigned char BIT4=0;
    unsigned char BIT8=0;
     
    unsigned char SELECT=SEL;
    SELECT &=0x0F;
    
    BIT1 = SELECT;
    BIT1 &= 0x01;
    
    BIT2 = SELECT>>1;
    BIT2 &= 0x01;
    
    BIT4 = SELECT>>2;
    BIT4 &=0x01;  
    
    BIT8 = SELECT>>3;
    BIT8 &=0x01;  
    /////////ポジション指定//////////////
    if(BIT1==1){
        IO_EX_BIT_WITE(WTRP_PC1_O,IOEX_ON_O);
    }else{
        IO_EX_BIT_WITE(WTRP_PC1_O,IOEX_OFF_O);
    }
    
    if(BIT2==1){
        IO_EX_BIT_WITE(WTRP_PC2_O,IOEX_ON_O);
    }else{
        IO_EX_BIT_WITE(WTRP_PC2_O,IOEX_OFF_O);
    }       
    if(BIT4==1){
        IO_EX_BIT_WITE(WTRP_PC4_O,IOEX_ON_O);
    }else{
        IO_EX_BIT_WITE(WTRP_PC4_O,IOEX_OFF_O);
    }
    
    if(BIT8==1){
        IO_EX_BIT_WITE(WTRP_PC8_O,IOEX_ON_O);
    }else{
        IO_EX_BIT_WITE(WTRP_PC8_O,IOEX_OFF_O);
    }
    
    ///現在位置以外であれば移動開始////
    if(SELECT !=C2_POS_ST){
        wait_ms(30);
        IO_EX_BIT_WITE(WTRP_CSTR_O,IOEX_ON_O);
        wait_ms(10);//min 6ms
        WT_POS_ST=SELECT;
        WT_MOV_WAIT_EN=1;//直行軸のWAIT有効 1で有効 *重複呼び出し時にWAITをキャンセルする為のフラグ
        //動作開始待ち////
        WT_MOVE_SWAIT();
     

    }else{
        WT_MOV_WAIT_EN=0;//直行軸のWAIT有効 1で有効 *重複呼び出し時にWAITをキャンセルする為のフラグ
    }

    
}
 

void EA_IO_INI(void){
    ///停止解除///
    IO_EX_BIT_WITE(NTRP1_STP_O,IOEX_ON_O);
    IO_EX_BIT_WITE(NTRP2_STP_O,IOEX_ON_O);
    IO_EX_BIT_WITE(WTRP_STP_O,IOEX_ON_O);

}