#include "mbed.h"
#include "main.h"
#include "nextion_lcd.h"
#include "APP.h"
#include "WORK_START.h"
///////////////////////
#include "ROBO1_CONT.h"
#include "ROBO2_CONT.h"
#include "ROBO_TWIN_CONT.h"
#include "SAVE_CONT.h"
///////////////////////
#include "PS3_BT_CTL.h"
#include "WD_CONT.h"
#include "DiNi_supplyr.h"

void ROBO2_ADJ_PAGE(void){
    if(touch_id!=0) { //作業中は、一時停止受付るため、マスクしない
        tp_mask=1;//1=タッチパネルマスク
    }
    switch (touch_id) {
        ////caseはnextion lcdのSWに割り当てられたidを記載する///
        case BT10_PSEL    :
                            RB2_PSEL=nx_val_get("cb0");
                            sprintf(lcd_print_buf,"ポジション選択 :%02d",RB2_PSEL);
                            lcd_print("t0",lcd_print_buf);
                            touch_id=0;
                            break;
        case BT10_X_M     : 
                            if(touch_t==1){
                                lcd_print("t0","JOG X-");
                                RB2_SEND_CMD("MoveJog(x-)");
                                RB2_POSE_DISP_EN=1;//位置表示自動更新ON
                            }else{
                                RB2_SEND_CMD("MoveJog()"); 
                                RB2_POSE_DISP_EN=0;
                                RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）   
                            }
                            touch_id=0;
                            break;
        case BT10_X_P     : 
                            if(touch_t==1){
                                lcd_print("t0","JOG X+");
                                RB2_SEND_CMD("MoveJog(x+)");   
                                RB2_POSE_DISP_EN=1;//位置表示自動更新ON 
                            }else{
                                RB2_SEND_CMD("MoveJog()");
                                RB2_POSE_DISP_EN=0;  
                                RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）
                                   
                            }
                            touch_id=0;
                            break;
        case BT10_Y_M     : 
                            if(touch_t==1){
                                lcd_print("t0","JOG Y-");
                                RB2_SEND_CMD("MoveJog(y-)");
                                RB2_POSE_DISP_EN=1;//位置表示自動更新ON
                             }else{
                                RB2_SEND_CMD("MoveJog()");
                                RB2_POSE_DISP_EN=0;  
                                RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している） 
                            }
                            touch_id=0;
                            break;
        case BT10_Y_P     : 
                            if(touch_t==1){
                                lcd_print("t0","JOG Y+");
                                RB2_SEND_CMD("MoveJog(y+)");
                                RB2_POSE_DISP_EN=1;//位置表示自動更新ON
                            }else{
                                RB2_SEND_CMD("MoveJog()");
                                RB2_POSE_DISP_EN=0;
                                RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）  
                            }
                            touch_id=0;
                            break;
        case BT10_Z_M     : 
                            if(touch_t==1){
                                lcd_print("t0","JOG Z-");
                                RB2_SEND_CMD("MoveJog(z-)");
                                RB2_POSE_DISP_EN=1;//位置表示自動更新ON   
                             }else{
                                RB2_SEND_CMD("MoveJog()");
                                RB2_POSE_DISP_EN=0; 
                                RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）   
                            }
                            touch_id=0;
                            break;
        case BT10_Z_P     : 
                            if(touch_t==1){
                                lcd_print("t0","JOG Z+");
                                RB2_SEND_CMD("MoveJog(z+)");
                                RB2_POSE_DISP_EN=1;//位置表示自動更新ON     
                            }else{
                                RB2_SEND_CMD("MoveJog()");
                                RB2_POSE_DISP_EN=0; 
                                RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）
                            }
                            touch_id=0;
                            break;                           
        case BT10_R_M     : 
                            if(touch_t==1){
                                lcd_print("t0","JOG R-");
                                RB2_SEND_CMD("MoveJog(j4-)");
                                RB2_POSE_DISP_EN=1;//位置表示自動更新ON   
                              }else{
                                RB2_SEND_CMD("MoveJog()"); 
                                RB2_POSE_DISP_EN=0;
                                RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）      
                            }
                            touch_id=0;
                            break;
        case BT10_R_P     : 
                            if(touch_t==1){
                                lcd_print("t0","JOG R+");
                                RB2_SEND_CMD("MoveJog(j4+)");
                                RB2_POSE_DISP_EN=1;//位置表示自動更新ON   
                            }else{
                                RB2_SEND_CMD("MoveJog()"); 
                                RB2_POSE_DISP_EN=0;
                                RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）     
                            }
                            touch_id=0;
                            break;
        case BT10_R0        :
                            RB2_SEND_CMD("EnableRobot()");
                            RB2_CMD_WAIT(RB_SWAIT);
                            RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）  
                            if(RB2_R_GET !=0.0){
                                lcd_print("t0","ハンド整列 0度"); 
                                RB2_MovJ(RB2_X_GET,RB2_Y_GET,RB2_Z_GET,0,0,0,RB2_SPEED_ADJ,RB2_ACC_ADJ);
                                RB2_MOVE_WAIT(10000);
                                RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）  
                                lcd_print("t0","ハンド整列 0度移動完了"); 
                            }else{
                                lcd_print("t0","現在位置です");   
                            }   
                            touch_id=0;
                            break;
        case BT10_RM90     :
                            RB2_SEND_CMD("EnableRobot()");
                            RB2_CMD_WAIT(RB_SWAIT);
                            RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）  
                            if(RB2_R_GET !=-90.0){
                                lcd_print("t0","ハンド整列 -90度"); 
                                RB2_MovJ(RB2_X_GET,RB2_Y_GET,RB2_Z_GET,-90,0,0,RB2_SPEED_ADJ,RB2_ACC_ADJ);
                                RB2_MOVE_WAIT(10000);
                                lcd_print("t0","ハンド整列 -90度移動完了"); 
                            }else{
                                lcd_print("t0","現在位置です");   
                            }
                            RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）  
 
                            touch_id=0;
                            break;
        case BT10_RP90     :
                            RB2_SEND_CMD("EnableRobot()");
                            RB2_CMD_WAIT(RB_SWAIT);
                            RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）  
                            if(RB2_R_GET !=90.0){
                                lcd_print("t0","ハンド整列 90度"); 
                                RB2_MovJ(RB2_X_GET,RB2_Y_GET,RB2_Z_GET,90,0,0,RB2_SPEED_ADJ,RB2_ACC_ADJ);
                                RB2_MOVE_WAIT(10000);
                                RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）  
                                lcd_print("t0","ハンド整列 90度移動完了");    
                            }else{
                                lcd_print("t0","現在位置です");   
                            }
                            touch_id=0;
                            break;
        case BT10_RM180     :
                            RB2_SEND_CMD("EnableRobot()");
                            RB2_CMD_WAIT(RB_SWAIT);
                            RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）
                            if(RB2_R_GET !=-180.0){
                                lcd_print("t0","ハンド整列 -180度"); 
                                RB2_MovJ(RB2_X_GET,RB2_Y_GET,RB2_Z_GET,-180,0,0,RB2_SPEED_ADJ,RB2_ACC_ADJ);
                                RB2_MOVE_WAIT(10000);
                                lcd_print("t0","ハンド整列 -180度移動完了"); 
                            }else{
                                lcd_print("t0","現在位置です");   
                            }
                            RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）  
 
                            touch_id=0;
                            break;
        case BT10_RP180     :
                            RB2_SEND_CMD("EnableRobot()");
                            RB2_CMD_WAIT(RB_SWAIT);
                            RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）
                            if(RB2_R_GET !=180.0){
                                lcd_print("t0","ハンド整列 180度"); 
                                RB2_MovJ(RB2_X_GET,RB2_Y_GET,RB2_Z_GET,180,0,0,RB2_SPEED_ADJ,RB2_ACC_ADJ);
                                RB2_MOVE_WAIT(10000);
                                RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）  
                                lcd_print("t0","ハンド整列 180度移動完了");    
                            }else{
                                lcd_print("t0","現在位置です");   
                            }
                            touch_id=0;
                            break;
                                
        case BT10_SPD_M     : 
                            
                            if(RB2_SPEED_ADJ>=5){
                                //RB2_SPEED_SET(RB2_SPEED_ADJ-5);   
                                RB2_SPEED_ADJ=RB2_SPEED_ADJ-5;
                                sprintf(lcd_print_buf,"%03d",RB2_SPEED_ADJ);
                                lcd_print("t9",lcd_print_buf);
                                lcd_progressbar("j0",RB2_SPEED_ADJ,50);//プログレスバー表示が50になる wait 50ms
                                wait_ms(300);
                            }else{
                                lcd_print("t0","下限値です");
                            }
                            touch_id=0;
                            break;
        case BT10_SPD_P     : 
                            if(RB2_SPEED_ADJ<=95){
                                //RB2_SPEED_SET(RB2_SPEED_ADJ+5);   
                                RB2_SPEED_ADJ=RB2_SPEED_ADJ+5;
                                sprintf(lcd_print_buf,"%03d",RB2_SPEED_ADJ);
                                lcd_print("t9",lcd_print_buf);
                                lcd_progressbar("j0",RB2_SPEED_ADJ,50);//プログレスバー表示が50になる wait 50ms
                                wait_ms(300);
                            }else{
                                lcd_print("t0","上限値です");
                            }
                            touch_id=0;
                            break;
                            
        case BT10_PSAVE      :
                            lcd_print("t0","位置保存");
                            RB2_PSEL=nx_val_get("cb0");
                            ///ダイレクトティーチング用に位置を取り込んでから保存////
                            RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している） 
                            RB2_SEND_CMD("EnableRobot()");//ダイレクトティーチの場合一度イネーブルをなげないとmovコマンドが使えない
                            RB2_CMD_WAIT(RB_SWAIT); 
                            RB2_PSEL_BAK=0xFF;
                            ////////////////////////////////////////////////
                            RB2_POINT_RD[RB2_PSEL][PX]=RB2_X_GET;
                            RB2_POINT_RD[RB2_PSEL][PY]=RB2_Y_GET;
                            RB2_POINT_RD[RB2_PSEL][PZ]=RB2_Z_GET;
                            RB2_POINT_RD[RB2_PSEL][PR]=RB2_R_GET;                            
                            RB2_LIST_WRITE();//保存
                            lcd_print("t0","位置保存完了");
                            touch_id=0;
                            break;
        case BT10_MOVE      :
                            if(RB2_PSEL_BAK==RP_WORK_DW){
                                if(RB2_PSEL !=RP_WORK_UP){
                                    lcd_print("t0","ロボットを上昇させてから移動させてください。");
                                    lcd_audio_play( AU_ERR,0,80);
                                    touch_id=0;
                                    break;      
                                }                          
                            } 
                            sprintf(lcd_print_buf,"移動開始 :%02d",RB2_PSEL);
                            lcd_print("t0",lcd_print_buf);
                            RB2_SEND_CMD("EnableRobot()");
                            RB2_CMD_WAIT(RB_SWAIT);

                            RB2_SEL_MOVE(RB2_PSEL,RB2_SPEED_ADJ,RB2_ACC_ADJ);
                            RB2_MOVE_WAIT(5000);
                            RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）     
                            lcd_print("t0","移動完了");
                            touch_id=0;
                            break;
        case BT10_ROSGET     ://位置表示更新///
                            //ダイレクトティーチ時に手で動かした座標を取得する　＊EnableRobot()しないとMOVコマンドが使用できない
                            RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している） 
                            RB2_SEND_CMD("EnableRobot()");
                            RB2_CMD_WAIT(RB_SWAIT); 
                            RB2_PSEL_BAK=0xFF;
                            touch_id=0;
                            break;
        case BT10_X_KEY     :
                            lcd_page_set(P_ROBO2_KEY,100);
                            sprintf(lcd_print_buf,"%8.4lf",RB2_X_GET);
                            lcd_print("t0",lcd_print_buf);
                            EDIT_SEL=PX;
                            touch_id=0;
                            break;
        case BT10_Y_KEY     :
                            lcd_page_set(P_ROBO2_KEY,100);
                            sprintf(lcd_print_buf,"%8.4lf",RB2_Y_GET);
                            lcd_print("t0",lcd_print_buf);
                            EDIT_SEL=PY;
                            touch_id=0;
                            break;
        case BT10_Z_KEY     :
                            lcd_page_set(P_ROBO2_KEY,100);
                            sprintf(lcd_print_buf,"%8.4lf",RB2_Z_GET);
                            lcd_print("t0",lcd_print_buf);
                            EDIT_SEL=PZ;
                            touch_id=0;
                            break;
        case BT10_R_KEY     :
                            lcd_page_set(P_ROBO2_KEY,100);
                            sprintf(lcd_print_buf,"%8.4lf",RB2_R_GET);
                            lcd_print("t0",lcd_print_buf);
                            EDIT_SEL=PR;
                            touch_id=0;
                            break;
        case BT10_LWD_PU     :
                            lcd_print("t0","加圧軸1 加圧位置");
                            PS1_MOVE2(EWAIT_ENB);
                            touch_id=0;
                            break;
        case BT10_LWD_WT     :
                            lcd_print("t0","加圧軸1 待機位置");
                            PS1_MOVE0(EWAIT_ENB);
                            touch_id=0;
                            break;
        case BT10_RWD_PU     :
                            lcd_print("t0","加圧軸2 加圧位置");
                            PS2_MOVE2(EWAIT_ENB);
                            touch_id=0;
                            break;
        case BT10_RWD_WT     :
                            lcd_print("t0","加圧軸2 待機位置");
                            PS2_MOVE0(EWAIT_ENB);
                            touch_id=0;
                            break;
        case BT10_R_HAND     :
                            //RB2_SEND_CMD("EnableRobot()");//だんまり防止テスト（治具干渉するとだんまりになる？？）
                            //RB2_CMD_WAIT(RB_SWAIT);
                            if(RB2_HAND_ST!=RB2_HAND_CLOSE){
                                RB2_HAND_CONT(RB2_HAND_CLOSE);
                                lcd_bc_color_chg("b6",LCD_RED,50);   
                            }else{
                                RB2_HAND_CONT(RB2_HAND_OPEN);
                                lcd_bc_color_chg("b6",65520,50);         
                            }
                            touch_id=0;
                            break;
        case BT10_WORK_WT    ://ワーク搬送軸//////
                             if(RB1_PSEL_BAK==RP_WORK_UP || RB1_PSEL_BAK==RP_WORK_DW){
                                lcd_print("t0","ロボット１が干渉位置にあります。");
                                lcd_audio_play( AU_ERR,0,80);
                                touch_id=0;
                                break;                                
                            }
                            if(RB2_PSEL_BAK==RP_WORK_UP || RB2_PSEL_BAK==RP_WORK_DW){
                                lcd_print("t0","ロボット２が干渉位置にあります。");
                                lcd_audio_play( AU_ERR,0,80);
                                touch_id=0;
                                break;                                
                            }
                            if(WT_POS_ST!=POS_WT_WAIT){
                                lcd_print("t0","投入待機位置移動開始");
                                WT_MOVE(POS_WT_WAIT);
                                WT_MOVE_EWAIT();
                                lcd_print("t0","投入待機位置移動完了");
                            }else{
                                 lcd_print("t0","現在位置です。");
                            }
                            touch_id=0;
                            break;
        case BT10_WORK_EJ    ://ワーク搬送軸//////
                            if(RB1_PSEL_BAK==RP_WORK_UP || RB1_PSEL_BAK==RP_WORK_DW){
                                lcd_print("t0","ロボット１が干渉位置にあります。");
                                lcd_audio_play( AU_ERR,0,80);
                                touch_id=0;
                                break;                                
                            }
                            if(RB2_PSEL_BAK==RP_WORK_UP || RB2_PSEL_BAK==RP_WORK_DW){
                                lcd_print("t0","ロボット２が干渉位置にあります。");
                                lcd_audio_play( AU_ERR,0,80);
                                touch_id=0;
                                break;                                
                            }
                            if(WT_POS_ST!=POS_WT_EJECT){
                                lcd_print("t0","排出位置移動開始");
                                WT_MOVE(POS_WT_EJECT);
                                WT_MOVE_EWAIT();
                                lcd_print("t0","排出位置移動開始完了");
                            }else{
                                lcd_print("t0","現在位置です。");      
                            }
                            touch_id=0;
                            break;
        case BT10_WORK_ST    ://ワーク搬送軸//////
                            if(RB1_PSEL_BAK==RP_WORK_DW){
                                lcd_print("t0","ロボット１が干渉位置にあります。");
                                lcd_audio_play( AU_ERR,0,80);
                                touch_id=0;
                                break;                                
                            }
                            if(RB2_PSEL_BAK==RP_WORK_DW){
                                lcd_print("t0","ロボット２が干渉位置にあります。");
                                lcd_audio_play( AU_ERR,0,80);
                                touch_id=0;
                                break;                                
                            }
                            if(WT_POS_ST!=POS_WT_START){
                                lcd_print("t0","作業開始位置移動開始");
                                WT_MOVE(POS_WT_START);
                                WT_MOVE_EWAIT();
                                lcd_print("t0","作業開始位置位置移動開始完了");
                            }else{
                                lcd_print("t0","現在位置です。");      
                            }
                            touch_id=0;
                            break;
                      
                        
        case BT10_BACK     : 
                            lcd_page_set(P_MAIN,100);
                            MAIN_PAGE_DISP();
                            RB2_SPEED_SET(RB_HIGH);
                            RB2_SEND_CMD("EnableRobot()");
                            RB2_CMD_WAIT(RB_SWAIT);
                            touch_id=0;
                            break;
    }
    //コントローラ制御//
    PS3_ROBO2_CONT();
    if(RB2_POSE_DISP_EN==1){
         RB2_POSE_DISP();//座標表示（このなかでIDLEになっているかも確認している）     
    }
    if(touch_id==0 && tp_mask==1) {
        tp_mask=0;//1=タッチパネルマスク
    }

}