#include "mbed.h"
#include "main.h"
#include "nextion_lcd.h"
#include "APP.h"
#include "WORK_START.h"
///////////////////////
#include "ROBO1_CONT.h"
#include "ROBO2_CONT.h"
#include "ROBO_TWIN_CONT.h"
#include "SAVE_CONT.h"
///////////////////////
#include "PS3_BT_CTL.h"
/////////////////////////
#include "WD_CONT.h"
#include "IO_CONT.h"
#include "DiNi_supplyr.h"

void BARCHG_PAGE(void){
    /////////////////////////////////page 3 極棒交換画面の操作//////////////////////////////////////
    if(touch_id!=0) {
        tp_mask=1;//1=タッチパネルマスク
    }
 switch (touch_id) {
        ////caseはnextion lcdのSWに割り当てられたidを記載する///

        case BT3_PU1_WAIT   :  //加圧軸１　待機位置(後退)
                                lcd_print("t0","加圧軸1 待機位置");
                                PS1_MOVE0(EWAIT_ENB);
                                touch_id=0;
                                break;
        case BT3_PU1_RT     :   //加圧軸1回転位置（中点）
                                if(HAND1_ESC_F==1){//1でハンド退避済み（左側極棒交換用）
                                    lcd_print("t0","加圧軸1 回転位置");
                                    PS1_MOVE1(EWAIT_ENB);
                                }else{
                                    lcd_print("t0","ハンド退避してください。");
                                }
                                touch_id=0;
                                break;
        case BT3_PU1_PU     :   //加圧軸１　加圧位置(前進)
                                if(HAND1_ESC_F==1){//1でハンド退避済み（左側極棒交換用）
                                    lcd_print("t0","加圧軸1 加圧位置");
                                    PS1_MOVE2(EWAIT_ENB);
                                }else{
                                    lcd_print("t0","ハンド退避してください。");
                                }
                                touch_id=0;
                                break;
        case BT3_WD1_ST    :   //ヘッド1溶接開始
                                if(HAND1_ESC_F==1){//1でハンド退避済み（左側極棒交換用）
                                    WD_HEAD1_START(1,HEAD_ESC_EN);
                                }else{
                                    lcd_print("t0","ハンド退避してください。");
                                }
                                touch_id=0;
                                break;
        case BT3_WD1_RT     :  //ヘッド1極棒回転
                                HEAD1_RT();
                                touch_id=0;
                                break;
        case BT3_CT1_HESC    :  ///端子供給機0ハンド退避
                                C1_WD_FET_CONT(FET_OFF);//極棒押し当て解除
                                wait_ms(200);
                                C1_MOVE(POS_WAIT_3MM );
                                C1_MOVE_SWAIT();
                                C1_HAND_FET_CONT(FET_OFF);//ハンド開 
                                C1_MOVE_EWAIT();  
                                HAND1_ESC_F=1;//1でハンド退避済み（左側極棒交換用）
                                touch_id=0;
                                break;                        
        //////////////////////////////////////////////////////////////////////////////   
        case BT3_PU2_WAIT   :  //加圧軸2　待機位置(後退)
                                lcd_print("t0","加圧軸2 待機位置");
                                PS2_MOVE0(EWAIT_ENB);
                                touch_id=0;
                                break;
        case BT3_PU2_RT     :   //加圧軸2回転位置（中点）
                                if(HAND2_ESC_F==1){//1でハンド退避済み（右側極棒交換用）
                                    lcd_print("t0","加圧軸2 回転位置");
                                    PS2_MOVE1(EWAIT_ENB);
                                }else{
                                    lcd_print("t0","ハンド退避してください。");
                                }
                                touch_id=0;
                                break;
        case BT3_PU2_PU     :   //加圧軸2　加圧位置(前進)
                                if(HAND2_ESC_F==1){//1でハンド退避済み（右側極棒交換用）
                                    lcd_print("t0","加圧軸2 加圧位置");
                                    PS2_MOVE2(EWAIT_ENB);
                                }else{
                                    lcd_print("t0","ハンド退避してください。");
                                }
                                touch_id=0;
                                break;
        case BT3_WD2_ST    :   //ヘッド2溶接開始
                                if(HAND2_ESC_F==1){//1でハンド退避済み（右側極棒交換用）
                                    WD_HEAD2_START(2,HEAD_ESC_EN);
                                }else{
                                    lcd_print("t0","ハンド退避してください。");
                                }
                                touch_id=0;
                                break;
        case BT3_WD2_RT     :  //ヘッド1極棒回転
                                HEAD2_RT();
                                touch_id=0;
                                break;
        case BT3_CT2_HESC    : ///端子供給機2ハンド退避
                                C2_WD_FET_CONT(FET_OFF);//極棒押し当て解除
                                wait_ms(200);
                                C2_MOVE(POS_WAIT_3MM );
                                C2_MOVE_SWAIT();
                                C2_HAND_FET_CONT(FET_OFF);//ハンド開 
                                C2_MOVE_EWAIT();   
                                HAND2_ESC_F=1;//1でハンド退避済み（右側極棒交換用）
                                touch_id=0;
                                break;
         //////////////////////////////////////////////////////////////////////////////                       


        case BT3_SET        :
        
                                 //=Φ４のみ　2=Φ３平のみ 3=Φ３丸のみ、4=Φ４+Φ３平、5=Φ４+Φ３丸、6=Φ３平＋Φ３丸、7=全て
                                if(BAR_CHG_MODE==1){
                                    WD1H_CHG_CNT=0;
                                }
                                if(BAR_CHG_MODE==2){
                                    WD2H_CHG_CNT=0;
                                }
                                if(BAR_CHG_MODE==3){
                                    WD2R_CHG_CNT=0;
                                }
                                if(BAR_CHG_MODE==4){
                                    WD1H_CHG_CNT=0;
                                    WD2H_CHG_CNT=0;
                                }                       
                                if(BAR_CHG_MODE==5){
                                    WD1H_CHG_CNT=0;
                                    WD2R_CHG_CNT=0;
                                }                                 
                                if(BAR_CHG_MODE==6){
                                    WD2H_CHG_CNT=0;
                                    WD2R_CHG_CNT=0;
                                }  
                                if(BAR_CHG_MODE==7){
                                    WD1H_CHG_CNT=0;
                                    WD2H_CHG_CNT=0;
                                    WD2R_CHG_CNT=0;
                                }
                            
                                BAR_CHG_MODE=0;//0=交換なし  1=極棒1のみ　2=極棒2のみ 3=極棒1,2両方
                                lcd_page_set(P_MAIN,50);
                                MAIN_PAGE_DISP();
                                BAR_CHG_DISP_F=0;
                                HAND1_ESC_F=0;//1でハンド退避済み（左側極棒交換用）
                                HAND2_ESC_F=0;//1でハンド退避済み（右側極棒交換用）
                                touch_id=0;
                                break;

    }

    if(touch_id==0 && tp_mask==1) { //タッチパネルに割りつけた作業がおわったらセンサ開始再開
        tp_mask=0;//1=タッチパネルマスク
    }


}
    
