#include "mbed.h"
#include "main.h"
#include "nextion_lcd.h"
#include "APP.h"
#include "WORK_START.h"
///////////////////////
#include "ROBO1_CONT.h"
#include "ROBO2_CONT.h"
#include "ROBO_TWIN_CONT.h"
#include "SAVE_CONT.h"
///////////////////////
#include "PS3_BT_CTL.h"
/////////////////////////
#include "WD_CONT.h"
#include "CUT_CONT.h"
#include "DiNi_supplyr.h"
#include "IO_CONT.h"

unsigned char tp_mask=0;//1=タッチパネルマスク
unsigned char ETHE_CONE_F=0;//1イーサー接続中

#define HAND_OPEN  0
#define HAND_CLOSE 1
Timer t_tact;//タクト確確認用
float time_chk=0;
float tact_chk=0;//タクト確認用

Timer t_test;//試験用タイマー

unsigned char MUTE_ST=0;//1で消音状態
unsigned char RB_SPEED_ST=RB_HIGH;

/////////時計///////////
unsigned int  rtc_year=2000;    //年
unsigned char rtc_month=1;      //月
unsigned char rtc_date=1;      //日
unsigned char rtc_hour=10;      //時
unsigned char rtc_min=20;    //分
unsigned char rtc_sec=30;       //秒

unsigned char LOOP_MODE_F=0;//1でループモードON 
unsigned char STEP_MODE_F=0;//1でステップモードON 

unsigned char WORK_STEP=0;  //ワークステップ（一連動作の進捗）
unsigned char WORK_STATE=0; //作業中フラグ(1=作業中 0=待機中)
unsigned char HOME_STATE=0; //原点復帰実行監視（1=原点復帰済み 0=未実施)


unsigned char W_STEP_END=0;//ワークステップの最後の処理が終了時に1

unsigned char STEP_STBY_F=0;//ステップ実行準備完了フラグ 1で準備完了
unsigned char CUT1_STBY_CHK=0;//1で準備完了（初回端子カット済み）
unsigned char CUT2_STBY_CHK=0;//1で準備完了（初回端子カット済み）

unsigned char WD_JUDG_DISP_F=0;//1で溶接結果確認画面表示
unsigned char BAR_CHG_DISP_F=0;//1で極棒交換画面表示

unsigned char HAND1_ESC_F;//1でハンド退避済み（左側極棒交換用）
unsigned char HAND2_ESC_F;//1でハンド退避済み（右側極棒交換用）

unsigned char RB1_PSEL=0;//ロボット1ポジションセレクト
unsigned char RB2_PSEL=0;//ロボット2ポジションセレクト
unsigned char HAND_RT_ST=0xFF;//調整モードでのハンド角度

unsigned char EDIT_SEL=0;
double EDIT_DATA=0.0;

unsigned char RB1_POSE_DISP_EN=0;//1:JOG動作中の位置表示リアルタイム更新有効
unsigned char RB2_POSE_DISP_EN=0;//1:JOG動作中の位置表示リアルタイム更新有効
unsigned char MOVE_MODE_ST=0;//0=通常　1=JOG

extern double POINT_RD[32][4];
////////////////DUAROより移植///////////////

unsigned char ERR_ST=ERR_NONE;//ALM状態
unsigned char ALM_ST=ALM_NONE;//ALM状態
///極棒交換回数設定用///

unsigned long WD1H_CHG_SET_DAT=0;//極棒交換回数

unsigned char WD1H_CHGDAT_4=0;
unsigned char WD1H_CHGDAT_3=0;
unsigned char WD1H_CHGDAT_2=0;
unsigned char WD1H_CHGDAT_1=0;



unsigned long WD2H_CHG_SET_DAT=0;//極棒交換回数

unsigned char WD2H_CHGDAT_4=0;
unsigned char WD2H_CHGDAT_3=0;
unsigned char WD2H_CHGDAT_2=0;
unsigned char WD2H_CHGDAT_1=0;

unsigned long WD2R_CHG_SET_DAT=0;//極棒交換回数

unsigned char WD2R_CHGDAT_4=0;
unsigned char WD2R_CHGDAT_3=0;
unsigned char WD2R_CHGDAT_2=0;
unsigned char WD2R_CHGDAT_1=0;


unsigned char BAR_CHG_MODE=0;//0=交換なし  1=極棒1のみ　2=極棒2のみ 3=極棒1,2両方
unsigned char PSTB_LOK_F=0;//1=引っ張り試験準備ok左側
unsigned char PSTB_ROK_F=0;//1=引っ張り試験準備ok右側
/////生産数設定用///////////////////
unsigned long PD_CNT_A=0;
unsigned long PD_CNT_C=0;
unsigned long PD_SET_DAT=0;//生産数設定

unsigned char PD_CHGDAT_4=0;
unsigned char PD_CHGDAT_3=0;
unsigned char PD_CHGDAT_2=0;
unsigned char PD_CHGDAT_1=0;


unsigned char PD_CNT_A_3=0;
unsigned char PD_CNT_A_2=0;
unsigned char PD_CNT_A_1=0;

unsigned char PD_CNT_C_3=0;
unsigned char PD_CNT_C_2=0;
unsigned char PD_CNT_C_1=0;

unsigned char TEST_MODE_EN=0; //1=テストモード
////////////////DUAROより移植///////////////
/////端子切断機用///////////////////
unsigned char ADJ_DAT_3=0;
unsigned char ADJ_DAT_2=0;
unsigned char ADJ_DAT_1=0;
unsigned char ADJ_MODE=0;//0=50 1=32 2=23


void ALM_HOLD_SET(){
    ///ALM情報の記録///
    lcd_page_set(P_EMG_STOP,100);
    ALM_INFO_SAVE();
    if(ALM_HOLD==1){
        wait_ms(2000);
        for(;;);
    }
}
////nextion lcdのrtcを読み込む////現状2048年まで対応 *rtc0のデータを2byte読み込みにすれば、以降も対応可能
////RTC_GET()は、LCD UARTの受信割り込みにより取得されるので、他の割り込み内でコールしないこと。
void RTC_GET(void){
    //1=タッチパネルマスク（タッチパネルマスク状態では、LCDからのデータ受信ができない為、RTC読み込み時は、マスク解除する）
    tp_mask=0;
    
    rtc_year=nx_get("rtc0")+1792;
    rtc_month=nx_get("rtc1");
    rtc_date=nx_get("rtc2");
    rtc_hour=nx_get("rtc3");
    rtc_min=nx_get("rtc4");
    rtc_sec=nx_get("rtc5");
    //sprintf(lcd_print_buf,"%04d/%02d/%02d---%02d:%02d:%02d",rtc_year, rtc_month, rtc_date, rtc_hour, rtc_min, rtc_sec);
    //lcd_print("t0",lcd_print_buf);
    tp_mask=1;//1=タッチパネルマスク
  
}


//極棒交換回数のチェック///
void  BAR_CHG_CHK()
{
    unsigned long WD1H_CHG_CHK=0xFFFF;
    unsigned long WD2H_CHG_CHK=0xFFFF;
    unsigned long WD2R_CHG_CHK=0xFFFF;
    
    //////交換回数設定が0以外の時だけチェックする///////
    if(WD1H_CHG_SET_DAT != 0){
       WD1H_CHG_CHK= WD1H_CHG_SET_DAT;
    }
    if(WD2H_CHG_SET_DAT != 0){
       WD2H_CHG_CHK= WD2H_CHG_SET_DAT;
    }  
    if(WD2R_CHG_SET_DAT != 0){
       WD2R_CHG_CHK= WD2R_CHG_SET_DAT ; 
    }
    /////////////////////////////////////////////////
    //BAR_CHG_MODE=0;
    //0=交換なし  1=Φ４のみ　2=Φ３平のみ 3=Φ３丸のみ、4=Φ４+Φ３平、5=Φ４+Φ３丸、6=Φ３平＋Φ３丸、7=全て
    //1=Φ４のみ
    if(WD1H_CHG_CNT>=WD1H_CHG_CHK && WD2H_CHG_CNT<WD2H_CHG_CHK &&WD2R_CHG_CNT<WD2R_CHG_CHK) {
        BAR_CHG_MODE=1;
    }
    //2=Φ３平のみ
    if(WD1H_CHG_CNT<WD1H_CHG_CHK && WD2H_CHG_CNT>=WD2H_CHG_CHK &&WD2R_CHG_CNT<WD2R_CHG_CHK) {
        BAR_CHG_MODE=2;
    }
    
    //3=Φ３丸のみ
    if(WD1H_CHG_CNT<WD1H_CHG_CHK && WD2H_CHG_CNT<WD2H_CHG_CHK &&WD2R_CHG_CNT>=WD2R_CHG_CHK) {
        BAR_CHG_MODE=3;
    }
    //4=Φ４+Φ３平
    if(WD1H_CHG_CNT>=WD1H_CHG_CHK && WD2H_CHG_CNT>=WD2H_CHG_CHK &&WD2R_CHG_CNT<WD2R_CHG_CHK) {
        BAR_CHG_MODE=4;
    } 
    //5=Φ４+Φ３丸
    if(WD1H_CHG_CNT>=WD1H_CHG_CHK && WD2H_CHG_CNT<WD2H_CHG_CHK &&WD2R_CHG_CNT>=WD2R_CHG_CHK) {
        BAR_CHG_MODE=5;
    } 
    //6=Φ３平＋Φ３丸
    if(WD1H_CHG_CNT<WD1H_CHG_CHK && WD2H_CHG_CNT>=WD2H_CHG_CHK &&WD2R_CHG_CNT>=WD2R_CHG_CHK) {
        BAR_CHG_MODE=6;
    }   
    //、7=全て
    if(WD1H_CHG_CNT>=WD1H_CHG_CHK && WD2H_CHG_CNT>=WD2H_CHG_CHK &&WD2R_CHG_CNT>=WD2R_CHG_CHK) {
        BAR_CHG_MODE=7;   
    }    
    if(BAR_CHG_MODE !=0){
        BAR_CHG_DISP_F=1;//1で極棒交換画面表示 
        //printf("BAR_CHG_MODE = %d\r\n",BAR_CHG_MODE);
        //printf("WD1H_CHG_CNT = %d  WD2H_CHG_CNT = %d WD2R_CHG_CNT =%d\r\n",WD1H_CHG_CNT,WD2H_CHG_CNT,WD2R_CHG_CNT);
       //printf("WD1H_CHG_CHK = %d  WD2H_CHG_CHK = %d WD2R_CHG_CHK =%d\r\n",WD1H_CHG_CHK,WD2H_CHG_CHK,WD2R_CHG_CHK);
    }                  
}


void BC_SET_DISP()
{
    //Φ４平
    sprintf(lcd_print_buf,"%01d",WD1H_CHGDAT_4);
    lcd_print("t5",lcd_print_buf);
    sprintf(lcd_print_buf,"%01d",WD1H_CHGDAT_3);
    lcd_print("t10",lcd_print_buf);
    sprintf(lcd_print_buf,"%01d",WD1H_CHGDAT_2);
    lcd_print("t13",lcd_print_buf);
    sprintf(lcd_print_buf,"%01d",WD1H_CHGDAT_1);
    lcd_print("t14",lcd_print_buf);
    
    ///Φ３平
    sprintf(lcd_print_buf,"%01d",WD2H_CHGDAT_4);
    lcd_print("t0",lcd_print_buf);
    sprintf(lcd_print_buf,"%01d",WD2H_CHGDAT_3);
    lcd_print("t1",lcd_print_buf);
    sprintf(lcd_print_buf,"%01d",WD2H_CHGDAT_2);
    lcd_print("t2",lcd_print_buf);
    sprintf(lcd_print_buf,"%01d",WD2H_CHGDAT_1);
    lcd_print("t3",lcd_print_buf);

     ///Φ３丸
    sprintf(lcd_print_buf,"%01d",WD2R_CHGDAT_4);
    lcd_print("t6",lcd_print_buf);
    sprintf(lcd_print_buf,"%01d",WD2R_CHGDAT_3);
    lcd_print("t7",lcd_print_buf);
    sprintf(lcd_print_buf,"%01d",WD2R_CHGDAT_2);
    lcd_print("t8",lcd_print_buf);
    sprintf(lcd_print_buf,"%01d",WD2R_CHGDAT_1);
    lcd_print("t9",lcd_print_buf);
}




//溶接判定画面の内容表示///
void WD_JUDG_DISP(){
 
        lcd_print("t0","溶接NGの場所がチェックされています。確認してください。");
        
        ///////平極棒//////////
        nx_val_set("c0",WD_JUDG_1[0]);
        wait_ms(10);
        nx_val_set("c1",WD_JUDG_1[1]);
        wait_ms(10);
        nx_val_set("c2",WD_JUDG_1[2]);
        wait_ms(10);        
        nx_val_set("c3",WD_JUDG_1[3]);
        wait_ms(10);        
        nx_val_set("c4",WD_JUDG_1[4]);
        wait_ms(10);       
        nx_val_set("c5",WD_JUDG_1[5]);
        wait_ms(10);       
        nx_val_set("c6",WD_JUDG_1[6]);
        wait_ms(10);   
        nx_val_set("c7",WD_JUDG_1[7]);
        wait_ms(10);
        ///////平極棒//////////
        nx_val_set("c8",WD_JUDG_2[0]);
        wait_ms(10);
        nx_val_set("c9",WD_JUDG_2[1]);
        wait_ms(10);
        nx_val_set("c10",WD_JUDG_2[2]);
        wait_ms(10);
        nx_val_set("c11",WD_JUDG_2[3]);
        wait_ms(10);
        nx_val_set("c12",WD_JUDG_2[4]);
        wait_ms(10);
        nx_val_set("c13",WD_JUDG_2[5]);
        wait_ms(10);
        nx_val_set("c14",WD_JUDG_2[6]);
        wait_ms(10);
        nx_val_set("c15",WD_JUDG_2[7]);
        wait_ms(10);
        //lcd_audio_play(AU_ALM,0,80);
        //wait_ms(2000);
    
}

//一時停止画面の内容表示（作業画面からの一時停止）
void POUSE_PAGE_DISP() //一時停止表示
{
    ///溶接確認暫定処置///
    if(ERR_ST==ERR_WDNG_1) {
        lcd_print("t0","溶接NG（左） 一時停止しました");
        lcd_print("t1","溶接コンパレート外れ（左）");
    }
    if(ERR_ST==ERR_WDNG_1) {
        lcd_print("t0","溶接NG（右） 一時停止しました");
        lcd_print("t1","溶接コンパレート外れ（右）");
    }
    if(ERR_ST==ERR_WDNG_12) {//2022/04/09 追加
        lcd_print("t0","溶接NG（左右） 一時停止しました");
        lcd_print("t1","溶接コンパレート外れ（左右）");
    }

    /*if(ERR_ST==ERR_AREA ) {
        lcd_print("t0","エリアセンサ検出です。");
        
    }
    */
    if(ERR_ST==ERR_NONE) {
        lcd_print("t0","一時停止しました");
        lcd_print("t1","タッチパネル操作により停止しました。");
        
    }
    sprintf(lcd_print_buf,"%02d",WORK_STEP);
    lcd_print("t3",lcd_print_buf);
    

}

void ROBO1_ADJ_DISP(){
    RB1_SPEED_SET(RB_LOW);
    sprintf(lcd_print_buf,"%03d",RB1_SPEED_ADJ);
    lcd_print("t9",lcd_print_buf);
    lcd_progressbar("j0",RB1_SPEED_ADJ,50);//プログレスバー表示が50になる wait 50ms
    RB1_GETPOS(3000);
    RB1_POSE_DISP();
    //////////////////////////
    sprintf(lcd_print_buf,"00:%s",RB1_point_txt[0]);
    lcd_print("cb0",lcd_print_buf);
    for(unsigned char cnt=0; cnt<RB1_POINT_NO_CNT ;cnt++){
        if(cnt !=RB1_POINT_NO_CNT-1){
            sprintf(lcd_print_buf,"%02d:%s\r\n",cnt,RB1_point_txt[cnt]);
        }else{//最後だけは、改行なしにしいないと余白ができる
            sprintf(lcd_print_buf,"%02d:%s",cnt,RB1_point_txt[cnt]);
        }
        lcd_print_cb("cb0", lcd_print_buf);
        //printf(lcd_print_buf);
    }
    ////////////////////////////
    RB1_PSEL=nx_val_get("cb0");

    if(RB1_HAND_ST==RB1_HAND_CLOSE){
        lcd_bc_color_chg("b6",LCD_RED,50);   
    }else{
        lcd_bc_color_chg("b6",65520,50);         
    }
}
void ROBO2_ADJ_DISP(){
    RB2_SPEED_SET(RB_LOW);
    sprintf(lcd_print_buf,"%03d",RB2_SPEED_ADJ);
    lcd_print("t9",lcd_print_buf);
    lcd_progressbar("j0",RB2_SPEED_ADJ,50);//プログレスバー表示が50になる wait 50ms
    RB2_GETPOS(3000);
    RB2_POSE_DISP();
    //////////////////////////
    sprintf(lcd_print_buf,"00:%s",RB2_point_txt[0]);
    lcd_print("cb0",lcd_print_buf);
    for(unsigned char cnt=0; cnt<RB2_POINT_NO_CNT ;cnt++){
         if(cnt !=RB2_POINT_NO_CNT-1){
            sprintf(lcd_print_buf,"%02d:%s\r\n",cnt,RB2_point_txt[cnt]);
        }else{//最後だけは、改行なしにしいないと余白ができる
            sprintf(lcd_print_buf,"%02d:%s",cnt,RB2_point_txt[cnt]);
        }
        lcd_print_cb("cb0", lcd_print_buf);
       // printf(lcd_print_buf);
    }
    ////////////////////////////
    RB2_PSEL=nx_val_get("cb0");
    if(RB2_HAND_ST==RB2_HAND_CLOSE){
        lcd_bc_color_chg("b6",LCD_RED,50);   
    }else{
        lcd_bc_color_chg("b6",65520,50);         
    }
    
}
///停止条件確認///
void PAUSE_CHK(){
    
     ////一時停止:優先度１画面切り替え///
    if(PAUSE_F==1 ||ERR_ST!=ERR_NONE) {
        touch_id=0;
        LOOP_MODE_F=0;
        lcd_page_set(P_PAUSE,50);
        POUSE_PAGE_DISP();
        //通常の一次停止以外は、異常発生メッセージ
        if(PAUSE_F==1){

            lcd_audio_play(AU_PAUSE,0,80);
        }else{
            lcd_audio_play(AU_ALM,0,80);
  
        }
        wait_ms(2000);
    }
    ////溶接結果:優先度2画面切り替え///
    if(PAUSE_F==0 &&ERR_ST==ERR_NONE && WD_JUDG_DISP_F==1){//1で溶接結果確認画面表示
        touch_id=0;
        LOOP_MODE_F=0;
        ///溶接結果の確認(NGで継続した場合に、すべての溶接ポイントの結果を表示)
        lcd_page_set(P_WD_JUDGE,50);
        WD_JUDG_DISP();
          
    }
    ///極棒交換:優先度3画面切り替え///
    if(PAUSE_F==0 && ERR_ST==ERR_NONE && WD_JUDG_DISP_F==0 && BAR_CHG_DISP_F==1){
         touch_id=0;
         LOOP_MODE_F=0;
         lcd_page_set(P_BARCHG,50);
         if(BAR_CHG_MODE==1) {
            lcd_print("t0","Φ４の極棒を交換してください");
        }
        if(BAR_CHG_MODE==2){
            lcd_print("t0","Φ３の平極棒を交換してください");
        }
        if(BAR_CHG_MODE==3){
            lcd_print("t0","Φ３の丸極棒を交換してください");
        }
        if(BAR_CHG_MODE==4){
            lcd_print("t0","Φ４極棒とΦ３平極棒を交換してください");
        }
        if(BAR_CHG_MODE==5) {
            lcd_print("t0","Φ４極棒とΦ３丸極棒を交換してください");
        } 
        if(BAR_CHG_MODE==6) {
            lcd_print("t0","Φ３平極棒とΦ３丸極棒を交換してください");
        }     
        if(BAR_CHG_MODE==7) {
            lcd_print("t0","Φ４、Φ３全ての極棒を交換してください");
        }
        lcd_audio_play(AU_WDBAR_CHG,0,80);
        wait_ms(2000); 
        
    }   
    
}
void WD_CNT_DISP(){
    /////////////極棒交換打点数表示///////////
    sprintf(lcd_print_buf,"%04d/%04d",WD1H_CHG_CNT,WD1H_CHG_SET_DAT);
    lcd_print("t19",lcd_print_buf);
    sprintf(lcd_print_buf,"%04d/%04d",WD2H_CHG_CNT,WD2H_CHG_SET_DAT);
    lcd_print("t7",lcd_print_buf);
    sprintf(lcd_print_buf,"%04d/%04d",WD2R_CHG_CNT,WD2R_CHG_SET_DAT);
    lcd_print("t8",lcd_print_buf);    
    
}
void MAIN_PAGE_DISP(){
      
    //////生産数を桁数に分離して表示//
    PD_CNT_A_DISP();
    PD_CNT_C_DISP();
    /////////////極棒交換打点数表示///////////
    WD_CNT_DISP();
    if(MUTE_ST==1){
       lcd_bc_color_chg("b39",LCD_GRAY,50);
    }
    if(RB_SPEED_ST==RB_LOW){
       lcd_bc_color_chg("b40",LCD_RED,50);
    }
    if(TEST_MODE_EN==1) { //1=テストモード
        lcd_bc_color_chg("b11",LCD_RED,50);
    }
    if(STEP_MODE_F==1){//1でステップモードON 
        lcd_bc_color_chg("b26",LCD_RED,50);
    }
    
}
void TANSHI_L_DISP(){
    sprintf(lcd_print_buf,"%3.1f",C1_SET_50MM);
    lcd_print("t3",lcd_print_buf);
    
    sprintf(lcd_print_buf,"%3.1f",C1_SET_32MM);
    lcd_print("t4",lcd_print_buf);
    
    sprintf(lcd_print_buf,"%3.1f",C1_SET_23MM);
    lcd_print("t5",lcd_print_buf);    
    
    sprintf(lcd_print_buf,"%3.1f",C2_SET_50MM);
    lcd_print("t6",lcd_print_buf);
    
    sprintf(lcd_print_buf,"%3.1f",C2_SET_32MM);
    lcd_print("t7",lcd_print_buf);
    
    sprintf(lcd_print_buf,"%3.1f",C2_SET_23MM);
    lcd_print("t8",lcd_print_buf); 
}
void ADJ_DISP(){
    //左<0=50 1=32 2=23> 右<4=50 5=32 6=23>
    
    if(ADJ_MODE==0){
        ADJ_DAT_3=C1_RD_50MM/100;
        ADJ_DAT_2=(C1_RD_50MM-(ADJ_DAT_3*100))/10;
        ADJ_DAT_1=C1_RD_50MM-(ADJ_DAT_3*100+ADJ_DAT_2*10);
    }
    if(ADJ_MODE==1){
        ADJ_DAT_3=C1_RD_32MM/100;
        ADJ_DAT_2=(C1_RD_32MM-(ADJ_DAT_3*100))/10;
        ADJ_DAT_1=C1_RD_32MM-(ADJ_DAT_3*100+ADJ_DAT_2*10);
    }   
    if(ADJ_MODE==2){
        ADJ_DAT_3=C1_RD_23MM/100;
        ADJ_DAT_2=(C1_RD_23MM-(ADJ_DAT_3*100))/10;
        ADJ_DAT_1=C1_RD_23MM-(ADJ_DAT_3*100+ADJ_DAT_2*10);
    }      
    if(ADJ_MODE==3){
        ADJ_DAT_3=C2_RD_50MM/100;
        ADJ_DAT_2=(C2_RD_50MM-(ADJ_DAT_3*100))/10;
        ADJ_DAT_1=C2_RD_50MM-(ADJ_DAT_3*100+ADJ_DAT_2*10);
    }
    if(ADJ_MODE==4){
        ADJ_DAT_3=C2_RD_32MM/100;
        ADJ_DAT_2=(C2_RD_32MM-(ADJ_DAT_3*100))/10;
        ADJ_DAT_1=C2_RD_32MM-(ADJ_DAT_3*100+ADJ_DAT_2*10);
    }   
    if(ADJ_MODE==5){
        ADJ_DAT_3=C2_RD_23MM/100;
        ADJ_DAT_2=(C2_RD_23MM-(ADJ_DAT_3*100))/10;
        ADJ_DAT_1=C2_RD_23MM-(ADJ_DAT_3*100+ADJ_DAT_2*10);
    }      
          
    sprintf(lcd_print_buf,"%d",ADJ_DAT_3);
    lcd_print("t1",lcd_print_buf);
    sprintf(lcd_print_buf,"%d",ADJ_DAT_2);
    lcd_print("t2",lcd_print_buf);
    sprintf(lcd_print_buf,"%d",ADJ_DAT_1);
    lcd_print("t3",lcd_print_buf);
    
}
void PD_CNT_A_DISP(){
      /////////////Aーツ表示//////////////
    PD_CNT_A_3=PD_CNT_A/100;
    PD_CNT_A_2=(PD_CNT_A-(PD_CNT_A_3*100))/10;
    PD_CNT_A_1=PD_CNT_A-(PD_CNT_A_3*100+PD_CNT_A_2*10);
    
    sprintf(lcd_print_buf,"%01d",PD_CNT_A_3);
    lcd_print("t12",lcd_print_buf);   
    
    sprintf(lcd_print_buf,"%01d",PD_CNT_A_2);
    lcd_print("t13",lcd_print_buf);   

    sprintf(lcd_print_buf,"%01d",PD_CNT_A_1);
    lcd_print("t14",lcd_print_buf); 
    
}
void PD_CNT_C_DISP(){
     /////////////Cパーツ表示//////////////
    PD_CNT_C_3=PD_CNT_C/100;
    PD_CNT_C_2=(PD_CNT_C-(PD_CNT_C_3*100))/10;
    PD_CNT_C_1=PD_CNT_C-(PD_CNT_C_3*100+PD_CNT_C_2*10);
    
    sprintf(lcd_print_buf,"%01d",PD_CNT_C_3);
    lcd_print("t15",lcd_print_buf);   

    sprintf(lcd_print_buf,"%01d",PD_CNT_C_2);
    lcd_print("t16",lcd_print_buf);   

    sprintf(lcd_print_buf,"%01d",PD_CNT_C_1);
    lcd_print("t17",lcd_print_buf);  
    
}

void RB1_POSE_DISP(){
    if(RB1_POSE_DISP_EN==0){//1のときは、連続動作しているので停止を確認しない
        RB1_JOG_WAIT(RB_EWAIT);//動作停止しているかチェック
    }
    RB1_GETPOS(500); //データ取得
    sprintf(lcd_print_buf,"%f",RB1_X_GET);
    lcd_print("t5",lcd_print_buf); 
    
    sprintf(lcd_print_buf,"%f",RB1_Y_GET);
    lcd_print("t6",lcd_print_buf); 
    
    sprintf(lcd_print_buf,"%f",RB1_Z_GET);
    lcd_print("t7",lcd_print_buf); 
    
    sprintf(lcd_print_buf,"%f",RB1_R_GET);
    lcd_print("t8",lcd_print_buf); 
}
void RB2_POSE_DISP(){
    if(RB2_POSE_DISP_EN==0){//1のときは、連続動作しているので停止を確認しない
        RB2_JOG_WAIT(RB_EWAIT);//動作停止しているかチェック
    }
    RB2_GETPOS(500); //データ取得
    sprintf(lcd_print_buf,"%f",RB2_X_GET);
    lcd_print("t5",lcd_print_buf); 
    
    sprintf(lcd_print_buf,"%f",RB2_Y_GET);
    lcd_print("t6",lcd_print_buf); 
    
    sprintf(lcd_print_buf,"%f",RB2_Z_GET);
    lcd_print("t7",lcd_print_buf); 
    
    sprintf(lcd_print_buf,"%f",RB2_R_GET);
    lcd_print("t8",lcd_print_buf); 
}


///エリアセンサの確認///
void AREA_SENS_CHEK(void)
{
    unsigned char on_cnt=0;
    unsigned char touch_id_bak=0;
    unsigned char touch_mask_bak=0;
    while(IO_EX_BIT_READ(AREA_SENS_I)==IOEX_ON_I && on_cnt<5) {
        on_cnt++;
        wait_ms(10);
    }
    if(on_cnt==5) {

        touch_id_bak=touch_id;
        touch_mask_bak=tp_mask;
        touch_id=0;
        //タッチパネルマスク解除
        tp_mask=0;
        //エリアセンサ検出画面//
        lcd_page_set(P_AREA_ALM,50);
        lcd_audio_play(AU_AREA_ALM,0,80);
        wait_ms(100);//2021/05/18 2000→100
        //再開ボタン待ち////////////
        while(1) {
            if(touch_id==BT14_RESTART && IO_EX_BIT_READ(AREA_SENS_I)==IOEX_OFF_I) {
                break;
            } else { //エリアセンサが解除しない間は、タッチできない。
                if(touch_id==BT14_RESTART ) {
                    lcd_page_set(P_AREA_ALM,50);
                    wait_ms(100);//2021/05/18 2000→100
                    touch_id=0;
                }
            }
            wait_ms(10);
        }
        ///画面表示を戻して再開///
        lcd_page_set(P_MAIN,50);
        MAIN_PAGE_DISP();
        lcd_audio_play(AU_RESTART ,0,80);
        wait_ms(100);//2021/05/18 2000→100

        
        //タッチ状態とマスク状態を復元//
        touch_id=touch_id_bak;
        tp_mask=touch_mask_bak;
    }
}
///page 15 時刻設定画面の操作 LCDのRTCを使用する為、調整は、LCD側のプログラムで行う（ここでは、ページ切換えだけ）
void TIME_SET_PAGE(void){
      switch (touch_id) {
 
            case BT15_SET:
                              
                                    lcd_page_set(P_MAIN ,100);
                                    MAIN_PAGE_DISP();
                                    touch_id=0;
                                    break;                               
                }
     
}
/////////////////////////////////page 1 作業画面の操作/////////////////////////////////////
void WORK_START_TEST(){
  
}



//////////////////アプリケーション//////////////////////////////////////////
void MG400_AP(void)
{
    switch (page) {

        case P_MAIN     :///page 1 スタート
                        MAIN_PAGE();
                        break;
                        
        case P_PAUSE:   //page 2 一時停止
                        PAUSE_PAGE();
                        break;
        case P_BARCHG:  //page 3 極棒交換
                        BARCHG_PAGE();
                        break;
        case P_CHGSET:  //page 4 極棒交換回数設定
                        CHGSET_PAGE();
                        break;
        case P_PULLTEST://page 5 引っ張り試験
                        PULLTEST_PAGE();
                        break;
        case P_WD_JUDGE://page 6 溶接結果表示
                        WD_JUDGE_PAGE();
                        break;
        case P_TANSI_MNT://page 7 端子供給設定
                        TANSI_MNT_PAGE();
                        break;
        case P_NI_ADJ:  //page 8ニッケル端子調整
                        NI_ADJ_PAGE();
                        break;
        case P_ROBO_ALM ://page 9ロボット障害
                        ROBO_ALM_PAGE();
                        break;   
        case P_ROBO1_ADJ ://page 10 ロボット1調整
                        ROBO1_ADJ_PAGE();
                        break;  
        case P_ROBO2_ADJ ://page 11 ロボット2調整
                        ROBO2_ADJ_PAGE();
                        break;  
        case P_ROBO1_KEY ://page 12 ロボット1キーボード
                        ROBO1_KEY_PAGE();
                        break;  
        case P_ROBO2_KEY ://page 13 ロボット2キーボード
                        ROBO2_KEY_PAGE();
                        break;      
        case P_TIME     :///page 15  時計設定
                        TIME_SET_PAGE();
                        break;    
        case P_JIKUTEST:///page 17 軸テスト
                        JIKUTEST_PAGE();
                        break;  
    }

}
