#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
//#include "HTTPClient.h"
#include "RPCFunction.h"
#include "NTPClient.h"

DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");
DigitalOut rfout(p22,"rfout");
InterruptIn button(p25); //energymeter flash detector

LocalFileSystem fs("webfs");// Create the local filesystem under the name "local"
LocalFileSystem local("local");// Create the local filesystem under the name "local"

EthernetNetIf eth(
    IpAddr(192,168,1,100), //IP Address
    IpAddr(255,255,255,0), //Network Mask
    IpAddr(192,168,1,254), //Gateway
    IpAddr(192,168,1,254)  //DNS
);
HTTPServer svr;
NTPClient ntp;
time_t ctTime;
//HTTPClient client;// for authentication, API key is set in client header

void sendbit(char a);
void open(char * input, char * output);//Open garage door
RPCFunction rpc_open(&open, "open");

Timer t;//timer to measure time between power meter flashes
//Timer t_pachube;//timer to set interval to post values to pachube
float watt;//is calculated from the time between flashes
int logPower;//initialize global variables
float time_s;
int firsttime;

void flip() {// measure time
    time_s = t.read(); // read time and store in global variable
    t.reset(); //reset time
    led2 = !led2;//toggle led2
    logPower=1;//tell the main loop to calculate the power
}

int main() {
    Base::add_rpc_class<AnalogIn>();
    Base::add_rpc_class<AnalogOut>();
    Base::add_rpc_class<DigitalIn>();
    Base::add_rpc_class<DigitalOut>();
    Base::add_rpc_class<DigitalInOut>();
    Base::add_rpc_class<PwmOut>();
    Base::add_rpc_class<Timer>();
    Base::add_rpc_class<BusOut>();
    Base::add_rpc_class<BusIn>();
    Base::add_rpc_class<BusInOut>();
    Base::add_rpc_class<Serial>();

    printf("Setting up...\n");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("Setup OK\n");

    FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path

    svr.addHandler<RPCHandler>("/rpc");
    svr.addHandler<FSHandler>("/files");
    svr.addHandler<FSHandler>("/"); //Default handler
    svr.bind(80);
    printf("Listening...\n");

    Host server(IpAddr(), 123, "0.uk.pool.ntp.org");
    ntp.setTime(server);
    ctTime = time(NULL);
    printf("Time (UTC): %s\r\n", ctime(&ctTime));
    FILE *fp = fopen("/local/test.txt", "a");
    fprintf(fp,"Restart (UTC): %s \r\n", ctime(&ctTime));
    fclose(fp);

    firsttime=1;//the first time the power must not be calculated
    button.rise(&flip);// attach the address of the flip function to the rising edge
    Timer tm;//timer to show that mbed is alive
    tm.start();//start timer to flash led1
    t.start();//start timer to measure power
   // t_pachube.start();//start timer that triggers a post interval

    while (true) {
        Net::poll();
        if (tm.read()>0.5) {
            led1=!led1; //Show that we are alive
            tm.reset();
        }
        /*
        if (t_pachube.read()>120) {
            led3=!led3; //Post to pachube
            string apiKey = "r5Nh4t4AKEH7-TmWz-jRf-q5DBIglZ2t_I_3D0EXLt4"; // copy API key from settings
            string environmentID = "26502";// use feed ID
            string datastreamID = "0"; // use datastream ID
            string data = FloatToStr(watt);//"500";  // datastream value
            
            printf("put data value: %f\r\n",watt);
            HTTPClient client;// for authentication, API key is set in client header
            client.setRequestHeader("X-PachubeApiKey", apiKey);
            HTTPText csvContent("text/csv"); // text object holds data to be posted
            csvContent.set(data);
            string uri = "http://api.pachube.com/v1/feeds/" + environmentID + "/datastreams/" + datastreamID + ".csv?_method=put"; // uri for post includes feed ID and datastream ID
            HTTPResult result = client.post(uri.c_str(), csvContent, NULL);// result should be 0 and response should be 200 for successful post
            int response = client.getHTTPResponseCode();
            printf("Pachube put response: %i\r\n",response);
            t_pachube.reset(); 
        }*/
        if (logPower==1) {//this code is running when the interrupt sets a flag
            logPower=0;//clear the flag
            if (firsttime==0) {//the first measurement is incorrect
                watt=3600/time_s;//calculate power
                if (watt>0) {
                    ctTime = time(NULL);
                    printf("T: %f s\r\n", time_s);//debug info
                    printf("P: %f W\r\n", watt);//debug info
                    FILE *fp = fopen("/local/power.txt", "a");
                    fprintf(fp,"%f W\r\n", watt);
                    fclose(fp);
                }//end of if(watt>0)
            }//end of firsttimme=00
            firsttime=0;//clear the firsttime variable
        }//end of if(logPower==1)
    }//end of while loop
}//end of main

void sendbit(char a) {
    if (a==0) {//pin low
        rfout=1;
        wait_us(2010);
        rfout=0;
        wait_us(270);
        rfout=1;
        wait_us(2010);
        rfout=0;
        wait_us(270);
    }
    if (a==1) {//pin high
        rfout=1;
        wait_us(270);
        rfout=0;
        wait_us(2010);
        rfout=1;
        wait_us(270);
        rfout=0;
        wait_us(2010);
    }
}//end of sendbit()

void open(char * input, char * output) {
    led4=1;
    for (char i = 0; i<10; i++) {
        sendbit(1);//address A1
        sendbit(0);//address A2
        sendbit(0);//address A3
        sendbit(0);//address A4
        sendbit(1);//address A5
        sendbit(0);//address A6 /data D6
        sendbit(1);//address A7 /data D7
        sendbit(0);//address A8 /data D8
        sendbit(1);//address A9 /data D9
        wait_ms(14);
    }
    led4=0;
    //beginning of open sesame log
    FILE *fp = fopen("/local/test.txt", "a");
    ctTime = time(NULL);
    fprintf(fp,"Open (UTC): %s \r\n", ctime(&ctTime));
    fclose(fp);
    //end of open sesame log
    sprintf(output, "<html><head><meta http-equiv=refresh content='2; url=../../index.htm'></head><body BGCOLOR=#A1F9FF>Opening,wait...</body></html>");
}













