// This program displays heart rate and time between heart beats on LCD, prints it to a USB serial port,
// print it to a bluetooth serial port and store it on a USB mass storage device.
// The program has two interrupt routines:
// 1.Every 1ms a counter is increased with one,
// 2. On every heart beat the counter is value copied.
// In the main loop the beats per minute are calculated.

// Ext.Modules:- Polar RMCM-01 heart rate module connected to pin8.
//             - 2x16 LCD
//             - a RF-BT0417CB bluetooth serial device connected to p27 and p28
//             - an USB mass storage device

#include "mbed.h"
#include "TextLCD.h"
#include "MSCFileSystem.h"
#define FSNAME "msc"
MSCFileSystem msc(FSNAME);

Timer t;                // counts the time from beginning of main loop
InterruptIn beat(p8);   // beat is the name for a interrupt on pin 8
TextLCD lcd(p10, p12, p15, p16, p29, p30); // rs, e, d0-d3
Ticker mscnt;           // this is used to create a ms counter
Serial bt(p28, p27);    // tx, rx of the bluetooth serial COM port

int count,CNT,displayBPMFlag;//initialize global variables

void ms_counter() {         //this interrupt routine starts every 1ms
    count++;                //the counter is increased with 1
    if (count>1999) {       //when no heart beat is detected for >2sec, then display "-" in the main loop
        CNT=count;          // copy counter value to CNT
        displayBPMFlag = 1; // set flag that the BPM can be put to LCD in the main loop
        count=0;            // reset counter value
    }
}

void flip() { //this interrupt routine starts on every heart beat
    CNT = count;        // copy counter value to CNT
    count = 0 ;         // reset counter value
    displayBPMFlag = 1; // set flag that the BPM can be put to LCD in the main loop
}

int main() {
    int BPM;                           //initialize BPM locally
    lcd.cls();                         //clear the lcd display
    lcd.locate(0,0);            //set cursor to first character and first line
    lcd.printf("Heart Rate");  //display the time in ms on the lcd
    lcd.locate(0,1);            //set cursor to first character and second line
    lcd.printf("Jasper Sikken");  //display the beats per minute on the lcd
    wait_ms(2000);
    mscnt.attach_us(&ms_counter,1000); //the address of the function to be attached (ms_counter) and the interval (1ms)
    printf("0 \r\n");                  //print 0 ms to the serial port
    bt.printf("0 \r\n");               //print 0 ms to the bluetooth serial port
    FILE *fp=fopen("/msc/HR.txt","a+");//Open file on USB Mass Storage device, 8.3 filesystem, open for write and append
    if (fp==NULL)error("Could not open file for write\n");// error code
    fprintf(fp,"0,0 \r\n");            //write "0,0" to file to indicate beginning of a measurement
    fclose(fp);                        //close file
    lcd.cls();                         //clear the lcd display
    t.start();                         //the time since the beginning of the main loop
    beat.rise(&flip);                  //the interrupt flip is started to the rising edge
    while (1) {                        //program loops around in here
        if (displayBPMFlag == 1) {     //if the flag is set that the BPM can be used in the main loop
            displayBPMFlag = 0;        //clear displayBPMflag
            if (CNT>250&CNT<2000) {    //when heart rate is within 30-240BPM
                BPM = 60000/CNT;            //calculate BPM
                lcd.locate(0,0);            //set cursor to first character and first line
                lcd.printf("%i ms ",CNT);  //display the time in ms on the lcd
                lcd.locate(0,1);            //set cursor to first character and second line
                lcd.printf("%i BPM ",BPM);  //display the beats per minute on the lcd
                printf("%i\r\n",CNT);       //print time between heart beats to the serial port
                bt.printf("%i\r\n",CNT);    //print time between heart beats to the bluetooth serial port
                FILE *fp=fopen("/msc/HR.txt","a+");//Open file on USB Mass Storage device, 8.3 filesystem, open for write and append
                if ( fp == NULL )error("Could not open file for write\n");//error code
                fprintf(fp, "%f,%i\r\n",t.read(),BPM);//write time-since-start-main-loop and BPM to file
                fclose(fp);                 //close file
            } else {                //when heart rate is NOT within 30-240BPM
                lcd.cls();                  //clear the lcd display
                lcd.locate(0,0);            //set cursor to first character and first line
                lcd.printf("- ms");         //display empty time in ms on the lcd
                lcd.locate(0,1);            //set cursor to first character and second line
                lcd.printf("- BPM");        //display empty beats per minute on the lcd
                printf("0 \r\n");       //print no time in ms to the serial port
                bt.printf("0 \r\n");    //print no between heart beats to the bluetooth serial port
                FILE *fp = fopen( "/msc/HR.txt", "a+");//Open file on USB Mass Storage device, 8.3 filesystem, open for write and append
                if ( fp == NULL )error("Could not open file for write\n"); // error code
                fprintf(fp, "0,0 \r\n");   //write "0,0" to file
                fclose(fp);             //close file
            }

        }

    }

}