#include "mbed.h"
#include "XNucleo53L0A1.h"
#include <stdio.h>




DigitalOut enable(p18);
BusOut answer(p19,p20);
BusOut myleds(LED1, LED2, LED3, LED4);
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

DigitalIn lidar_enable(p9);

// READING DATA BETWEEN MBEDS
DigitalIn other_player(p15);
DigitalOut my_player(p16);

Serial blue(p13, p14);  // tx, rx

Serial pc(USBTX,USBRX);
DigitalOut shdn(p26);
// This VL53L0X board test application performs a range measurement in polling mode
// Use 3.3(Vout) for Vin, p28 for SDA, p27 for SCL, P26 for shdn on mbed LPC1768

//I2C sensor pins
#define VL53L0_I2C_SDA   p28
#define VL53L0_I2C_SCL   p27
static XNucleo53L0A1 *board=NULL;

int msg = -1;
char bnum = 0; //button number variable
char bhit = 0;


void bluetooth() //function that is called after lidar distance <70 to get bluetooth inputs
{
    while(1) {
        pc.printf("Start bluetooth |");
        while (blue.readable()) {
            blue.getc();
        }
        if (blue.getc()=='!') {
            if (blue.getc()=='B') { //button data
                bnum = blue.getc(); //button number
                bhit = blue.getc(); //1=hit, 0=release
                if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) {
                    blue.getc();
                    while (blue.readable()) {
                        blue.getc();
                    }
                    switch (bnum) {
                        case '1': //number button 1
                            if (bhit=='1') {
                                msg = 1;
                                myled1 = 1;
                            } else {
                                msg = 0;
                                myled1 = 1;
                            }
                            break;
                        case '2': //number button 2
                            if (bhit=='1') {
                                msg = 2;
                                myled2 = 1;
                            } else {
                                msg = 0;
                                myled2 = 1;
                            }
                            break;
                        case '3': //number button 3
                            if (bhit=='1') {
                                msg = 3;
                                myled3 = 1;
                            } else {
                                msg = 0;
                                myled3 = 1;
                            }
                            break;
                        case '4': //number button 4
                            if (bhit=='1') {
                                msg = 4;
                                myled4 = 1;
                            } else {
                                msg = 0;
                                myled4 = 1;
                            }
                            break;
                        default:
                            break;

                    }
                    //device.putc(msg);
                    return;
                }
            }
        }

        //device.putc(msg);
        wait(1);
    }
}

int main()
{

    int status;
    uint32_t distance;
    DevI2C *device_i2c = new DevI2C(VL53L0_I2C_SDA, VL53L0_I2C_SCL);
    /* creates the 53L0A1 expansion board singleton obj */
    board = XNucleo53L0A1::instance(device_i2c, A2, D8, D2);
    shdn = 0; //must reset sensor for an mbed reset to work
    wait(0.1);
    shdn = 1;
    wait(0.1);
    /* init the 53L0A1 board with default values */
    status = board->init_board();
    while (status) {
        pc.printf("Failed to init board! \r\n");
        status = board->init_board();
    }
    //loop taking and printing distance

    while (1) {
        msg = 0;
        status = board->sensor_centre->get_distance(&distance);
        if (status == VL53L0X_ERROR_NONE) {

           
            if (distance < 70) {
// once master mbed as already printed the question
                if (lidar_enable){
                    
                    my_player = 1;
                    
                    if (!other_player) {  //if the other player has not pressed buzzer yet
                        myleds = 15; // all leds on player mbed light up using BUSOUT
                        wait(0.5);
                        myleds = 0;
                        bluetooth();
                        if (msg > 0 && msg < 5) {
                            answer = msg - 1;//send answer to master
                            enable = 1; //let master mbed know youre ready
                            wait(1);
                        }
                    }
                }
            } else {
                //reset values
                msg = -1;
                enable = 0;
                myleds = 0;
                my_player = 0;
            
            }
        }
    }

}
