#include "mbed.h"


#ifndef M_PI 
#define M_PI 3.14159265358979323846 
#endif 

DigitalOut myled(LED1); 
PwmOut CH1(PA_8); 
PwmOut CH2(PA_15); 
PwmOut CH3(PA_6);

// dc : duty cycle
// n:   sample 
// f:   
 
 /* This program calculates values of a sine 
 function and splits them up in 100 points, these points are then written
  to the duty cycle of the pwm signals.
*/
Ticker interrupt;
InterruptIn button(USER_BUTTON);
int n;
double dc_min = 0.0, dc_max = 1.0;
void sine_dc() { 
    double dc, sine_term; 
    n = n + 1;
    if(n == 100) n = 0;
    sine_term = (1 + sin(2*M_PI*n/100.0));
    dc = sine_term * dc_min + (2 - sine_term) * dc_max;
    CH1.write(dc/2);
    CH2.write(dc/2);
    CH3.write(dc/2);
}
int main() {
    int f = 20000;
    n = 0;
    CH1.period_us(100);
    CH1.write(0.5);
    CH2.period_us(100);
    CH2.write(0.5);
    CH3.period_us(100);
    CH3.write(0.5);
    interrupt.attach_us(&sine_dc, f);
    
    while(1) {
         myled = !myled;
         wait(1);
    }
}

