#include "mbed.h"
 
class MCP23008 {
public:

    /** Constructor
     *
     * @param sda I2C sda pin
     * @param scl I2C scl pin
     * @param address The hardware address of the MCP23008. This is the 3-bit
     * value that is physically set via A0, A1, and A2.
     * @param freq The I2C frequency.
     */
     
     MCP23008(PinName sda, PinName scl, uint8_t address, int freq);
     
     /** Setup the port direction of each of the pins
     *
     */
     
     void init();
    
    
     /** Write to the output pins.
     *
     * This function is used to set output pins on or off.
     *
     * @param val The GPIO channels to turn on
     */
     
     void writeOutput(int chn1, int chn2, int chn3, int chn4);
     
          
     /** Sets I2C address
     *
     * This function is used to set the I2C address
     *
     * @param address The I2C address
     */
     
     void setAddress(int address);

  
private:
    I2C i2c;
    
    uint8_t addrI2C; 
    
    uint8_t GPIO_Pin_Status;
};
 
