#include "mbed.h"
 
class LTC2487 {
public:

    /** Constructor
     *
     * @param sda I2C sda pin
     * @param scl I2C scl pin
     * @param address The hardware address of the LTC2487. This is the 3-bit
     * value that is physically set via A0, A1, and A2.
     * @param freq The I2C frequency.
     */
     
     LTC2487(PinName sda, PinName scl, uint8_t address, int freq);
     
    
    /** Write to LTC chip to select port to read from
     *
     * This function is used select the LTC2487 channel we would like to read from
     *
     * @param channel The channel we would like to read from
     */
     
     float writePort(int channel);
     
     /** Read value from LTC2487
     *
     * This function is used to read data from LTC2487 from channel selected in writePort()
     *
     * @param N/A
     */
     
     float read();
     
     /** Sets I2C address
     *
     * This function is used to set the I2C address
     *
     * @param address The I2C address
     */
     
     void setAddress(int address);

  
private:
    I2C i2c;
    uint8_t addrI2C; 
    
};
 
