
#include "mbed.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "uLCD_4DGL.h"
#include "mpr121.h"
#include "PinDetect.h"
#include <string>
#include <list>

DigitalOut led1(LED1);
InterruptIn interrupt(p26);
InterruptIn start(p12);
PinDetect stop(p13);

SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
uLCD_4DGL uLCD(p9, p10, p11);
Serial pc(USBTX, USBRX);  
                                                                                                                                                               

// Speaker and Class D
AnalogOut speaker(p18);
wave_player waver(&speaker);

// Keypad
I2C i2c(p28, p27);
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

int keypad = 0;
string title;
int title_size;
string artist;
int artist_size;


bool newKey = false;
bool play = false;
bool reset = false;

void key () {
    
    newKey = true;
    
}

void b1 () {
    
    if (keypad != 0) {
        play = true;
    }
    
}


void update_screen(int index) {
    
    if (index == 1) { // MENU SCREEN
    
            uLCD.cls();
    
            // Draw border
            uLCD.filled_circle(0,0,10,AQUA);   
            uLCD.filled_circle(0,128,10,AQUA);   
            uLCD.filled_circle(128,0,10,AQUA);   
            uLCD.filled_circle(128,128,10,AQUA);   
            uLCD.filled_rectangle(0,0,128,3,AQUA);   
            uLCD.filled_rectangle(124,0,128,128,AQUA);  
            uLCD.filled_rectangle(0,0,3,128,AQUA);  
            uLCD.filled_rectangle(0,125,128,128,AQUA);  

            // Print title
            uLCD.color(AQUA);
            uLCD.text_width(2.5);
            uLCD.text_height(2.5);
            uLCD.locate(1,1);
            uLCD.printf("JUKEBOX");
 
            // Print menu information
            uLCD.color(TEAL);           
            uLCD.text_width(1);
            uLCD.text_height(1);
            uLCD.locate(3,5);
            uLCD.printf("  Welcome!\r\n");
            uLCD.locate(2,6);
            uLCD.printf("Please make a \r\n");
            uLCD.locate(2,7);
            uLCD.printf("song selection.\r\n");            
            uLCD.locate(1,9);
            uLCD.printf(" Then hit PLAY!\r\n"); 
            uLCD.filled_rectangle(15,90,114,90, GREEN);
            uLCD.filled_rectangle(15,110,114,110, GREEN);            
            uLCD.filled_rectangle(15,90,15,110, GREEN);
            uLCD.filled_rectangle(114,90,114,110, GREEN);  
                       
    } else if (index == 2) { // SONG CHOICE 

            // Print KEYPAD selection
            uLCD.text_width(1);
            uLCD.text_height(1);
            uLCD.locate(6,12);
            uLCD.color(GREEN);
            if (keypad > 0) {
                if (keypad < 10) {
                     uLCD.printf("Song 0%i\r\n",keypad);   
                } else {
                    uLCD.printf("Song %i\r\n",keypad);
                }
            }
            
    } else if (index == 3) { // NOW PLAYING

            uLCD.cls();
            
            // Draw border
            uLCD.filled_circle(0,0,10,AQUA);   
            uLCD.filled_circle(0,128,10,AQUA);   
            uLCD.filled_circle(128,0,10,AQUA);   
            uLCD.filled_circle(128,128,10,AQUA);   
            uLCD.filled_rectangle(0,0,128,3,AQUA);   
            uLCD.filled_rectangle(124,0,128,128,AQUA);  
            uLCD.filled_rectangle(0,0,3,128,AQUA);  
            uLCD.filled_rectangle(0,125,128,128,AQUA);             
   
            // Print NOW PLAYING     
            uLCD.color(AQUA);
            uLCD.locate(1,2);
            uLCD.text_width(1);
            uLCD.text_height(1); 
            uLCD.printf("  Now playing..."); 
            uLCD.color(GREEN);
            uLCD.text_width(1);
            uLCD.text_height(1);
            uLCD.locate(1,5); 
            uLCD.printf("%s\r\n",title);    // song title
            uLCD.locate(1,7); 
            uLCD.printf("%s\r\n",artist);
            uLCD.filled_rectangle(15,35,114,35, GREEN);
            uLCD.filled_rectangle(15,67,114,67, GREEN);            
            uLCD.filled_rectangle(15,35,15,67, GREEN);
            uLCD.filled_rectangle(114,35,114,67, GREEN);            


            // MUSIC SYMBOL #1           
            uLCD.filled_rectangle(30,76,45,78, BLUE);
            uLCD.filled_rectangle(30,76,32,91,BLUE);
            uLCD.filled_rectangle(43,76,45,91,BLUE);
            uLCD.filled_circle(29,91,3,BLUE);
            uLCD.filled_circle(42,91,3,BLUE);                
            
            
            // MUSIC SYMBOL #2             
            uLCD.filled_rectangle(58,84,73,86,PURPLE);
            uLCD.filled_rectangle(58,84,60,99,PURPLE);
            uLCD.filled_rectangle(71,84,73,99,PURPLE);
            uLCD.filled_circle(56,99,3,PURPLE);
            uLCD.filled_circle(70,99,3,PURPLE);        
            
            // MUSIC SYMBOL #3            
            uLCD.filled_rectangle(87,76,102,78, PINK);
            uLCD.filled_rectangle(87,76,89,91,PINK);
            uLCD.filled_rectangle(100,76,102,91,PINK);
            uLCD.filled_circle(86,91,3,PINK);
            uLCD.filled_circle(99,91,3,PINK);   
            
            
 
            // Print STOP message
            uLCD.color(RED);           
            uLCD.text_width(1.0);
            uLCD.text_height(1.0);       
            uLCD.locate(1,14);
            uLCD.printf(" Hit STOP to end");
            
        }
    
}

void get_song() {

    // Read value
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
 
    // Match keypad value to number   
    switch (value) {
        case 2:
            keypad = 1;
            break;
        case 4:
            keypad = 2;
            break;
        case 8:
            keypad = 3;
            break;
        case 16:
            keypad = 4;
            break;
        case 32:
            keypad = 5;
            break;
        case 64:
            keypad = 6;
            break;
        case 128:
            keypad = 7;
            break;
        case 256:
            keypad = 8;
            break;
        case 512:
            keypad = 9;
            break;
        case 1024:
            keypad = 10;
            break;
       }
             
       update_screen(2);

}


void play_song() {
    
    FILE *wave_file;
    switch (keypad) {
        case 1:
            wave_file=fopen("/sd/wavfiles/dura.wav","r");
            title = "      Dura";
            artist = "  Daddy Yankee";
            title_size = 1;
            artist_size = 1;
            break;
        case 2:
            wave_file=fopen("/sd/wavfiles/despacito.wav","r");
            title = "    Despacito";
            artist = "    Luis Fonsi";
            title_size = 1;
            artist_size = 1;
            break;
        case 3:
            wave_file=fopen("/sd/wavfiles/disco.wav","r");
            title = "      Disco";
            artist = "  Maxine Night";
            title_size = 1;
            artist_size = 1;
            break;
        case 4:
            wave_file=fopen("/sd/wavfiles/california.wav","r");
            title = "   California";
            artist = "     Phantom  ";
            title_size = 1;
            artist_size = 1;
            break;
        case 5:
            wave_file=fopen("/sd/wavfiles/christmas.wav","r");
            title = "   All I Want";
            artist = "  Mariah Carey";
            title_size = 1;
            artist_size = 1;
            break;
        case 6:
            wave_file=fopen("/sd/wavfiles/beethoven.wav","r");
            title = "   Symphony 9";
            artist = "    Beethoven";
            title_size = 1;
            artist_size = 1;
            break;
        case 7:
            wave_file=fopen("/sd/wavfiles/queen.wav","r");
            title = "    Rock You";
            artist = "      Queen";
            title_size = 1;
            artist_size = 1;
            break;
        case 8:
            wave_file=fopen("/sd/wavfiles/losing_it.wav","r");
            title = "    Losing It";
            artist = "     Fisher";
            title_size = 1;
            artist_size = 1;
            break;
        case 9:
            wave_file=fopen("/sd/wavfiles/better_not.wav","r");
            title = "   Better Not";
            artist = "    Louis TC";
            title_size = 1;
            artist_size = 1;
            break;
        case 10:
            wave_file=fopen("/sd/wavfiles/drinkee.wav","r");
            title = "     Drinkee";
            artist = "   Sofi Tukker";
            title_size = 1;
            artist_size = 1;
            break;
       }
        update_screen(3);     
        waver.play(wave_file);      
        fclose(wave_file);

        

}


void stop_song() {
    
        play = false; 
        

}



int main(){
        
        
        interrupt.mode(PullUp);
        start.mode(PullUp);
        interrupt.fall(&key);
        start.fall(&b1);
        stop.mode(PullUp);
        wait_ms(10);
        stop.attach_deasserted(&stop_song);
        stop.setSampleFrequency();
        
        
        
        
        while(1) { // One jukebox cycle
        
            
            // Reset, draw menu screen
            keypad = 0;
            update_screen(1);
    
            // Wait for user to select song AND press play        
            while ((keypad == 0)||(play==false)) {
                if (newKey) {
                    newKey = false;
                    get_song();                  
                }
            }
    
            play_song();            

            // Reset values before starting again                
            play = false;
            newKey = false;
            keypad = 0;
            
            
            
        }

    
    
}