/*
    Buffered serial 1 - Setup to work with UART1 (p13,p14)
*/

#ifndef BUFFERED_SERIAL_H
#define BUFFERED_SERIAL_H

#define BUFFER_SIZE     255
#define LINE_SIZE       80
#define NEXT(x)         ((x+1)&BUFFER_SIZE)
#define IS_TX_FULL      (((tx_in + 1) & BUFFER_SIZE) == tx_out)
#define IS_RX_FULL      (((rx_in + 1) & BUFFER_SIZE) == rx_out)
#define IS_RX_EMPTY     (rx_in == rx_out)

#include "mbed.h"
#include "rtos.h"

class BufferedSerial : public Serial
{
public:
    BufferedSerial(PinName tx, PinName rx);

    void send_line(char*);
    void read_line(char*);

private:
    void Tx_interrupt();
    void Rx_interrupt();

// for disabling the irq
    IRQn device_irqn;
    
// Circular buffers for serial TX and RX data - used by interrupt routines
// might need to increase buffer size for high baud rates
    char tx_buffer[BUFFER_SIZE];
    char rx_buffer[BUFFER_SIZE];
// Circular buffer pointers
// volatile makes read-modify-write atomic
    volatile int tx_in;
    volatile int tx_out;
    volatile int rx_in;
    volatile int rx_out;
// Line buffers for sprintf and sscanf
    char tx_line[LINE_SIZE];
    char rx_line[LINE_SIZE];

    DigitalOut led1;
    DigitalOut led2;
    
    Semaphore rx_sem;
    Semaphore tx_sem;
};

#endif