
#include "IOControl.h"
#include "SPIDAC.h"
#include "math.h"

IOControl::IOControl(void) :
    hvEn(p26, 0),
    shutdown(p17, 0),
    activate(p25),
    hvFault(p29, PullUp),
    hvControl(p18)
{
    PWM.Enable(false);
    requestedOutputVoltage = 0;

}

void IOControl::Activate(void)
{
    hvControl = (((HV_MAX) * (requestedOutputVoltage)) / ( MAX_OUTPUT_VOLTAGE));

    PWM.Enable(true);
    hvEn = false;
    shutdown = false;
}

void IOControl::Deactivate(void)
{
    hvControl = 0;
    PWM.Enable(false);
    hvEn = true;
    shutdown = true;
    activate.reset();
}

bool IOControl::isActivateSwitchOn(void)
{
    if( activate.read() == 0)
        return true ;
    return false;
}
bool IOControl::hasFalling(void)
{
    if (activate.falling() > 0)
        return true;
    return false;
}

double IOControl::GetOutputVoltage(void)
{
    return ((((hvControl) * (MAX_OUTPUT_VOLTAGE)) / (HV_MAX)));
}

void IOControl::SetOutputVoltage(double outputVoltage)
{
    mutex.lock();
    requestedOutputVoltage = outputVoltage;
    mutex.unlock();
}
void IOControl::ChangeOutputVoltage(double outputVoltage)
{
    mutex.lock();
    hvControl = (((HV_MAX) * (outputVoltage)) / ( MAX_OUTPUT_VOLTAGE));
    mutex.unlock();
}
double IOControl::GetActualPWMFrequency(void)
{
    mutex.lock();
    double result = PWM.GetActualFrequency();
    mutex.unlock();
    return result;
}

void IOControl::SetPWMFrequency(double freq)
{
    PWM.SetState(freq);
}

void IOControl::SetLimits( double voltageLim, double currentLim )
{
    double vLim, iLim;
    iLim = (((DAC_LIM_MAX ) * (currentLim )) / ( DAC_VOLTAGE_MAX));
    // Map the voltage from 0 to 3.3V into 0 to 2048
    vLim = (((DAC_LIM_MAX) * (voltageLim )) / ( DAC_VOLTAGE_MAX));
    SPIDACSend((uint16_t)vLim, (uint16_t)iLim);
}

double IOControl::GetHVControl(void)
{
    double result = hvControl * 3.3;
    return result;
}
void IOControl::SetHVControl(double control)
{
    hvControl = (control/3.3) * HV_MAX;
}
void IOControl::HVcalControl(double control)
{
    hvControl = control;
}
