
#ifndef __FULL_BRIDGE_DRIVER_H__
#define __FULL_BRIDGE_DRIVER_H__

const double MIN_PWM_FREQUENCY = 50;
const double MAX_PWM_FREQUENCY = 1000;
const double DEFAULT_PWM_FREQUENCY = 400;

class FullBridgeDriver
{
public:
    FullBridgeDriver(void);
    double GetActualFrequency(void);
    void SetState(double kHzFrequency);
    void Enable(bool enabled);
    
private:
    void ChangeFrequency(double kHzFrequency);

private:
    double currentFrequency;
    bool   isEnabled;
};

#endif
