#ifndef __DEVICE_PROPERTIES_H__
#define __DEVICE_PROPERTIES_H__

#include "Mutex.h"
#include "DataContainer.h"
const int MAX_ACQUISITION_SAMPLES = 500;

enum OutputMode
{
    OMRamp = 0,
    OMConstantVoltage = 1,
    OMConstantPower = 2,
    OMCalibrate = 3
};

struct DeviceConfig
{
    DeviceConfig(void);
    
    // Control Parameters
    OutputMode outputMode;
    double constantVoltage;
    double constantPower;
    double kp;
    double ki;
    double kd;
    double voltageCal;
    double currentCal;
    double vLim;
    double iLim;
    double hvLim;
    // Activation Parameters
    double pwmFrequency;
    uint8_t msOpenLoopDuration;
    int TotalDurationSeconds;
    double msRampDuration;
    double rampStartPower;
    double rampEndPower;
    double startVoltage;
    uint8_t msSamplePeriod;  
    uint8_t doneBit;
    double pwrCalLow;
    double pwrCalHigh;
    double vCalLow;
    double vCalHigh;
    bool PID_GOOD;
    double voltageSensed;
    double currentSensed;
    double sensedResistance;
    double sensedPower;
};

struct AcquisitionData
{
    float timestampMilliseconds;
    float targetVoltage;
    float vSense;
    float iSense;
    float vRMS;
    float iRMS; 
    float power;
    float resistence;
};



class DeviceProperties
{
public:
    DeviceProperties(void);
    void AddAcquisitionSample( AcquisitionData &data);
    void ClearAcquisitionData(void);
    int GetAcquisitionNumber(void);
    int GetAcquisitionSampleCount(void);

    AcquisitionData GetAcquisitionSample(int acquisition, int sample);
 
    void SetActualPWMFrequency(double frequency);
    double GetActualPWMFrequency(void) const;

public:
    DeviceConfig deviceConfig;
    
private:
    int acquisitionSampleCount;
    int acquisitionNumber;
    AcquisitionData acquisitionData[MAX_ACQUISITION_SAMPLES];
    mutable rtos::Mutex mutex;
    double actualPwmFrequency;

};

extern DeviceProperties Device;

#endif


