
#include "DeviceProperties.h"

DeviceProperties Device;

DeviceConfig::DeviceConfig(void)
{
    // Control Parameters
    outputMode = OMRamp;
    constantVoltage = 0;
    constantPower = 0;
    kp = 0;
    ki = 0;
    kd = 0;
    voltageCal = 1;
    currentCal = 1;
    vLim = 0;
    iLim = 0;
    hvLim = 8;
    // Activation Parameters
    pwmFrequency = 400;
    msOpenLoopDuration = 50;
    TotalDurationSeconds = 4000;
    msRampDuration = 1000;
    rampStartPower = 1;
    rampEndPower = 10;
    startVoltage = 30;
    msSamplePeriod = 10;
    doneBit = 0;
    pwrCalLow =1;
    pwrCalHigh =1;
    vCalLow = 1;
    vCalHigh = 1;
    PID_GOOD = false;
    voltageSensed = 0;
    currentSensed = 0;
    sensedResistance = 0;
    sensedPower = 0;
}

DeviceProperties::DeviceProperties(void)
{
    acquisitionSampleCount = 0;
    acquisitionNumber = 0;
}

int DeviceProperties::GetAcquisitionNumber(void)
{
    mutex.lock();
    int result = acquisitionNumber;
    mutex.unlock();
    return result;
}

int DeviceProperties::GetAcquisitionSampleCount(void)
{
    mutex.lock();
    int result = acquisitionSampleCount;
    mutex.unlock();
    return result;
}

void DeviceProperties::AddAcquisitionSample( AcquisitionData &data)
{
    mutex.lock();
    if (acquisitionSampleCount < MAX_ACQUISITION_SAMPLES)
        acquisitionData[acquisitionSampleCount++] = data;
    mutex.unlock();
}

void DeviceProperties::ClearAcquisitionData(void)
{
    mutex.lock();
    ++acquisitionNumber;
    acquisitionSampleCount = 0;
    mutex.unlock();

}

AcquisitionData DeviceProperties::GetAcquisitionSample(int acquisition, int sample)
{
    mutex.lock();
    AcquisitionData result;
    if (acquisitionNumber==acquisition) {
        if (sample>=0 && sample<acquisitionSampleCount)
            result = acquisitionData[sample];
    }
    mutex.unlock();
    return result;

}

double DeviceProperties::GetActualPWMFrequency(void) const
{
    mutex.lock();
    double result = actualPwmFrequency;
    mutex.unlock();
    return result;
}


void DeviceProperties::SetActualPWMFrequency(double frequency)
{
    mutex.lock();
    this->actualPwmFrequency = frequency;
    mutex.unlock();
}




