
#include "mbed.h"

#include "MillisecondCounter.h"
#include "SPIDAC.h"
#include "CMSerial.h"
#include "PowerController.h"

DigitalOut myled(LED1);
LocalFileSystem local("local");
int main()
{


    CMSerial serial;
    double calVal[8];
    int i = 0;
    FILE *fp = fopen("/local/out.txt", "r");  // Open "out.txt" on the local file system for writing
    if( fp != NULL) {
        char buffer[128];
        while(fgets(buffer, 128, fp)) {
            calVal[i] = atof(buffer);
            i++;
            wait(1);
        }
        fclose(fp);
    }

    Device.deviceConfig.pwrCalLow = calVal[0];
    Device.deviceConfig.pwrCalHigh = calVal[1];
    Device.deviceConfig.vCalLow = calVal[2];
    Device.deviceConfig.vCalHigh = calVal[3];
    if(calVal[4] != 0){
    Device.deviceConfig.kp = calVal[4];
    Device.deviceConfig.ki = calVal[5];
    Device.deviceConfig.kd = calVal[6];
    Device.deviceConfig.PID_GOOD = true;
    }
    PowerController powerController;
    StartTimer_ms();
    SPIDACInitialize();


    while(1) {
        // pause
        myled = (GetTime_ms() / 1000) & 1;
        rtos::Thread::wait(100);
    }
}

