#ifndef __PID_H__
#define __PID_H__

class PID
{
public:
    PID(void);
    
    void AddSample(double sampleValue,double control);
    double GetOutput(void) { return currentOutput; }
    double GetPidSampleValue(void) { return pidSampleValue; }
    void Reset(void);
    void SetOutputRange(double minOutput, double maxOutput);
    void SetPeriodMilliseconds(double period) { msPeriod = period; }
    void SetPID(double kp, double ki, double kd);
    void SetTarget(double target) { this->target = target; }
    double GetTarget(void){return target;}
private:
    double minOutput, maxOutput;
    double kp, ki, kd;
    double errorIntegral;
    double lastError;
    double msPeriod;
    double target;
    double currentOutput;
    double pidSampleValue;
};


#endif

