#ifndef __IOCONTROL_H__
#define __IOCONTROL_H__

#include "mbed.h"
#include "FullBridgeDriver.h"
#include "Mutex.h"
#include "DebouncedIn.h"

const double MAX_TARGET_POWER = 200;
const double MAX_OUTPUT_VOLTAGE = 200;
const double VOLTAGE_LIMIT = 160;
const double HV_MAX = 1;
const uint16_t DAC_LIM_MAX = 2048;  // Max value of 10 bit DAC
const uint16_t DAC_VOLTAGE_MAX = 3.3; // Max Voltage output


class IOControl
{
public:
    IOControl(void);
    
    bool isActivateSwitchOn(void);
    void Activate(void);
    void Deactivate(void);
    bool hasFalling(void);
    double GetOutputVoltage(void);
    void SetOutputVoltage(double outputVoltage);
    void ChangeOutputVoltage(double outputVoltage);
    double GetActualPWMFrequency(void);
    void SetPWMFrequency(double freq);
    void SetLimits(double voltageLim, double currentLim);
    double GetHVControl(void);
    void SetHVControl(double control);
    void HVcalControl(double control);
private:
    DigitalOut hvEn;
    DigitalOut shutdown;
    DebouncedIn activate;
    DigitalIn hvFault;
    AnalogOut hvControl;  
    
    mutable rtos::Mutex mutex;
    double requestedOutputVoltage;
    
    // PWM control 
    FullBridgeDriver PWM;
};
#endif

