#ifndef __DATACONTAINER_H__
#define __DATACONTAINER_H__

#include "mbed.h"



class DataContainer
{
   

public:
    
    /** Create a DataContianer object
     *
     * @param iSize size of the object in DataContianer
     * @param iCount number of items in the DataContianer
     */
    DataContainer( int iSize, int iCount );
 
    /** destruction
     *
     */
    virtual ~DataContainer( void );
 
    /** Add item to queue
     *
     * @param pvItem item to add
     * @returns true if item added, false if queue full
     */
    bool Put( void* pvItem );
 
    /** get an item from the queue in an IRQ handler
     *
     * @param pvItem pointer to the tiem to retrieve
     * @returns true if item fetched, false if queue is empty
     */
    bool GetIrq( void* pvItem );
    
    /** Add item to queue from an IRQ handler
     *
     * @param pvItem item to add
     * @returns true if item added, false if queue full
     */
    bool PutIrq( void* pvItem );
 
    /** get an item from the queue
     *
     * @param pvItem pointer to the tiem to retrieve
     * @returns true if item fetched, false if queue is empty
     */
    bool Get( void* pvItem );
    
    /** get the number of items in the queue
     * 
     * @returns the number of items in the queue
     */
    int GetNumberOfItems( void );
    
    /** peek at the entry at the top of the queue
     * 
     * @returns the entry at the top of the queue
     */
    bool Peek( void* pvItem );    
 
    /** flush the queue
     *
     */
    void Flush( void );
 
 
protected:
    int              m_iSize;        // size of each item in queue
    int              m_iCount;        // number of items in the queue
    unsigned char*   m_pnHead;        // pointer to the head of the queue
    unsigned char*   m_pnTail;        // pointer to the tail of the queue
    unsigned char*   m_pnRdIndex;    // read index
    unsigned char*   m_pnWrIndex;    // write index
    int              m_iLclCount;    // number of items in queue
};
#endif
 
