#include "mbed.h"
//#include "Thread.h"
#include "SPIDAC.h"

DigitalOut spiChipSelect(p8, 1);
spi_t spi;

void SPIDACInitialize(void)
{
    // Setup the output pins for the SPI chip
    spi_init(&spi, p5, p6, p7, NC);
    // Set the format for the registers
    spi_format(&spi, 16, 2, 0);
    // Set the comm frequency
    spi_frequency(&spi, 1000000);
    
    // Set the initial values
    SPIDACSend(0, 0);
}

void SPIDACSend(uint16_t aValue, uint16_t bValue)
{
    // First write the bValue to the B buffer
    spiChipSelect = 0;
    spi_master_write(&spi, ((bValue & 0xFFF) | (0x5000)));
    while( spi_busy(&spi) )
        continue;
    spiChipSelect = 1;
    
    // Pause
    rtos::Thread::wait(1);
    
    // Now write the aValue to A and move the B buffer to B register
    spiChipSelect = 0;
    spi_master_write( &spi, ((aValue & 0xFFF) | (0xC000)));
    while (spi_busy(&spi))
        continue;
    spiChipSelect = 1;
}
