#include "DataContainer.h"
 
// construction 
DataContainer::DataContainer( int iSize, int iCount )
{
    // allocate space for the queue
    if (( m_pnHead = ( unsigned char* )malloc( iSize * iCount )) != NULL )
    {
        // set the tail/clear the indices/set the size and length
        m_pnTail     = m_pnHead + ( iSize * iCount );
        m_iSize     = iSize;
        m_iCount     = iCount;
        m_pnRdIndex    = m_pnHead;
        m_pnWrIndex    = m_pnHead;
        m_iLclCount    = 0;
    }
}
 
// destruction
DataContainer::~DataContainer( )
{
    // free the memory
    free( m_pnHead );
}
 
// put an item into the queue
bool DataContainer::Put( void* pvItem )
{
    bool bResult = false;
    
    // check for room
    if ( m_iLclCount < m_iCount )
    {
        __disable_irq( );
        // copy the item/adjust the pointer/check for overflow
        memcpy( m_pnWrIndex, pvItem, m_iSize );
        m_pnWrIndex += m_iSize;
        if ( m_pnWrIndex >= m_pnTail )
            m_pnWrIndex = m_pnHead;
 
        // increment the count
        m_iLclCount++;
        __enable_irq( );
 
        // set the result to 0k
        bResult = true;
    }
 
    // return the status
    return( bResult );
}
 
// get an item from the queue
bool DataContainer::Get( void* pvItem )
{
    bool bResult = false;
    
    // check for room
    if ( m_iLclCount != 0 )
    {
        __disable_irq( );
        // copy the item/adjust the pointer/check for overflow
        memcpy( pvItem, m_pnRdIndex, m_iSize );
        m_pnRdIndex += m_iSize;
        if ( m_pnRdIndex >= m_pnTail )
            m_pnRdIndex = m_pnHead;
 
        // decrement the count
        m_iLclCount--;
        __enable_irq( );
        // set the result to 0k
        bResult = true;
    }
 
    // return the status
    return( bResult );
}
 
// put an item into the queue
bool DataContainer::PutIrq( void* pvItem )
{
    bool bResult = false;
    
    // check for room
    if ( m_iLclCount < m_iCount )
    {
        // copy the item/adjust the pointer/check for overflow
        memcpy( m_pnWrIndex, pvItem, m_iSize );
        m_pnWrIndex += m_iSize;
        if ( m_pnWrIndex >= m_pnTail )
            m_pnWrIndex = m_pnHead;
 
        // increment the count
        m_iLclCount++;
 
        // set the result to 0k
        bResult = true;
    }
 
    // return the status
    return( bResult );
}
 
// get an item from the queue
bool DataContainer::GetIrq( void* pvItem )
{
    bool bResult = false;
    
    // check for room
    if ( m_iLclCount != 0 )
    {
        // copy the item/adjust the pointer/check for overflow
        memcpy( pvItem, m_pnRdIndex, m_iSize );
        m_pnRdIndex += m_iSize;
        if ( m_pnRdIndex >= m_pnTail )
            m_pnRdIndex = m_pnHead;
 
        // decrement the count
        m_iLclCount--;
 
        // set the result to 0k
        bResult = true;
    }
 
    // return the status
    return( bResult );
}
 
// get the number of items in the queue
int DataContainer::GetNumberOfItems( void )
{
    // return the count
    return( m_iLclCount );
}
 
// peeks at the item at the top of the queue
bool DataContainer::Peek( void* pvItem )
{
    bool bResult = false;
    
    // check for room
    if ( m_iLclCount != 0 )
    {
        // copy the item
        memcpy( pvItem, m_pnRdIndex, m_iSize );
 
        // set the result to 0k
        bResult = true;
    }
 
    // return the status
    return( bResult );
}
 
// flush all items from the queue
void DataContainer::Flush( void )
{
    // reset the indices
    m_iLclCount = 0;
    m_pnRdIndex = m_pnWrIndex = m_pnHead;
}
 
 
