
#include "CMSerial.h"
#include "DeviceProperties.h"

const char VERSION_STRING[] = "0.6";


CMSerial::CMSerial(void) : led(LED2), serial(p13, p14)
{
    lineLength = 0;
    serial.baud(115200);
    threadSerial.start(this, &CMSerial::ThreadEntry);
}

void CMSerial::ThreadEntry(void)
{
    while(true)
    {
        char c = serial.getc();
        led = !led;
        if( c == '\n' )
            continue;
        if (c == '\r')
        {
            line[lineLength] = 0;
            ProcessCommand();
            lineLength = 0;
            continue;
        }
        if (lineLength < sizeof(line) - 1)
            line[lineLength++] = c;
    }
}

void CMSerial::ProcessCommand(void)
{
    
    if (CommandIs("status"))
    {
	    serial.printf("<status");
	    serial.printf(" version=\"%s\"", VERSION_STRING);
	    serial.printf(" AcquisitionNumber=\"%d\"", Device.GetAcquisitionNumber());
	    serial.printf(" AcquisitionSamples=\"%d\"", Device.GetAcquisitionSampleCount());
        // Control Parameters
	    serial.printf(" OutputMode=\"%d\"", (int)Device.deviceConfig.outputMode);
	    serial.printf(" ConstantVoltage=\"%f\"", Device.deviceConfig.constantVoltage);
	    serial.printf(" ConstantPower=\"%f\"", Device.deviceConfig.constantPower);
	    serial.printf(" KP=\"%lf\"", Device.deviceConfig.kp);
	    serial.printf(" KI=\"%lf\"", Device.deviceConfig.ki);
	    serial.printf(" KD=\"%lf\"", Device.deviceConfig.kd);
	    serial.printf(" VoltageCal=\"%lf\"", Device.deviceConfig.voltageCal);
	    serial.printf(" CurrentCal=\"%lf\"", Device.deviceConfig.currentCal);
	    serial.printf(" vLim=\"%lf\"", Device.deviceConfig.vLim);
	    serial.printf(" iLim=\"%lf\"", Device.deviceConfig.iLim);
        // Activation Parameters
	    serial.printf(" PwmFrequency=\"%lf\"", Device.GetActualPWMFrequency());
	    serial.printf(" OpenLoopDuration=\"%d\"", Device.deviceConfig.msOpenLoopDuration);
	    serial.printf(" TotalDuration=\"%lf\"", Device.deviceConfig.TotalDurationSeconds);
	    serial.printf(" RampDuration=\"%lf\"", Device.deviceConfig.msRampDuration);
	    serial.printf(" RampStartPower=\"%lf\"", Device.deviceConfig.rampStartPower);
	    serial.printf(" RampEndPower=\"%lf\"", Device.deviceConfig.rampEndPower);
	    serial.printf(" StartVoltage=\"%lf\"", Device.deviceConfig.startVoltage);
	    serial.printf(" SamplePeriod=\"%d\"", Device.deviceConfig.msSamplePeriod);  
        serial.printf("/>\r\n");
        return;
    }
    
    if( CommandIs("GetSample"))
    {
        int acquisition = (int)GetNumericArgument(1, 0);
        int sample = (int)GetNumericArgument(2, 0);
        AcquisitionData sampleData = Device.GetAcquisitionSample(acquisition, sample);
        serial.printf("<sample");
        serial.printf(" Time=\"%f\"", sampleData.timestampMilliseconds);
        serial.printf(" TargetVoltage=\"%f\"", Device.deviceConfig.constantVoltage);
        serial.printf(" Isns=\"%f\"", sampleData.iSense);
        serial.printf(" Vsns=\"%f\"", sampleData.vSense);
        serial.printf(" Irms=\"%f\"", sampleData.iRMS);
        serial.printf(" Vrms=\"%f\"", sampleData.vRMS);
        serial.printf("/>\r\n");
        return;
    }
    
    if (CommandIs("version"))
    {
        serial.printf("%s\r\n", VERSION_STRING);
        return;
    }

    if( CommandIs("OutputMode"))
    {   
        Device.deviceConfig.outputMode = (OutputMode) (int)GetNumericArgument(1, (int)Device.deviceConfig.outputMode);
        serial.printf("%d\r\n", Device.deviceConfig.outputMode);
        return;
    }   
    
    if( CommandIs("ConstantVoltage"))
    {
        Device.deviceConfig.constantVoltage = GetNumericArgument(1, Device.deviceConfig.constantVoltage);
        serial.printf("%lf\r\n", Device.deviceConfig.constantVoltage);
        return;
    } 

    if( CommandIs("ConstantPower"))
    {
        Device.deviceConfig.constantPower = GetNumericArgument(1, Device.deviceConfig.constantPower);
        serial.printf("%lf\r\n", Device.deviceConfig.constantPower);
        return;
    }
    
    if( CommandIs("KP"))
    {
        Device.deviceConfig.kp = GetNumericArgument(1, Device.deviceConfig.kp);
        serial.printf("%lf\r\n", Device.deviceConfig.kp);
        return;
    }

    if( CommandIs("KI"))
    {
        Device.deviceConfig.ki = GetNumericArgument(1, Device.deviceConfig.ki);
        serial.printf("%lf\r\n", Device.deviceConfig.ki);
        return;
    }
    
    if( CommandIs("KD"))
    {
        Device.deviceConfig.kd = GetNumericArgument(1, Device.deviceConfig.kd);
        serial.printf("%lf\r\n", Device.deviceConfig.kd);
        return;
    }
    
    if( CommandIs("VoltageCal"))
    {
        Device.deviceConfig.voltageCal = GetNumericArgument(1, Device.deviceConfig.voltageCal);
        serial.printf("%lf\r\n", Device.deviceConfig.voltageCal);
        return;
    }
    
    if( CommandIs("CurrentCal"))
    {
        Device.deviceConfig.currentCal = GetNumericArgument(1, Device.deviceConfig.currentCal);
        serial.printf("%lf\r\n", Device.deviceConfig.currentCal);
        return;
    }
    
    if( CommandIs("vLim"))
    {
        Device.deviceConfig.vLim = GetNumericArgument(1, Device.deviceConfig.vLim);
        serial.printf("%lf\r\n", Device.deviceConfig.vLim);
        return;
    }
    
    if( CommandIs("iLim"))
    {
        Device.deviceConfig.iLim = GetNumericArgument(1, Device.deviceConfig.iLim);
        serial.printf("%lf\r\n", Device.deviceConfig.iLim);
        return;
    }
    
    // Activation Parameters
    if( CommandIs("PwmFrequency"))
    {
        Device.deviceConfig.pwmFrequency = GetNumericArgument(1, Device.deviceConfig.pwmFrequency);
        serial.printf("%lf\r\n", Device.deviceConfig.pwmFrequency);
        return;
    }
    
    if( CommandIs("OpenLoopDuration"))
    {
        Device.deviceConfig.msOpenLoopDuration = GetNumericArgument(1, Device.deviceConfig.msOpenLoopDuration);
        serial.printf("%lf\r\n", Device.deviceConfig.msOpenLoopDuration);
        return;
    }
    
    if( CommandIs("TotalDuration"))
    {
        Device.deviceConfig.TotalDurationSeconds = GetNumericArgument(1, Device.deviceConfig.TotalDurationSeconds);
        serial.printf("%lf\r\n", Device.deviceConfig.TotalDurationSeconds);
        return;
    }
    
    if( CommandIs("RampDuration"))
    {
        Device.deviceConfig.msRampDuration = GetNumericArgument(1, Device.deviceConfig.msRampDuration);
        serial.printf("%lf\r\n", Device.deviceConfig.msRampDuration);
        return;
    }
    
    if( CommandIs("RampStartPower"))
    {
        Device.deviceConfig.rampStartPower = GetNumericArgument(1, Device.deviceConfig.rampStartPower);
        serial.printf("%lf\r\n", Device.deviceConfig.rampStartPower);
        return;
    }
    
    if( CommandIs("RampEndPower"))
    {
        Device.deviceConfig.rampEndPower = GetNumericArgument(1, Device.deviceConfig.rampEndPower);
        serial.printf("%lf\r\n", Device.deviceConfig.rampEndPower);
        return;
    }
    
    if( CommandIs("StartVoltage"))
    {
        Device.deviceConfig.startVoltage = GetNumericArgument(1, Device.deviceConfig.startVoltage);
        serial.printf("%lf\r\n", Device.deviceConfig.startVoltage);
        return;
    }
    
    if( CommandIs("SamplePeriod"))
    {
        Device.deviceConfig.msSamplePeriod = GetNumericArgument(1, Device.deviceConfig.msSamplePeriod);
        serial.printf("%lf\r\n", Device.deviceConfig.msSamplePeriod);
        return;
    }

    serial.printf("Unrecognized command: %s\r\n", line);
}

bool CMSerial::CommandIs(const char *command)
{
    int length = strlen(command);
    if (strncmp(command, line, length) != 0)
        return false;
    if (line[length]!=0 && line[length]!=' ')
        return false;
    return true;
}

double CMSerial::GetNumericArgument(int index, double defaultValue)
{
    // for the moment we just require that arguments be separated by a single space
    const char *start = line;
    for (int i=0; i<index; ++i)
    {
        start = strchr(start, ' ');
        if (start == NULL)
            return defaultValue;
        ++start;
    }
    
    double result;
    if (1 != sscanf(start, "%lf", &result))
        return defaultValue;
    return result;
}

