
#include "ADCInput.h"
#include "DeviceProperties.h"

ADCInput::ADCInput(void) : vSense(p15),
    iSense(p16),
    vRMS(p19),
    iRMS(p20)

{
    avgValue = 0.0;
}

double ADCInput::GetSensedVoltage(void)
{
    avgValue = 0.0;
    for(int i=0; i<NUM_SAMPLES; i++) {
        avgValue += vSense.read();
        wait_us(1);
    }

    //Device.deviceConfig.voltageSensed = ((avgValue / NUM_SAMPLES)  * 3.3 )* 200 ;
    return ((avgValue / NUM_SAMPLES)  * 3.3 )* 200 ;

}

double ADCInput::GetSensedCurrent(void)
{
    avgValue = 0.0;
    for(int i=0; i<NUM_SAMPLES; i++) {
        avgValue += iSense.read();
        wait_us(1);
    }
    //Device.deviceConfig.currentSensed = ((avgValue / NUM_SAMPLES) * 3.3);
    return((avgValue / NUM_SAMPLES) * 3.3)/.85;

}

double ADCInput::GetRMSVoltage(void)
{
    avgValue = 0.0;
    for(int i=0; i<NUM_SAMPLES; i++) {
        avgValue += vRMS.read();
        wait_us(1);
    }


    return (avgValue / NUM_SAMPLES)* 3.3 * 200 ;
}

double ADCInput::GetRMSCurrent(void)
{
    avgValue = 0.0;
    for(int i=0; i<NUM_SAMPLES; i++) {
        avgValue += iRMS.read();
        wait_us(1);
    }

    return((avgValue / NUM_SAMPLES) * 3.3)/.85 ;

}

double ADCInput::GetResistance(void)
{
    
        return((GetRMSVoltage()) / GetRMSCurrent());
    
}
double ADCInput::GetSensedPower(void)
{
    return( GetSensedVoltage() * GetSensedCurrent() );
}

