
#ifndef __POWER_CONTROLLER_H__
#define __POWER_CONTROLLER_H__

#include "Thread.h"
#include "RtosTimer.h"
#include "IOControl.h"
#include "ADCInput.h"

#include "DeviceProperties.h"
#include "PID.h"

class PowerController
{
 public:
    PowerController(void);
    
    void ThreadEntry(void);
  
    void AcquireData(void);
    void ExecuteConstantPower(void);
    void ExecuteConstantVoltage(void);
    void ExecuteRamp(void);
    void ProcessPID(void);
    void Calibrate(void);
    double OffsetAndGain(double, double, double, double, double);
private:
    DigitalOut  led3;
    DigitalOut  led4;    
    IOControl   ioControl;
    ADCInput    ADC;    
    PID         pid;
    int myTime;
    int loopTimer;   
    int calState; 
    rtos::Thread thread;
    rtos::RtosTimer acquisitionTimer;
    rtos::RtosTimer pidTimer;   
};


#endif
