#ifndef __ADC_INPUT_H__
#define __ADC_INPUT_H__

#include "mbed.h"

const uint16_t NUM_SAMPLES = 30;

class ADCInput
{
public:
    ADCInput(void);
    
    double GetSensedVoltage(void);
    double GetSensedCurrent(void);
    double GetRMSVoltage(void);
    double GetRMSCurrent(void);
    double GetSensedPower(void);   
    double GetResistance(void);

private:
    double avgValue;  
    AnalogIn vSense;
    AnalogIn iSense;
    AnalogIn vRMS;
    AnalogIn iRMS;    
};


#endif
