#include "mbed.h"
#include "mDot.h"
#include "ChannelPlans.h"

static bool deep_sleep = false;

#define CHANNEL_PLAN CP_US915

mDot* dot = NULL;
lora::ChannelPlan* plan = NULL;

Serial pc(USBTX, USBRX);

#if defined(TARGET_XDOT_L151CC)
I2C i2c(I2C_SDA, I2C_SCL);
ISL29011 lux(i2c);
#else
AnalogIn lux(XBEE_AD0);
#endif

int main() {

    pc.baud(115200);

    mts::MTSLog::setLogLevel(0);
    
#if CHANNEL_PLAN == CP_US915
    plan = new lora::ChannelPlan_US915();
#elif CHANNEL_PLAN == CP_AU915
    plan = new lora::ChannelPlan_AU915();
#elif CHANNEL_PLAN == CP_EU868
    plan = new lora::ChannelPlan_EU868();
#elif CHANNEL_PLAN == CP_KR920
    plan = new lora::ChannelPlan_KR920();
#elif CHANNEL_PLAN == CP_AS923
    plan = new lora::ChannelPlan_AS923();
#elif CHANNEL_PLAN == CP_AS923_JAPAN
    plan = new lora::ChannelPlan_AS923_Japan();
#elif CHANNEL_PLAN == CP_IN865
    plan = new lora::ChannelPlan_IN865();
#endif
    assert(plan);

    dot = mDot::getInstance(plan);
    assert(dot);

    
    printf("\r\nCreate a file\r\n");
    
    uint8_t buffer[20];
    
    memset(buffer, 0x23, 20);
    
    dot->saveUserFile("Test", buffer, 20);
    
    uint8_t new_buffer[20];
    
    memset(new_buffer, 0, 20);
    
    dot->readUserFile("Test", new_buffer, 20);
        
    printf("Read from file: %02x %02x %02x\r\n", new_buffer[0], new_buffer[1], new_buffer[2]);
    
    
    memset(buffer, 0x78, 20);
    
    
    // Similar to C open interface
    // see http://codewiki.wikidot.com/c:system-calls:open
    mDot::mdot_file my_file = dot->openUserFile("Test2", mDot::FM_CREAT | mDot::FM_WRONLY | mDot::FM_APPEND);
   
    dot->writeUserFile(my_file, buffer, 20);
    
    dot->closeUserFile(my_file);
    
    memset(new_buffer, 0, 20);
    
    dot->readUserFile("Test2", new_buffer, 20);
        
    printf("Read from file: %02x %02x %02x\r\n", new_buffer[0], new_buffer[1], new_buffer[2]);
    
    while (true) {
        osDelay(5000);            
    }
 
    return 0;
}

