#include "dot_util.h"
#include "RadioEvent.h"
#include <string.h>
#if ACTIVE_EXAMPLE == CLASS_C_EXAMPLE

/////////////////////////////////////////////////////////////////////////////
// -------------------- DOT LIBRARY REQUIRED ------------------------------//
// * Because these example programs can be used for both mDot and xDot     //
//     devices, the LoRa stack is not included. The libmDot library should //
//     be imported if building for mDot devices. The libxDot library       //
//     should be imported if building for xDot devices.                    //
// * https://developer.mbed.org/teams/MultiTech/code/libmDot-dev-mbed5/    //
// * https://developer.mbed.org/teams/MultiTech/code/libmDot-mbed5/        //
// * https://developer.mbed.org/teams/MultiTech/code/libxDot-dev-mbed5/    //
// * https://developer.mbed.org/teams/MultiTech/code/libxDot-mbed5/        //
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////
// * these options must match the settings on your gateway //
// * edit their values to match your configuration         //
// * frequency sub band is only relevant for the 915 bands //
// * either the network name and passphrase can be used or //
//     the network ID (8 bytes) and KEY (16 bytes)         //
/////////////////////////////////////////////////////////////
//static std::string network_name = "iotlab01";
//static std::string network_passphrase = "11223344";
static uint8_t network_id[] = { 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11 };
static uint8_t network_key[] = { 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88 };
static uint8_t frequency_sub_band = 4;
static lora::NetworkType network_type = lora::PUBLIC_LORAWAN;
static uint8_t join_delay = 6;
static uint8_t ack = 1;
static bool adr = true;

mDot* dot = NULL;
lora::ChannelPlan* plan = NULL;

Serial pc(USBTX, USBRX);

#if defined(TARGET_XDOT_L151CC)
I2C i2c(I2C_SDA, I2C_SCL);
ISL29011 lux(i2c);
#else
AnalogIn lux(XBEE_AD0);
#endif

std::string Last_RX;

class MyEvent : public mDotEvent
{
 
public:
    MyEvent() {}
 
    virtual ~MyEvent() {}
 
    
    virtual void MacEvent(LoRaMacEventFlags* flags, LoRaMacEventInfo* info) {
 
        if (mts::MTSLog::getLogLevel() == mts::MTSLog::TRACE_LEVEL) {
            std::string msg = "OK";
            switch (info->Status) {
                case LORAMAC_EVENT_INFO_STATUS_ERROR:
                    msg = "ERROR";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_TX_TIMEOUT:
                    msg = "TX_TIMEOUT";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_RX_TIMEOUT:
                    msg = "RX_TIMEOUT";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_RX_ERROR:
                    msg = "RX_ERROR";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_JOIN_FAIL:
                    msg = "JOIN_FAIL";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_DOWNLINK_FAIL:
                    msg = "DOWNLINK_FAIL";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_ADDRESS_FAIL:
                    msg = "ADDRESS_FAIL";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_MIC_FAIL:
                    msg = "MIC_FAIL";
                    break;
                default:
                    break;
            }
            logTrace("Event: %s", msg.c_str());
 
            logTrace("Flags Tx: %d Rx: %d RxData: %d RxSlot: %d LinkCheck: %d JoinAccept: %d",
                     flags->Bits.Tx, flags->Bits.Rx, flags->Bits.RxData, flags->Bits.RxSlot, flags->Bits.LinkCheck, flags->Bits.JoinAccept);
            logTrace("Info: Status: %d ACK: %d Retries: %d TxDR: %d RxPort: %d RxSize: %d RSSI: %d SNR: %d Energy: %d Margin: %d Gateways: %d",
                     info->Status, info->TxAckReceived, info->TxNbRetries, info->TxDatarate, info->RxPort, info->RxBufferSize,
                     info->RxRssi, info->RxSnr, info->Energy, info->DemodMargin, info->NbGateways);
        }
 
        if (flags->Bits.Rx) {
            
            logDebug("Rx %d bytes", info->RxBufferSize);
            if (info->RxBufferSize > 0) {
                // print RX data as hexadecimal
                //printf("Rx data: %s\r\n", mts::Text::bin2hexString(info->RxBuffer, info->RxBufferSize).c_str());

                // print RX data as string
                std::string rx((const char*)info->RxBuffer, info->RxBufferSize);
                //printf("Rx data: %s\r\n", rx.c_str());
                Last_RX = rx;
            }
        }
    }
};


 char* vector2string(std::vector<uint8_t> var)
{
    char* test = new char[var.size()];

    std::copy(var.begin(),var.end(),test);
    
    return test;
    }
    
    
    
 void send_string(std::string data,mDot *dot)
{
    int32_t ret;
    std::vector<uint8_t> sendData;
    int i;
    
    for(i=0; i<data.size(); i++ )
        sendData.push_back( data[i] );
    
               
    ret = dot->send(sendData);
    if (ret != mDot::MDOT_OK) {
        logError("failed to send data to ");
    } else {
        logInfo("successfully sent data to ");
    }
    
    }
       
std::string get_buffer;

void Uart_interrupt(){
    
    char get_char;
    while(!pc.readable());
    
    get_char=pc.getc();
    if (get_char!='-')
    {
        get_buffer=get_buffer+get_char;
        }
    else
    {
        send_string(get_buffer,dot);
        get_buffer.clear();
    }
    
    }

int main() {

    pc.baud(115200);
    pc.attach(&Uart_interrupt, SerialBase::RxIrq);
   // pc.attach(&Uart_send_interrupt, SerialBase::TxIrq);
#if defined(TARGET_XDOT_L151CC)
    i2c.frequency(400000);
#endif

    // Custom event handler for automatically displaying RX data
   //RadioEvent events;
    MyEvent events;
    mts::MTSLog::setLogLevel(mts::MTSLog::TRACE_LEVEL);
    
    #if CHANNEL_PLAN == CP_US915
    plan = new lora::ChannelPlan_US915();
#elif CHANNEL_PLAN == CP_AU915
    plan = new lora::ChannelPlan_AU915();
#elif CHANNEL_PLAN == CP_EU868
    plan = new lora::ChannelPlan_EU868();
#elif CHANNEL_PLAN == CP_KR920
    plan = new lora::ChannelPlan_KR920();
#elif CHANNEL_PLAN == CP_AS923
    plan = new lora::ChannelPlan_AS923();
#elif CHANNEL_PLAN == CP_AS923_JAPAN
    plan = new lora::ChannelPlan_AS923_Japan();
#elif CHANNEL_PLAN == CP_IN865
    plan = new lora::ChannelPlan_IN865();
#endif
    assert(plan);

    dot = mDot::getInstance(plan);
    assert(dot);
    
    logInfo("mbed-os library version: %d", MBED_LIBRARY_VERSION);

    // start from a well-known state
    logInfo("defaulting Dot configuration");
    dot->resetConfig();
    dot->resetNetworkSession();

        // make sure library logging is turned on
    dot->setLogLevel(mts::MTSLog::INFO_LEVEL);

    // attach the custom events handler
    dot->setEvents(&events);

    // update configuration if necessary
    if (dot->getJoinMode() != mDot::OTA) {
        logInfo("changing network join mode to OTA");
        if (dot->setJoinMode(mDot::OTA) != mDot::MDOT_OK) {
            logError("failed to set network join mode to OTA");
        }
    }
    // in OTA and AUTO_OTA join modes, the credentials can be passed to the library as a name and passphrase or an ID and KEY
    // only one method or the other should be used!
    // network ID = crc64(network name)
    // network KEY = cmac(network passphrase)
    // update_ota_config_name_phrase(network_name, network_passphrase, frequency_sub_band, network_type, ack);
    update_ota_config_id_key(network_id, network_key, frequency_sub_band, network_type, ack);

    // configure the Dot for class C operation
    // the Dot must also be configured on the gateway for class C
    // use the lora-query application to do this on a Conduit: http://www.multitech.net/developer/software/lora/lora-network-server/
    // to provision your Dot for class C operation with a 3rd party gateway, see the gateway or network provider documentation
    logInfo("changing network mode to class C");
    if (dot->setClass("C") != mDot::MDOT_OK) {
        logError("failed to set network mode to class C");
    }

    // enable or disable Adaptive Data Rate
    dot->setAdr(adr);

    // Configure the join delay
    dot->setJoinDelay(join_delay);

    // save changes to configuration
    logInfo("saving configuration");
    if (!dot->saveConfig()) {
        logError("failed to save configuration");
    }

    // display configuration
    display_config();
    //    uint32_t ret;
    //    uint16_t light;
        std::string tx_str;
 //       uint8_t recv_from_uart;
        
    std::vector<uint8_t> tx_data;
   
    int count = 0;
    
    while (true) {

        // join network if not joined
        if (!dot->getNetworkJoinStatus()) {
            join_network();
            while (dot->getIsTransmitting()) ;
            
            dot->setAck(1);
            
            events.AckReceived = false;
            
            while (!events.AckReceived) {
                send_string("start!",dot);
            }
            
            events.AckReceived = false;
            
            while (!events.AckReceived) {        
                send_string(tx_str.c_str(),dot);
            }
            
            dot->setAck(0);
        }       
        
        if (!Last_RX.empty()) { // || count++ > 100) {
            count = 0;
            
            tx_str=Last_RX;
            Last_RX.clear();
      
            pc.printf("%s",tx_str.c_str());
                send_string(tx_str.c_str(),dot);
            } 
            
            osDelay(100);
        }
}

#endif

