#include "mbed.h"
#include "mDot.h"
#include "ChannelPlans.h"

static bool deep_sleep = false;

#define CHANNEL_PLAN CP_US915

mDot* dot = NULL;
lora::ChannelPlan* plan = NULL;

Serial pc(USBTX, USBRX);

#if defined(TARGET_XDOT_L151CC)
I2C i2c(I2C_SDA, I2C_SCL);
ISL29011 lux(i2c);
#else
AnalogIn lux(XBEE_AD0);
#endif

int main() {

    pc.baud(115200);

    mts::MTSLog::setLogLevel(0);
    
#if CHANNEL_PLAN == CP_US915
    plan = new lora::ChannelPlan_US915();
#elif CHANNEL_PLAN == CP_AU915
    plan = new lora::ChannelPlan_AU915();
#elif CHANNEL_PLAN == CP_EU868
    plan = new lora::ChannelPlan_EU868();
#elif CHANNEL_PLAN == CP_KR920
    plan = new lora::ChannelPlan_KR920();
#elif CHANNEL_PLAN == CP_AS923
    plan = new lora::ChannelPlan_AS923();
#elif CHANNEL_PLAN == CP_AS923_JAPAN
    plan = new lora::ChannelPlan_AS923_Japan();
#elif CHANNEL_PLAN == CP_IN865
    plan = new lora::ChannelPlan_IN865();
#endif
    assert(plan);

    dot = mDot::getInstance(plan);
    assert(dot);

    
    printf("\r\nenter loop*****\r\n");
    
    while (true) {
        int8_t bk_reg = 1; // 0, 1, mDot::UBR0, or mDot::UBR1
        uint32_t value;
        
        dot->readUserBackupRegister(bk_reg, value);
        
        printf("initial read value %lu from reg UBR%d\r\n", value, bk_reg);
        
        value = rand();
        
        printf("save value %lu to reg UBR%d\r\n", value, bk_reg);
        
        dot->writeUserBackupRegister(bk_reg, value);
        
        dot->readUserBackupRegister(bk_reg, value);
        
        printf("after write read value %lu from reg UBR%d\r\n", value, bk_reg);
    
        // ONLY ONE of the three functions below should be uncommented depending on the desired wakeup method
        //sleep_wake_rtc_only(deep_sleep);
        //sleep_wake_interrupt_only(deep_sleep);
        printf("sleep 5 seconds\r\n");
        dot->sleep(5, mDot::RTC_ALARM, deep_sleep);
        
        dot->readUserBackupRegister(bk_reg, value);
        
        printf("\r\n********after sleep read value %lu from reg UBR%d\r\n\r\n", value, bk_reg);
            
    }
 
    return 0;
}

