#include "mbed.h"
#include "Wifly.h"

Wifly wifly(p9, p10, p21, "eyerobot", "none", false);
DigitalOut listening(LED1);
DigitalOut connected(LED2);
DigitalOut ractivity(LED3);
DigitalOut dactivity(LED4);
char reading[50];
int buflen;

Serial pc(USBTX, USBRX);
Serial iRobot(p28, p27);
Serial disto(p13, p14);
Serial wifi(p9, p10);

int main() {
    listening = 0;
    connected = 0;
    ractivity = 0;
    dactivity = 0;
    
    iRobot.baud(57600);
    disto.baud(9600);
    
    wifly.reset();

    while( 1 ) {
        while( !wifly.enableAltGPIO(p23, p22, NC) );
        while( !wifly.setCommRemote() );
        
        pc.printf("Initialized\r\n");
        
        pc.printf("Joining network...\r\n");
        
        while( !listening ) {
            if( !wifly.join() ) {
                pc.printf("Join failed\r\n");
                wifly.reset();
            }

            listening = wifly.associated() ? 1 : 0;
        }
        pc.printf("Network joined. Listening for connections...");
        
        while( 1 ) {
            while( !connected ) {
                connected = wifly.connected() ? 1 : 0;
                wait(0.5);
                pc.printf(".");
            }
            
            wifly.flush();
            pc.printf("\r\nTCP Connection established. Pass-thru mode.\r\n");
            
            char c;
            while( connected ) {
                if( pc.readable() ) {
                    pc.printf("pc->wifly:\t");
                    while( pc.readable() ) {
                        c = pc.getc();
                        pc.putc(c);
                        wifly.putc(c);
                    }
                    pc.printf("\r\n");
                }

                buflen = wifly.read(reading);
                if( buflen > 0 ) {
                    // TODO: Determine where to send characters
                    // First characters should be a "header"
                    // TODO: OEM commands terminate with \n
                    pc.printf("tag: %d\r\n", *(reading));
                    if( *(reading) == 'R' ) {
                        ractivity = !ractivity;
                        pc.printf("wifly->Robot (%d):\t", buflen);
                        for( int i = 1 ; i < buflen; i++ ) {
                            pc.printf("%d ",(*(reading+i)));
                            iRobot.putc(*(reading+i));
                        }
                        pc.printf("\r\n");
                    } else if( *(reading) == 'D') {
                        dactivity = !dactivity;
                        pc.printf("wifly->disto (%d):\t", buflen);
                        for( int i = 1 ; i < buflen; i++ ) {
                            pc.printf("%d ",(*(reading+i)));
                            disto.putc(*(reading+i));
                        }
                        pc.printf("\r\n");
                    } else {
                        pc.printf("wifly->UNKNOWN (%d):\t", buflen);
                    }
                }

                if( iRobot.readable() ) {
                    pc.printf("Robot->:\t");
                    while( iRobot.readable() ) {
                        pc.putc(iRobot.getc());
                    }
                    pc.printf("\r\n");
                }
                if( disto.readable() ) {
                    pc.printf("disto->:\t");
                    while( disto.readable() ) {
                        c = disto.getc();
                        wifly.putc(c);
                        pc.printf("%c(%d) ", c, c);
                    }
                    wifly.putc('\n');
                    pc.printf("\r\n");
                }

                connected = wifly.connected()? 1 : 0;
            }
            
            pc.printf("Disconnected. Listening for connections...\r\n");
        }
    }
}
