#include "mbed.h"
#include "DHT.h"
#include "LCD_DISCO_L476VG.h"

//  STM32L476VGT DISCOVERY BOARD
//  DHT11 SENSOR RUNNING FROM 3V3 SUPPLY
//  PULL DOWN WITH 10K RESISTOR
//  DATA VIA THE PIN PA_0 
//  COM PORT 4 AT 9600 BAUD

LCD_DISCO_L476VG lcd;

DigitalOut led_green(LED1);

 #define   DHT_DATA_PIN  PA_0                        // sets pin PA_0 as data input
 
DHT sensor(DHT_DATA_PIN, DHT11);              
      //DHT(PinName pin, eType DHTtype)
 
int main()
{
    
    uint32_t temp = 0;
    uint8_t stemp[7] = {0};
    uint8_t stemp2[7] = {0};
    uint8_t title[] = "      TEMPERATURE";
     
    

    int error = 0;
   float h = 0.0f, c = 0.0f, f = 0.0f, k = 0.0f, dp = 0.0f, dpf = 0.0f;
   
 //   lcd.Clear();
 //   lcd.DisplayString((uint8_t *)"HELLO");
 //   wait(3);
 //   lcd.Clear();
 //   lcd.DisplayString((uint8_t *)"EET");
 //   wait(5);
  
    lcd.Clear();
    lcd.ScrollSentence(title, 1, 200);
    lcd.Clear();
   
   
   
   
    while(1) 
    {
        wait(2.0f);                                 //wait 2 second
       error = sensor.readData();                  //read error value
        if (error == 0)                             //case: no error 
          {
            c   = sensor.ReadTemperature(CELCIUS);
            f   = sensor.ReadTemperature(FARENHEIT);
            k   = sensor.ReadTemperature(KELVIN);
            h   = sensor.ReadHumidity();
            dp  = sensor.CalcdewPoint(c, h);
           dpf = sensor.CalcdewPointFast(c, h);
            printf("F: %4.2f, \r\n", f);            //prints temp in farenheit to Real Term
            printf("H: %4.2f, \r\n", h);          //prints humidity to Real Term
            printf(" \r\n ");                       //acts as empty line to space readings in Real Term
            printf(" \r\n ");                       //acts as empty line to space readings in Real Term
            
            lcd.Clear();
            sprintf((char *)stemp,"T:%2.0fF",f);
            lcd.DisplayString(stemp);
            

            if (f >= 90) {
                temp=4;
            } else if ((f <= 89)&&(f >= 80)) {
                temp=3;
            } else if ((f <= 79)&&(f >= 70)) {
                temp=2;
            } else if ((f <= 69)&&(f >= 60)) {
                temp=1;
            } else  {
                temp=0;                
            }
            lcd.BarLevelConfig((uint8_t)temp);
            
            
            wait(4);
            lcd.Clear();
            sprintf((char *)stemp2,"H:%2.0f%",h);
            lcd.DisplayString(stemp2);
            wait(2);
            lcd.Clear();
            
            


   
   
    //    wait(1);     
            
            
            
          } 
        else                                        //case: error
        {
            printf("Error: %d\r\n", error);         //prints error to Real Term when "if" criteria isn't satisfied
        }
        
        
        
   //     sprintf((char *)stemp, "BAR %d", temp);
    //    lcd.DisplayString(stemp);
    //    lcd.BarLevelConfig((uint8_t)temp);
    //    temp++;
   //     if (temp > 4) temp = 0;
    //    wait(1);     
          
        
    }


}
