
#ifndef LCD43PCT_H
#define LCD43PCT_H

#include <mbed.h>

//******************LIBRARY DEFINED PINS (don't modify)*******************//
//General definitions
#define RESET 13
#define TX 1
#define RX 0
#define OFF 0
#define ON 1
#define FULL 127
#define UNFILL 0
#define FILL 1
#define TRANS 0
#define COLOUR 1
#define BEGINNING 0
#define ALLCONTENTS 0
#define LANDSCAPEL  0x00  //left
#define PORTRAITL   0x01  //low
#define LANDSCAPER  0x02  //right
#define PORTRAITT   0x03  //top
#define DOUT0 0
#define DOUT1 1
#define GND 0
#define VCC 1
#define XCOORD 0
#define YCOORD 1
#define LC_WIDTH  480
#define LC_HEIGHT 272

//basic colours definition
#define BLACK   0x0000
#define WHITE   0xFFFF
#define RED     0xF800
#define GREEN   0x07E0
#define BLUE    0x001F
#define YELLOW  0xFFE0
#define CYAN    0x07FF
#define MAGENTA 0xF81F

//fonts definition
#define LC_FONT0   0x00
#define LC_FONT1   0x00
#define LC_FONT2   0x01
#define LC_FONT3   0x01
#define LC_FONT4   0x02
#define LC_FONT5   0x02
#define LC_FONT6   0x03
#define LC_FONT7   0x03

//**************************************************************************
// class LCD43PCT LCD43PCT.h
// This is the main class. It shoud be used like this : LCD43PCT lcd(p13,p14,p15);

class LCD43PCT{
    
public:
    
    LCD43PCT(PinName TXPin, PinName RXPin, PinName resetPin);
    
    void init();

    void reset();
    
    unsigned char start();  

    unsigned char erase();

    unsigned char sleep(unsigned char);
    
    unsigned char orientation(unsigned char);
    
    unsigned char bright(unsigned char);
    
    unsigned char baudChange(unsigned long val);
    
    unsigned char digitalOut(unsigned char, unsigned char);
    
    unsigned char setScreenBackground(int);
    
    unsigned char setTextBackground(int);
    
    unsigned char ReadPixel(int, int, char[]);
    
    unsigned char putPixel(int, int, int);
    
    unsigned char drawLine(int, int, int, int, int);
    
    unsigned char drawRectangle(int, int, int, int, int, unsigned char);
    
    unsigned char drawTriangle(int, int, int, int, int, int, int, unsigned char);
    
    unsigned char drawCircle(int, int, int, int, unsigned char);
    
    unsigned char putLetter(int, int, int, unsigned char, unsigned char, unsigned char);
    
    unsigned char string(int, int, int, int, int, unsigned char, unsigned char, char[]);
    
    unsigned char stringSD(int, int, int, int, int, unsigned char, unsigned char, int, int, char[]);
    
    unsigned char icon(int, int, int, int, char[]);
    
    unsigned char imageSD(int , int , char[]);
    
    unsigned char touchScreen(int[]);
    
    unsigned char touchIcon(char[]);

    protected :

    Serial     _serialLCD43PCT;
    DigitalOut _resetPin;
    
};
typedef unsigned char BYTE;

#endif
